/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.identity;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.identity.SSHKeypair;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.identity.ShellKeySupport;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Keypair
implements ShellKeySupport {
    private CSCloud provider;

    Keypair(@Nonnull CSCloud provider) {
        this.provider = provider;
    }

    @Nonnull
    public SSHKeypair createKeypair(@Nonnull String name) throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl("createSSHKeyPair", new Param("name", name)));
        NodeList matches = doc.getElementsByTagName("keypair");
        for (int i = 0; i < matches.getLength(); ++i) {
            SSHKeypair key = this.toKeypair(ctx, matches.item(i));
            if (key == null) continue;
            return key;
        }
        throw new CloudException("Request did not error, but no keypair was generated");
    }

    public void deleteKeypair(@Nonnull String providerId) throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.provider);
        method.get(method.buildUrl("deleteSSHKeyPair", new Param("name", providerId)));
    }

    @Nullable
    public String getFingerprint(@Nonnull String providerId) throws InternalException, CloudException {
        SSHKeypair keypair = this.getKeypair(providerId);
        return keypair == null ? null : keypair.getFingerprint();
    }

    public Requirement getKeyImportSupport() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nullable
    public SSHKeypair getKeypair(@Nonnull String providerId) throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl("listSSHKeyPairs", new Param("name", providerId)));
        NodeList matches = doc.getElementsByTagName("sshkeypair");
        for (int i = 0; i < matches.getLength(); ++i) {
            SSHKeypair key = this.toKeypair(ctx, matches.item(i));
            if (key == null) continue;
            return key;
        }
        return null;
    }

    @Nonnull
    public String getProviderTermForKeypair(@Nonnull Locale locale) {
        return "SSH keypair";
    }

    @Nonnull
    public SSHKeypair importKeypair(@Nonnull String name, @Nonnull String publicKey) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Import of keypairs is not supported");
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        return this.provider.getComputeServices().getVirtualMachineSupport().isSubscribed();
    }

    @Nonnull
    public Collection<SSHKeypair> list() throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl("listSSHKeyPairs", new Param[0]));
        ArrayList<SSHKeypair> keys = new ArrayList<SSHKeypair>();
        NodeList matches = doc.getElementsByTagName("sshkeypair");
        for (int i = 0; i < matches.getLength(); ++i) {
            SSHKeypair key = this.toKeypair(ctx, matches.item(i));
            if (key == null) continue;
            keys.add(key);
        }
        return keys;
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    @Nullable
    private SSHKeypair toKeypair(@Nonnull ProviderContext ctx, @Nullable Node node) throws CloudException, InternalException {
        if (node == null || !node.hasChildNodes()) {
            return null;
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No region is part of this request");
        }
        NodeList attributes = node.getChildNodes();
        SSHKeypair kp = new SSHKeypair();
        String privateKey = null;
        String fingerprint = null;
        String name = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            if (attribute == null) continue;
            String nodeName = attribute.getNodeName();
            if (nodeName.equalsIgnoreCase("name") && attribute.hasChildNodes()) {
                name = attribute.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (nodeName.equalsIgnoreCase("fingerprint") && attribute.hasChildNodes()) {
                fingerprint = attribute.getFirstChild().getNodeValue().trim();
                continue;
            }
            if (!nodeName.equalsIgnoreCase("privatekey") || !attribute.hasChildNodes()) continue;
            privateKey = attribute.getFirstChild().getNodeValue().trim();
        }
        if (name == null || fingerprint == null) {
            return null;
        }
        kp.setProviderRegionId(regionId);
        kp.setProviderOwnerId(ctx.getAccountNumber());
        kp.setProviderKeypairId(name);
        kp.setName(name);
        kp.setFingerprint(fingerprint);
        if (privateKey != null) {
            try {
                kp.setPrivateKey(privateKey.getBytes("utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new InternalException((Throwable)e);
            }
        }
        return kp;
    }
}

