/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSException;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.CSVersion;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.cloudstack.network.LoadBalancers;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.AddressType;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.IpAddressSupport;
import org.dasein.cloud.network.IpForwardingRule;
import org.dasein.cloud.network.LoadBalancer;
import org.dasein.cloud.network.Protocol;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IpAddress
implements IpAddressSupport {
    private static final String ASSOCIATE_IP_ADDRESS = "associateIpAddress";
    private static final String CREATE_PORT_FORWARDING_RULE = "createPortForwardingRule";
    private static final String DISASSOCIATE_IP_ADDRESS = "disassociateIpAddress";
    private static final String LIST_PORT_FORWARDING_RULES = "listPortForwardingRules";
    private static final String LIST_PUBLIC_IP_ADDRESSES = "listPublicIpAddresses";
    private static final String STOP_FORWARD = "deletePortForwardingRule";
    private CSCloud provider;

    public IpAddress(CSCloud provider) {
        this.provider = provider;
    }

    public void assign(@Nonnull String addressId, @Nonnull String toServerId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Address assignment is not supported");
    }

    public void assignToNetworkInterface(@Nonnull String addressId, @Nonnull String nicId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Network interfaces are not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String forward(@Nonnull String addressId, int publicPort, @Nonnull Protocol protocol, int privatePort, @Nonnull String onServerId) throws InternalException, CloudException {
        Logger logger = CSCloud.getLogger(IpAddress.class, "std");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enter - " + IpAddress.class.getName() + ".forward(" + addressId + "," + publicPort + "," + protocol + "," + privatePort + "," + onServerId + ")"));
        }
        try {
            VirtualMachine server = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(onServerId);
            String privateIpAddress = null;
            if (server == null) {
                throw new CloudException("No such server: " + onServerId);
            }
            String[] addresses = server.getPrivateIpAddresses();
            if (addresses != null && addresses.length > 0) {
                privateIpAddress = addresses[0];
            }
            if (privateIpAddress == null) {
                throw new CloudException("Could not determine a private IP address for " + onServerId);
            }
            Param[] params = this.isId() ? new Param[]{new Param("ipAddressId", addressId), new Param("publicPort", String.valueOf(publicPort)), new Param("privatePort", String.valueOf(privatePort)), new Param("protocol", protocol.name()), new Param("virtualMachineId", onServerId)} : new Param[]{new Param("ipAddress", addressId), new Param("publicPort", String.valueOf(publicPort)), new Param("privatePort", String.valueOf(privatePort)), new Param("protocol", protocol.name()), new Param("virtualMachineId", onServerId)};
            CSMethod method = new CSMethod(this.provider);
            Document doc = method.get(method.buildUrl(CREATE_PORT_FORWARDING_RULE, params));
            this.provider.waitForJob(doc, "Assigning forwarding rule");
            for (IpForwardingRule rule : this.listRules(addressId)) {
                if (rule.getPublicPort() != publicPort || rule.getPrivatePort() != privatePort || !onServerId.equals(rule.getServerId()) || !protocol.equals((Object)rule.getProtocol()) || !addressId.equals(rule.getAddressId())) continue;
                String string = rule.getProviderRuleId();
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + IpAddress.class.getName() + ".forward()"));
            }
        }
    }

    private boolean isId() {
        return this.provider.getVersion().greaterThan(CSVersion.CS21);
    }

    @Nullable
    public org.dasein.cloud.network.IpAddress getIpAddress(@Nonnull String addressId) throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        try {
            CSMethod method = new CSMethod(this.provider);
            Document doc = method.get(method.buildUrl(LIST_PUBLIC_IP_ADDRESSES, new Param(this.isId() ? "ipAddressId" : "ipAddress", addressId)));
            HashMap<String, LoadBalancer> loadBalancers = new HashMap<String, LoadBalancer>();
            LoadBalancers support = this.provider.getNetworkServices().getLoadBalancerSupport();
            LoadBalancer lb = support == null ? null : support.getLoadBalancer(addressId);
            loadBalancers.put(addressId, lb);
            NodeList matches = doc.getElementsByTagName("publicipaddress");
            for (int i = 0; i < matches.getLength(); ++i) {
                org.dasein.cloud.network.IpAddress addr = this.toAddress(matches.item(i), ctx, loadBalancers);
                if (addr == null || !addr.getProviderIpAddressId().equals(addressId)) continue;
                return addr;
            }
            return null;
        }
        catch (CSException e) {
            if (e.getHttpCode() == 431) {
                return null;
            }
            throw e;
        }
    }

    @Nonnull
    public String getProviderTermForIpAddress(@Nonnull Locale locale) {
        return "IP address";
    }

    @Nonnull
    public Requirement identifyVlanForVlanIPRequirement() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    public boolean isAssigned(@Nonnull AddressType type) {
        return false;
    }

    public boolean isAssigned(@Nonnull IPVersion version) throws CloudException, InternalException {
        return false;
    }

    public boolean isAssignablePostLaunch(@Nonnull IPVersion version) throws CloudException, InternalException {
        return false;
    }

    public boolean isForwarding() {
        return true;
    }

    public boolean isForwarding(@Nonnull IPVersion version) throws CloudException, InternalException {
        return version.equals((Object)IPVersion.IPV4);
    }

    public boolean isRequestable(@Nonnull AddressType type) {
        return type.equals((Object)AddressType.PUBLIC);
    }

    public boolean isRequestable(@Nonnull IPVersion version) throws CloudException, InternalException {
        return version.equals((Object)IPVersion.IPV4);
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        CSMethod method = new CSMethod(this.provider);
        try {
            method.get(method.buildUrl("listZones", new Param("available", "true")));
            return true;
        }
        catch (CSException e) {
            int code = e.getHttpCode();
            if (code == 403 || code == 401 || code == 531) {
                return false;
            }
            throw e;
        }
    }

    @Deprecated
    @Nonnull
    public Iterable<org.dasein.cloud.network.IpAddress> listPrivateIpPool(boolean unassignedOnly) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Deprecated
    @Nonnull
    public Iterable<org.dasein.cloud.network.IpAddress> listPublicIpPool(boolean unassignedOnly) throws InternalException, CloudException {
        return this.listIpPool(IPVersion.IPV4, unassignedOnly);
    }

    @Nonnull
    public Iterable<org.dasein.cloud.network.IpAddress> listIpPool(@Nonnull IPVersion version, boolean unassignedOnly) throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        if (version.equals((Object)IPVersion.IPV4)) {
            HashMap<String, LoadBalancer> loadBalancers = new HashMap<String, LoadBalancer>();
            LoadBalancers support = this.provider.getNetworkServices().getLoadBalancerSupport();
            if (support != null) {
                for (LoadBalancer lb : support.listLoadBalancers()) {
                    loadBalancers.put(lb.getProviderLoadBalancerId(), lb);
                }
            }
            CSMethod method = new CSMethod(this.provider);
            Document doc = method.get(method.buildUrl(LIST_PUBLIC_IP_ADDRESSES, new Param("zoneId", ctx.getRegionId())));
            ArrayList<org.dasein.cloud.network.IpAddress> addresses = new ArrayList<org.dasein.cloud.network.IpAddress>();
            NodeList matches = doc.getElementsByTagName("publicipaddress");
            for (int i = 0; i < matches.getLength(); ++i) {
                org.dasein.cloud.network.IpAddress addr = this.toAddress(matches.item(i), ctx, loadBalancers);
                if (addr == null || unassignedOnly && addr.isAssigned()) continue;
                addresses.add(addr);
            }
            return addresses;
        }
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<ResourceStatus> listIpPoolStatus(@Nonnull IPVersion version) throws InternalException, CloudException {
        ProviderContext ctx;
        if (!IPVersion.IPV4.equals((Object)version)) {
            return Collections.emptyList();
        }
        HashMap<String, LoadBalancer> loadBalancers = new HashMap<String, LoadBalancer>();
        LoadBalancers support = this.provider.getNetworkServices().getLoadBalancerSupport();
        if (support != null) {
            for (LoadBalancer lb : support.listLoadBalancers()) {
                loadBalancers.put(lb.getProviderLoadBalancerId(), lb);
            }
        }
        if ((ctx = this.provider.getContext()) == null) {
            throw new CloudException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_PUBLIC_IP_ADDRESSES, new Param("zoneId", ctx.getRegionId())));
        ArrayList<ResourceStatus> addresses = new ArrayList<ResourceStatus>();
        NodeList matches = doc.getElementsByTagName("publicipaddress");
        for (int i = 0; i < matches.getLength(); ++i) {
            ResourceStatus addr = this.toStatus(matches.item(i), loadBalancers);
            if (addr == null) continue;
            addresses.add(addr);
        }
        return addresses;
    }

    @Nonnull
    public Collection<IpForwardingRule> listRules(@Nonnull String addressId) throws InternalException, CloudException {
        Logger logger = CSCloud.getLogger(IpAddress.class, "std");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enter - " + IpAddress.class.getName() + ".listRules('" + addressId + "')"));
        }
        try {
            ArrayList<IpForwardingRule> rules = new ArrayList<IpForwardingRule>();
            Param[] params = this.provider.getVersion().greaterThan(CSVersion.CS21) ? new Param[]{new Param("ipaddressid", addressId)} : new Param[]{new Param("ipAddress", addressId)};
            CSMethod method = new CSMethod(this.provider);
            Document doc = method.get(method.buildUrl(LIST_PORT_FORWARDING_RULES, params));
            if (doc == null) {
                throw new CloudException("No such IP address: " + addressId);
            }
            NodeList matches = doc.getElementsByTagName("portforwardingrule");
            for (int i = 0; i < matches.getLength(); ++i) {
                Node node = matches.item(i);
                if (node == null) continue;
                IpForwardingRule rule = new IpForwardingRule();
                NodeList list = node.getChildNodes();
                rule.setAddressId(addressId);
                for (int j = 0; j < list.getLength(); ++j) {
                    Node attr = list.item(j);
                    if (attr.getNodeName().equals("publicport")) {
                        rule.setPublicPort(Integer.parseInt(attr.getFirstChild().getNodeValue()));
                        continue;
                    }
                    if (attr.getNodeName().equals("privateport")) {
                        rule.setPrivatePort(Integer.parseInt(attr.getFirstChild().getNodeValue()));
                        continue;
                    }
                    if (attr.getNodeName().equals("protocol")) {
                        rule.setProtocol(Protocol.valueOf((String)attr.getFirstChild().getNodeValue().toUpperCase()));
                        continue;
                    }
                    if (attr.getNodeName().equals("id")) {
                        rule.setProviderRuleId(attr.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (!attr.getNodeName().equals("virtualmachineid")) continue;
                    rule.setServerId(attr.getFirstChild().getNodeValue());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("listRules(): * " + rule));
                }
                rules.add(rule);
            }
            ArrayList<IpForwardingRule> arrayList = rules;
            return arrayList;
        }
        catch (RuntimeException e) {
            logger.error((Object)("listRules(): Runtime exception listing rules for " + addressId + ": " + e.getMessage()));
            e.printStackTrace();
            throw new InternalException((Throwable)e);
        }
        catch (Error e) {
            logger.error((Object)("listRules(): Error listing rules for " + addressId + ": " + e.getMessage()));
            e.printStackTrace();
            throw new InternalException((Throwable)e);
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + IpAddress.class.getName() + ".listRules()"));
            }
        }
    }

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException {
        return Collections.singletonList(IPVersion.IPV4);
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseFromPool(@Nonnull String addressId) throws InternalException, CloudException {
        Logger logger = CSCloud.getLogger(IpAddress.class, "std");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enter - " + IpAddress.class.getName() + ".releaseFromPool(" + addressId + ")"));
        }
        try {
            CSMethod method = new CSMethod(this.provider);
            method.get(method.buildUrl(DISASSOCIATE_IP_ADDRESS, new Param(this.isId() ? "id" : "ipaddress", addressId)));
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + IpAddress.class.getName() + ".releaseFromPool()"));
            }
        }
    }

    public void releaseFromServer(@Nonnull String addressId) throws InternalException, CloudException {
        throw new OperationNotSupportedException();
    }

    @Nonnull
    public String request(@Nonnull AddressType typeOfAddress) throws InternalException, CloudException {
        if (typeOfAddress.equals((Object)AddressType.PUBLIC)) {
            return this.request(IPVersion.IPV4);
        }
        throw new OperationNotSupportedException("Private IP requests are not supported");
    }

    @Nonnull
    public String request(@Nonnull IPVersion version) throws InternalException, CloudException {
        if (!version.equals((Object)IPVersion.IPV4)) {
            throw new OperationNotSupportedException("Only IPv4 is currently supported");
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(ASSOCIATE_IP_ADDRESS, new Param("zoneId", ctx.getRegionId())));
        NodeList matches = this.provider.getVersion().greaterThan(CSVersion.CS21) ? doc.getElementsByTagName("id") : doc.getElementsByTagName("ipaddress");
        String id = null;
        if (matches.getLength() > 0) {
            id = matches.item(0).getFirstChild().getNodeValue();
        }
        if (id == null) {
            throw new CloudException("Failed to request an IP address without error");
        }
        this.provider.waitForJob(doc, ASSOCIATE_IP_ADDRESS);
        return id;
    }

    @Nonnull
    public String requestForVLAN(@Nonnull IPVersion version) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Not yet supported since CloudStack requires you to name the network");
    }

    @Nonnull
    public String requestForVLAN(@Nonnull IPVersion version, @Nonnull String vlanId) throws InternalException, CloudException {
        if (!version.equals((Object)IPVersion.IPV4)) {
            throw new OperationNotSupportedException("Only IPv4 is currently supported");
        }
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(ASSOCIATE_IP_ADDRESS, new Param("zoneId", ctx.getRegionId()), new Param("networkId", vlanId)));
        NodeList matches = this.provider.getVersion().greaterThan(CSVersion.CS21) ? doc.getElementsByTagName("id") : doc.getElementsByTagName("ipaddress");
        String id = null;
        if (matches.getLength() > 0) {
            id = matches.item(0).getFirstChild().getNodeValue();
        }
        if (id == null) {
            throw new CloudException("Failed to request an IP address without error");
        }
        this.provider.waitForJob(doc, ASSOCIATE_IP_ADDRESS);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopForward(@Nonnull String ruleId) throws InternalException, CloudException {
        Logger logger = CSCloud.getLogger(IpAddress.class, "std");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enter - " + IpAddress.class.getName() + ".stopForward(" + ruleId + ")"));
        }
        try {
            CSMethod method = new CSMethod(this.provider);
            Document doc = method.get(method.buildUrl(STOP_FORWARD, new Param("id", ruleId)));
            this.provider.waitForJob(doc, STOP_FORWARD);
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + IpAddress.class.getName() + ".stopForward()"));
            }
        }
    }

    public boolean supportsVLANAddresses(@Nonnull IPVersion ofVersion) throws InternalException, CloudException {
        return IPVersion.IPV4.equals((Object)ofVersion);
    }

    @Nullable
    private org.dasein.cloud.network.IpAddress toAddress(@Nullable Node node, @Nonnull ProviderContext ctx, @Nonnull Map<String, LoadBalancer> loadBalancers) throws InternalException, CloudException {
        if (node == null) {
            return null;
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No region was set for this request");
        }
        org.dasein.cloud.network.IpAddress address = new org.dasein.cloud.network.IpAddress();
        NodeList attributes = node.getChildNodes();
        address.setRegionId(regionId);
        address.setServerId(null);
        address.setProviderLoadBalancerId(null);
        address.setAddressType(AddressType.PUBLIC);
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node n = attributes.item(i);
            String name = n.getNodeName().toLowerCase();
            String value = n.getChildNodes().getLength() > 0 ? n.getFirstChild().getNodeValue() : null;
            if (name.equalsIgnoreCase("id") && value != null) {
                address.setIpAddressId(value);
                continue;
            }
            if (name.equalsIgnoreCase("ipaddress") && value != null) {
                if (address.getProviderIpAddressId() == null) {
                    address.setIpAddressId(value);
                }
                address.setAddress(value);
                continue;
            }
            if (name.equalsIgnoreCase("zoneid") && value != null) {
                address.setRegionId(value);
                continue;
            }
            if (name.equalsIgnoreCase("virtualmachineid")) {
                address.setServerId(value);
                continue;
            }
            if (name.equalsIgnoreCase("state")) {
                if (value == null || value.equalsIgnoreCase("allocated")) continue;
                return null;
            }
            if (!name.equalsIgnoreCase("associatednetworkid") || value == null) continue;
            address.setForVlan(true);
        }
        LoadBalancer lb = loadBalancers.get(address.getAddress());
        if (lb != null) {
            address.setProviderLoadBalancerId(lb.getProviderLoadBalancerId());
        }
        if (address.getServerId() == null) {
            for (VirtualMachine vm : this.provider.getComputeServices().getVirtualMachineSupport().listVirtualMachines()) {
                String[] addrs = vm.getPublicIpAddresses();
                if (addrs == null) continue;
                for (String addr : addrs) {
                    if (!addr.equals(address.getAddress())) continue;
                    address.setServerId(vm.getProviderVirtualMachineId());
                }
            }
        }
        return address;
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node node, @Nonnull Map<String, LoadBalancer> loadBalancers) throws InternalException, CloudException {
        LoadBalancer lb;
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        String addressId = null;
        String address = null;
        Boolean available = null;
        boolean hasState = false;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node n = attributes.item(i);
            String name = n.getNodeName().toLowerCase();
            String value = n.getChildNodes().getLength() > 0 ? n.getFirstChild().getNodeValue() : null;
            if (name.equalsIgnoreCase("id") && value != null) {
                addressId = value;
            } else if (name.equalsIgnoreCase("ipaddress") && value != null) {
                address = value;
            } else if (name.equalsIgnoreCase("virtualmachineid")) {
                available = value != null && !value.equals("");
            } else if (name.equalsIgnoreCase("state")) {
                if (value != null && !value.equalsIgnoreCase("allocated")) {
                    return null;
                }
                hasState = true;
            }
            if (addressId != null && address != null && available != null && hasState) break;
        }
        if (addressId == null) {
            return null;
        }
        if (address != null && (lb = loadBalancers.get(address)) != null) {
            available = false;
        }
        if (available == null) {
            available = true;
        }
        return new ResourceStatus(addressId, (Object)available);
    }
}

