/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSException;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.IpAddress;
import org.dasein.cloud.network.LbAlgorithm;
import org.dasein.cloud.network.LbListener;
import org.dasein.cloud.network.LbProtocol;
import org.dasein.cloud.network.LoadBalancer;
import org.dasein.cloud.network.LoadBalancerAddressType;
import org.dasein.cloud.network.LoadBalancerState;
import org.dasein.cloud.network.LoadBalancerSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LoadBalancers
implements LoadBalancerSupport {
    public static final String ASSIGN_TO_LOAD_BALANCER_RULE = "assignToLoadBalancerRule";
    public static final String CREATE_LOAD_BALANCER_RULE = "createLoadBalancerRule";
    public static final String DELETE_LOAD_BALANCER_RULE = "deleteLoadBalancerRule";
    public static final String LIST_LOAD_BALANCER_RULES = "listLoadBalancerRules";
    public static final String LIST_LOAD_BALANCER_RULE_INSTANCES = "listLoadBalancerRuleInstances";
    public static final String REMOVE_FROM_LOAD_BALANCER_RULE = "removeFromLoadBalancerRule";
    private CSCloud provider;
    private static volatile List<LbAlgorithm> algorithms = null;
    private static volatile List<LbProtocol> protocols = null;

    LoadBalancers(CSCloud provider) {
        this.provider = provider;
    }

    public void addDataCenters(String toLoadBalancerId, String ... dataCenterIds) throws CloudException, InternalException {
    }

    public void addServers(String toLoadBalancerId, String ... serverIds) throws CloudException, InternalException {
        try {
            LoadBalancer lb = this.getLoadBalancer(toLoadBalancerId);
            if (lb == null) {
                throw new CloudException("No such load balancer: " + toLoadBalancerId);
            }
            if (serverIds == null || serverIds.length < 1) {
                return;
            }
            for (LbListener listener : lb.getListeners()) {
                String ruleId = this.getVmOpsRuleId(listener.getAlgorithm(), toLoadBalancerId, listener.getPublicPort(), listener.getPrivatePort());
                StringBuilder str = new StringBuilder();
                for (int i = 0; i < serverIds.length; ++i) {
                    str.append(serverIds[i]);
                    if (i >= serverIds.length - 1) continue;
                    str.append(",");
                }
                CSMethod method = new CSMethod(this.provider);
                Document doc = method.get(method.buildUrl(ASSIGN_TO_LOAD_BALANCER_RULE, new Param("id", ruleId), new Param("virtualMachineIds", str.toString())));
                this.provider.waitForJob(doc, "Add Server");
            }
        }
        catch (RuntimeException e) {
            throw new InternalException((Throwable)e);
        }
        catch (Error e) {
            throw new InternalException((Throwable)e);
        }
    }

    public String create(String name, String description, String addressId, String[] dcIds, LbListener[] listeners, String[] servers) throws CloudException, InternalException {
        try {
            IpAddress publicAddress = this.provider.getNetworkServices().getIpAddressSupport().getIpAddress(addressId);
            if (publicAddress == null) {
                throw new CloudException("You must specify the IP address for your load balancer.");
            }
            for (LbListener listener : listeners) {
                if (!this.isId(addressId)) {
                    this.createVmOpsRule(listener.getAlgorithm(), addressId, listener.getPublicPort(), listener.getPrivatePort());
                    continue;
                }
                this.createCloudstack22Rule(listener.getAlgorithm(), addressId, listener.getPublicPort(), listener.getPrivatePort());
            }
            if (servers != null) {
                this.addServers(publicAddress.getAddress(), servers);
            }
            return publicAddress.getAddress();
        }
        catch (CloudException e) {
            e.printStackTrace();
            throw e;
        }
        catch (InternalException e) {
            e.printStackTrace();
            throw e;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private void createVmOpsRule(LbAlgorithm algorithm, String publicIp, int publicPort, int privatePort) throws CloudException, InternalException {
        Collection<Object> lbs;
        Node node;
        HashMap<String, Object> current;
        int i;
        String algor;
        String id = this.getVmOpsRuleId(algorithm, publicIp, publicPort, privatePort);
        if (id != null) {
            return;
        }
        Param[] params = new Param[6];
        switch (algorithm) {
            case ROUND_ROBIN: {
                algor = "roundrobin";
                break;
            }
            case LEAST_CONN: {
                algor = "leastconn";
                break;
            }
            case SOURCE: {
                algor = "source";
                break;
            }
            default: {
                algor = "roundrobin";
            }
        }
        params[0] = new Param("publicIp", publicIp);
        params[1] = new Param("publicPort", String.valueOf(publicPort));
        params[2] = new Param("privatePort", String.valueOf(privatePort));
        params[3] = new Param("algorithm", algor);
        params[4] = new Param("name", "dsnlb_" + publicIp + "_" + publicPort + "_" + privatePort);
        params[5] = new Param("description", "dsnlb_" + publicIp + "_" + publicPort + "_" + privatePort);
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(CREATE_LOAD_BALANCER_RULE, params));
        NodeList matches = doc.getElementsByTagName("loadbalancerrule");
        for (i = 0; i < matches.getLength(); ++i) {
            current = new HashMap<String, LoadBalancer>();
            node = matches.item(i);
            this.toRule(node, current);
            lbs = current.values();
            if (lbs.size() <= 0) continue;
            return;
        }
        matches = doc.getElementsByTagName("loadbalancer");
        for (i = 0; i < matches.getLength(); ++i) {
            current = new HashMap();
            node = matches.item(i);
            this.toRule(node, current);
            lbs = current.values();
            if (lbs.size() <= 0) continue;
            return;
        }
        throw new CloudException("Failed to add load balancer rule (2).");
    }

    private void createCloudstack22Rule(LbAlgorithm algorithm, String publicIpId, int publicPort, int privatePort) throws CloudException, InternalException {
        Collection<Object> lbs;
        Node node;
        HashMap<String, Object> current;
        int i;
        String algor;
        String id = this.getVmOpsRuleId(algorithm, publicIpId, publicPort, privatePort);
        if (id != null) {
            return;
        }
        Param[] params = new Param[6];
        switch (algorithm) {
            case ROUND_ROBIN: {
                algor = "roundrobin";
                break;
            }
            case LEAST_CONN: {
                algor = "leastconn";
                break;
            }
            case SOURCE: {
                algor = "source";
                break;
            }
            default: {
                algor = "roundrobin";
            }
        }
        params[0] = new Param("publicIpId", publicIpId);
        params[1] = new Param("publicPort", String.valueOf(publicPort));
        params[2] = new Param("privatePort", String.valueOf(privatePort));
        params[3] = new Param("algorithm", algor);
        params[4] = new Param("name", "dsnlb_" + publicIpId + "_" + publicPort + "_" + privatePort);
        params[5] = new Param("description", "dsnlb_" + publicIpId + "_" + publicPort + "_" + privatePort);
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(CREATE_LOAD_BALANCER_RULE, params));
        NodeList matches = doc.getElementsByTagName("loadbalancerrule");
        for (i = 0; i < matches.getLength(); ++i) {
            current = new HashMap<String, LoadBalancer>();
            node = matches.item(i);
            this.toRule(node, current);
            lbs = current.values();
            if (lbs.size() <= 0) continue;
            return;
        }
        matches = doc.getElementsByTagName("loadbalancer");
        for (i = 0; i < matches.getLength(); ++i) {
            current = new HashMap();
            node = matches.item(i);
            this.toRule(node, current);
            lbs = current.values();
            if (lbs.size() <= 0) continue;
            return;
        }
        matches = doc.getElementsByTagName("jobid");
        if (matches.getLength() > 0) {
            this.provider.waitForJob(doc, "Create Load Balancer Rule");
            return;
        }
        throw new CloudException("Failed to add load balancer rule (2).");
    }

    public LoadBalancerAddressType getAddressType() throws CloudException, InternalException {
        return LoadBalancerAddressType.IP;
    }

    private boolean isId(String ipAddressIdCandidate) {
        String[] parts = ipAddressIdCandidate.split("\\.");
        return parts == null || parts.length != 4;
    }

    public LoadBalancer getLoadBalancer(String loadBalancerId) throws CloudException, InternalException {
        try {
            HashMap<String, LoadBalancer> matches = new HashMap<String, LoadBalancer>();
            boolean isId = this.isId(loadBalancerId);
            String key = isId ? "publicIpId" : "publicIp";
            CSMethod method = new CSMethod(this.provider);
            Document doc = method.get(method.buildUrl(LIST_LOAD_BALANCER_RULES, new Param(key, loadBalancerId)));
            NodeList rules = doc.getElementsByTagName("loadbalancerrule");
            for (int i = 0; i < rules.getLength(); ++i) {
                Node node = rules.item(i);
                this.toRule(node, matches);
            }
            return (LoadBalancer)matches.get(loadBalancerId);
        }
        catch (CSException e) {
            if (e.getHttpCode() == 431) {
                return null;
            }
            throw e;
        }
    }

    public int getMaxPublicPorts() throws CloudException, InternalException {
        return 0;
    }

    public String getProviderTermForLoadBalancer(Locale locale) {
        return "load balancer";
    }

    public Iterable<ResourceStatus> listLoadBalancerStatus() throws CloudException, InternalException {
        HashMap<String, LoadBalancer> matches = new HashMap<String, LoadBalancer>();
        CSMethod method = new CSMethod(this.provider);
        try {
            Document doc = method.get(method.buildUrl(LIST_LOAD_BALANCER_RULES, new Param[0]));
            NodeList rules = doc.getElementsByTagName("loadbalancerrule");
            for (int i = 0; i < rules.getLength(); ++i) {
                Node node = rules.item(i);
                this.toRule(node, matches);
            }
            ArrayList<ResourceStatus> results = new ArrayList<ResourceStatus>();
            for (LoadBalancer lb : matches.values()) {
                if (!this.matchesRegion(lb.getProviderLoadBalancerId())) continue;
                results.add(new ResourceStatus(lb.getProviderLoadBalancerId(), (Object)lb.getCurrentState()));
            }
            return results;
        }
        catch (CloudException e) {
            if (e.getHttpCode() == 404) {
                return Collections.emptyList();
            }
            e.printStackTrace();
            throw e;
        }
    }

    public Iterable<LbAlgorithm> listSupportedAlgorithms() {
        List<LbAlgorithm> list = algorithms;
        if (list == null) {
            list = new ArrayList<LbAlgorithm>();
            list.add(LbAlgorithm.ROUND_ROBIN);
            list.add(LbAlgorithm.LEAST_CONN);
            list.add(LbAlgorithm.SOURCE);
            algorithms = Collections.unmodifiableList(list);
        }
        return algorithms;
    }

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException {
        return Collections.singletonList(IPVersion.IPV4);
    }

    public Iterable<LbProtocol> listSupportedProtocols() {
        List<LbProtocol> list = protocols;
        if (protocols == null) {
            list = new ArrayList<LbProtocol>();
            list.add(LbProtocol.RAW_TCP);
            protocols = Collections.unmodifiableList(list);
        }
        return protocols;
    }

    private Collection<String> getServersAt(String ruleId) throws InternalException, CloudException {
        ArrayList<String> ids = new ArrayList<String>();
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_LOAD_BALANCER_RULE_INSTANCES, new Param("id", ruleId)));
        NodeList instances = doc.getElementsByTagName("loadbalancerruleinstance");
        for (int i = 0; i < instances.getLength(); ++i) {
            Node node = instances.item(i);
            NodeList attributes = node.getChildNodes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node n = attributes.item(j);
                if (!n.getNodeName().equals("id")) continue;
                ids.add(n.getFirstChild().getNodeValue());
            }
        }
        return ids;
    }

    private String getVmOpsRuleId(LbAlgorithm lbAlgorithm, String publicIp, int publicPort, int privatePort) throws CloudException, InternalException {
        String algorithm;
        String ruleId = null;
        switch (lbAlgorithm) {
            case ROUND_ROBIN: {
                algorithm = "roundrobin";
                break;
            }
            case LEAST_CONN: {
                algorithm = "leastconn";
                break;
            }
            case SOURCE: {
                algorithm = "source";
                break;
            }
            default: {
                algorithm = "roundrobin";
            }
        }
        boolean isId = this.isId(publicIp);
        String key = isId ? "publicIpId" : "publicIp";
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_LOAD_BALANCER_RULES, new Param(key, publicIp)));
        NodeList rules = doc.getElementsByTagName("loadbalancerrule");
        for (int i = 0; i < rules.getLength(); ++i) {
            Node node = rules.item(i);
            NodeList attributes = node.getChildNodes();
            boolean isIt = true;
            String id = null;
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node n = attributes.item(j);
                String name = n.getNodeName().toLowerCase();
                String value = n.getChildNodes().getLength() > 0 ? n.getFirstChild().getNodeValue() : null;
                if (name.equals("publicip")) {
                    if (value.equals(publicIp)) continue;
                    isIt = false;
                    break;
                }
                if (name.equals("publicport")) {
                    if (value != null && publicPort == Integer.parseInt(value)) continue;
                    isIt = false;
                    break;
                }
                if (name.equals("privateport")) {
                    if (value != null && privatePort == Integer.parseInt(value)) continue;
                    isIt = false;
                    break;
                }
                if (name.equals("algorithm")) {
                    if (value != null && value.equals(algorithm)) continue;
                    isIt = false;
                    break;
                }
                if (!name.equals("id")) continue;
                id = value;
            }
            if (!isIt) continue;
            ruleId = id;
            break;
        }
        return ruleId;
    }

    public boolean isAddressAssignedByProvider() throws CloudException, InternalException {
        return false;
    }

    public boolean isDataCenterLimited() {
        return false;
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    public boolean requiresListenerOnCreate() throws CloudException, InternalException {
        return true;
    }

    public boolean requiresServerOnCreate() throws CloudException, InternalException {
        return false;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        CSMethod method = new CSMethod(this.provider);
        try {
            method.get(method.buildUrl("listZones", new Param("available", "true")));
            return true;
        }
        catch (CSException e) {
            int code = e.getHttpCode();
            if (code == 403 || code == 401 || code == 531) {
                return false;
            }
            throw e;
        }
    }

    public boolean supportsMonitoring() {
        return false;
    }

    public Iterable<LoadBalancer> listLoadBalancers() throws CloudException, InternalException {
        HashMap<String, LoadBalancer> matches = new HashMap<String, LoadBalancer>();
        CSMethod method = new CSMethod(this.provider);
        try {
            Document doc = method.get(method.buildUrl(LIST_LOAD_BALANCER_RULES, new Param[0]));
            NodeList rules = doc.getElementsByTagName("loadbalancerrule");
            for (int i = 0; i < rules.getLength(); ++i) {
                Node node = rules.item(i);
                this.toRule(node, matches);
            }
            ArrayList<LoadBalancer> results = new ArrayList<LoadBalancer>();
            for (LoadBalancer lb : matches.values()) {
                if (!this.matchesRegion(lb.getProviderLoadBalancerId())) continue;
                results.add(lb);
            }
            return results;
        }
        catch (CloudException e) {
            if (e.getHttpCode() == 404) {
                return Collections.emptyList();
            }
            e.printStackTrace();
            throw e;
        }
    }

    boolean matchesRegion(String addressId) throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl("listPublicIpAddresses", new Param(this.isId(addressId) ? "ipAddressId" : "ipAddress", addressId)));
        HashMap<String, LoadBalancer> loadBalancers = new HashMap<String, LoadBalancer>();
        LoadBalancer lb = this.provider.getNetworkServices().getLoadBalancerSupport().getLoadBalancer(addressId);
        loadBalancers.put(addressId, lb);
        NodeList matches = doc.getElementsByTagName("publicipaddress");
        for (int i = 0; i < matches.getLength(); ++i) {
            Node n = matches.item(i);
            NodeList attributes = n.getChildNodes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node child = attributes.item(j);
                String name = child.getNodeName().toLowerCase();
                String value = child.getChildNodes().getLength() > 0 ? child.getFirstChild().getNodeValue() : null;
                if (!name.equalsIgnoreCase("zoneid")) continue;
                return value != null && value.equalsIgnoreCase(this.provider.getContext().getRegionId());
            }
        }
        return false;
    }

    public void remove(String loadBalancerId) throws CloudException, InternalException {
        LoadBalancer lb = this.getLoadBalancer(loadBalancerId);
        if (lb.getListeners() == null) {
            return;
        }
        for (LbListener listener : lb.getListeners()) {
            String ruleId = this.getVmOpsRuleId(listener.getAlgorithm(), lb.getAddress(), listener.getPublicPort(), listener.getPrivatePort());
            if (ruleId == null) continue;
            this.removeVmOpsRule(ruleId);
        }
    }

    public void removeDataCenters(String fromLoadBalancerId, String ... dataCenterIds) throws CloudException, InternalException {
        throw new OperationNotSupportedException("These load balancers are not data center based.");
    }

    public void removeServers(String toLoadBalancerId, String ... serverIds) throws CloudException, InternalException {
        try {
            LoadBalancer lb = this.getLoadBalancer(toLoadBalancerId);
            if (lb == null) {
                throw new CloudException("No such load balancer: " + toLoadBalancerId);
            }
            StringBuilder ids = new StringBuilder();
            for (int i = 0; i < serverIds.length; ++i) {
                ids.append(serverIds[i]);
                if (i >= serverIds.length - 1) continue;
                ids.append(",");
            }
            for (LbListener listener : lb.getListeners()) {
                String ruleId = this.getVmOpsRuleId(listener.getAlgorithm(), toLoadBalancerId, listener.getPublicPort(), listener.getPrivatePort());
                CSMethod method = new CSMethod(this.provider);
                Document doc = method.get(method.buildUrl(REMOVE_FROM_LOAD_BALANCER_RULE, new Param("id", ruleId), new Param("virtualMachineIds", ids.toString())));
                this.provider.waitForJob(doc, "Remove Server");
            }
        }
        catch (RuntimeException e) {
            throw new InternalException((Throwable)e);
        }
        catch (Error e) {
            throw new InternalException((Throwable)e);
        }
    }

    private void removeVmOpsRule(String ruleId) throws CloudException, InternalException {
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(DELETE_LOAD_BALANCER_RULE, new Param("id", ruleId)));
        this.provider.waitForJob(doc, "Remove Load Balancer Rule");
    }

    private void toRule(Node node, Map<String, LoadBalancer> current) throws InternalException, CloudException {
        LoadBalancer lb;
        NodeList attributes = node.getChildNodes();
        int publicPort = -1;
        int privatePort = -1;
        LbAlgorithm algorithm = null;
        String publicIp = null;
        String ruleId = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node n = attributes.item(i);
            String name = n.getNodeName().toLowerCase();
            String value = n.getChildNodes().getLength() > 0 ? n.getFirstChild().getNodeValue() : null;
            if (name.equals("publicip")) {
                publicIp = value;
                continue;
            }
            if (name.equals("id")) {
                ruleId = value;
                continue;
            }
            if (name.equals("publicport") && value != null) {
                publicPort = Integer.parseInt(value);
                continue;
            }
            if (name.equals("privateport") && value != null) {
                privatePort = Integer.parseInt(value);
                continue;
            }
            if (!name.equals("algorithm")) continue;
            algorithm = algorithm == null || algorithm.equals((Object)"roundrobin") ? LbAlgorithm.ROUND_ROBIN : (algorithm.equals((Object)"leastconn") ? LbAlgorithm.LEAST_CONN : (algorithm.equals((Object)"") ? LbAlgorithm.SOURCE : LbAlgorithm.ROUND_ROBIN));
        }
        LbListener listener = new LbListener();
        listener.setAlgorithm(algorithm);
        listener.setNetworkProtocol(LbProtocol.RAW_TCP);
        listener.setPrivatePort(privatePort);
        listener.setPublicPort(publicPort);
        Collection<String> serverIds = this.getServersAt(ruleId);
        if (current.containsKey(publicIp)) {
            lb = current.get(publicIp);
            LbListener[] listeners = lb.getListeners();
            String[] currentIds = lb.getProviderServerIds();
            TreeSet<Integer> ports = new TreeSet<Integer>();
            for (int port : lb.getPublicPorts()) {
                ports.add(port);
            }
            ports.add(publicPort);
            int[] portList = new int[ports.size()];
            int i = 0;
            for (Integer p : ports) {
                portList[i++] = p;
            }
            lb.setPublicPorts(portList);
            i = 0;
            boolean there = false;
            LbListener[] newList = new LbListener[listeners.length];
            for (LbListener l : listeners) {
                if (l.getAlgorithm().equals((Object)listener.getAlgorithm()) && l.getNetworkProtocol().equals((Object)listener.getNetworkProtocol()) && l.getPublicPort() == listener.getPublicPort() && l.getPrivatePort() == listener.getPrivatePort()) {
                    there = true;
                    break;
                }
                newList[i++] = l;
            }
            if (!there) {
                LbListener[] tmp = new LbListener[newList.length + 1];
                tmp[i++] = listener;
                lb.setListeners(tmp);
            }
            TreeSet<String> newIds = new TreeSet<String>();
            for (String id : currentIds) {
                newIds.add(id);
            }
            for (String id : serverIds) {
                newIds.add(id);
            }
            lb.setProviderServerIds(newIds.toArray(new String[newIds.size()]));
        } else {
            lb = new LoadBalancer();
            lb.setCurrentState(LoadBalancerState.ACTIVE);
            lb.setAddress(publicIp);
            lb.setAddressType(LoadBalancerAddressType.IP);
            lb.setDescription(publicIp + ":" + publicPort + " -> RAW_TCP:" + privatePort);
            lb.setName(publicIp);
            lb.setProviderOwnerId(this.provider.getContext().getAccountNumber());
            lb.setCreationTimestamp(0L);
            lb.setPublicPorts(new int[]{publicPort});
            Collection<DataCenter> dcs = this.provider.getDataCenterServices().listDataCenters(this.provider.getContext().getRegionId());
            String[] ids = new String[dcs.size()];
            int i = 0;
            for (DataCenter dc : dcs) {
                ids[i++] = dc.getProviderDataCenterId();
            }
            lb.setProviderDataCenterIds(ids);
            lb.setProviderLoadBalancerId(publicIp);
            lb.setProviderRegionId(this.provider.getContext().getRegionId());
            lb.setProviderServerIds(serverIds.toArray(new String[serverIds.size()]));
            lb.setListeners(new LbListener[]{listener});
            current.put(publicIp, lb);
        }
    }

    public String getLoadBalancerForAddress(String address) throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.provider);
        boolean isId = this.isId(address);
        String key = isId ? "publicIpId" : "publicIp";
        Document doc = method.get(method.buildUrl(LIST_LOAD_BALANCER_RULES, new Param(key, address)));
        NodeList rules = doc.getElementsByTagName("loadbalancerrule");
        if (rules.getLength() > 0) {
            return address;
        }
        return null;
    }
}

