/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSException;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.cloudstack.network.CSNetworkServices;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.Firewall;
import org.dasein.cloud.network.FirewallSupport;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.IpAddress;
import org.dasein.cloud.network.IpAddressSupport;
import org.dasein.cloud.network.NICCreateOptions;
import org.dasein.cloud.network.NetworkInterface;
import org.dasein.cloud.network.Networkable;
import org.dasein.cloud.network.RoutingTable;
import org.dasein.cloud.network.Subnet;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.network.VLANState;
import org.dasein.cloud.network.VLANSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Network
implements VLANSupport {
    public static final String CREATE_NETWORK = "createNetwork";
    public static final String LIST_NETWORK_OFFERINGS = "listNetworkOfferings";
    public static final String LIST_NETWORKS = "listNetworks";
    private CSCloud cloudstack;

    Network(CSCloud cloudstack) {
        this.cloudstack = cloudstack;
    }

    public boolean allowsNewSubnetCreation() throws CloudException, InternalException {
        return false;
    }

    public void assignRoutingTableToSubnet(@Nonnull String subnetId, @Nonnull String routingTableId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Cannot assign routing tables");
    }

    public void assignRoutingTableToVlan(@Nonnull String vlanId, @Nonnull String routingTableId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Cannot assign routing tables");
    }

    public void attachNetworkInterface(@Nonnull String nicId, @Nonnull String vmId, int index) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Cannot manage network interfaces");
    }

    public String createInternetGateway(@Nonnull String forVlanId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Cannot manage internet gateways");
    }

    @Nonnull
    public String createRoutingTable(@Nonnull String forVlanId, @Nonnull String name, @Nonnull String description) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Cannot assign routing tables");
    }

    @Nonnull
    public NetworkInterface createNetworkInterface(@Nonnull NICCreateOptions options) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Cannot manage network interfaces");
    }

    public void addRouteToAddress(@Nonnull String toRoutingTableId, @Nonnull IPVersion version, @Nullable String destinationCidr, @Nonnull String address) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Cannot manage routing tables");
    }

    public void addRouteToGateway(@Nonnull String toRoutingTableId, @Nonnull IPVersion version, @Nullable String destinationCidr, @Nonnull String gatewayId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Cannot manage internet gateways");
    }

    public void addRouteToNetworkInterface(@Nonnull String toRoutingTableId, @Nonnull IPVersion version, @Nullable String destinationCidr, @Nonnull String nicId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Cannot manage network interfaces");
    }

    public void addRouteToVirtualMachine(@Nonnull String toRoutingTableId, @Nonnull IPVersion version, @Nullable String destinationCidr, @Nonnull String vmId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Cannot manage routing tables");
    }

    public boolean allowsNewNetworkInterfaceCreation() throws CloudException, InternalException {
        return false;
    }

    public boolean allowsNewVlanCreation() throws CloudException, InternalException {
        return false;
    }

    public List<String> findFreeNetworks() throws CloudException, InternalException {
        ArrayList<String> vlans = new ArrayList<String>();
        for (VLAN n : this.listDefaultNetworks(true, true)) {
            if (n == null) continue;
            vlans.add(n.getProviderVlanId());
        }
        for (VLAN n : this.listDefaultNetworks(false, true)) {
            if (n == null || vlans.contains(n.getProviderVlanId())) continue;
            vlans.add(n.getProviderVlanId());
        }
        return vlans;
    }

    public int getMaxVlanCount() throws CloudException, InternalException {
        return 1;
    }

    @Nonnull
    public Collection<NetworkOffering> getNetworkOfferings(@Nonnull String regionId) throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.cloudstack);
        Document doc = method.get(method.buildUrl(LIST_NETWORK_OFFERINGS, new Param("zoneId", regionId)));
        NodeList matches = doc.getElementsByTagName("networkoffering");
        ArrayList<NetworkOffering> offerings = new ArrayList<NetworkOffering>();
        for (int i = 0; i < matches.getLength(); ++i) {
            Node node = matches.item(i);
            NodeList attributes = node.getChildNodes();
            NetworkOffering offering = new NetworkOffering();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node n = attributes.item(j);
                String value = n.getChildNodes().getLength() > 0 ? n.getFirstChild().getNodeValue() : null;
                if (n.getNodeName().equals("id") && value != null) {
                    offering.offeringId = value.trim();
                    continue;
                }
                if (n.getNodeName().equalsIgnoreCase("availability")) {
                    offering.availability = value == null ? "unavailable" : value.trim();
                    continue;
                }
                if (!n.getNodeName().equalsIgnoreCase("guestiptype")) continue;
                offering.networkType = value == null ? "direct" : value.trim();
            }
            offerings.add(offering);
        }
        return offerings;
    }

    @Nullable
    private String getNetworkOffering(@Nonnull String regionId) throws InternalException, CloudException {
        for (NetworkOffering offering : this.getNetworkOfferings(regionId)) {
            if (offering.availability.equalsIgnoreCase("unavailable") || !offering.networkType.equals("virtual")) continue;
            return offering.offeringId;
        }
        return null;
    }

    @Nullable
    public VLAN getVlan(@Nonnull String vlanId) throws CloudException, InternalException {
        ProviderContext ctx = this.cloudstack.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        try {
            CSMethod method = new CSMethod(this.cloudstack);
            Document doc = method.get(method.buildUrl(LIST_NETWORKS, new Param("zoneId", ctx.getRegionId()), new Param("id", vlanId)));
            NodeList matches = doc.getElementsByTagName("network");
            for (int i = 0; i < matches.getLength(); ++i) {
                VLAN vlan;
                Node node = matches.item(i);
                if (node == null || (vlan = this.toNetwork(node, ctx)) == null) continue;
                return vlan;
            }
            return null;
        }
        catch (CSException e) {
            if (e.getHttpCode() == 431) {
                return null;
            }
            throw e;
        }
    }

    public boolean isNetworkInterfaceSupportEnabled() throws CloudException, InternalException {
        return false;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        ProviderContext ctx = this.cloudstack.getContext();
        if (ctx == null) {
            throw new InternalException("No context was established");
        }
        CSMethod method = new CSMethod(this.cloudstack);
        try {
            method.get(method.buildUrl(LIST_NETWORKS, new Param("zoneId", ctx.getRegionId())));
            return true;
        }
        catch (CSException e) {
            int code = e.getHttpCode();
            if (code == 403 || code == 401 || code == 531) {
                return false;
            }
            throw e;
        }
    }

    @Nonnull
    public Iterable<VLAN> listVlans() throws CloudException, InternalException {
        ProviderContext ctx = this.cloudstack.getContext();
        if (ctx == null) {
            throw new InternalException("No context was established");
        }
        CSMethod method = new CSMethod(this.cloudstack);
        Document doc = method.get(method.buildUrl(LIST_NETWORKS, new Param("zoneId", ctx.getRegionId())));
        ArrayList<VLAN> networks = new ArrayList<VLAN>();
        NodeList matches = doc.getElementsByTagName("network");
        for (int i = 0; i < matches.getLength(); ++i) {
            VLAN vlan;
            Node node = matches.item(i);
            if (node == null || (vlan = this.toNetwork(node, ctx)) == null) continue;
            networks.add(vlan);
        }
        return networks;
    }

    public void removeInternetGateway(@Nonnull String forVlanId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Cannot manage internet gateways");
    }

    public void removeNetworkInterface(@Nonnull String nicId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Cannot manage network interfaces");
    }

    public void removeRoute(@Nonnull String inRoutingTableId, @Nonnull String destinationCidr) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Cannot manage routing tables");
    }

    public void removeRoutingTable(@Nonnull String routingTableId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Cannot manage routing tables");
    }

    @Nonnull
    public Iterable<VLAN> listDefaultNetworks(boolean shared, boolean forDeploy) throws CloudException, InternalException {
        ProviderContext ctx = this.cloudstack.getContext();
        if (ctx == null) {
            throw new InternalException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.cloudstack);
        Param[] params = !shared && forDeploy ? new Param[4] : (!shared || forDeploy ? new Param[3] : new Param[]{new Param("zoneId", ctx.getRegionId()), new Param("isdefault", "true")});
        int idx = 2;
        if (forDeploy) {
            params[idx++] = new Param("canUseForDeploy", "true");
        }
        if (!shared) {
            params[idx] = new Param("account", ctx.getAccountNumber());
        }
        Document doc = method.get(method.buildUrl(LIST_NETWORKS, params));
        ArrayList<VLAN> networks = new ArrayList<VLAN>();
        NodeList matches = doc.getElementsByTagName("network");
        for (int i = 0; i < matches.getLength(); ++i) {
            VLAN vlan;
            Node node = matches.item(i);
            if (node == null || (vlan = this.toNetwork(node, ctx)) == null) continue;
            networks.add(vlan);
        }
        return networks;
    }

    @Nonnull
    public VLAN createVlan(@Nonnull String cidr, @Nonnull String name, @Nonnull String description, @Nullable String domainName, @Nullable String[] dnsServers, @Nullable String[] ntpServers) throws CloudException, InternalException {
        if (!this.allowsNewVlanCreation()) {
            throw new OperationNotSupportedException();
        }
        ProviderContext ctx = this.cloudstack.getContext();
        if (ctx == null) {
            throw new InternalException("No context was set for this request");
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No region was set for this request");
        }
        String offering = this.getNetworkOffering(regionId);
        if (offering == null) {
            throw new CloudException("No offerings exist for " + ctx.getRegionId());
        }
        CSMethod method = new CSMethod(this.cloudstack);
        Document doc = method.get(method.buildUrl(CREATE_NETWORK, new Param("zoneId", ctx.getRegionId()), new Param("networkOfferingId", offering), new Param("name", name), new Param("displayText", name)));
        NodeList matches = doc.getElementsByTagName("network");
        for (int i = 0; i < matches.getLength(); ++i) {
            VLAN network;
            Node node = matches.item(i);
            if (node == null || (network = this.toNetwork(node, ctx)) == null) continue;
            return network;
        }
        throw new CloudException("Creation requested failed to create a network without an error");
    }

    public void detachNetworkInterface(@Nonnull String nicId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Cannot manage network interfaces");
    }

    public int getMaxNetworkInterfaceCount() throws CloudException, InternalException {
        return 0;
    }

    public void removeVlan(String vlanId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("VLAN removal is not allowed");
    }

    public boolean supportsInternetGatewayCreation() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsRawAddressRouting() throws CloudException, InternalException {
        return false;
    }

    @Nullable
    public VLAN toNetwork(@Nullable Node node, @Nonnull ProviderContext ctx) {
        if (node == null) {
            return null;
        }
        String netmask = null;
        VLAN network = new VLAN();
        String gateway = null;
        NodeList attributes = node.getChildNodes();
        network.setProviderOwnerId(ctx.getAccountNumber());
        network.setProviderRegionId(ctx.getRegionId());
        network.setCurrentState(VLANState.AVAILABLE);
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (name.equalsIgnoreCase("id")) {
                network.setProviderVlanId(value);
                continue;
            }
            if (name.equalsIgnoreCase("name")) {
                if (network.getName() != null) continue;
                network.setName(value);
                continue;
            }
            if (name.equalsIgnoreCase("displaytext")) {
                network.setName(value);
                continue;
            }
            if (name.equalsIgnoreCase("zoneid") && value != null) {
                network.setProviderRegionId(value);
                continue;
            }
            if (name.startsWith("dns") && value != null && !value.trim().equals("")) {
                String[] dns;
                if (network.getDnsServers() != null) {
                    dns = new String[network.getDnsServers().length + 1];
                    for (int idx = 0; idx < network.getDnsServers().length; ++idx) {
                        dns[idx] = network.getDnsServers()[idx];
                    }
                    dns[dns.length - 1] = value;
                } else {
                    dns = new String[]{value};
                }
                network.setDnsServers(dns);
                continue;
            }
            if (name.equalsIgnoreCase("netmask")) {
                netmask = value;
                continue;
            }
            if (!name.equals("gateway")) continue;
            gateway = value;
        }
        if (network.getProviderVlanId() == null) {
            return null;
        }
        network.setProviderDataCenterId(network.getProviderRegionId());
        if (network.getName() == null) {
            network.setName(network.getProviderVlanId());
        }
        if (network.getDescription() == null) {
            network.setDescription(network.getName());
        }
        if (gateway != null) {
            if (netmask == null) {
                netmask = "255.255.255.0";
            }
            network.setCidr(this.toCidr(gateway, netmask));
        }
        return network;
    }

    @Nonnull
    public Subnet createSubnet(@Nonnull String cidr, @Nonnull String inProviderVlanId, @Nonnull String name, @Nonnull String description) throws CloudException, InternalException {
        throw new OperationNotSupportedException("Unable to create subnets");
    }

    @Nonnull
    public String getProviderTermForNetworkInterface(@Nonnull Locale locale) {
        return "NIC";
    }

    @Nonnull
    public String getProviderTermForSubnet(@Nonnull Locale locale) {
        return "network";
    }

    @Nonnull
    public String getProviderTermForVlan(@Nonnull Locale locale) {
        return "network";
    }

    @Nullable
    public NetworkInterface getNetworkInterface(@Nonnull String nicId) throws CloudException, InternalException {
        return null;
    }

    @Nullable
    public RoutingTable getRoutingTableForSubnet(@Nonnull String subnetId) throws CloudException, InternalException {
        return null;
    }

    @Nonnull
    public Requirement getRoutingTableSupport() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nullable
    public RoutingTable getRoutingTableForVlan(@Nonnull String vlanId) throws CloudException, InternalException {
        return null;
    }

    @Nullable
    public Subnet getSubnet(@Nonnull String subnetId) throws CloudException, InternalException {
        return null;
    }

    @Nonnull
    public Requirement getSubnetSupport() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    public boolean isVlanDataCenterConstrained() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Collection<String> listFirewallIdsForNIC(@Nonnull String nicId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<ResourceStatus> listNetworkInterfaceStatus() throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfaces() throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfacesForVM(@Nonnull String forVmId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfacesInSubnet(@Nonnull String subnetId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfacesInVLAN(@Nonnull String vlanId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<Networkable> listResources(@Nonnull String inVlanId) throws CloudException, InternalException {
        IpAddressSupport ipSupport;
        ArrayList<Networkable> resources = new ArrayList<Networkable>();
        CSNetworkServices network = this.cloudstack.getNetworkServices();
        FirewallSupport fwSupport = network.getFirewallSupport();
        if (fwSupport != null) {
            for (Firewall fw : fwSupport.list()) {
                if (!inVlanId.equals(fw.getProviderVlanId())) continue;
                resources.add((Networkable)fw);
            }
        }
        if ((ipSupport = network.getIpAddressSupport()) != null) {
            for (IPVersion version : ipSupport.listSupportedIPVersions()) {
                for (IpAddress addr : ipSupport.listIpPool(version, false)) {
                    if (!inVlanId.equals(addr.getProviderVlanId())) continue;
                    resources.add((Networkable)addr);
                }
            }
        }
        for (RoutingTable table : this.listRoutingTables(inVlanId)) {
            resources.add((Networkable)table);
        }
        Iterable<VirtualMachine> vms = this.cloudstack.getComputeServices().getVirtualMachineSupport().listVirtualMachines();
        for (VirtualMachine vm : vms) {
            if (!inVlanId.equals(vm.getProviderVlanId())) continue;
            resources.add((Networkable)vm);
        }
        return resources;
    }

    @Nonnull
    public Iterable<RoutingTable> listRoutingTables(@Nonnull String inVlanId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    public boolean isSubnetDataCenterConstrained() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Iterable<Subnet> listSubnets(@Nonnull String inVlanId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException {
        return Collections.singletonList(IPVersion.IPV4);
    }

    @Nonnull
    public Iterable<ResourceStatus> listVlanStatus() throws CloudException, InternalException {
        ProviderContext ctx = this.cloudstack.getContext();
        if (ctx == null) {
            throw new InternalException("No context was established");
        }
        CSMethod method = new CSMethod(this.cloudstack);
        Document doc = method.get(method.buildUrl(LIST_NETWORKS, new Param("zoneId", ctx.getRegionId())));
        ArrayList<ResourceStatus> networks = new ArrayList<ResourceStatus>();
        NodeList matches = doc.getElementsByTagName("network");
        for (int i = 0; i < matches.getLength(); ++i) {
            ResourceStatus vlan;
            Node node = matches.item(i);
            if (node == null || (vlan = this.toVLANStatus(node)) == null) continue;
            networks.add(vlan);
        }
        return networks;
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    public void removeSubnet(String providerSubnetId) throws CloudException, InternalException {
        throw new OperationNotSupportedException("No subnet support");
    }

    @Nonnull
    private String toCidr(@Nonnull String gateway, @Nonnull String netmask) {
        String[] dots = netmask.split("\\.");
        int cidr = 0;
        for (String item : dots) {
            int x = Integer.parseInt(item);
            while (x > 0) {
                ++cidr;
                x = (x << 1) % 256;
            }
        }
        StringBuilder network = new StringBuilder();
        dots = gateway.split("\\.");
        int start = 0;
        for (String item : dots) {
            if (start + 8 < cidr || cidr == 0) {
                network.append(item);
            } else {
                int addresses = (int)Math.pow(2.0, start + 8 - cidr);
                int subnets = 256 / addresses;
                int gw = Integer.parseInt(item);
                for (int i = 0; i < subnets; ++i) {
                    int base = i * addresses;
                    int top = (i + 1) * addresses;
                    if (gw < base || gw >= top) continue;
                    network.append(String.valueOf(base));
                    break;
                }
            }
            if ((start += 8) >= 32) continue;
            network.append(".");
        }
        network.append("/");
        network.append(String.valueOf(cidr));
        return network.toString();
    }

    @Nullable
    public ResourceStatus toVLANStatus(@Nullable Node node) {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        String networkId = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (!name.equalsIgnoreCase("id")) continue;
            networkId = value;
            break;
        }
        if (networkId == null) {
            return null;
        }
        return new ResourceStatus(networkId, (Object)VLANState.AVAILABLE);
    }

    public static class NetworkOffering {
        public String availability;
        public String networkType;
        public String offeringId;
    }
}

