/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.AbstractCloud;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.ContextRequirements;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.cloudstack.CSException;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.CSServiceProvider;
import org.dasein.cloud.cloudstack.CSTopology;
import org.dasein.cloud.cloudstack.CSVersion;
import org.dasein.cloud.cloudstack.Iterables;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.cloudstack.compute.CSComputeServices;
import org.dasein.cloud.cloudstack.identity.CSIdentityServices;
import org.dasein.cloud.cloudstack.network.CSNetworkServices;
import org.dasein.cloud.storage.BlobStoreSupport;
import org.dasein.cloud.storage.StorageServices;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CSCloud
extends AbstractCloud {
    private static final Logger logger = CSCloud.getLogger(CSCloud.class, "std");
    private static final String LIST_ACCOUNTS = "listAccounts";
    private static final String LIST_HYPERVISORS = "listHypervisors";
    private transient CSServiceProvider serviceProvider;
    private transient CSVersion version;

    @Nonnull
    private static String getLastItem(@Nonnull String name) {
        int idx = name.lastIndexOf(46);
        if (idx < 0) {
            return name;
        }
        if (idx == name.length() - 1) {
            return "";
        }
        return name.substring(idx + 1);
    }

    @Nonnull
    public static Logger getLogger(@Nonnull Class<?> cls, @Nonnull String type) {
        String pkg = CSCloud.getLastItem(cls.getPackage().getName());
        pkg = pkg.equals("cloudstack") ? "" : pkg + ".";
        return Logger.getLogger((String)("dasein.cloud.cloudstack." + type + "." + pkg + CSCloud.getLastItem(cls.getName())));
    }

    @Nonnull
    public String getCloudName() {
        ProviderContext ctx = this.getContext();
        if (ctx == null) {
            return "Citrix";
        }
        String name = ctx.getCloudName();
        if (name == null) {
            return "Citrix";
        }
        return name;
    }

    @Nonnull
    public ContextRequirements getContextRequirements() {
        return new ContextRequirements(new ContextRequirements.Field[]{new ContextRequirements.Field("apiKey", "The API Keypair", ContextRequirements.FieldType.KEYPAIR, "accessKeys", true)});
    }

    @Nonnull
    public CSComputeServices getComputeServices() {
        return new CSComputeServices(this);
    }

    @Nonnull
    public CSTopology getDataCenterServices() {
        return new CSTopology(this);
    }

    @Nullable
    public CSIdentityServices getIdentityServices() {
        if (this.getVersion().greaterThan(CSVersion.CS21)) {
            return new CSIdentityServices(this);
        }
        return null;
    }

    @Nonnull
    public CSNetworkServices getNetworkServices() {
        return new CSNetworkServices(this);
    }

    @Nonnull
    public String getProviderName() {
        ProviderContext ctx = this.getContext();
        if (ctx == null) {
            return "Citrix";
        }
        String name = ctx.getProviderName();
        if (name == null) {
            return "Citrix";
        }
        return name;
    }

    public CSServiceProvider getServiceProvider() {
        if (this.serviceProvider == null) {
            String pn = this.getProviderName();
            this.serviceProvider = "kt".equalsIgnoreCase(pn) ? CSServiceProvider.KT : ("datapipe".equalsIgnoreCase(pn) ? CSServiceProvider.DATAPIPE : ("tata".equalsIgnoreCase(pn) ? CSServiceProvider.TATA : ("democloud".equalsIgnoreCase(pn) ? CSServiceProvider.DEMOCLOUD : CSServiceProvider.INTERNAL)));
        }
        return this.serviceProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public CSVersion getVersion() {
        if (this.version == null) {
            Properties properties;
            ProviderContext ctx = this.getContext();
            Properties properties2 = properties = ctx == null ? null : ctx.getCustomProperties();
            if (properties == null || properties.getProperty("apiVersion") == null || properties.getProperty("apiVersion").equals("")) {
                try {
                    CSMethod method = new CSMethod(this);
                    String url = method.buildUrl("listZones", new Param("available", "true"));
                    Document doc = method.get(url, "listZones");
                    NodeList meta = doc.getElementsByTagName("listzonesresponse");
                    for (int item = 0; item < meta.getLength(); ++item) {
                        Node node = meta.item(item);
                        String v = node.getAttributes().getNamedItem("cloud-stack-version").getNodeValue();
                        if (!v.startsWith("4")) continue;
                        if (properties == null) {
                            properties = new Properties();
                        }
                        properties.setProperty("apiVersion", "CS4");
                        logger.info((Object)("Version property not found so setting based on result of query: " + v));
                        CSVersion cSVersion = this.version = CSVersion.CS4;
                        return cSVersion;
                    }
                }
                catch (Throwable ignore) {
                }
                finally {
                    APITrace.end();
                }
            }
            String versionString = properties == null ? "CS3" : properties.getProperty("apiVersion", "CS3");
            try {
                this.version = CSVersion.valueOf(versionString);
            }
            catch (Throwable t) {
                this.version = CSVersion.CS3;
            }
        }
        return this.version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this, (String)"CSCloud.isSubscribed");
        try {
            String ctxKey;
            NodeList matches;
            CSMethod method = new CSMethod(this);
            try {
                Document doc = method.get(method.buildUrl(LIST_ACCOUNTS, new Param[0]), LIST_ACCOUNTS);
                matches = doc.getElementsByTagName("user");
                if (matches.getLength() < 1) {
                    boolean bl = false;
                    return bl;
                }
                ctxKey = null;
            }
            catch (CSException e) {
                int code = e.getHttpCode();
                if (code != 403 && code != 401) {
                    if (code != 531) throw e;
                }
                boolean bl2 = false;
                return bl2;
            }
            catch (CloudException e) {
                int code = e.getHttpCode();
                if (code != 403) {
                    if (code != 401) throw e;
                }
                boolean bl3 = false;
                return bl3;
            }
            try {
                List fields = this.getContextRequirements().getConfigurableValues();
                for (ContextRequirements.Field f : fields) {
                    if (!f.type.equals((Object)ContextRequirements.FieldType.KEYPAIR)) continue;
                    byte[][] keyPair = (byte[][])this.getContext().getConfigurationValue(f);
                    ctxKey = new String(keyPair[0], "utf-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new RuntimeException("This cannot happen: " + e.getMessage());
            }
            int i = 0;
            while (true) {
                if (i >= matches.getLength()) {
                    logger.debug((Object)"No match to api key found");
                    boolean bl = false;
                    return bl;
                }
                boolean found = false;
                String account = null;
                Node node = matches.item(i);
                NodeList attributes = node.getChildNodes();
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Node attribute = attributes.item(j);
                    String name = attribute.getNodeName().toLowerCase();
                    String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
                    if (name.equals("apikey")) {
                        if (!value.equals(ctxKey)) continue;
                        found = true;
                        continue;
                    }
                    if (!name.equals("account")) continue;
                    account = value;
                }
                if (found) {
                    if (!this.getContext().getAccountNumber().equals(account)) {
                        this.getContext().setAccountNumber(account);
                    }
                    boolean bl = true;
                    return bl;
                }
                ++i;
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnegative
    public long parseTime(@Nonnull String timestamp) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        try {
            return df.parse(timestamp).getTime();
        }
        catch (ParseException e) {
            df = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
            try {
                return df.parse(timestamp).getTime();
            }
            catch (ParseException another) {
                return 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String testContext() {
        String string;
        APITrace.begin((CloudProvider)this, (String)"testContext");
        try {
            ProviderContext ctx = this.getContext();
            if (ctx == null) {
                String string2 = null;
                return string2;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"testContext(): Checking CSCloud compute credentials");
            }
            if (!this.isSubscribed()) {
                logger.warn((Object)"testContext(): CSCloud compute credentials are not subscribed for VM services");
                String string3 = null;
                return string3;
            }
            if (this.hasStorageServices()) {
                BlobStoreSupport support;
                StorageServices services;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("testContext(): Checking " + ctx.getStorage() + " storage credentials"));
                }
                if ((services = this.getStorageServices()) != null && services.hasBlobStoreSupport() && (support = services.getBlobStoreSupport()) != null) {
                    try {
                        support.list(null).iterator().hasNext();
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("testContext(): Storage credentials failed: " + t.getMessage()));
                        t.printStackTrace();
                        String string4 = null;
                        APITrace.end();
                        return string4;
                    }
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)"testContext(): Credentials validated");
            }
            string = ctx.getAccountNumber();
            return string;
        }
        catch (Throwable t) {
            logger.warn((Object)("testContext(): Failed to test cloudstack context: " + t.getMessage()));
            t.printStackTrace();
            string = null;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    public Document waitForJob(Document doc, String jobName) throws CloudException, InternalException {
        NodeList matches = doc.getElementsByTagName("jobid");
        if (matches.getLength() > 0) {
            return this.waitForJob(matches.item(0).getFirstChild().getNodeValue(), jobName);
        }
        return null;
    }

    public Document waitForJob(String jobId, String jobName) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this, (String)"waitForJob");
        try {
            int code;
            NodeList matches;
            Document doc;
            CSMethod method = new CSMethod(this);
            String url = method.buildUrl("queryAsyncJobResult", new Param("jobId", jobId));
            while (true) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                doc = method.get(url, "queryAsyncJobResult");
                matches = doc.getElementsByTagName("jobstatus");
                int status = 0;
                if (matches.getLength() > 0) {
                    status = Integer.parseInt(matches.item(0).getFirstChild().getNodeValue());
                }
                if (status <= 0) continue;
                code = status;
                if (status == 1) {
                    Document document = doc;
                    return document;
                }
                if (status == 2) break;
            }
            matches = doc.getElementsByTagName("jobresult");
            if (matches.getLength() > 0) {
                String str = matches.item(0).getFirstChild().getNodeValue();
                if (str == null || str.trim().length() < 1) {
                    NodeList nodes = matches.item(0).getChildNodes();
                    String message = null;
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node n = nodes.item(i);
                        if (n.getNodeName().equalsIgnoreCase("errorcode")) {
                            try {
                                code = Integer.parseInt(n.getFirstChild().getNodeValue().trim());
                            }
                            catch (NumberFormatException ignore) {}
                            continue;
                        }
                        if (!n.getNodeName().equalsIgnoreCase("errortext")) continue;
                        message = n.getFirstChild().getNodeValue().trim();
                    }
                    CSMethod.ParsedError error = new CSMethod.ParsedError();
                    error.code = code;
                    error.message = message;
                    throw new CSException(error);
                }
                throw new CloudException(str);
            }
            throw new CloudException(jobName + " failed with an unexplained error.");
        }
        finally {
            APITrace.end();
        }
    }

    public String getParentAccount() throws CloudException, InternalException {
        return this.getUserAccountData().getParentAccount();
    }

    public String getDomainId() throws CloudException, InternalException {
        return this.getUserAccountData().getDomainId();
    }

    public String getAccountId() throws CloudException, InternalException {
        return this.getUserAccountData().getAccountId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private AccountData getUserAccountData() throws CloudException, InternalException {
        AccountData data = null;
        Cache cache = Cache.getInstance((CloudProvider)this, (String)"account", AccountData.class, (CacheLevel)CacheLevel.CLOUD_ACCOUNT, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.DAY));
        Iterable cachedValues = cache.get(this.getContext());
        if (cachedValues != null && cachedValues.iterator().hasNext()) {
            data = (AccountData)cachedValues.iterator().next();
        }
        if (data != null) {
            return data;
        }
        APITrace.begin((CloudProvider)this, (String)"getUserAccountData");
        try {
            CSMethod method = new CSMethod(this);
            String url = method.buildUrl(LIST_ACCOUNTS, new Param[0]);
            Document doc = method.get(url, LIST_ACCOUNTS);
            NodeList matches = doc.getElementsByTagName("user");
            for (int i = 0; i < matches.getLength(); ++i) {
                boolean foundUser = false;
                String accountForUser = null;
                String domainIdForUser = null;
                String accountIdForUser = null;
                NodeList attributes = matches.item(i).getChildNodes();
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Node attribute = attributes.item(j);
                    String name = attribute.getNodeName().toLowerCase();
                    String value = attribute.hasChildNodes() && attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
                    if (name.equalsIgnoreCase("username")) {
                        if (!this.getContext().getAccountNumber().equalsIgnoreCase(value)) continue;
                        foundUser = true;
                        continue;
                    }
                    if (name.equalsIgnoreCase("account")) {
                        accountForUser = value;
                        continue;
                    }
                    if (name.equalsIgnoreCase("domainid")) {
                        domainIdForUser = value;
                        continue;
                    }
                    if (!"accountid".equalsIgnoreCase(name)) continue;
                    accountIdForUser = value;
                }
                if (!foundUser) continue;
                data = new AccountData(accountIdForUser, accountForUser, domainIdForUser);
                break;
            }
        }
        finally {
            APITrace.end();
        }
        if (data == null) {
            throw new InternalException("Unable to find user account for name " + this.getContext().getAccountNumber());
        }
        cache.put(this.getContext(), Arrays.asList(data));
        return data;
    }

    public static String getTextValue(Node node) {
        if (node.getChildNodes().getLength() == 0) {
            return null;
        }
        return node.getFirstChild().getNodeValue();
    }

    public static boolean getBooleanValue(Node node) {
        return Boolean.valueOf(CSCloud.getTextValue(node));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public List<String> getZoneHypervisors(String regionId) throws CloudException, InternalException {
        ProviderContext ctx = this.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        String cacheName = "hypervisorCache";
        Cache hypervisorCache = Cache.getInstance((CloudProvider)this, (String)cacheName, String.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.DAY));
        List<String> zoneHypervisors = Iterables.toList(hypervisorCache.get(ctx));
        if (zoneHypervisors != null) {
            return zoneHypervisors;
        }
        CSMethod method = new CSMethod(this);
        Document doc = method.get(method.buildUrl(LIST_HYPERVISORS, new Param("zoneid", ctx.getRegionId())), LIST_HYPERVISORS);
        NodeList nodes = doc.getElementsByTagName("name");
        zoneHypervisors = new ArrayList<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            zoneHypervisors.add(item.getFirstChild().getNodeValue().trim());
        }
        hypervisorCache.put(ctx, zoneHypervisors);
        List<String> list = zoneHypervisors;
        return list;
    }

    class AccountData {
        private String accountId;
        private String parentAccount;
        private String domainId;

        public AccountData(String accountId, String parentAccount, String domainId) {
            this.accountId = accountId;
            this.parentAccount = parentAccount;
            this.domainId = domainId;
        }

        public String getAccountId() {
            return this.accountId;
        }

        public String getParentAccount() {
            return this.parentAccount;
        }

        public String getDomainId() {
            return this.domainId;
        }
    }
}

