/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.CSTopologyCapabilities;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.DataCenterCapabilities;
import org.dasein.cloud.dc.DataCenterServices;
import org.dasein.cloud.dc.Region;
import org.dasein.cloud.dc.ResourcePool;
import org.dasein.cloud.dc.StoragePool;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CSTopology
implements DataCenterServices {
    public static final String LIST_ZONES = "listZones";
    private CSCloud provider;
    private volatile transient CSTopologyCapabilities capabilities;

    public CSTopology(@Nonnull CSCloud provider) {
        this.provider = provider;
    }

    @Nonnull
    public DataCenterCapabilities getCapabilities() throws InternalException, CloudException {
        if (this.capabilities == null) {
            this.capabilities = new CSTopologyCapabilities(this.provider);
        }
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataCenter getDataCenter(@Nonnull String zoneId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.getDataCenter");
        try {
            for (Region region : this.listRegions()) {
                for (DataCenter dc : this.listDataCenters(region.getProviderRegionId())) {
                    if (!dc.getProviderDataCenterId().equals(zoneId)) continue;
                    DataCenter dataCenter = dc;
                    return dataCenter;
                }
            }
            DataCenter dataCenter = null;
            return dataCenter;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String getProviderTermForDataCenter(@Nonnull Locale locale) {
        return "zone";
    }

    @Nonnull
    public String getProviderTermForRegion(@Nonnull Locale locale) {
        return "region";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Region getRegion(@Nonnull String regionId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.getRegion");
        try {
            for (Region region : this.listRegions()) {
                if (!region.getProviderRegionId().equals(regionId)) continue;
                Region region2 = region;
                return region2;
            }
            Region region = null;
            return region;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requiresNetwork(@Nonnull String zoneId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.requiresNetwork");
        try {
            CSMethod method = new CSMethod(this.provider);
            String url = method.buildUrl(LIST_ZONES, new Param("available", "true"));
            Document doc = method.get(url, LIST_ZONES);
            NodeList matches = doc.getElementsByTagName("zone");
            for (int i = 0; i < matches.getLength(); ++i) {
                Node zone = matches.item(i);
                if (!zone.hasChildNodes()) continue;
                NodeList attrs = zone.getChildNodes();
                String networkType = null;
                String id = null;
                for (int j = 0; j < attrs.getLength(); ++j) {
                    Node attr = attrs.item(j);
                    if (attr.getNodeName().equalsIgnoreCase("id")) {
                        id = attr.getFirstChild().getNodeValue().trim();
                        continue;
                    }
                    if (!attr.getNodeName().equalsIgnoreCase("networkType")) continue;
                    networkType = attr.getFirstChild().getNodeValue().trim();
                }
                if (!zoneId.equals(id)) continue;
                boolean bl = !"basic".equalsIgnoreCase(networkType);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsSecurityGroups(@Nonnull String zoneId, boolean basicOnly) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.supportsSecurityGroups");
        try {
            CSMethod method = new CSMethod(this.provider);
            String url = method.buildUrl(LIST_ZONES, new Param("available", "true"));
            Document doc = method.get(url, LIST_ZONES);
            boolean sg = false;
            boolean basic = false;
            NodeList matches = doc.getElementsByTagName("zone");
            for (int i = 0; i < matches.getLength(); ++i) {
                Node zone = matches.item(i);
                if (!zone.hasChildNodes()) continue;
                NodeList attrs = zone.getChildNodes();
                boolean groups = false;
                String networkType = null;
                String id = null;
                for (int j = 0; j < attrs.getLength(); ++j) {
                    Node attr = attrs.item(j);
                    if (attr.getNodeName().equalsIgnoreCase("id")) {
                        id = attr.getFirstChild().getNodeValue().trim();
                        continue;
                    }
                    if (attr.getNodeName().equalsIgnoreCase("networkType")) {
                        networkType = attr.getFirstChild().getNodeValue().trim();
                        continue;
                    }
                    if (!attr.getNodeName().equalsIgnoreCase("securitygroupsenabled")) continue;
                    groups = attr.getFirstChild().getNodeValue().trim().equalsIgnoreCase("true");
                }
                if (!zoneId.equals(id)) continue;
                basic = "basic".equalsIgnoreCase(networkType);
                sg = groups;
                break;
            }
            boolean bl = (!basicOnly || basic) && sg;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<DataCenter> listDataCenters(@Nonnull String regionId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.listDataCenters");
        try {
            Cache cache = Cache.getInstance((CloudProvider)this.provider, (String)"dataCenters", DataCenter.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)15, (TimePeriodUnit)TimePeriod.MINUTE));
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            List<DataCenter> dcs = (List<DataCenter>)cache.get(ctx);
            if (dcs == null) {
                Region region = this.getRegion(regionId);
                if (region == null) {
                    throw new CloudException("No such region: " + regionId);
                }
                DataCenter zone = new DataCenter();
                zone.setActive(true);
                zone.setAvailable(true);
                zone.setName(region.getName() + " (DC)");
                zone.setProviderDataCenterId(regionId);
                zone.setRegionId(regionId);
                dcs = Collections.singletonList(zone);
                cache.put(ctx, dcs);
            }
            List<DataCenter> list = dcs;
            return list;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<Region> listRegions() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.provider, (String)"DC.listRegions");
        try {
            Cache cache = Cache.getInstance((CloudProvider)this.provider, (String)"regions", Region.class, (CacheLevel)CacheLevel.CLOUD_ACCOUNT, (TimePeriod)new TimePeriod((Number)15, (TimePeriodUnit)TimePeriod.MINUTE));
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            ArrayList<Region> regions = (ArrayList<Region>)cache.get(ctx);
            if (regions == null) {
                CSMethod method = new CSMethod(this.provider);
                String url = method.buildUrl(LIST_ZONES, new Param("available", "true"));
                Document doc = method.get(url, LIST_ZONES);
                regions = new ArrayList<Region>();
                NodeList matches = doc.getElementsByTagName("zone");
                for (int i = 0; i < matches.getLength(); ++i) {
                    Region r = this.toRegion(matches.item(i));
                    if (r == null || this.provider.getProviderName().contains("Datapipe") && r.getName().contains("Shanghai")) continue;
                    regions.add(r);
                }
                cache.put(ctx, regions);
            }
            ArrayList<Region> arrayList = regions;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public Collection<ResourcePool> listResourcePools(String providerDataCenterId) throws InternalException, CloudException {
        return Collections.emptyList();
    }

    public ResourcePool getResourcePool(String providerResourcePoolId) throws InternalException, CloudException {
        return null;
    }

    public Collection<StoragePool> listStoragePools() throws InternalException, CloudException {
        return Collections.emptyList();
    }

    @Nullable
    private Region toRegion(@Nullable Node node) {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        Region region = new Region();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node n = attributes.item(i);
            String name = n.getNodeName().toLowerCase();
            String value = n.getChildNodes().getLength() > 0 ? n.getFirstChild().getNodeValue() : null;
            if (name.equals("id")) {
                region.setProviderRegionId(value);
                continue;
            }
            if (!name.equals("name")) continue;
            region.setName(value);
        }
        if (region.getProviderRegionId() == null) {
            return null;
        }
        if (region.getName() == null) {
            region.setName(region.getProviderRegionId());
        }
        region.setActive(true);
        region.setAvailable(true);
        region.setJurisdiction(this.getJurisdiction(region.getName()));
        return region;
    }

    private String getJurisdiction(String name) {
        if (name.contains("New York")) {
            return "US";
        }
        if (name.contains("Hong Kong")) {
            return "HK";
        }
        if (name.contains("India")) {
            return "IN";
        }
        if (name.contains("London")) {
            return "EU";
        }
        ProviderContext ctx = this.provider.getContext();
        Properties p = ctx == null ? null : ctx.getCustomProperties();
        return p == null ? "US" : p.getProperty("locale." + name, "US");
    }
}

