/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.compute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.compute.VolumeCapabilities;
import org.dasein.cloud.compute.VolumeFormat;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.cloud.util.NamingConstraints;
import org.dasein.util.uom.storage.Gigabyte;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;

public class CSVolumeCapabilities
extends AbstractCapabilities<CSCloud>
implements VolumeCapabilities {
    public CSVolumeCapabilities(@Nonnull CSCloud provider) {
        super((CloudProvider)provider);
    }

    public boolean canAttach(VmState vmState) throws InternalException, CloudException {
        return vmState.equals((Object)VmState.STOPPED) || vmState.equals((Object)VmState.RUNNING);
    }

    public boolean canDetach(VmState vmState) throws InternalException, CloudException {
        return vmState.equals((Object)VmState.STOPPED) || vmState.equals((Object)VmState.RUNNING);
    }

    public int getMaximumVolumeCount() throws InternalException, CloudException {
        return -2;
    }

    public int getMaximumVolumeProductIOPS() throws InternalException, CloudException {
        return -2;
    }

    public int getMinimumVolumeProductIOPS() throws InternalException, CloudException {
        return -2;
    }

    public int getMaximumVolumeSizeIOPS() throws InternalException, CloudException {
        return -2;
    }

    public int getMinimumVolumeSizeIOPS() throws InternalException, CloudException {
        return -2;
    }

    @Nullable
    public Storage<Gigabyte> getMaximumVolumeSize() throws InternalException, CloudException {
        return new Storage((Number)5000, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public Storage<Gigabyte> getMinimumVolumeSize() throws InternalException, CloudException {
        return new Storage((Number)1, (StorageUnit)Storage.GIGABYTE);
    }

    @Nonnull
    public NamingConstraints getVolumeNamingConstraints() throws CloudException, InternalException {
        return null;
    }

    @Nonnull
    public String getProviderTermForVolume(@Nonnull Locale locale) {
        return "volume";
    }

    @Nonnull
    public Requirement getVolumeProductRequirement() throws InternalException, CloudException {
        return Requirement.OPTIONAL;
    }

    public boolean isVolumeSizeDeterminedByProduct() throws InternalException, CloudException {
        return false;
    }

    @Nonnull
    public Iterable<String> listPossibleDeviceIds(@Nonnull Platform platform) throws InternalException, CloudException {
        Cache cache = platform.isWindows() ? Cache.getInstance((CloudProvider)this.getProvider(), (String)"windowsDeviceIds", String.class, (CacheLevel)CacheLevel.CLOUD) : Cache.getInstance((CloudProvider)this.getProvider(), (String)"unixDeviceIds", String.class, (CacheLevel)CacheLevel.CLOUD);
        List ids = cache.get(this.getContext());
        if (ids == null) {
            ArrayList<String> list = new ArrayList<String>();
            if (platform.isWindows()) {
                list.add("hde");
                list.add("hdf");
                list.add("hdg");
                list.add("hdh");
                list.add("hdi");
                list.add("hdj");
            } else {
                list.add("/dev/xvdc");
                list.add("/dev/xvde");
                list.add("/dev/xvdf");
                list.add("/dev/xvdg");
                list.add("/dev/xvdh");
                list.add("/dev/xvdi");
                list.add("/dev/xvdj");
            }
            ids = Collections.unmodifiableList(list);
            cache.put(this.getContext(), ids);
        }
        return ids;
    }

    @Nonnull
    public Iterable<VolumeFormat> listSupportedFormats() throws InternalException, CloudException {
        return Collections.singletonList(VolumeFormat.BLOCK);
    }

    @Nonnull
    public Requirement requiresVMOnCreate() throws InternalException, CloudException {
        return Requirement.NONE;
    }
}

