/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.compute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.cloudstack.compute.CSSnapshotCapabilities;
import org.dasein.cloud.compute.AbstractSnapshotSupport;
import org.dasein.cloud.compute.Snapshot;
import org.dasein.cloud.compute.SnapshotCapabilities;
import org.dasein.cloud.compute.SnapshotCreateOptions;
import org.dasein.cloud.compute.SnapshotState;
import org.dasein.cloud.compute.Volume;
import org.dasein.cloud.util.APITrace;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Snapshots
extends AbstractSnapshotSupport {
    private static final Logger logger = Logger.getLogger(Snapshots.class);
    private static final String CREATE_SNAPSHOT = "createSnapshot";
    private static final String DELETE_SNAPSHOT = "deleteSnapshot";
    private static final String LIST_SNAPSHOTS = "listSnapshots";
    private CSCloud provider;
    private volatile transient CSSnapshotCapabilities capabilities;

    Snapshots(CSCloud provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    public String createSnapshot(@Nonnull SnapshotCreateOptions options) throws InternalException, CloudException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 21[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nonnull
    public SnapshotCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new CSSnapshotCapabilities(this.provider);
        }
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@Nonnull String snapshotId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Snapshot.remove");
        try {
            CSMethod method = new CSMethod(this.provider);
            String url = method.buildUrl(DELETE_SNAPSHOT, new Param("id", snapshotId));
            Document doc = method.get(url, DELETE_SNAPSHOT);
            this.provider.waitForJob(doc, "Delete Snapshot");
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String getProviderTermForSnapshot(@Nonnull Locale locale) {
        return "snapshot";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listSnapshotStatus() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Snapshot.listSnapshotStatus");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            CSMethod method = new CSMethod(this.provider);
            String url = method.buildUrl(LIST_SNAPSHOTS, new Param("zoneId", ctx.getRegionId()));
            Document doc = method.get(url, LIST_SNAPSHOTS);
            ArrayList<ResourceStatus> snapshots = new ArrayList<ResourceStatus>();
            int numPages = 1;
            NodeList nodes = doc.getElementsByTagName("count");
            Node n = nodes.item(0);
            if (n != null) {
                String value = n.getFirstChild().getNodeValue().trim();
                int count = Integer.parseInt(value);
                numPages = count / 500;
                int remainder = count % 500;
                if (remainder > 0) {
                    ++numPages;
                }
            }
            for (int page = 1; page <= numPages; ++page) {
                if (page > 1) {
                    String nextPage = String.valueOf(page);
                    doc = method.get(method.buildUrl(LIST_SNAPSHOTS, new Param("zoneId", ctx.getRegionId()), new Param("pagesize", "500"), new Param("page", nextPage)), LIST_SNAPSHOTS);
                }
                NodeList matches = doc.getElementsByTagName("snapshot");
                for (int i = 0; i < matches.getLength(); ++i) {
                    ResourceStatus snapshot;
                    Node s = matches.item(i);
                    if (s == null || (snapshot = this.toStatus(s)) == null) continue;
                    snapshots.add(snapshot);
                }
            }
            ArrayList<ResourceStatus> arrayList = snapshots;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isPublic(@Nonnull String snapshotId) throws InternalException, CloudException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<Snapshot> listSnapshots() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Snapshot.listSnapshots");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            Iterable<Volume> volumes = this.provider.getComputeServices().getVolumeSupport().listVolumes();
            CSMethod method = new CSMethod(this.provider);
            String url = method.buildUrl(LIST_SNAPSHOTS, new Param("zoneId", ctx.getRegionId()));
            Document doc = method.get(url, LIST_SNAPSHOTS);
            ArrayList<Snapshot> snapshots = new ArrayList<Snapshot>();
            int numPages = 1;
            NodeList nodes = doc.getElementsByTagName("count");
            Node n = nodes.item(0);
            if (n != null) {
                String value = n.getFirstChild().getNodeValue().trim();
                int count = Integer.parseInt(value);
                numPages = count / 500;
                int remainder = count % 500;
                if (remainder > 0) {
                    ++numPages;
                }
            }
            for (int page = 1; page <= numPages; ++page) {
                if (page > 1) {
                    String nextPage = String.valueOf(page);
                    doc = method.get(method.buildUrl(LIST_SNAPSHOTS, new Param("zoneId", ctx.getRegionId()), new Param("pagesize", "500"), new Param("page", nextPage)), LIST_SNAPSHOTS);
                }
                NodeList matches = doc.getElementsByTagName("snapshot");
                for (int i = 0; i < matches.getLength(); ++i) {
                    Snapshot snapshot;
                    Node s = matches.item(i);
                    if (s == null || (snapshot = this.toSnapshot(s, ctx, volumes)) == null) continue;
                    snapshots.add(snapshot);
                }
            }
            ArrayList<Snapshot> arrayList = snapshots;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    private Snapshot getLatestSnapshot(String forVolumeId) throws InternalException, CloudException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.provider);
        String url = method.buildUrl(LIST_SNAPSHOTS, new Param("zoneId", ctx.getRegionId()), new Param("volumeId", forVolumeId));
        Volume volume = this.provider.getComputeServices().getVolumeSupport().getVolume(forVolumeId);
        List<Object> volumes = volume == null ? Collections.emptyList() : Collections.singletonList(volume);
        Document doc = method.get(url, LIST_SNAPSHOTS);
        Snapshot latest = null;
        NodeList matches = doc.getElementsByTagName("snapshot");
        for (int i = 0; i < matches.getLength(); ++i) {
            Snapshot snapshot;
            Node s = matches.item(i);
            if (s == null || (snapshot = this.toSnapshot(s, ctx, volumes)) == null || snapshot.getVolumeId() == null || !snapshot.getVolumeId().equals(forVolumeId) || latest != null && snapshot.getSnapshotTimestamp() <= latest.getSnapshotTimestamp()) continue;
            latest = snapshot;
        }
        return latest;
    }

    @Nullable
    private Snapshot toSnapshot(@Nullable Node node, @Nonnull ProviderContext ctx, @Nonnull Iterable<Volume> volumes) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        Snapshot snapshot = new Snapshot();
        NodeList attrs = node.getChildNodes();
        String type = null;
        snapshot.setCurrentState(SnapshotState.AVAILABLE);
        snapshot.setOwner(ctx.getAccountNumber());
        snapshot.setProgress("100%");
        snapshot.setRegionId(ctx.getRegionId());
        snapshot.setSizeInGb(1);
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            String value = null;
            if (attr.hasChildNodes()) {
                value = attr.getFirstChild().getNodeValue();
            }
            if (name.equalsIgnoreCase("id")) {
                snapshot.setProviderSnapshotId(value);
                continue;
            }
            if (name.equalsIgnoreCase("volumeid")) {
                snapshot.setVolumeId(value);
                if (value == null) continue;
                Volume v = null;
                for (Volume volume : volumes) {
                    if (!volume.getProviderVolumeId().equals(value)) continue;
                    v = volume;
                    break;
                }
                if (v == null) continue;
                snapshot.setSizeInGb(v.getSize().intValue());
                continue;
            }
            if (name.equalsIgnoreCase("name")) {
                snapshot.setName(value);
                continue;
            }
            if (value != null && name.equalsIgnoreCase("created")) {
                snapshot.setSnapshotTimestamp(this.provider.parseTime(value));
                continue;
            }
            if (name.equalsIgnoreCase("snapshottype")) {
                type = value;
                continue;
            }
            if (name.equals("account")) {
                snapshot.setOwner(value);
                continue;
            }
            if (!name.equals("state")) continue;
            String state = value;
            if (state.equalsIgnoreCase("backedup")) {
                snapshot.setCurrentState(SnapshotState.AVAILABLE);
                continue;
            }
            snapshot.setCurrentState(SnapshotState.PENDING);
        }
        if (snapshot.getProviderSnapshotId() == null) {
            return null;
        }
        if (snapshot.getName() == null) {
            snapshot.setName(snapshot.getProviderSnapshotId());
        }
        if (snapshot.getDescription() == null) {
            if (type == null) {
                snapshot.setDescription(snapshot.getName());
            } else {
                snapshot.setDescription(snapshot.getName() + " (" + type + ")");
            }
        }
        return snapshot;
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        NodeList attrs = node.getChildNodes();
        String snapId = null;
        SnapshotState state = null;
        for (int i = 0; i < attrs.getLength(); ++i) {
            Node attr = attrs.item(i);
            String name = attr.getNodeName();
            String value = null;
            if (attr.hasChildNodes()) {
                value = attr.getFirstChild().getNodeValue();
            }
            if (name.equalsIgnoreCase("id")) {
                snapId = value;
                break;
            }
            if (!name.equals("state")) continue;
            state = value.equalsIgnoreCase("backedup") ? SnapshotState.AVAILABLE : SnapshotState.PENDING;
        }
        if (snapId == null) {
            return null;
        }
        return new ResourceStatus(snapId, state);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Snapshot.isSubscribed");
        try {
            boolean bl = this.provider.getComputeServices().getVolumeSupport().isSubscribed();
            return bl;
        }
        finally {
            APITrace.end();
        }
    }
}

