/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.compute;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.AsynchronousTask;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSException;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.CSServiceProvider;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.cloudstack.compute.CSTemplateCapabilities;
import org.dasein.cloud.compute.AbstractImageSupport;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ImageCapabilities;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.ImageCreateOptions;
import org.dasein.cloud.compute.ImageFilterOptions;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.MachineImageFormat;
import org.dasein.cloud.compute.MachineImageState;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.util.APITrace;
import org.dasein.util.Jiterator;
import org.dasein.util.JiteratorPopulator;
import org.dasein.util.PopulatorThread;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Templates
extends AbstractImageSupport {
    public static final Logger logger = Logger.getLogger(Templates.class);
    private static final String CREATE_TEMPLATE = "createTemplate";
    private static final String DELETE_ISO = "deleteIso";
    private static final String DELETE_TEMPLATE = "deleteTemplate";
    private static final String LIST_ISOS = "listIsos";
    private static final String LIST_OS_TYPES = "listOsTypes";
    private static final String LIST_ISO_PERMISSIONS = "listIsoPermissions";
    private static final String LIST_TEMPLATE_PERMISSIONS = "listTemplatePermissions";
    private static final String LIST_TEMPLATES = "listTemplates";
    private static final String REGISTER_TEMPLATE = "registerTemplate";
    private static final String UPDATE_ISO_PERMISSIONS = "updateIsoPermissions";
    private static final String UPDATE_TEMPLATE_PERMISSIONS = "updateTemplatePermissions";
    private CSCloud provider;
    private volatile transient CSTemplateCapabilities capabilities;

    public Templates(CSCloud provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageShare(@Nonnull String providerImageId, @Nonnull String accountNumber) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.addImageShare");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            MachineImage img = this.getImage(providerImageId);
            if (img == null) {
                return;
            }
            if (!ctx.getAccountNumber().equals(img.getProviderOwnerId()) && !this.provider.getParentAccount().equalsIgnoreCase(img.getProviderOwnerId())) {
                return;
            }
            Param[] params = new Param[]{new Param("id", providerImageId), new Param("accounts", accountNumber), new Param("op", "add")};
            CSMethod method = new CSMethod(this.provider);
            try {
                Document doc = method.get(method.buildUrl(UPDATE_TEMPLATE_PERMISSIONS, params), UPDATE_TEMPLATE_PERMISSIONS);
                this.provider.waitForJob(doc, "Share Template");
            }
            catch (CSException e) {
                if (e.getHttpCode() == 431) {
                    Document doc = method.get(method.buildUrl(UPDATE_ISO_PERMISSIONS, params), UPDATE_ISO_PERMISSIONS);
                    this.provider.waitForJob(doc, "Share Iso");
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPublicShare(@Nonnull String providerImageId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.addPublicShare");
        try {
            MachineImage img = this.getImage(providerImageId);
            if (img == null) {
                return;
            }
            if (!this.getContext().getAccountNumber().equals(img.getProviderOwnerId()) && !this.provider.getParentAccount().equalsIgnoreCase(img.getProviderOwnerId())) {
                return;
            }
            Param[] params = new Param[]{new Param("id", providerImageId), new Param("isPublic", "true")};
            CSMethod method = new CSMethod(this.provider);
            try {
                Document doc = method.get(method.buildUrl(UPDATE_TEMPLATE_PERMISSIONS, params), UPDATE_TEMPLATE_PERMISSIONS);
                this.provider.waitForJob(doc, "Share Template");
            }
            catch (CSException e) {
                if (e.getHttpCode() == 431) {
                    Document doc = method.get(method.buildUrl(UPDATE_ISO_PERMISSIONS, params), UPDATE_ISO_PERMISSIONS);
                    this.provider.waitForJob(doc, "Share Iso");
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    public ImageCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new CSTemplateCapabilities(this.provider);
        }
        return this.capabilities;
    }

    /*
     * Exception decompiling
     */
    public MachineImage getImage(@Nonnull String providerImageId) throws CloudException, InternalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Nullable
    private String getRootVolume(@Nonnull String serverId) throws InternalException, CloudException {
        return this.provider.getComputeServices().getVolumeSupport().getRootVolumeId(serverId);
    }

    private Architecture guess(String desc) {
        Architecture arch = Architecture.I64;
        if (desc.contains("x64")) {
            arch = Architecture.I64;
        } else if (desc.contains("x32")) {
            arch = Architecture.I32;
        } else if (desc.contains("64 bit")) {
            arch = Architecture.I64;
        } else if (desc.contains("32 bit")) {
            arch = Architecture.I32;
        } else if (desc.contains("i386")) {
            arch = Architecture.I32;
        } else if (desc.contains("64")) {
            arch = Architecture.I64;
        } else if (desc.contains("32")) {
            arch = Architecture.I32;
        }
        return arch;
    }

    private void guessSoftware(@Nonnull MachineImage image) {
        String[] components = (image.getName() + " " + image.getDescription()).toLowerCase().split(",");
        StringBuilder software = new StringBuilder();
        boolean comma = false;
        if (components == null || components.length < 0) {
            components = new String[]{(image.getName() + " " + image.getDescription()).toLowerCase()};
        }
        for (String str : components) {
            if (!str.contains("sql server")) continue;
            if (comma) {
                software.append(",");
            }
            if (str.contains("sql server 2008")) {
                software.append("SQL Server 2008");
            } else if (str.contains("sql server 2005")) {
                software.append("SQL Server 2005");
            } else {
                software.append("SQL Server 2008");
            }
            comma = true;
        }
        image.withSoftware(software.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    protected MachineImage capture(@Nonnull ImageCreateOptions options, @Nullable AsynchronousTask<MachineImage> task) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.capture");
        try {
            MachineImage img;
            NodeList nodeList;
            String rootVolumeId;
            String vmId = options.getVirtualMachineId();
            if (vmId == null) {
                throw new OperationNotSupportedException("Only options based off of servers are supported");
            }
            VirtualMachine server = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(vmId);
            if (server == null) {
                throw new CloudException("No such server: " + vmId);
            }
            CSMethod method = new CSMethod(this.provider);
            boolean restart = false;
            if (!server.getCurrentState().equals((Object)VmState.STOPPED)) {
                restart = true;
                this.provider.getComputeServices().getVirtualMachineSupport().stop(vmId);
                long timeout = System.currentTimeMillis() + 600000L;
                server = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(vmId);
                while (timeout > System.currentTimeMillis() && !server.getCurrentState().equals((Object)VmState.STOPPED)) {
                    server = this.provider.getComputeServices().getVirtualMachineSupport().getVirtualMachine(vmId);
                    try {
                        Thread.sleep(15000L);
                    }
                    catch (InterruptedException ignore) {}
                }
            }
            if ((rootVolumeId = this.getRootVolume(vmId)) == null) {
                throw new CloudException("No root volume is attached to the target server.");
            }
            String osId = server.getTag("guestosid").toString();
            String name = this.validateName(options.getName());
            ArrayList<Param> params = new ArrayList<Param>();
            params.add(new Param("name", name));
            params.add(new Param("displayText", name));
            params.add(new Param("osTypeId", osId == null ? this.toOs(server.getPlatform(), server.getArchitecture()) : osId));
            params.add(new Param("zoneId", this.getContext().getRegionId()));
            params.add(new Param("isPublic", "false"));
            params.add(new Param("isFeatured", "false"));
            params.add(new Param("volumeid", rootVolumeId));
            params.add(new Param("passwordEnabled", String.valueOf(server.getTag("passwordenabled"))));
            Document doc = method.get(method.buildUrl(CREATE_TEMPLATE, params), CREATE_TEMPLATE);
            NodeList matches = doc.getElementsByTagName("templateid");
            String templateId = null;
            if (matches.getLength() > 0) {
                templateId = matches.item(0).getFirstChild().getNodeValue();
            }
            if (templateId == null && (matches = doc.getElementsByTagName("id")).getLength() > 0) {
                templateId = matches.item(0).getFirstChild().getNodeValue();
            }
            if (templateId == null && (matches = doc.getElementsByTagName("jobid")).getLength() > 0) {
                templateId = matches.item(0).getFirstChild().getNodeValue();
            }
            if (templateId == null) {
                throw new CloudException("Failed to provide a template ID.");
            }
            Document responseDoc = this.provider.waitForJob(doc, "Create Template");
            if (responseDoc != null && (nodeList = responseDoc.getElementsByTagName("template")).getLength() > 0) {
                Node template = nodeList.item(0);
                NodeList attributes = template.getChildNodes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attribute = attributes.item(i);
                    String tmpname = attribute.getNodeName().toLowerCase();
                    String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
                    if (!tmpname.equalsIgnoreCase("id")) continue;
                    templateId = value;
                    break;
                }
            }
            if ((img = this.getImage(templateId)) == null) {
                throw new CloudException("Machine image job completed successfully, but no image " + templateId + " exists.");
            }
            if (task != null) {
                task.completeWithResult((Object)img);
            }
            if (restart) {
                this.provider.getComputeServices().getVirtualMachineSupport().start(vmId);
            }
            MachineImage machineImage = img;
            return machineImage;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isImageSharedWithPublic(@Nonnull String templateId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.isImageSharedWithPublic");
        try {
            Document doc;
            CSMethod method = new CSMethod(this.provider);
            String url = method.buildUrl(LIST_TEMPLATES, new Param("templateFilter", "executable"), new Param("id", templateId));
            boolean isTemplate = true;
            try {
                doc = method.get(url, LIST_TEMPLATES);
            }
            catch (CSException e) {
                if (e.getHttpCode() == 431) {
                    url = method.buildUrl(LIST_ISOS, new Param("id", templateId), new Param("isoFilter", "executable"), new Param("bootable", "true"));
                    doc = method.get(url, LIST_ISOS);
                    isTemplate = false;
                }
                throw e;
            }
            NodeList matches = isTemplate ? doc.getElementsByTagName("template") : doc.getElementsByTagName("iso");
            for (int i = 0; i < matches.getLength(); ++i) {
                Node node = matches.item(i);
                MachineImage image = this.toImage(node, true, null);
                if (image == null || !image.getProviderMachineImageId().equals(templateId)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPasswordEnabled(@Nonnull String templateId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.isPasswordEnabled");
        try {
            Document doc;
            CSMethod method = new CSMethod(this.provider);
            String url = method.buildUrl(LIST_TEMPLATES, new Param("templateFilter", "executable"), new Param("id", templateId));
            boolean isTemplate = true;
            try {
                doc = method.get(url, LIST_TEMPLATES);
            }
            catch (CSException e) {
                if (e.getHttpCode() == 431) {
                    url = method.buildUrl(LIST_ISOS, new Param("id", templateId), new Param("isoFilter", "executable"), new Param("bootable", "true"));
                    doc = method.get(url, LIST_ISOS);
                    isTemplate = false;
                }
                throw e;
            }
            NodeList matches = isTemplate ? doc.getElementsByTagName("template") : doc.getElementsByTagName("iso");
            if (matches.getLength() > 0) {
                Node node = matches.item(0);
                Boolean val = this.isPasswordEnabled(templateId, node);
                boolean bl = val != null && val != false;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    private Boolean isPasswordEnabled(@Nonnull String templateId, @Nullable Node node) {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        boolean enabled = false;
        String id = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (name.equalsIgnoreCase("id")) {
                id = value;
            } else if (name.equalsIgnoreCase("passwordenabled")) {
                boolean bl = enabled = value != null && value.equalsIgnoreCase("true");
            }
            if (id != null && enabled) break;
        }
        if (id == null || !id.equals(templateId)) {
            return null;
        }
        return enabled;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.isSubscribed");
        try {
            CSMethod method = new CSMethod(this.provider);
            try {
                method.get(method.buildUrl("listZones", new Param("available", "true")), "listZones");
                boolean bl = true;
                return bl;
            }
            catch (CSException e) {
                block7: {
                    int code = e.getHttpCode();
                    if (code != 403 && code != 401 && code != 531) break block7;
                    boolean bl = false;
                    APITrace.end();
                    return bl;
                }
                throw e;
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listImageStatus(@Nonnull ImageClass cls) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.listImageStatus");
        try {
            if (!cls.equals((Object)ImageClass.MACHINE)) {
                List<ResourceStatus> list = Collections.emptyList();
                return list;
            }
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            CSMethod method = new CSMethod(this.provider);
            Document doc = method.get(method.buildUrl(LIST_TEMPLATES, new Param("templateFilter", "self"), new Param("zoneId", ctx.getRegionId())), LIST_TEMPLATES);
            ArrayList<ResourceStatus> templates = new ArrayList<ResourceStatus>();
            int numPages = 1;
            NodeList nodes = doc.getElementsByTagName("count");
            Node n = nodes.item(0);
            if (n != null) {
                String value = n.getFirstChild().getNodeValue().trim();
                int count = Integer.parseInt(value);
                numPages = count / 500;
                int remainder = count % 500;
                if (remainder > 0) {
                    ++numPages;
                }
            }
            for (int page = 1; page <= numPages; ++page) {
                if (page > 1) {
                    String nextPage = String.valueOf(page);
                    doc = method.get(method.buildUrl(LIST_TEMPLATES, new Param("templateFilter", "self"), new Param("zoneId", ctx.getRegionId()), new Param("pagesize", "500"), new Param("page", nextPage)), LIST_TEMPLATES);
                }
                NodeList matches = doc.getElementsByTagName("template");
                for (int i = 0; i < matches.getLength(); ++i) {
                    ResourceStatus status = this.toStatus(matches.item(i), false);
                    if (status == null) continue;
                    templates.add(status);
                }
            }
            ArrayList<ResourceStatus> arrayList = templates;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private List<ResourceStatus> listIsoStatus() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.listImageStatus");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            CSMethod method = new CSMethod(this.provider);
            Document doc = method.get(method.buildUrl(LIST_ISOS, new Param("isoFilter", "self"), new Param("zoneId", ctx.getRegionId()), new Param("bootable", "true")), LIST_ISOS);
            ArrayList<ResourceStatus> templates = new ArrayList<ResourceStatus>();
            int numPages = 1;
            NodeList nodes = doc.getElementsByTagName("count");
            Node n = nodes.item(0);
            if (n != null) {
                String value = n.getFirstChild().getNodeValue().trim();
                int count = Integer.parseInt(value);
                numPages = count / 500;
                int remainder = count % 500;
                if (remainder > 0) {
                    ++numPages;
                }
            }
            for (int page = 1; page <= numPages; ++page) {
                if (page > 1) {
                    String nextPage = String.valueOf(page);
                    doc = method.get(method.buildUrl(LIST_ISOS, new Param("isoFilter", "self"), new Param("zoneId", ctx.getRegionId()), new Param("bootable", "true"), new Param("pagesize", "500"), new Param("page", nextPage)), LIST_ISOS);
                }
                NodeList matches = doc.getElementsByTagName("iso");
                for (int i = 0; i < matches.getLength(); ++i) {
                    ResourceStatus status = this.toStatus(matches.item(i), false);
                    if (status == null) continue;
                    templates.add(status);
                }
            }
            ArrayList<ResourceStatus> arrayList = templates;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<MachineImage> listImages(@Nullable ImageFilterOptions options) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.listImages");
        try {
            List<String> hypervisors = this.provider.getZoneHypervisors(this.getContext().getRegionId());
            CSMethod method = new CSMethod(this.provider);
            String accountNumber = options == null ? null : options.getAccountNumber();
            ArrayList<Param> params = new ArrayList<Param>();
            params.add(new Param("zoneId", this.getContext().getRegionId()));
            params.add(new Param("pagesize", "500"));
            if (hypervisors != null && hypervisors.size() == 1) {
                params.add(new Param("hypervisor", hypervisors.get(0)));
            }
            String templateFilter = "executable";
            if (accountNumber == null || this.provider.getServiceProvider().equals((Object)CSServiceProvider.DATAPIPE)) {
                templateFilter = "selfexecutable";
            }
            params.add(new Param("templateFilter", templateFilter));
            Param pageParam = new Param("page", "1");
            params.add(pageParam);
            Document doc = method.get(method.buildUrl(LIST_TEMPLATES, params), LIST_TEMPLATES);
            ArrayList<MachineImage> templates = new ArrayList<MachineImage>();
            int numPages = 1;
            NodeList nodes = doc.getElementsByTagName("count");
            Node n = nodes.item(0);
            if (n != null) {
                String value = n.getFirstChild().getNodeValue().trim();
                int count = Integer.parseInt(value);
                numPages = count / 500;
                int remainder = count % 500;
                if (remainder > 0) {
                    ++numPages;
                }
            }
            for (int page = 1; page <= numPages; ++page) {
                if (page > 1) {
                    String nextPage = String.valueOf(page);
                    pageParam.setValue(nextPage);
                    doc = method.get(method.buildUrl(LIST_TEMPLATES, params), LIST_TEMPLATES);
                }
                NodeList matches = doc.getElementsByTagName("template");
                for (int i = 0; i < matches.getLength(); ++i) {
                    MachineImage image = this.toImage(matches.item(i), false, hypervisors);
                    if (image == null || options != null && !options.matches(image)) continue;
                    templates.add(image);
                }
            }
            ArrayList<MachineImage> arrayList = templates;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private ArrayList<MachineImage> listIsos(@Nullable ImageFilterOptions options) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.listIsos");
        try {
            CSMethod method = new CSMethod(this.provider);
            String accountNumber = options == null ? null : options.getAccountNumber();
            Param[] params = accountNumber == null || this.provider.getServiceProvider().equals((Object)CSServiceProvider.DATAPIPE) ? new Param[]{new Param("isoFilter", "selfexecutable"), new Param("zoneId", this.getContext().getRegionId()), new Param("bootable", "true"), new Param("pagesize", "500"), new Param("page", "1")} : new Param[]{new Param("isoFilter", "executable"), new Param("zoneId", this.getContext().getRegionId()), new Param("bootable", "true"), new Param("pagesize", "500"), new Param("page", "1")};
            Document doc = method.get(method.buildUrl(LIST_ISOS, params), LIST_ISOS);
            ArrayList<MachineImage> templates = new ArrayList<MachineImage>();
            int numPages = 1;
            NodeList nodes = doc.getElementsByTagName("count");
            Node n = nodes.item(0);
            if (n != null) {
                String value = n.getFirstChild().getNodeValue().trim();
                int count = Integer.parseInt(value);
                numPages = count / 500;
                int remainder = count % 500;
                if (remainder > 0) {
                    ++numPages;
                }
            }
            for (int page = 1; page <= numPages; ++page) {
                if (page > 1) {
                    String nextPage = String.valueOf(page);
                    int length = params.length;
                    params[length - 1] = new Param("page", nextPage);
                    doc = method.get(method.buildUrl(LIST_ISOS, params), LIST_ISOS);
                }
                NodeList matches = doc.getElementsByTagName("iso");
                for (int i = 0; i < matches.getLength(); ++i) {
                    MachineImage image = this.toImage(matches.item(i), false, this.provider.getZoneHypervisors(this.getContext().getRegionId()));
                    if (image == null || options != null && !options.matches(image)) continue;
                    image.setTag("isISO", "true");
                    templates.add(image);
                }
            }
            ArrayList<MachineImage> arrayList = templates;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<String> listShares(@Nonnull String templateId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.listShares");
        try {
            Document doc;
            CSMethod method = new CSMethod(this.provider);
            try {
                doc = method.get(method.buildUrl(LIST_TEMPLATE_PERMISSIONS, new Param("id", templateId)), LIST_TEMPLATES);
            }
            catch (CSException e) {
                if (e.getHttpCode() == 431) {
                    doc = method.get(method.buildUrl(LIST_ISO_PERMISSIONS, new Param("id", templateId)), LIST_ISO_PERMISSIONS);
                }
                throw e;
            }
            TreeSet<String> accounts = new TreeSet<String>();
            NodeList matches = doc.getElementsByTagName("account");
            for (int i = 0; i < matches.getLength(); ++i) {
                Node node = matches.item(i);
                accounts.add(node.getFirstChild().getNodeValue());
            }
            TreeSet<String> treeSet = accounts;
            return treeSet;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public MachineImage registerImageBundle(@Nonnull ImageCreateOptions options) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.registerImageBundle");
        try {
            String format;
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            String atStorageLocation = options.getBundleLocation();
            if (atStorageLocation == null) {
                throw new OperationNotSupportedException("Cannot register a machine image without a location");
            }
            String name = this.validateName(options.getName());
            Platform platform = Platform.guess((String)name);
            Architecture architecture = this.guess(name);
            ArrayList<Param> params = new ArrayList<Param>();
            params.add(new Param("name", name));
            params.add(new Param("displayText", name));
            params.add(new Param("url", atStorageLocation));
            MachineImageFormat fmt = options.getBundleFormat();
            if (fmt == null) {
                throw new CloudException("You must specify the bundle format for the new bundle");
            }
            switch (options.getBundleFormat()) {
                case VHD: {
                    format = "VHD";
                    break;
                }
                case RAW: {
                    format = "RAW";
                    break;
                }
                case QCOW2: {
                    format = "QCOW2";
                    break;
                }
                default: {
                    throw new OperationNotSupportedException("Unsupported bundle format: " + options.getBundleFormat());
                }
            }
            params.add(new Param("format", format));
            params.add(new Param("osTypeId", this.toOs(platform, architecture)));
            params.add(new Param("zoneId", ctx.getRegionId()));
            params.add(new Param("isPublic", "false"));
            params.add(new Param("isFeatured", "false"));
            CSMethod method = new CSMethod(this.provider);
            Document doc = method.get(method.buildUrl(REGISTER_TEMPLATE, params), REGISTER_TEMPLATE);
            NodeList matches = doc.getElementsByTagName("templateid");
            String templateId = null;
            if (matches.getLength() > 0) {
                templateId = matches.item(0).getFirstChild().getNodeValue();
            } else {
                matches = doc.getElementsByTagName("id");
                if (matches.getLength() > 0) {
                    templateId = matches.item(0).getFirstChild().getNodeValue();
                }
            }
            if (templateId == null) {
                throw new CloudException("No error was encountered during registration, but no templateId was returned");
            }
            this.provider.waitForJob(doc, "Create Template");
            MachineImage img = this.getImage(templateId);
            if (img == null) {
                throw new CloudException("Machine image " + templateId + " was created, but it does not exist");
            }
            MachineImage machineImage = img;
            return machineImage;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(@Nonnull String providerImageId, boolean checkState) throws CloudException, InternalException {
        block9: {
            APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.remove");
            try {
                ProviderContext ctx = this.provider.getContext();
                if (ctx == null) {
                    throw new CloudException("No context was set for the request");
                }
                String regionId = ctx.getRegionId();
                String accountNumber = ctx.getAccountNumber();
                MachineImage img = this.getImage(providerImageId);
                if (img == null) {
                    throw new CloudException("No such machine image: " + providerImageId);
                }
                if (!accountNumber.equals(img.getProviderOwnerId()) && !this.provider.getParentAccount().equalsIgnoreCase(img.getProviderOwnerId())) {
                    throw new CloudException(accountNumber + " cannot remove images belonging to " + img.getProviderOwnerId());
                }
                CSMethod method = new CSMethod(this.provider);
                try {
                    Document doc = method.get(method.buildUrl(DELETE_TEMPLATE, new Param("id", providerImageId), new Param("zoneid", regionId)), DELETE_TEMPLATE);
                    this.provider.waitForJob(doc, "Delete Template");
                }
                catch (CSException e) {
                    if (e.getHttpCode() == 431) {
                        Document doc = method.get(method.buildUrl(DELETE_ISO, new Param("id", providerImageId)), DELETE_ISO);
                        this.provider.waitForJob(doc, "Delete Iso");
                        break block9;
                    }
                    throw e;
                }
            }
            finally {
                APITrace.end();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllImageShares(@Nonnull String providerImageId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.removeAllImageShares");
        try {
            for (String account : this.listShares(providerImageId)) {
                this.removeImageShare(providerImageId, account);
            }
            this.removePublicShare(providerImageId);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImageShare(@Nonnull String providerImageId, @Nonnull String accountNumber) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.removeImageShare");
        try {
            MachineImage img = this.getImage(providerImageId);
            if (img == null) {
                return;
            }
            if (!this.getContext().getAccountNumber().equals(img.getProviderOwnerId()) && !this.provider.getParentAccount().equalsIgnoreCase(img.getProviderOwnerId())) {
                return;
            }
            Param[] params = new Param[]{new Param("id", providerImageId), new Param("accounts", accountNumber), new Param("op", "remove")};
            CSMethod method = new CSMethod(this.provider);
            try {
                Document doc = method.get(method.buildUrl(UPDATE_TEMPLATE_PERMISSIONS, params), UPDATE_TEMPLATE_PERMISSIONS);
                this.provider.waitForJob(doc, "Share Template");
            }
            catch (CSException e) {
                if (e.getHttpCode() == 431) {
                    Document doc = method.get(method.buildUrl(UPDATE_ISO_PERMISSIONS, params), UPDATE_ISO_PERMISSIONS);
                    this.provider.waitForJob(doc, "Share Iso");
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePublicShare(@Nonnull String providerImageId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Image.removePublicShare");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            MachineImage img = this.getImage(providerImageId);
            if (img == null) {
                return;
            }
            if (!ctx.getAccountNumber().equals(img.getProviderOwnerId()) && !this.provider.getParentAccount().equalsIgnoreCase(img.getProviderOwnerId())) {
                return;
            }
            Param[] params = new Param[]{new Param("id", providerImageId), new Param("isPublic", "false")};
            CSMethod method = new CSMethod(this.provider);
            try {
                Document doc = method.get(method.buildUrl(UPDATE_TEMPLATE_PERMISSIONS, params), UPDATE_TEMPLATE_PERMISSIONS);
                this.provider.waitForJob(doc, "Share Template");
            }
            catch (CSException e) {
                if (e.getHttpCode() == 431) {
                    Document doc = method.get(method.buildUrl(UPDATE_ISO_PERMISSIONS, params), UPDATE_ISO_PERMISSIONS);
                    this.provider.waitForJob(doc, "Share Iso");
                }
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<MachineImage> searchPublicImages(final @Nonnull ImageFilterOptions options) throws CloudException, InternalException {
        final ArrayList<Param> params = new ArrayList<Param>();
        final ArrayList<MachineImage> allImages = new ArrayList<MachineImage>();
        final CSMethod method = new CSMethod(this.provider);
        Param filterParam = new Param("templateFilter", "featured");
        params.add(filterParam);
        final List<String> hypervisors = this.provider.getZoneHypervisors(this.getContext().getRegionId());
        if (hypervisors != null && hypervisors.size() == 1) {
            params.add(new Param("hypervisor", hypervisors.get(0)));
        }
        params.add(new Param("zoneId", this.getContext().getRegionId()));
        this.provider.hold();
        PopulatorThread populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<MachineImage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void populate(@Nonnull Jiterator<MachineImage> iterator) throws Exception {
                try {
                    APITrace.begin((CloudProvider)Templates.this.getProvider(), (String)"Image.searchPublicImages.populate");
                    try {
                        Document doc = method.get(method.buildUrl(Templates.LIST_TEMPLATES, params), Templates.LIST_TEMPLATES);
                        NodeList matches = doc.getElementsByTagName("template");
                        for (int i = 0; i < matches.getLength(); ++i) {
                            MachineImage img = Templates.this.toImage(matches.item(i), true, hypervisors);
                            if (img == null || !options.matches(img)) continue;
                            iterator.push((Object)img);
                        }
                    }
                    finally {
                        APITrace.end();
                    }
                }
                finally {
                    Templates.this.provider.release();
                }
            }
        });
        populator.populate();
        allImages.addAll(populator.getResult());
        filterParam.setValue("community");
        if (!this.provider.getServiceProvider().equals((Object)CSServiceProvider.DATAPIPE)) {
            this.provider.hold();
            populator = new PopulatorThread((JiteratorPopulator)new JiteratorPopulator<MachineImage>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void populate(@Nonnull Jiterator<MachineImage> iterator) throws Exception {
                    try {
                        APITrace.begin((CloudProvider)Templates.this.getProvider(), (String)"Image.searchPublicImages.populate");
                        try {
                            Document doc = method.get(method.buildUrl(Templates.LIST_TEMPLATES, params), Templates.LIST_TEMPLATES);
                            NodeList matches = doc.getElementsByTagName("template");
                            for (int i = 0; i < matches.getLength(); ++i) {
                                MachineImage img = Templates.this.toImage(matches.item(i), true, hypervisors);
                                if (img == null || !options.matches(img) || allImages.contains(img)) continue;
                                iterator.push((Object)img);
                            }
                        }
                        finally {
                            APITrace.end();
                        }
                    }
                    finally {
                        Templates.this.provider.release();
                    }
                }
            });
            populator.populate();
            allImages.addAll(populator.getResult());
        }
        return allImages;
    }

    @Nullable
    private MachineImage toImage(@Nullable Node node, boolean onlyIfPublic, List<String> desiredHypervisors) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        Architecture bestArchitectureGuess = Architecture.I64;
        HashMap<String, String> properties = new HashMap<String, String>();
        NodeList attributes = node.getChildNodes();
        boolean isPublic = false;
        String providerOwnerId = this.getContext().getAccountNumber();
        MachineImageState state = MachineImageState.PENDING;
        String regionId = this.getContext().getRegionId();
        ImageClass imageClass = ImageClass.MACHINE;
        String imageId = null;
        String imgName = null;
        String description = null;
        Platform platform = null;
        Architecture architecture = null;
        long creationTimestamp = 0L;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = null;
            if (attribute.hasChildNodes() && attribute.getChildNodes().getLength() > 0) {
                value = attribute.getFirstChild().getNodeValue();
            }
            if (name.equals("id")) {
                imageId = value;
                continue;
            }
            if (name.equals("zoneid")) {
                if (value != null && value.equals(this.getContext().getRegionId())) continue;
                return null;
            }
            if (name.equals("hypervisor")) {
                if (desiredHypervisors == null || desiredHypervisors.contains(value)) continue;
                return null;
            }
            if (name.equalsIgnoreCase("account")) {
                providerOwnerId = value;
                continue;
            }
            if (name.equals("name")) {
                imgName = value;
                if (value != null && value.contains("x64")) {
                    bestArchitectureGuess = Architecture.I64;
                    continue;
                }
                if (value == null || !value.contains("x32")) continue;
                bestArchitectureGuess = Architecture.I32;
                continue;
            }
            if (name.equals("displaytext")) {
                description = value;
                if (value != null && value.contains("x64")) {
                    bestArchitectureGuess = Architecture.I64;
                    continue;
                }
                if (value == null || !value.contains("x32")) continue;
                bestArchitectureGuess = Architecture.I32;
                continue;
            }
            if (name.equals("ispublic")) {
                isPublic = value != null && value.equalsIgnoreCase("true");
                continue;
            }
            if (name.equals("ostypename")) {
                if (value != null && value.contains("64")) {
                    bestArchitectureGuess = Architecture.I64;
                } else if (value != null && value.contains("32")) {
                    bestArchitectureGuess = Architecture.I32;
                }
                if (value == null) continue;
                platform = Platform.guess((String)value);
                continue;
            }
            if (name.equals("ostypeid") && value != null) {
                properties.put("cloud.com.os.typeId", value);
                continue;
            }
            if (name.equals("bits")) {
                if (value == null || value.equals("64")) {
                    architecture = Architecture.I64;
                    continue;
                }
                architecture = Architecture.I32;
                continue;
            }
            if (name.equals("created")) {
                if (value == null) continue;
                creationTimestamp = this.provider.parseTime(value);
                continue;
            }
            if (name.equals("isready")) {
                if (value == null || !value.equalsIgnoreCase("true")) continue;
                state = MachineImageState.ACTIVE;
                continue;
            }
            if (!name.equals("status") || value != null && value.equalsIgnoreCase("Download Complete")) continue;
            logger.warn((Object)("Template status=" + value));
        }
        if (platform == null && imgName != null) {
            platform = Platform.guess(imgName);
        }
        if (platform == null) {
            platform = Platform.UNKNOWN;
        }
        if (architecture == null) {
            architecture = bestArchitectureGuess;
        }
        if (!onlyIfPublic || isPublic) {
            MachineImage img = MachineImage.getImageInstance((String)providerOwnerId, (String)regionId, imageId, (ImageClass)imageClass, (MachineImageState)state, imgName, description, (Architecture)architecture, (Platform)platform);
            this.guessSoftware(img);
            img.setTags(properties);
            img.createdAt(creationTimestamp);
            return img;
        }
        return null;
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node node, boolean onlyIfPublic) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        MachineImageState imageState = null;
        String imageId = null;
        boolean isPublic = false;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.hasChildNodes() && attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (name.equals("id")) {
                imageId = value;
                continue;
            }
            if (name.equals("ispublic")) {
                isPublic = value != null && value.equalsIgnoreCase("true");
                continue;
            }
            if (!name.equals("isready") || value == null || !value.equalsIgnoreCase("true")) continue;
            imageState = MachineImageState.ACTIVE;
        }
        if (imageId != null && (!onlyIfPublic || isPublic)) {
            if (imageState == null) {
                imageState = MachineImageState.PENDING;
            }
            return new ResourceStatus(imageId, (Object)imageState);
        }
        return null;
    }

    private String toOs(Platform platform, Architecture architecture) throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_OS_TYPES, new Param[0]), LIST_OS_TYPES);
        NodeList matches = doc.getElementsByTagName("ostype");
        for (int i = 0; i < matches.getLength(); ++i) {
            NodeList attrs = matches.item(i).getChildNodes();
            Architecture arch = Architecture.I64;
            Platform pf = null;
            String id = null;
            for (int j = 0; j < attrs.getLength(); ++j) {
                Node attr = attrs.item(j);
                if (attr.getNodeName().equals("id")) {
                    id = attr.getFirstChild().getNodeValue();
                    continue;
                }
                if (!attr.getNodeName().equals("description")) continue;
                String desc = attr.getFirstChild().getNodeValue();
                pf = Platform.guess((String)desc);
                arch = this.guess(desc);
            }
            if (!platform.equals(pf) || !architecture.equals((Object)arch)) continue;
            return id;
        }
        return null;
    }

    private String validateName(String name) throws InternalException, CloudException {
        boolean found;
        if (name.length() < 32) {
            return name;
        }
        name = name.substring(0, 32);
        int i = 0;
        do {
            found = false;
            for (MachineImage vm : this.listImages(ImageClass.MACHINE)) {
                if (!name.equals(vm.getName())) continue;
                found = true;
                break;
            }
            if (!found) continue;
            name = ++i < 10 ? name.substring(0, 31) + i : (i < 100 ? name.substring(0, 30) + i : name.substring(0, 29) + i);
        } while (found);
        return name;
    }
}

