/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.compute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.VisibleScope;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSServiceProvider;
import org.dasein.cloud.cloudstack.CSVersion;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VMScalingCapabilities;
import org.dasein.cloud.compute.VirtualMachineCapabilities;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.NamingConstraints;

public class VMCapabilities
extends AbstractCapabilities<CSCloud>
implements VirtualMachineCapabilities {
    private transient Collection<Architecture> architectures;

    public VMCapabilities(@Nonnull CSCloud cloud) {
        super((CloudProvider)cloud);
    }

    public boolean canAlter(@Nonnull VmState fromState) throws CloudException, InternalException {
        if (!((CSCloud)this.getProvider()).getProviderName().contains("Datapipe")) {
            return fromState.equals((Object)VmState.STOPPED);
        }
        return false;
    }

    public boolean canClone(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canPause(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canReboot(@Nonnull VmState fromState) throws CloudException, InternalException {
        return true;
    }

    public boolean canResume(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canStart(@Nonnull VmState fromState) throws CloudException, InternalException {
        return !fromState.equals((Object)VmState.RUNNING);
    }

    public boolean canStop(@Nonnull VmState fromState) throws CloudException, InternalException {
        return !fromState.equals((Object)VmState.STOPPED);
    }

    public boolean canSuspend(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canTerminate(@Nonnull VmState fromState) throws CloudException, InternalException {
        return !fromState.equals((Object)VmState.TERMINATED);
    }

    public boolean canUnpause(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public int getMaximumVirtualMachineCount() throws CloudException, InternalException {
        return -2;
    }

    public int getCostFactor(@Nonnull VmState state) throws CloudException, InternalException {
        return 100;
    }

    @Nonnull
    public String getProviderTermForVirtualMachine(@Nonnull Locale locale) throws CloudException, InternalException {
        return "virtual machine";
    }

    @Nullable
    public VMScalingCapabilities getVerticalScalingCapabilities() throws CloudException, InternalException {
        return VMScalingCapabilities.getInstance((boolean)false, (boolean)true, (Requirement)Requirement.NONE, (Requirement)Requirement.NONE);
    }

    @Nonnull
    public NamingConstraints getVirtualMachineNamingConstraints() throws CloudException, InternalException {
        return NamingConstraints.getAlphaNumeric((int)1, (int)64);
    }

    @Nullable
    public VisibleScope getVirtualMachineVisibleScope() {
        return null;
    }

    @Nullable
    public VisibleScope getVirtualMachineProductVisibleScope() {
        return null;
    }

    @Nonnull
    public Requirement identifyDataCenterLaunchRequirement() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    @Nonnull
    public Requirement identifyImageRequirement(@Nonnull ImageClass cls) throws CloudException, InternalException {
        return cls.equals((Object)ImageClass.MACHINE) ? Requirement.REQUIRED : Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyPasswordRequirement(Platform platform) throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyRootVolumeRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyShellKeyRequirement(Platform platform) throws CloudException, InternalException {
        if (Platform.WINDOWS.equals((Object)platform)) {
            return Requirement.NONE;
        }
        return Requirement.OPTIONAL;
    }

    @Nonnull
    public Requirement identifyStaticIPRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifySubnetRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Requirement identifyVlanRequirement() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.identifyVlanRequirement");
        try {
            if (((CSCloud)this.getProvider()).getServiceProvider().equals((Object)CSServiceProvider.DATAPIPE)) {
                Requirement requirement = Requirement.NONE;
                return requirement;
            }
            if (((CSCloud)this.getProvider()).getVersion().greaterThan(CSVersion.CS21)) {
                ProviderContext ctx = ((CSCloud)this.getProvider()).getContext();
                if (ctx == null) {
                    throw new CloudException("No context was set for this request");
                }
                String regionId = ctx.getRegionId();
                if (regionId == null) {
                    throw new CloudException("No region was set for this request");
                }
                Requirement requirement = ((CSCloud)this.getProvider()).getDataCenterServices().requiresNetwork(regionId) ? Requirement.REQUIRED : Requirement.OPTIONAL;
                return requirement;
            }
            Requirement requirement = Requirement.OPTIONAL;
            return requirement;
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isAPITerminationPreventable() throws CloudException, InternalException {
        return false;
    }

    public boolean isBasicAnalyticsSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isExtendedAnalyticsSupported() throws CloudException, InternalException {
        return false;
    }

    public boolean isUserDataSupported() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Iterable<Architecture> listSupportedArchitectures() throws InternalException, CloudException {
        if (this.architectures == null) {
            ArrayList<Architecture> a = new ArrayList<Architecture>();
            a.add(Architecture.I32);
            a.add(Architecture.I64);
            this.architectures = Collections.unmodifiableList(a);
        }
        return this.architectures;
    }

    public boolean supportsSpotVirtualMachines() throws InternalException, CloudException {
        return false;
    }

    public boolean supportsAlterVM() {
        return !((CSCloud)this.getProvider()).getProviderName().contains("Datapipe");
    }

    public boolean supportsClone() {
        return false;
    }

    public boolean supportsPause() {
        return false;
    }

    public boolean supportsReboot() {
        return true;
    }

    public boolean supportsResume() {
        return false;
    }

    public boolean supportsStart() {
        return true;
    }

    public boolean supportsStop() {
        return true;
    }

    public boolean supportsSuspend() {
        return false;
    }

    public boolean supportsTerminate() {
        return true;
    }

    public boolean supportsUnPause() {
        return false;
    }
}

