/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.compute;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSException;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.CSServiceProvider;
import org.dasein.cloud.cloudstack.CSVersion;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.cloudstack.compute.VMCapabilities;
import org.dasein.cloud.cloudstack.network.Network;
import org.dasein.cloud.cloudstack.network.SecurityGroup;
import org.dasein.cloud.compute.AbstractVMSupport;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VMLaunchOptions;
import org.dasein.cloud.compute.VMScalingCapabilities;
import org.dasein.cloud.compute.VMScalingOptions;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineCapabilities;
import org.dasein.cloud.compute.VirtualMachineProduct;
import org.dasein.cloud.compute.VirtualMachineProductFilterOptions;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.network.RawAddress;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VirtualMachines
extends AbstractVMSupport {
    public static final Logger logger = Logger.getLogger(VirtualMachines.class);
    private static final String DEPLOY_VIRTUAL_MACHINE = "deployVirtualMachine";
    private static final String DESTROY_VIRTUAL_MACHINE = "destroyVirtualMachine";
    private static final String GET_VIRTUAL_MACHINE_PASSWORD = "getVMPassword";
    private static final String LIST_VIRTUAL_MACHINES = "listVirtualMachines";
    private static final String LIST_SERVICE_OFFERINGS = "listServiceOfferings";
    private static final String REBOOT_VIRTUAL_MACHINE = "rebootVirtualMachine";
    private static final String RESET_VIRTUAL_MACHINE_PASSWORD = "resetPasswordForVirtualMachine";
    private static final String RESIZE_VIRTUAL_MACHINE = "scaleVirtualMachine";
    private static final String START_VIRTUAL_MACHINE = "startVirtualMachine";
    private static final String STOP_VIRTUAL_MACHINE = "stopVirtualMachine";
    private static Properties cloudMappings;
    private static Map<String, Map<String, String>> customNetworkMappings;
    private static Map<String, Map<String, Set<String>>> customServiceMappings;
    private CSCloud provider;
    private volatile transient VMCapabilities capabilities;
    private transient Collection<Architecture> architectures;

    public VirtualMachines(CSCloud provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualMachine alterVirtualMachine(@Nonnull String vmId, @Nonnull VMScalingOptions options) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.alterVM");
        try {
            Node virtualMachine;
            NodeList nodeList;
            String productId = options.getProviderProductId();
            if (vmId == null || options.getProviderProductId() == null) {
                throw new CloudException("No vmid and/or product id set for this operation");
            }
            CSMethod method = new CSMethod(this.provider);
            VirtualMachine vm = this.getVirtualMachine(vmId);
            if (vm.getProductId().equals(productId)) {
                VirtualMachine virtualMachine2 = vm;
                return virtualMachine2;
            }
            boolean restart = false;
            if (!vm.getCurrentState().equals((Object)VmState.STOPPED)) {
                restart = true;
                this.stop(vmId, true);
            }
            long timeout = System.currentTimeMillis() + 1200000L;
            while (System.currentTimeMillis() < timeout && !vm.getCurrentState().equals((Object)VmState.STOPPED)) {
                try {
                    Thread.sleep(15000L);
                    vm = this.getVirtualMachine(vmId);
                }
                catch (InterruptedException ignore) {}
            }
            vm = this.getVirtualMachine(vmId);
            if (!vm.getCurrentState().equals((Object)VmState.STOPPED)) {
                throw new CloudException("Unable to stop vm for scaling");
            }
            Document doc = method.get(method.buildUrl(RESIZE_VIRTUAL_MACHINE, new Param("id", vmId), new Param("serviceOfferingId", productId)), RESIZE_VIRTUAL_MACHINE);
            NodeList matches = doc.getElementsByTagName("scalevirtualmachineresponse");
            String jobId = null;
            for (int i = 0; i < matches.getLength(); ++i) {
                NodeList attrs = matches.item(i).getChildNodes();
                for (int j = 0; j < attrs.getLength(); ++j) {
                    Node node = attrs.item(j);
                    if (node == null || !node.getNodeName().equalsIgnoreCase("jobid")) continue;
                    jobId = node.getFirstChild().getNodeValue();
                }
            }
            if (jobId == null) {
                throw new CloudException("Could not scale server");
            }
            Document responseDoc = this.provider.waitForJob(doc, "Scale Server");
            if (responseDoc != null && (nodeList = responseDoc.getElementsByTagName("virtualmachine")).getLength() > 0 && (vm = this.toVirtualMachine(virtualMachine = nodeList.item(0))) != null) {
                if (restart) {
                    this.start(vmId);
                }
                VirtualMachine virtualMachine3 = vm;
                return virtualMachine3;
            }
            if (restart) {
                this.start(vmId);
            }
            VirtualMachine virtualMachine4 = this.getVirtualMachine(vmId);
            return virtualMachine4;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public VirtualMachineCapabilities getCapabilities() throws InternalException, CloudException {
        if (this.capabilities == null) {
            this.capabilities = new VMCapabilities(this.provider);
        }
        return this.capabilities;
    }

    @Nullable
    public VMScalingCapabilities describeVerticalScalingCapabilities() throws CloudException, InternalException {
        return VMScalingCapabilities.getInstance((boolean)false, (boolean)true, (Requirement)Requirement.NONE, (Requirement)Requirement.NONE);
    }

    @Nullable
    public String getPassword(@Nonnull String vmId) throws InternalException, CloudException {
        return this.getRootPassword(vmId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VirtualMachineProduct getProduct(@Nonnull String productId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.getProduct");
        try {
            for (Architecture architecture : this.getCapabilities().listSupportedArchitectures()) {
                for (VirtualMachineProduct product : this.listProducts(architecture)) {
                    if (!product.getProviderProductId().equals(productId)) continue;
                    VirtualMachineProduct virtualMachineProduct = product;
                    return virtualMachineProduct;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unknown product ID for cloud.com: " + productId));
            }
            VirtualMachineProduct virtualMachineProduct = null;
            return virtualMachineProduct;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRootPassword(@Nonnull String serverId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.getPassword");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was specified for this request");
            }
            CSMethod method = new CSMethod(this.provider);
            Document doc = method.get(method.buildUrl(GET_VIRTUAL_MACHINE_PASSWORD, new Param("id", serverId)), GET_VIRTUAL_MACHINE_PASSWORD);
            if (doc != null) {
                NodeList matches = doc.getElementsByTagName("getvmpasswordresponse");
                for (int i = 0; i < matches.getLength(); ++i) {
                    Node node = matches.item(i);
                    if (node == null) continue;
                    NodeList attributes = node.getChildNodes();
                    for (int j = 0; j < attributes.getLength(); ++j) {
                        Node attribute = attributes.item(j);
                        String name = attribute.getNodeName().toLowerCase();
                        String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
                        if (!name.equals("password")) continue;
                        NodeList nodes = attribute.getChildNodes();
                        for (int k = 0; k < nodes.getLength(); ++k) {
                            Node password = nodes.item(k);
                            name = password.getNodeName().toLowerCase();
                            value = password.getChildNodes().getLength() > 0 ? password.getFirstChild().getNodeValue() : null;
                            if (!name.equals("encryptedpassword")) continue;
                            String string = value;
                            return string;
                        }
                    }
                }
            }
            logger.warn((Object)("Unable to find password for vm with id " + serverId));
            String string = null;
            return string;
        }
        catch (CSException e) {
            if (e.getHttpCode() == 431) {
                logger.warn((Object)("No password found for vm " + serverId));
            }
            String string = null;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VirtualMachine getVirtualMachine(@Nonnull String serverId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.getVirtualMachine");
        try {
            NodeList matches;
            block12: {
                CSMethod method = new CSMethod(this.provider);
                Document doc = method.get(method.buildUrl(LIST_VIRTUAL_MACHINES, new Param("id", serverId)), LIST_VIRTUAL_MACHINES);
                matches = doc.getElementsByTagName("virtualmachine");
                if (matches.getLength() >= 1) break block12;
                VirtualMachine virtualMachine = null;
                return virtualMachine;
            }
            for (int i = 0; i < matches.getLength(); ++i) {
                VirtualMachine s = this.toVirtualMachine(matches.item(i));
                if (s != null && s.getProviderVirtualMachineId().equals(serverId)) {
                    VirtualMachine virtualMachine = s;
                    return virtualMachine;
                }
                try {
                    continue;
                }
                catch (CloudException e) {
                    if (e.getMessage().contains("does not exist")) {
                        VirtualMachine virtualMachine = null;
                        return virtualMachine;
                    }
                    throw e;
                }
            }
            VirtualMachine virtualMachine = null;
            return virtualMachine;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * Exception decompiling
     */
    public boolean isSubscribed() throws CloudException, InternalException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public VirtualMachine launch(@Nonnull VMLaunchOptions withLaunchOptions) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.launch");
        try {
            String id = withLaunchOptions.getStandardProductId();
            VirtualMachineProduct product = this.getProduct(id);
            if (product == null) {
                throw new CloudException("Invalid product ID: " + id);
            }
            if (this.provider.getVersion().greaterThan(CSVersion.CS21)) {
                VirtualMachine virtualMachine = this.launch22(withLaunchOptions.getMachineImageId(), product, withLaunchOptions.getDataCenterId(), withLaunchOptions.getFriendlyName(), withLaunchOptions.getBootstrapKey(), withLaunchOptions.getVlanId(), withLaunchOptions.getFirewallIds(), withLaunchOptions.getUserData());
                return virtualMachine;
            }
            VirtualMachine virtualMachine = this.launch21(withLaunchOptions.getMachineImageId(), product, withLaunchOptions.getDataCenterId(), withLaunchOptions.getFriendlyName());
            return virtualMachine;
        }
        finally {
            APITrace.end();
        }
    }

    @Deprecated
    @Nonnull
    public VirtualMachine launch(@Nonnull String imageId, @Nonnull VirtualMachineProduct product, @Nonnull String inZoneId, @Nonnull String name, @Nonnull String description, @Nullable String usingKey, @Nullable String withVlanId, boolean withMonitoring, boolean asSandbox, @Nullable String[] protectedByFirewalls, Tag ... tags) throws InternalException, CloudException {
        if (this.provider.getVersion().greaterThan(CSVersion.CS21)) {
            StringBuilder userData = new StringBuilder();
            if (tags != null && tags.length > 0) {
                for (Tag tag : tags) {
                    userData.append(tag.getKey());
                    userData.append("=");
                    userData.append(tag.getValue());
                    userData.append("\n");
                }
            } else {
                userData.append("created=Dasein Cloud\n");
            }
            return this.launch22(imageId, product, inZoneId, name, usingKey, withVlanId, protectedByFirewalls, userData.toString());
        }
        return this.launch21(imageId, product, inZoneId, name);
    }

    private VirtualMachine launch21(String imageId, VirtualMachineProduct product, String inZoneId, String name) throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.provider);
        return this.launch(method.get(method.buildUrl(DEPLOY_VIRTUAL_MACHINE, new Param("zoneId", this.getContext().getRegionId()), new Param("serviceOfferingId", product.getProviderProductId()), new Param("templateId", imageId), new Param("displayName", name)), DEPLOY_VIRTUAL_MACHINE));
    }

    private void load() {
        HashMap<String, Map<String, String>> mapping;
        Properties properties;
        InputStream input;
        try {
            String line;
            input = VirtualMachines.class.getResourceAsStream("/cloudMappings.cfg");
            BufferedReader reader = new BufferedReader(new InputStreamReader(input));
            properties = new Properties();
            while ((line = reader.readLine()) != null) {
                int idx;
                if (line.startsWith("#") || (idx = line.indexOf(61)) < 0 || line.endsWith("=")) continue;
                String cloudUrl = line.substring(0, idx);
                String cloudId = line.substring(idx + 1);
                properties.put(cloudUrl, cloudId);
            }
            cloudMappings = properties;
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        try {
            input = VirtualMachines.class.getResourceAsStream("/customNetworkMappings.cfg");
            mapping = new HashMap<String, Map<String, String>>();
            properties = new Properties();
            properties.load(input);
            for (Object key : properties.keySet()) {
                String[] trueKey = ((String)key).split(",");
                HashMap<String, String> current = (HashMap<String, String>)mapping.get(trueKey[0]);
                if (current == null) {
                    current = new HashMap<String, String>();
                    mapping.put(trueKey[0], current);
                }
                current.put(trueKey[1], (String)properties.get(key));
            }
            customNetworkMappings = mapping;
        }
        catch (Throwable ignore) {
            // empty catch block
        }
        try {
            input = VirtualMachines.class.getResourceAsStream("/customServiceMappings.cfg");
            mapping = new HashMap();
            properties = new Properties();
            properties.load(input);
            for (Object key : properties.keySet()) {
                String value = (String)properties.get(key);
                if (value == null) continue;
                String[] trueKey = ((String)key).split(",");
                HashMap tmp = (HashMap)mapping.get(trueKey[0]);
                if (tmp == null) {
                    tmp = new HashMap();
                    mapping.put(trueKey[0], tmp);
                }
                TreeSet<String> m = new TreeSet<String>();
                String[] offerings = value.split(",");
                if (offerings == null || offerings.length < 1) {
                    m.add(value);
                } else {
                    Collections.addAll(m, offerings);
                }
                tmp.put(trueKey[1], m);
            }
            customServiceMappings = mapping;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Nonnull
    private VirtualMachine launch22(@Nonnull String imageId, @Nonnull VirtualMachineProduct product, @Nullable String inZoneId, @Nonnull String name, @Nullable String withKeypair, @Nullable String targetVlanId, @Nullable String[] protectedByFirewalls, @Nullable String userData) throws InternalException, CloudException {
        String id;
        Map<String, String> map;
        String cloudId;
        ProviderContext ctx = this.provider.getContext();
        List<Object> vlans = null;
        if (ctx == null) {
            throw new InternalException("No context was provided for this request");
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new InternalException("No region is established for this request");
        }
        String prdId = product.getProviderProductId();
        if (customNetworkMappings == null) {
            this.load();
        }
        if (customNetworkMappings != null && (cloudId = cloudMappings.getProperty(ctx.getCloud().getEndpoint())) != null && (map = customNetworkMappings.get(cloudId)) != null && (id = map.get(prdId)) != null) {
            targetVlanId = id;
        }
        if (targetVlanId != null && targetVlanId.length() < 1) {
            targetVlanId = null;
        }
        if (userData == null) {
            userData = "";
        }
        String securityGroupIds = null;
        if (protectedByFirewalls != null && protectedByFirewalls.length > 0) {
            StringBuilder str = new StringBuilder();
            int idx = 0;
            for (String fw : protectedByFirewalls) {
                if ((fw = fw.trim()).equals("")) continue;
                str.append(fw);
                if (idx++ >= protectedByFirewalls.length - 1) continue;
                str.append(",");
            }
            securityGroupIds = str.toString();
        }
        if (targetVlanId == null) {
            Network vlan = this.provider.getNetworkServices().getVlanSupport();
            if (vlan != null && vlan.isSubscribed() && this.provider.getDataCenterServices().requiresNetwork(regionId)) {
                vlans = vlan.findFreeNetworks();
            }
        } else {
            vlans = new ArrayList<String>();
            vlans.add(targetVlanId);
        }
        if (securityGroupIds != null && securityGroupIds.length() > 0) {
            if (!this.provider.getDataCenterServices().supportsSecurityGroups(regionId, vlans == null || vlans.size() < 1)) {
                securityGroupIds = null;
            } else if (!this.provider.getServiceProvider().equals((Object)CSServiceProvider.DATAPIPE)) {
                securityGroupIds = null;
            }
        } else if (this.provider.getDataCenterServices().supportsSecurityGroups(regionId, vlans == null || vlans.size() < 1)) {
            // empty if block
        }
        ArrayList<Param> params = new ArrayList<Param>();
        params.add(new Param("zoneId", this.getContext().getRegionId()));
        params.add(new Param("serviceOfferingId", prdId));
        params.add(new Param("templateId", imageId));
        params.add(new Param("displayName", name));
        if (userData != null && userData.length() > 0) {
            try {
                params.add(new Param("userdata", new String(Base64.encodeBase64((byte[])userData.getBytes("utf-8")), "utf-8")));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        if (withKeypair != null) {
            params.add(new Param("keypair", withKeypair));
        }
        if (securityGroupIds != null && securityGroupIds.length() > 0) {
            params.add(new Param("securitygroupids", securityGroupIds));
        }
        if (vlans != null && vlans.size() > 0) {
            CloudException lastError = null;
            for (String string : vlans) {
                params.add(new Param("networkIds", string));
                try {
                    CSMethod method = new CSMethod(this.provider);
                    return this.launch(method.get(method.buildUrl(DEPLOY_VIRTUAL_MACHINE, params.toArray(new Param[params.size()])), DEPLOY_VIRTUAL_MACHINE));
                }
                catch (CloudException e) {
                    if (e.getMessage().contains("sufficient address capacity")) {
                        lastError = e;
                        continue;
                    }
                    throw e;
                }
            }
            if (lastError == null) {
                throw lastError;
            }
            throw new CloudException("Unable to identify a network into which a VM can be launched");
        }
        CSMethod method = new CSMethod(this.provider);
        return this.launch(method.get(method.buildUrl(DEPLOY_VIRTUAL_MACHINE, params.toArray(new Param[params.size()])), DEPLOY_VIRTUAL_MACHINE));
    }

    @Nonnull
    private VirtualMachine launch(@Nonnull Document doc) throws InternalException, CloudException {
        Node virtualMachine;
        NodeList nodeList;
        NodeList matches = doc.getElementsByTagName("deployvirtualmachineresponse");
        String serverId = null;
        String jobId = null;
        for (int i = 0; i < matches.getLength(); ++i) {
            NodeList attrs = matches.item(i).getChildNodes();
            for (int j = 0; j < attrs.getLength(); ++j) {
                Node node = attrs.item(j);
                if (node != null && (node.getNodeName().equalsIgnoreCase("virtualmachineid") || node.getNodeName().equalsIgnoreCase("id"))) {
                    serverId = node.getFirstChild().getNodeValue();
                    break;
                }
                if (node == null || !node.getNodeName().equalsIgnoreCase("jobid")) continue;
                jobId = node.getFirstChild().getNodeValue();
            }
            if (serverId != null) break;
        }
        if (serverId == null && jobId == null) {
            throw new CloudException("Could not launch server");
        }
        VirtualMachine vm = null;
        Document responseDoc = this.provider.waitForJob(doc, "Launch Server");
        if (responseDoc != null && (nodeList = responseDoc.getElementsByTagName("virtualmachine")).getLength() > 0 && (vm = this.toVirtualMachine(virtualMachine = nodeList.item(0))) != null) {
            return vm;
        }
        if (vm == null) {
            vm = this.getVirtualMachine(serverId);
        }
        if (vm == null) {
            throw new CloudException("No virtual machine provided: " + serverId);
        }
        return vm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<String> listFirewalls(@Nonnull String vmId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.listFirewalls");
        try {
            SecurityGroup support = this.provider.getNetworkServices().getFirewallSupport();
            if (support == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            Iterable<String> iterable = support.listFirewallsForVM(vmId);
            return iterable;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFirewalls(@Nonnull VirtualMachine vm) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.setFirewalls");
        try {
            SecurityGroup support = this.provider.getNetworkServices().getFirewallSupport();
            if (support == null) {
                return;
            }
            ArrayList<String> ids = new ArrayList<String>();
            for (String id : support.listFirewallsForVM(vm.getProviderVirtualMachineId())) {
                ids.add(id);
            }
            vm.setProviderFirewallIds(ids.toArray(new String[ids.size()]));
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<VirtualMachineProduct> listProducts(@Nonnull Architecture architecture) throws InternalException, CloudException {
        return this.listProducts(null, architecture);
    }

    public Iterable<VirtualMachineProduct> listProducts(VirtualMachineProductFilterOptions options) throws InternalException, CloudException {
        ArrayList<VirtualMachineProduct> products = new ArrayList<VirtualMachineProduct>();
        for (Architecture arch : this.getCapabilities().listSupportedArchitectures()) {
            this.mergeProductLists(products, this.listProducts(options, arch));
        }
        return products;
    }

    private void mergeProductLists(List<VirtualMachineProduct> to, Iterable<VirtualMachineProduct> from) {
        ArrayList<VirtualMachineProduct> copy = new ArrayList<VirtualMachineProduct>(to);
        for (VirtualMachineProduct productFrom : from) {
            boolean found = false;
            for (VirtualMachineProduct productTo : copy) {
                if (!productTo.getProviderProductId().equalsIgnoreCase(productFrom.getProviderProductId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            to.add(productFrom);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<VirtualMachineProduct> listProducts(VirtualMachineProductFilterOptions options, Architecture architecture) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.listProducts");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was configured for this request");
            }
            Cache cache = Cache.getInstance((CloudProvider)this.provider, (String)"ServerProducts", VirtualMachineProduct.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)4, (TimePeriodUnit)TimePeriod.HOUR));
            ArrayList<VirtualMachineProduct> products = (ArrayList<VirtualMachineProduct>)cache.get(this.provider.getContext());
            if (products == null) {
                Map<String, Set<String>> map;
                String cloudId;
                Set<String> mapping = null;
                if (customServiceMappings == null) {
                    this.load();
                }
                if (customServiceMappings != null && (cloudId = cloudMappings.getProperty(this.provider.getContext().getCloud().getEndpoint())) != null && (map = customServiceMappings.get(cloudId)) != null) {
                    mapping = map.get(this.provider.getContext().getRegionId());
                }
                products = new ArrayList<VirtualMachineProduct>();
                CSMethod method = new CSMethod(this.provider);
                Document doc = method.get(method.buildUrl(LIST_SERVICE_OFFERINGS, new Param("zoneId", ctx.getRegionId())), LIST_SERVICE_OFFERINGS);
                NodeList matches = doc.getElementsByTagName("serviceoffering");
                for (int i = 0; i < matches.getLength(); ++i) {
                    String id = null;
                    String name = null;
                    Node node = matches.item(i);
                    int memory = 0;
                    int cpu = 0;
                    NodeList attributes = node.getChildNodes();
                    for (int j = 0; j < attributes.getLength(); ++j) {
                        Node n = attributes.item(j);
                        String value = n.getChildNodes().getLength() > 0 ? n.getFirstChild().getNodeValue() : null;
                        if (n.getNodeName().equals("id")) {
                            id = value;
                        } else if (n.getNodeName().equals("name")) {
                            name = value;
                        } else if (n.getNodeName().equals("cpunumber")) {
                            cpu = Integer.parseInt(value);
                        } else if (n.getNodeName().equals("memory")) {
                            memory = Integer.parseInt(value);
                        }
                        if (id != null && name != null && cpu > 0 && memory > 0) break;
                    }
                    if (id == null || name == null || cpu <= 0 || memory <= 0 || mapping != null && !mapping.contains(id)) continue;
                    VirtualMachineProduct product = new VirtualMachineProduct();
                    product.setProviderProductId(id);
                    product.setName(name + " (" + cpu + " CPU/" + memory + "MB RAM)");
                    product.setDescription(name + " (" + cpu + " CPU/" + memory + "MB RAM)");
                    product.setRamSize(new Storage((Number)memory, (StorageUnit)Storage.MEGABYTE));
                    product.setCpuCount(cpu);
                    product.setRootVolumeSize(new Storage((Number)1, (StorageUnit)Storage.GIGABYTE));
                    if (options != null) {
                        if (!options.matches(product)) continue;
                        products.add(product);
                        continue;
                    }
                    products.add(product);
                }
                cache.put(this.provider.getContext(), products);
            }
            ArrayList<VirtualMachineProduct> arrayList = products;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listVirtualMachineStatus() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.listVirtualMachineStatus");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was specified for this request");
            }
            CSMethod method = new CSMethod(this.provider);
            Document doc = method.get(method.buildUrl(LIST_VIRTUAL_MACHINES, new Param("zoneId", ctx.getRegionId())), LIST_VIRTUAL_MACHINES);
            ArrayList<ResourceStatus> servers = new ArrayList<ResourceStatus>();
            int numPages = 1;
            NodeList nodes = doc.getElementsByTagName("count");
            Node n = nodes.item(0);
            if (n != null) {
                String value = n.getFirstChild().getNodeValue().trim();
                int count = Integer.parseInt(value);
                numPages = count / 500;
                int remainder = count % 500;
                if (remainder > 0) {
                    ++numPages;
                }
            }
            for (int page = 1; page <= numPages; ++page) {
                if (page > 1) {
                    String nextPage = String.valueOf(page);
                    doc = method.get(method.buildUrl(LIST_VIRTUAL_MACHINES, new Param("zoneId", ctx.getRegionId()), new Param("pagesize", "500"), new Param("page", nextPage)), LIST_VIRTUAL_MACHINES);
                }
                NodeList matches = doc.getElementsByTagName("virtualmachine");
                for (int i = 0; i < matches.getLength(); ++i) {
                    ResourceStatus vm;
                    Node node = matches.item(i);
                    if (node == null || (vm = this.toStatus(node)) == null) continue;
                    servers.add(vm);
                }
            }
            ArrayList<ResourceStatus> arrayList = servers;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<VirtualMachine> listVirtualMachines() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.listVirtualMachines");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was specified for this request");
            }
            CSMethod method = new CSMethod(this.provider);
            Document doc = method.get(method.buildUrl(LIST_VIRTUAL_MACHINES, new Param("zoneId", ctx.getRegionId())), LIST_VIRTUAL_MACHINES);
            ArrayList<VirtualMachine> servers = new ArrayList<VirtualMachine>();
            int numPages = 1;
            NodeList nodes = doc.getElementsByTagName("count");
            Node n = nodes.item(0);
            if (n != null) {
                String value = n.getFirstChild().getNodeValue().trim();
                int count = Integer.parseInt(value);
                numPages = count / 500;
                int remainder = count % 500;
                if (remainder > 0) {
                    ++numPages;
                }
            }
            for (int page = 1; page <= numPages; ++page) {
                if (page > 1) {
                    String nextPage = String.valueOf(page);
                    doc = method.get(method.buildUrl(LIST_VIRTUAL_MACHINES, new Param("zoneId", ctx.getRegionId()), new Param("pagesize", "500"), new Param("page", nextPage)), LIST_VIRTUAL_MACHINES);
                }
                NodeList matches = doc.getElementsByTagName("virtualmachine");
                for (int i = 0; i < matches.getLength(); ++i) {
                    VirtualMachine vm;
                    Node node = matches.item(i);
                    if (node == null || (vm = this.toVirtualMachine(node)) == null) continue;
                    servers.add(vm);
                }
            }
            ArrayList<VirtualMachine> arrayList = servers;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resetPassword(@Nonnull String serverId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.resetPassword");
        try {
            ProviderContext ctx = this.provider.getContext();
            if (ctx == null) {
                throw new CloudException("No context was specified for this request");
            }
            CSMethod method = new CSMethod(this.provider);
            Document doc = method.get(method.buildUrl(RESET_VIRTUAL_MACHINE_PASSWORD, new Param("id", serverId)), RESET_VIRTUAL_MACHINE_PASSWORD);
            Document responseDoc = this.provider.waitForJob(doc, "reset vm password");
            if (responseDoc != null) {
                NodeList matches = responseDoc.getElementsByTagName("virtualmachine");
                for (int i = 0; i < matches.getLength(); ++i) {
                    Node node = matches.item(i);
                    if (node == null) continue;
                    NodeList attributes = node.getChildNodes();
                    for (int j = 0; j < attributes.getLength(); ++j) {
                        Node attribute = attributes.item(j);
                        String name = attribute.getNodeName().toLowerCase();
                        String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
                        if (!name.equals("password")) continue;
                        String string = value;
                        return string;
                    }
                }
            }
            logger.warn((Object)("Unable to find password for vm with id " + serverId));
            String string = null;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reboot(@Nonnull String serverId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.reboot");
        try {
            CSMethod method = new CSMethod(this.provider);
            method.get(method.buildUrl(REBOOT_VIRTUAL_MACHINE, new Param("id", serverId)), REBOOT_VIRTUAL_MACHINE);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(@Nonnull String serverId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.start");
        try {
            CSMethod method = new CSMethod(this.provider);
            method.get(method.buildUrl(START_VIRTUAL_MACHINE, new Param("id", serverId)), START_VIRTUAL_MACHINE);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(@Nonnull String vmId, boolean force) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.stop");
        try {
            CSMethod method = new CSMethod(this.provider);
            method.get(method.buildUrl(STOP_VIRTUAL_MACHINE, new Param("id", vmId), new Param("forced", String.valueOf(force))), STOP_VIRTUAL_MACHINE);
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(@Nonnull String serverId, @Nullable String explanation) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.terminate");
        try {
            CSMethod method = new CSMethod(this.provider);
            method.get(method.buildUrl(DESTROY_VIRTUAL_MACHINE, new Param("id", serverId), new Param("expunge", "true")), DESTROY_VIRTUAL_MACHINE);
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        VmState state = null;
        String serverId = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (name.equals("virtualmachineid") || name.equals("id")) {
                serverId = value;
            } else if (name.equals("state")) {
                if (value == null) {
                    state = VmState.PENDING;
                } else if (value.equalsIgnoreCase("stopped")) {
                    state = VmState.STOPPED;
                } else if (value.equalsIgnoreCase("running")) {
                    state = VmState.RUNNING;
                } else if (value.equalsIgnoreCase("stopping")) {
                    state = VmState.STOPPING;
                } else if (value.equalsIgnoreCase("starting")) {
                    state = VmState.PENDING;
                } else if (value.equalsIgnoreCase("creating")) {
                    state = VmState.PENDING;
                } else if (value.equalsIgnoreCase("migrating")) {
                    state = VmState.REBOOTING;
                } else if (value.equalsIgnoreCase("destroyed")) {
                    state = VmState.TERMINATED;
                } else {
                    if (value.equalsIgnoreCase("error")) {
                        logger.warn((Object)"VM is in an error state.");
                        return null;
                    }
                    if (value.equalsIgnoreCase("expunging")) {
                        state = VmState.TERMINATED;
                    } else if (value.equalsIgnoreCase("ha")) {
                        state = VmState.REBOOTING;
                    } else {
                        throw new CloudException("Unexpected server state: " + value);
                    }
                }
            }
            if (serverId != null && state != null) break;
        }
        if (serverId == null) {
            return null;
        }
        if (state == null) {
            state = VmState.PENDING;
        }
        return new ResourceStatus(serverId, (Object)state);
    }

    @Nullable
    private VirtualMachine toVirtualMachine(@Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        VirtualMachine server = new VirtualMachine();
        NodeList attributes = node.getChildNodes();
        String productId = null;
        server.setProviderOwnerId(this.provider.getContext().getAccountNumber());
        server.setClonable(false);
        server.setImagable(false);
        server.setPausable(true);
        server.setPersistent(true);
        server.setArchitecture(Architecture.I64);
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (name.equals("virtualmachineid") || name.equals("id")) {
                server.setProviderVirtualMachineId(value);
                continue;
            }
            if (name.equals("name")) {
                server.setDescription(value);
                continue;
            }
            if (name.equals("displayname")) {
                server.setName(value);
                continue;
            }
            if (name.equals("ipaddress")) {
                if (value != null) {
                    server.setPrivateAddresses(new RawAddress[]{new RawAddress(value)});
                }
                server.setPrivateDnsAddress(value);
                continue;
            }
            if (name.equals("password")) {
                server.setRootPassword(value);
                continue;
            }
            if (name.equals("nic")) {
                if (!attribute.hasChildNodes()) continue;
                NodeList parts = attribute.getChildNodes();
                String addr = null;
                for (int j = 0; j < parts.getLength(); ++j) {
                    Node part = parts.item(j);
                    if (part.getNodeName().equalsIgnoreCase("ipaddress")) {
                        if (!part.hasChildNodes() || (addr = part.getFirstChild().getNodeValue()) == null) continue;
                        addr = addr.trim();
                        continue;
                    }
                    if (!part.getNodeName().equalsIgnoreCase("networkid")) continue;
                    server.setProviderVlanId(part.getFirstChild().getNodeValue().trim());
                }
                if (addr == null) continue;
                boolean pub = false;
                if (!addr.startsWith("10.") && !addr.startsWith("192.168.")) {
                    if (addr.startsWith("172.")) {
                        String[] nums = addr.split("\\.");
                        if (nums.length != 4) {
                            pub = true;
                        } else {
                            try {
                                int x = Integer.parseInt(nums[1]);
                                if (x < 16 || x > 31) {
                                    pub = true;
                                }
                            }
                            catch (NumberFormatException ignore) {}
                        }
                    } else {
                        pub = true;
                    }
                }
                if (pub) {
                    server.setPublicAddresses(new RawAddress[]{new RawAddress(addr)});
                    if (server.getPublicDnsAddress() != null) continue;
                    server.setPublicDnsAddress(addr);
                    continue;
                }
                server.setPrivateAddresses(new RawAddress[]{new RawAddress(addr)});
                if (server.getPrivateDnsAddress() != null) continue;
                server.setPrivateDnsAddress(addr);
                continue;
            }
            if (name.equals("osarchitecture")) {
                if (value != null && value.equals("32")) {
                    server.setArchitecture(Architecture.I32);
                    continue;
                }
                server.setArchitecture(Architecture.I64);
                continue;
            }
            if (name.equals("created")) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                try {
                    server.setCreationTimestamp(df.parse(value).getTime());
                }
                catch (ParseException e) {
                    logger.warn((Object)("Invalid date: " + value));
                    server.setLastBootTimestamp(0L);
                }
                continue;
            }
            if (name.equals("state")) {
                VmState state;
                if (value.equalsIgnoreCase("stopped")) {
                    state = VmState.STOPPED;
                    server.setImagable(true);
                } else if (value.equalsIgnoreCase("running")) {
                    state = VmState.RUNNING;
                } else if (value.equalsIgnoreCase("stopping")) {
                    state = VmState.STOPPING;
                } else if (value.equalsIgnoreCase("starting")) {
                    state = VmState.PENDING;
                } else if (value.equalsIgnoreCase("creating")) {
                    state = VmState.PENDING;
                } else if (value.equalsIgnoreCase("migrating")) {
                    state = VmState.REBOOTING;
                } else if (value.equalsIgnoreCase("destroyed")) {
                    state = VmState.TERMINATED;
                } else {
                    if (value.equalsIgnoreCase("error")) {
                        logger.warn((Object)"VM is in an error state.");
                        return null;
                    }
                    if (value.equalsIgnoreCase("expunging")) {
                        state = VmState.TERMINATED;
                    } else if (value.equalsIgnoreCase("ha")) {
                        state = VmState.REBOOTING;
                    } else {
                        throw new CloudException("Unexpected server state: " + value);
                    }
                }
                server.setCurrentState(state);
                continue;
            }
            if (name.equals("zoneid")) {
                server.setProviderRegionId(value);
                server.setProviderDataCenterId(value);
                continue;
            }
            if (name.equals("templateid")) {
                server.setProviderMachineImageId(value);
                continue;
            }
            if (name.equals("templatename")) {
                server.setPlatform(Platform.guess((String)value));
                continue;
            }
            if (name.equals("serviceofferingid")) {
                productId = value;
                continue;
            }
            if (value == null) continue;
            properties.put(name, value);
        }
        if (server.getName() == null) {
            server.setName(server.getProviderVirtualMachineId());
        }
        if (server.getDescription() == null) {
            server.setDescription(server.getName());
        }
        server.setProviderAssignedIpAddressId(null);
        if (server.getProviderRegionId() == null) {
            server.setProviderRegionId(this.provider.getContext().getRegionId());
        }
        if (server.getProviderDataCenterId() == null) {
            server.setProviderDataCenterId(this.provider.getContext().getRegionId());
        }
        if (productId != null) {
            server.setProductId(productId);
        }
        server.setTags(properties);
        return server;
    }
}

