/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.network;

import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.VisibleScope;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.VLANCapabilities;

public class CSVlanCapabilities
extends AbstractCapabilities<CSCloud>
implements VLANCapabilities {
    public CSVlanCapabilities(@Nonnull CSCloud cloud) {
        super((CloudProvider)cloud);
    }

    public boolean allowsNewNetworkInterfaceCreation() throws CloudException, InternalException {
        return false;
    }

    public boolean allowsNewVlanCreation() throws CloudException, InternalException {
        return true;
    }

    public boolean allowsNewRoutingTableCreation() throws CloudException, InternalException {
        return false;
    }

    public boolean allowsNewSubnetCreation() throws CloudException, InternalException {
        return false;
    }

    public boolean allowsMultipleTrafficTypesOverSubnet() throws CloudException, InternalException {
        if (this.getSubnetSupport().equals((Object)Requirement.NONE)) {
            return false;
        }
        int count = 0;
        for (IPVersion version : this.listSupportedIPVersions()) {
            if (++count <= 1) continue;
            return true;
        }
        return false;
    }

    public boolean allowsMultipleTrafficTypesOverVlan() throws CloudException, InternalException {
        int count = 0;
        for (IPVersion version : this.listSupportedIPVersions()) {
            if (++count <= 1) continue;
            return true;
        }
        return false;
    }

    public int getMaxNetworkInterfaceCount() throws CloudException, InternalException {
        return 0;
    }

    public int getMaxVlanCount() throws CloudException, InternalException {
        return -1;
    }

    @Nonnull
    public String getProviderTermForNetworkInterface(@Nonnull Locale locale) {
        return "NIC";
    }

    @Nonnull
    public String getProviderTermForSubnet(@Nonnull Locale locale) {
        return "";
    }

    @Nonnull
    public String getProviderTermForVlan(@Nonnull Locale locale) {
        return "network";
    }

    @Nonnull
    public Requirement getRoutingTableSupport() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement getSubnetSupport() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nullable
    public VisibleScope getVLANVisibleScope() {
        return null;
    }

    @Nonnull
    public Requirement identifySubnetDCRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    public boolean isNetworkInterfaceSupportEnabled() throws CloudException, InternalException {
        return false;
    }

    public boolean isSubnetDataCenterConstrained() throws CloudException, InternalException {
        return true;
    }

    public boolean isVlanDataCenterConstrained() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException {
        return Collections.singletonList(IPVersion.IPV4);
    }

    public boolean supportsInternetGatewayCreation() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsRawAddressRouting() throws CloudException, InternalException {
        return false;
    }
}

