/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.network;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.VisibleScope;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.LbAlgorithm;
import org.dasein.cloud.network.LbEndpointType;
import org.dasein.cloud.network.LbPersistence;
import org.dasein.cloud.network.LbProtocol;
import org.dasein.cloud.network.LoadBalancerAddressType;
import org.dasein.cloud.network.LoadBalancerCapabilities;

public class LBCapabilities
extends AbstractCapabilities<CSCloud>
implements LoadBalancerCapabilities {
    private static volatile List<LbAlgorithm> algorithms = null;
    private static volatile List<LbProtocol> protocols = null;

    public LBCapabilities(@Nonnull CSCloud provider) {
        super((CloudProvider)provider);
    }

    @Nonnull
    public LoadBalancerAddressType getAddressType() throws CloudException, InternalException {
        return LoadBalancerAddressType.IP;
    }

    public int getMaxPublicPorts() throws CloudException, InternalException {
        return 0;
    }

    @Nonnull
    public String getProviderTermForLoadBalancer(@Nonnull Locale locale) {
        return "load balancer";
    }

    @Nullable
    public VisibleScope getLoadBalancerVisibleScope() {
        return null;
    }

    public boolean healthCheckRequiresLoadBalancer() throws CloudException, InternalException {
        return true;
    }

    public Requirement healthCheckRequiresName() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    @Nonnull
    public Requirement identifyEndpointsOnCreateRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Requirement identifyListenersOnCreateRequirement() throws CloudException, InternalException {
        return Requirement.REQUIRED;
    }

    public boolean isAddressAssignedByProvider() throws CloudException, InternalException {
        return false;
    }

    public boolean isDataCenterLimited() throws CloudException, InternalException {
        return false;
    }

    @Nonnull
    public Iterable<LbAlgorithm> listSupportedAlgorithms() throws CloudException, InternalException {
        List<LbAlgorithm> list = algorithms;
        if (list == null) {
            list = new ArrayList<LbAlgorithm>();
            list.add(LbAlgorithm.ROUND_ROBIN);
            list.add(LbAlgorithm.LEAST_CONN);
            list.add(LbAlgorithm.SOURCE);
            algorithms = Collections.unmodifiableList(list);
        }
        return algorithms;
    }

    @Nonnull
    public Iterable<LbEndpointType> listSupportedEndpointTypes() throws CloudException, InternalException {
        return Collections.singletonList(LbEndpointType.VM);
    }

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException {
        return Collections.singletonList(IPVersion.IPV4);
    }

    @Nonnull
    public Iterable<LbPersistence> listSupportedPersistenceOptions() throws CloudException, InternalException {
        return Collections.singletonList(LbPersistence.NONE);
    }

    @Nonnull
    public Iterable<LbProtocol> listSupportedProtocols() throws CloudException, InternalException {
        if (protocols == null) {
            ArrayList<LbProtocol> list = new ArrayList<LbProtocol>();
            list.add(LbProtocol.RAW_TCP);
            protocols = Collections.unmodifiableList(list);
        }
        return protocols;
    }

    public boolean supportsAddingEndpoints() throws CloudException, InternalException {
        return true;
    }

    public boolean supportsMonitoring() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsMultipleTrafficTypes() throws CloudException, InternalException {
        return false;
    }
}

