/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.network;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSException;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.cloudstack.network.LBCapabilities;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.AbstractLoadBalancerSupport;
import org.dasein.cloud.network.HealthCheckOptions;
import org.dasein.cloud.network.IpAddress;
import org.dasein.cloud.network.LbAlgorithm;
import org.dasein.cloud.network.LbEndpointState;
import org.dasein.cloud.network.LbEndpointType;
import org.dasein.cloud.network.LbListener;
import org.dasein.cloud.network.LbPersistence;
import org.dasein.cloud.network.LbProtocol;
import org.dasein.cloud.network.LbType;
import org.dasein.cloud.network.LoadBalancer;
import org.dasein.cloud.network.LoadBalancerAddressType;
import org.dasein.cloud.network.LoadBalancerCapabilities;
import org.dasein.cloud.network.LoadBalancerCreateOptions;
import org.dasein.cloud.network.LoadBalancerEndpoint;
import org.dasein.cloud.network.LoadBalancerHealthCheck;
import org.dasein.cloud.network.LoadBalancerState;
import org.dasein.cloud.network.SSLCertificate;
import org.dasein.cloud.network.SSLCertificateCreateOptions;
import org.dasein.cloud.util.APITrace;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LoadBalancers
extends AbstractLoadBalancerSupport<CSCloud> {
    public static final String ASSIGN_TO_LOAD_BALANCER_RULE = "assignToLoadBalancerRule";
    public static final String CREATE_LOAD_BALANCER_RULE = "createLoadBalancerRule";
    public static final String DELETE_LOAD_BALANCER_RULE = "deleteLoadBalancerRule";
    public static final String LIST_LOAD_BALANCER_RULES = "listLoadBalancerRules";
    public static final String LIST_LOAD_BALANCER_RULE_INSTANCES = "listLoadBalancerRuleInstances";
    public static final String REMOVE_FROM_LOAD_BALANCER_RULE = "removeFromLoadBalancerRule";
    public static final String UPLOAD_SSL_CERTIFICATE = "uploadSslCert";
    public static final String LIST_SSL_CERTIFICATES = "listSslCerts";
    public static final String DELETE_SSL_CERTIFICATE = "deleteSslCert";
    public static final String CREATE_LB_HEALTH_CHECK_POLICY = "createLBHealthCheckPolicy";
    private CSCloud provider;
    private volatile transient LBCapabilities capabilities;
    private static volatile List<LbAlgorithm> algorithms = null;

    LoadBalancers(CSCloud provider) {
        super((CloudProvider)provider);
        this.provider = provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServers(@Nonnull String toLoadBalancerId, String ... serverIds) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.addServers");
        try {
            LoadBalancer lb = this.getLoadBalancer(toLoadBalancerId);
            if (lb == null) {
                throw new CloudException("No such load balancer: " + toLoadBalancerId);
            }
            if (serverIds == null || serverIds.length < 1) {
                return;
            }
            try {
                for (LbListener listener : lb.getListeners()) {
                    String ruleId = this.getVmOpsRuleId(listener.getAlgorithm(), toLoadBalancerId, listener.getPublicPort(), listener.getPrivatePort());
                    StringBuilder str = new StringBuilder();
                    for (int i = 0; i < serverIds.length; ++i) {
                        str.append(serverIds[i]);
                        if (i >= serverIds.length - 1) continue;
                        str.append(",");
                    }
                    CSMethod method = new CSMethod(this.provider);
                    Document doc = method.get(method.buildUrl(ASSIGN_TO_LOAD_BALANCER_RULE, new Param("id", ruleId), new Param("virtualMachineIds", str.toString())), ASSIGN_TO_LOAD_BALANCER_RULE);
                    this.provider.waitForJob(doc, "Add Server");
                }
            }
            catch (RuntimeException e) {
                throw new InternalException((Throwable)e);
            }
            catch (Error e) {
                throw new InternalException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String createLoadBalancer(@Nonnull LoadBalancerCreateOptions options) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.create");
        try {
            IpAddress publicAddress = this.provider.getNetworkServices().getIpAddressSupport().getIpAddress(options.getProviderIpAddressId());
            if (publicAddress == null) {
                throw new CloudException("You must specify the IP address for your load balancer.");
            }
            for (LbListener lbListener : options.getListeners()) {
                if (!this.isId(options.getProviderIpAddressId())) {
                    this.createVmOpsRule(options.getName(), lbListener.getAlgorithm(), options.getProviderIpAddressId(), lbListener.getPublicPort(), lbListener.getPrivatePort());
                    continue;
                }
                this.createCloudstack22Rule(options.getName(), lbListener.getAlgorithm(), options.getProviderIpAddressId(), lbListener.getPublicPort(), lbListener.getPrivatePort());
            }
            for (LbListener lbListener : options.getEndpoints()) {
                if (!lbListener.getEndpointType().equals((Object)LbEndpointType.VM)) continue;
                this.addServers(publicAddress.getRawAddress().getIpAddress(), lbListener.getEndpointValue());
            }
            String string = publicAddress.getRawAddress().getIpAddress();
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    public LoadBalancerHealthCheck createLoadBalancerHealthCheck(@Nonnull HealthCheckOptions options) throws CloudException, InternalException {
        ArrayList<Param> params = new ArrayList<Param>();
        String ruleId = this.getRuleId(options.getProviderLoadBalancerId());
        params.add(new Param("lbruleid", ruleId));
        if (options.getDescription() != null) {
            params.add(new Param("description", options.getDescription()));
        }
        params.add(new Param("healthythreshold", String.valueOf(options.getHealthyCount())));
        params.add(new Param("unhealthythreshold", String.valueOf(options.getUnhealthyCount())));
        params.add(new Param("intervaltime", String.valueOf(options.getInterval())));
        params.add(new Param("responsetimeout", String.valueOf(options.getTimeout())));
        params.add(new Param("pingpath", options.getHost() + ":" + options.getPort() + "/" + options.getPath()));
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(CREATE_LB_HEALTH_CHECK_POLICY, params.toArray(new Param[params.size()])), CREATE_LB_HEALTH_CHECK_POLICY);
        NodeList matches = doc.getElementsByTagName("healthcheckpolicy");
        int i = 0;
        if (i < matches.getLength()) {
            Node n = matches.item(i);
            NodeList attributes = n.getChildNodes();
            String lbhcId = null;
            LoadBalancerHealthCheck.HCProtocol protocol = null;
            String path = null;
            int port = 0;
            int interval = 0;
            int healthyCount = 0;
            int unhealthyCount = 0;
            int timeout = 0;
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node child = attributes.item(j);
                String name = child.getNodeName().toLowerCase();
                String value = child.getChildNodes().getLength() > 0 ? child.getFirstChild().getNodeValue() : null;
                if ("id".equalsIgnoreCase(name)) {
                    lbhcId = value;
                    continue;
                }
                if ("path".equalsIgnoreCase(name)) {
                    path = value;
                    continue;
                }
                if ("healthcheckinterval".equalsIgnoreCase(name)) {
                    interval = Integer.parseInt(value);
                    continue;
                }
                if ("healthcheckthresshold".equalsIgnoreCase(name)) {
                    healthyCount = Integer.parseInt(value);
                    continue;
                }
                if ("unhealthcheckthresshold".equalsIgnoreCase(name)) {
                    unhealthyCount = Integer.parseInt(value);
                    continue;
                }
                if ("pingpath".equalsIgnoreCase(name)) {
                    path = value;
                    continue;
                }
                if (!"responsetime".equalsIgnoreCase(name)) continue;
                timeout = Integer.parseInt(value);
            }
            return LoadBalancerHealthCheck.getInstance(lbhcId, protocol, (int)port, path, (int)interval, (int)timeout, (int)healthyCount, (int)unhealthyCount);
        }
        return null;
    }

    @Deprecated
    @Nonnull
    public String create(@Nonnull String name, @Nonnull String description, @Nullable String addressId, @Nullable String[] zoneIds, @Nullable LbListener[] listeners, @Nullable String[] serverIds, @Nullable String[] subnetIds, LbType type) throws CloudException, InternalException {
        if (addressId == null) {
            throw new CloudException("You must specify an IP address for load balancer creation");
        }
        LoadBalancerCreateOptions options = LoadBalancerCreateOptions.getInstance((String)name, (String)description, (String)addressId);
        if (zoneIds != null && zoneIds.length > 0) {
            options.limitedTo(zoneIds);
        }
        if (listeners != null && listeners.length > 0) {
            options.havingListeners(listeners);
        }
        if (serverIds != null && serverIds.length > 0) {
            options.withVirtualMachines(serverIds);
        }
        if (subnetIds != null && subnetIds.length > 0) {
            options.withProviderSubnetIds(subnetIds);
        }
        if (type != null) {
            options.asType(type);
        }
        return this.createLoadBalancer(options);
    }

    private void createVmOpsRule(String lbName, LbAlgorithm algorithm, String publicIp, int publicPort, int privatePort) throws CloudException, InternalException {
        Collection lbs;
        Node node;
        HashMap<String, Object> current;
        int i;
        String algor;
        String id = this.getVmOpsRuleId(algorithm, publicIp, publicPort, privatePort);
        if (id != null) {
            return;
        }
        ArrayList<Param> params = new ArrayList<Param>();
        switch (algorithm) {
            case ROUND_ROBIN: {
                algor = "roundrobin";
                break;
            }
            case LEAST_CONN: {
                algor = "leastconn";
                break;
            }
            case SOURCE: {
                algor = "source";
                break;
            }
            default: {
                algor = "roundrobin";
            }
        }
        params.add(new Param("publicIp", publicIp));
        params.add(new Param("publicPort", String.valueOf(publicPort)));
        params.add(new Param("privatePort", String.valueOf(privatePort)));
        params.add(new Param("algorithm", algor));
        if (lbName != null && !lbName.equals("")) {
            params.add(new Param("name", lbName));
        } else {
            params.add(new Param("name", "dsnlb_" + publicIp + "_" + publicPort + "_" + privatePort));
        }
        params.add(new Param("description", "dsnlb_" + publicIp + "_" + publicPort + "_" + privatePort));
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(CREATE_LOAD_BALANCER_RULE, params.toArray(new Param[params.size()])), CREATE_LOAD_BALANCER_RULE);
        NodeList matches = doc.getElementsByTagName("loadbalancerrule");
        for (i = 0; i < matches.getLength(); ++i) {
            current = new HashMap<String, LoadBalancer>();
            node = matches.item(i);
            this.toRule(node, current);
            lbs = current.values();
            if (lbs.size() <= 0) continue;
            return;
        }
        matches = doc.getElementsByTagName("loadbalancer");
        for (i = 0; i < matches.getLength(); ++i) {
            current = new HashMap();
            node = matches.item(i);
            this.toRule(node, current);
            lbs = current.values();
            if (lbs.size() <= 0) continue;
            return;
        }
        throw new CloudException("Failed to add load balancer rule (2).");
    }

    private void createCloudstack22Rule(String lbName, LbAlgorithm algorithm, String publicIpId, int publicPort, int privatePort) throws CloudException, InternalException {
        Collection lbs;
        Node node;
        HashMap<String, Object> current;
        int i;
        String algor;
        String id = this.getVmOpsRuleId(algorithm, publicIpId, publicPort, privatePort);
        if (id != null) {
            return;
        }
        ArrayList<Param> params = new ArrayList<Param>();
        switch (algorithm) {
            case ROUND_ROBIN: {
                algor = "roundrobin";
                break;
            }
            case LEAST_CONN: {
                algor = "leastconn";
                break;
            }
            case SOURCE: {
                algor = "source";
                break;
            }
            default: {
                algor = "roundrobin";
            }
        }
        params.add(new Param("publicIpId", publicIpId));
        params.add(new Param("publicPort", String.valueOf(publicPort)));
        params.add(new Param("privatePort", String.valueOf(privatePort)));
        params.add(new Param("algorithm", algor));
        if (lbName != null && !lbName.equals("")) {
            params.add(new Param("name", lbName));
        } else {
            params.add(new Param("name", "dsnlb_" + publicIpId + "_" + publicPort + "_" + privatePort));
        }
        params.add(new Param("description", "dsnlb_" + publicIpId + "_" + publicPort + "_" + privatePort));
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(CREATE_LOAD_BALANCER_RULE, params.toArray(new Param[params.size()])), CREATE_LOAD_BALANCER_RULE);
        NodeList matches = doc.getElementsByTagName("loadbalancerrule");
        for (i = 0; i < matches.getLength(); ++i) {
            current = new HashMap<String, LoadBalancer>();
            node = matches.item(i);
            this.toRule(node, current);
            lbs = current.values();
            if (lbs.size() <= 0) continue;
            return;
        }
        matches = doc.getElementsByTagName("loadbalancer");
        for (i = 0; i < matches.getLength(); ++i) {
            current = new HashMap();
            node = matches.item(i);
            this.toRule(node, current);
            lbs = current.values();
            if (lbs.size() <= 0) continue;
            return;
        }
        matches = doc.getElementsByTagName("jobid");
        if (matches.getLength() > 0) {
            this.provider.waitForJob(doc, "Create Load Balancer Rule");
            return;
        }
        throw new CloudException("Failed to add load balancer rule (2).");
    }

    @Nonnull
    public LoadBalancerAddressType getAddressType() throws CloudException, InternalException {
        return LoadBalancerAddressType.IP;
    }

    @Nonnull
    public LoadBalancerCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new LBCapabilities(this.provider);
        }
        return this.capabilities;
    }

    private boolean isId(String ipAddressIdCandidate) {
        String[] parts = ipAddressIdCandidate.split("\\.");
        return parts == null || parts.length != 4;
    }

    @Nullable
    public LoadBalancer getLoadBalancer(@Nonnull String loadBalancerId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.getLoadBalancer");
        try {
            HashMap<String, LoadBalancer> matches = new HashMap<String, LoadBalancer>();
            boolean isId = this.isId(loadBalancerId);
            String key = isId ? "publicIpId" : "publicIp";
            CSMethod method = new CSMethod(this.provider);
            Document doc = method.get(method.buildUrl(LIST_LOAD_BALANCER_RULES, new Param(key, loadBalancerId)), LIST_LOAD_BALANCER_RULES);
            NodeList rules = doc.getElementsByTagName("loadbalancerrule");
            for (int i = 0; i < rules.getLength(); ++i) {
                Node node = rules.item(i);
                this.toRule(node, matches);
            }
            LoadBalancer loadBalancer = (LoadBalancer)matches.get(loadBalancerId);
            return loadBalancer;
        }
        catch (CSException e) {
            if (e.getHttpCode() == 431) {
                LoadBalancer loadBalancer = null;
                return loadBalancer;
            }
            throw e;
        }
        finally {
            APITrace.end();
        }
    }

    public int getMaxPublicPorts() throws CloudException, InternalException {
        return 0;
    }

    @Nonnull
    public Iterable<ResourceStatus> listLoadBalancerStatus() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.listLoadBalancerStatus");
        try {
            HashMap<String, LoadBalancer> matches = new HashMap<String, LoadBalancer>();
            CSMethod method = new CSMethod(this.provider);
            try {
                Document doc = method.get(method.buildUrl(LIST_LOAD_BALANCER_RULES, new Param[0]), LIST_LOAD_BALANCER_RULES);
                int numPages = 1;
                NodeList nodes = doc.getElementsByTagName("count");
                Node n = nodes.item(0);
                if (n != null) {
                    String value = n.getFirstChild().getNodeValue().trim();
                    int count = Integer.parseInt(value);
                    numPages = count / 500;
                    int remainder = count % 500;
                    if (remainder > 0) {
                        ++numPages;
                    }
                }
                for (int page = 1; page <= numPages; ++page) {
                    if (page > 1) {
                        String nextPage = String.valueOf(page);
                        doc = method.get(method.buildUrl(LIST_LOAD_BALANCER_RULES, new Param("pagesize", "500"), new Param("page", nextPage)), LIST_LOAD_BALANCER_RULES);
                    }
                    NodeList rules = doc.getElementsByTagName("loadbalancerrule");
                    for (int i = 0; i < rules.getLength(); ++i) {
                        Node node = rules.item(i);
                        this.toRule(node, matches);
                    }
                }
                ArrayList<ResourceStatus> results = new ArrayList<ResourceStatus>();
                for (LoadBalancer lb : matches.values()) {
                    if (!this.matchesRegion(lb.getProviderLoadBalancerId())) continue;
                    results.add(new ResourceStatus(lb.getProviderLoadBalancerId(), (Object)lb.getCurrentState()));
                }
                ArrayList<ResourceStatus> arrayList = results;
                return arrayList;
            }
            catch (CloudException e) {
                block13: {
                    if (e.getHttpCode() != 404) break block13;
                    List<ResourceStatus> list = Collections.emptyList();
                    APITrace.end();
                    return list;
                }
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    private Collection<String> getServersAt(String ruleId) throws InternalException, CloudException {
        ArrayList<String> ids = new ArrayList<String>();
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_LOAD_BALANCER_RULE_INSTANCES, new Param("id", ruleId)), LIST_LOAD_BALANCER_RULE_INSTANCES);
        int numPages = 1;
        NodeList nodes = doc.getElementsByTagName("count");
        Node nd = nodes.item(0);
        if (nd != null) {
            String value = nd.getFirstChild().getNodeValue().trim();
            int count = Integer.parseInt(value);
            numPages = count / 500;
            int remainder = count % 500;
            if (remainder > 0) {
                ++numPages;
            }
        }
        for (int page = 1; page <= numPages; ++page) {
            if (page > 1) {
                String nextPage = String.valueOf(page);
                doc = method.get(method.buildUrl(LIST_LOAD_BALANCER_RULE_INSTANCES, new Param("id", ruleId), new Param("pagesize", "500"), new Param("page", nextPage)), LIST_LOAD_BALANCER_RULE_INSTANCES);
            }
            NodeList instances = doc.getElementsByTagName("loadbalancerruleinstance");
            for (int i = 0; i < instances.getLength(); ++i) {
                Node node = instances.item(i);
                NodeList attributes = node.getChildNodes();
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Node n = attributes.item(j);
                    if (!n.getNodeName().equals("id")) continue;
                    ids.add(n.getFirstChild().getNodeValue());
                }
            }
        }
        return ids;
    }

    @Nullable
    private String getVmOpsRuleId(@Nonnull LbAlgorithm lbAlgorithm, @Nonnull String publicIp, int publicPort, int privatePort) throws CloudException, InternalException {
        String algorithm;
        String ruleId = null;
        switch (lbAlgorithm) {
            case ROUND_ROBIN: {
                algorithm = "roundrobin";
                break;
            }
            case LEAST_CONN: {
                algorithm = "leastconn";
                break;
            }
            case SOURCE: {
                algorithm = "source";
                break;
            }
            default: {
                algorithm = "roundrobin";
            }
        }
        boolean isId = this.isId(publicIp);
        String key = isId ? "publicIpId" : "publicIp";
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_LOAD_BALANCER_RULES, new Param(key, publicIp)), LIST_LOAD_BALANCER_RULES);
        NodeList rules = doc.getElementsByTagName("loadbalancerrule");
        for (int i = 0; i < rules.getLength(); ++i) {
            Node node = rules.item(i);
            NodeList attributes = node.getChildNodes();
            boolean isIt = true;
            String id = null;
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node n = attributes.item(j);
                String name = n.getNodeName().toLowerCase();
                String value = n.getChildNodes().getLength() > 0 ? n.getFirstChild().getNodeValue() : null;
                if (name.equals("publicip")) {
                    if (value == null || value.equals(publicIp)) continue;
                    isIt = false;
                    break;
                }
                if (name.equals("publicport")) {
                    if (value != null && publicPort == Integer.parseInt(value)) continue;
                    isIt = false;
                    break;
                }
                if (name.equals("privateport")) {
                    if (value != null && privatePort == Integer.parseInt(value)) continue;
                    isIt = false;
                    break;
                }
                if (name.equals("algorithm")) {
                    if (value != null && value.equals(algorithm)) continue;
                    isIt = false;
                    break;
                }
                if (!name.equals("id")) continue;
                id = value;
            }
            if (!isIt) continue;
            ruleId = id;
            break;
        }
        return ruleId;
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.isSubscribed");
        try {
            CSMethod method = new CSMethod(this.provider);
            try {
                method.get(method.buildUrl(LIST_LOAD_BALANCER_RULES, new Param[0]), LIST_LOAD_BALANCER_RULES);
                boolean bl = true;
                return bl;
            }
            catch (CSException e) {
                block7: {
                    int code = e.getHttpCode();
                    if (code != 403 && code != 401 && code != 531) break block7;
                    boolean bl = false;
                    APITrace.end();
                    return bl;
                }
                throw e;
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<LoadBalancerEndpoint> listEndpoints(@Nonnull String loadBalancerId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"LB.listEndpoints");
        try {
            LoadBalancer lb = this.getLoadBalancer(loadBalancerId);
            if (lb == null) {
                List<LoadBalancerEndpoint> list = Collections.emptyList();
                return list;
            }
            ArrayList<LoadBalancerEndpoint> endpoints = new ArrayList<LoadBalancerEndpoint>();
            for (String serverId : lb.getProviderServerIds()) {
                VirtualMachine vm = ((CSCloud)this.getProvider()).getComputeServices().getVirtualMachineSupport().getVirtualMachine(serverId);
                endpoints.add(LoadBalancerEndpoint.getInstance((LbEndpointType)LbEndpointType.VM, (String)serverId, (LbEndpointState)(vm != null && vm.getCurrentState().equals((Object)VmState.RUNNING) ? LbEndpointState.ACTIVE : LbEndpointState.INACTIVE)));
            }
            ArrayList<LoadBalancerEndpoint> arrayList = endpoints;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<LoadBalancer> listLoadBalancers() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.listLoadBalancers");
        try {
            HashMap<String, LoadBalancer> matches = new HashMap<String, LoadBalancer>();
            CSMethod method = new CSMethod(this.provider);
            try {
                Document doc = method.get(method.buildUrl(LIST_LOAD_BALANCER_RULES, new Param[0]), LIST_LOAD_BALANCER_RULES);
                int numPages = 1;
                NodeList nodes = doc.getElementsByTagName("count");
                Node n = nodes.item(0);
                if (n != null) {
                    String value = n.getFirstChild().getNodeValue().trim();
                    int count = Integer.parseInt(value);
                    numPages = count / 500;
                    int remainder = count % 500;
                    if (remainder > 0) {
                        ++numPages;
                    }
                }
                for (int page = 1; page <= numPages; ++page) {
                    if (page > 1) {
                        String nextPage = String.valueOf(page);
                        doc = method.get(method.buildUrl(LIST_LOAD_BALANCER_RULES, new Param("pagesize", "500"), new Param("page", nextPage)), LIST_LOAD_BALANCER_RULES);
                    }
                    NodeList rules = doc.getElementsByTagName("loadbalancerrule");
                    for (int i = 0; i < rules.getLength(); ++i) {
                        Node node = rules.item(i);
                        this.toRule(node, matches);
                    }
                }
                ArrayList<LoadBalancer> results = new ArrayList<LoadBalancer>();
                for (LoadBalancer lb : matches.values()) {
                    if (!this.matchesRegion(lb.getProviderLoadBalancerId())) continue;
                    results.add(lb);
                }
                ArrayList<LoadBalancer> arrayList = results;
                return arrayList;
            }
            catch (CloudException e) {
                block13: {
                    if (e.getHttpCode() != 404) break block13;
                    List<LoadBalancer> list = Collections.emptyList();
                    APITrace.end();
                    return list;
                }
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            APITrace.end();
        }
    }

    boolean matchesRegion(@Nonnull String addressId) throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl("listPublicIpAddresses", new Param(this.isId(addressId) ? "ipAddressId" : "ipAddress", addressId)), "listPublicIpAddresses");
        NodeList matches = doc.getElementsByTagName("publicipaddress");
        for (int i = 0; i < matches.getLength(); ++i) {
            Node n = matches.item(i);
            NodeList attributes = n.getChildNodes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node child = attributes.item(j);
                String name = child.getNodeName().toLowerCase();
                String value = child.getChildNodes().getLength() > 0 ? child.getFirstChild().getNodeValue() : null;
                if (!name.equalsIgnoreCase("zoneid")) continue;
                return value != null && value.equalsIgnoreCase(this.getContext().getRegionId());
            }
        }
        return false;
    }

    @Deprecated
    public void remove(@Nonnull String loadBalancerId) throws CloudException, InternalException {
        this.removeLoadBalancer(loadBalancerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoadBalancer(@Nonnull String loadBalancerId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.remove");
        try {
            LoadBalancer lb = this.getLoadBalancer(loadBalancerId);
            if (lb == null || lb.getListeners().length < 1) {
                return;
            }
            for (LbListener listener : lb.getListeners()) {
                String ruleId = this.getVmOpsRuleId(listener.getAlgorithm(), lb.getAddress(), listener.getPublicPort(), listener.getPrivatePort());
                if (ruleId == null) continue;
                this.removeVmOpsRule(ruleId);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeServers(@Nonnull String toLoadBalancerId, String ... serverIds) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.provider, (String)"LB.removeServers");
        try {
            try {
                LoadBalancer lb = this.getLoadBalancer(toLoadBalancerId);
                if (lb == null) {
                    throw new CloudException("No such load balancer: " + toLoadBalancerId);
                }
                StringBuilder ids = new StringBuilder();
                for (int i = 0; i < serverIds.length; ++i) {
                    ids.append(serverIds[i]);
                    if (i >= serverIds.length - 1) continue;
                    ids.append(",");
                }
                for (LbListener listener : lb.getListeners()) {
                    String ruleId = this.getVmOpsRuleId(listener.getAlgorithm(), toLoadBalancerId, listener.getPublicPort(), listener.getPrivatePort());
                    CSMethod method = new CSMethod(this.provider);
                    Document doc = method.get(method.buildUrl(REMOVE_FROM_LOAD_BALANCER_RULE, new Param("id", ruleId), new Param("virtualMachineIds", ids.toString())), REMOVE_FROM_LOAD_BALANCER_RULE);
                    this.provider.waitForJob(doc, "Remove Server");
                }
            }
            catch (RuntimeException e) {
                throw new InternalException((Throwable)e);
            }
            catch (Error e) {
                throw new InternalException((Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    public SSLCertificate createSSLCertificate(@Nonnull SSLCertificateCreateOptions options) throws CloudException, InternalException {
        Document doc = null;
        try {
            doc = this.uploadSslCertificate(options, false);
        }
        catch (CloudException e) {
            if (e.getHttpCode() == 530) {
                doc = this.uploadSslCertificate(options, true);
            }
            throw e;
        }
        String certId = null;
        String certBody = null;
        String certChain = null;
        NodeList matches = doc.getElementsByTagName("sslcert");
        for (int i = 0; i < matches.getLength(); ++i) {
            Node n = matches.item(i);
            NodeList attributes = n.getChildNodes();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node child = attributes.item(j);
                String name = child.getNodeName().toLowerCase();
                String value = child.getChildNodes().getLength() > 0 ? child.getFirstChild().getNodeValue() : null;
                if ("id".equalsIgnoreCase(name)) {
                    certId = value;
                    continue;
                }
                if ("certificate".equalsIgnoreCase(name)) {
                    certBody = value;
                    continue;
                }
                if (!"certchain".equalsIgnoreCase(name)) continue;
                certChain = value;
            }
        }
        return SSLCertificate.getInstance(certId, certId, null, certBody, certChain, (String)"");
    }

    private Document uploadSslCertificate(SSLCertificateCreateOptions opts, boolean cs44hack) throws InternalException, CloudException {
        CSMethod method = new CSMethod(this.provider);
        ArrayList<Param> params = new ArrayList<Param>();
        try {
            params.add(new Param("certificate", cs44hack ? URLEncoder.encode(opts.getCertificateBody(), "UTF-8") : opts.getCertificateBody()));
            params.add(new Param("privatekey", cs44hack ? URLEncoder.encode(opts.getPrivateKey(), "UTF-8") : opts.getPrivateKey()));
            if (opts.getCertificateChain() != null) {
                params.add(new Param("certchain", cs44hack ? URLEncoder.encode(opts.getCertificateChain(), "UTF-8") : opts.getCertificateChain()));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalException((Throwable)e);
        }
        return method.get(method.buildUrl(UPLOAD_SSL_CERTIFICATE, params.toArray(new Param[params.size()])), UPLOAD_SSL_CERTIFICATE);
    }

    @Nonnull
    public Iterable<SSLCertificate> listSSLCertificates() throws CloudException, InternalException {
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(LIST_SSL_CERTIFICATES, new Param("accountid", this.provider.getAccountId())), LIST_SSL_CERTIFICATES);
        ArrayList<SSLCertificate> results = new ArrayList<SSLCertificate>();
        NodeList matches = doc.getElementsByTagName("sslcert");
        for (int i = 0; i < matches.getLength(); ++i) {
            Node n = matches.item(i);
            NodeList attributes = n.getChildNodes();
            String certId = null;
            String certBody = null;
            String certChain = null;
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node child = attributes.item(j);
                String name = child.getNodeName().toLowerCase();
                String value = child.getChildNodes().getLength() > 0 ? child.getFirstChild().getNodeValue() : null;
                if ("id".equalsIgnoreCase(name)) {
                    certId = value;
                    continue;
                }
                if ("certificate".equalsIgnoreCase(name)) {
                    certBody = value;
                    continue;
                }
                if (!"certchain".equalsIgnoreCase(name)) continue;
                certChain = value;
            }
            results.add(SSLCertificate.getInstance(certId, certId, null, certBody, certChain, (String)""));
        }
        return results;
    }

    @Nullable
    public SSLCertificate getSSLCertificate(@Nonnull String certificateName) throws CloudException, InternalException {
        CSMethod method = new CSMethod(this.provider);
        Document doc = null;
        try {
            doc = method.get(method.buildUrl(LIST_SSL_CERTIFICATES, new Param("certid", certificateName)), LIST_SSL_CERTIFICATES);
        }
        catch (CSException e) {
            if (e.getHttpCode() == 431) {
                return null;
            }
            throw e;
        }
        NodeList matches = doc.getElementsByTagName("sslcert");
        int i = 0;
        if (i < matches.getLength()) {
            Node n = matches.item(i);
            NodeList attributes = n.getChildNodes();
            String certId = null;
            String certBody = null;
            String certChain = null;
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node child = attributes.item(j);
                String name = child.getNodeName().toLowerCase();
                String value = child.getChildNodes().getLength() > 0 ? child.getFirstChild().getNodeValue() : null;
                if ("id".equalsIgnoreCase(name)) {
                    certId = value;
                    continue;
                }
                if ("certificate".equalsIgnoreCase(name)) {
                    certBody = value;
                    continue;
                }
                if (!"certchain".equalsIgnoreCase(name)) continue;
                certChain = value;
            }
            return SSLCertificate.getInstance(certId, certId, null, certBody, certChain, (String)"");
        }
        return null;
    }

    public void removeSSLCertificate(@Nonnull String certificateName) throws CloudException, InternalException {
        boolean success;
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(DELETE_SSL_CERTIFICATE, new Param("id", certificateName)), DELETE_SSL_CERTIFICATE);
        NodeList matches = doc.getElementsByTagName("success");
        if (matches.getLength() > 0 && !(success = CSCloud.getBooleanValue(matches.item(0))) && (matches = doc.getElementsByTagName("displaytext")).getLength() > 0) {
            String description = CSCloud.getTextValue(matches.item(0));
            throw new CloudException("Unable to remove SSL certificate: " + description);
        }
    }

    private void removeVmOpsRule(@Nonnull String ruleId) throws CloudException, InternalException {
        CSMethod method = new CSMethod(this.provider);
        Document doc = method.get(method.buildUrl(DELETE_LOAD_BALANCER_RULE, new Param("id", ruleId)), DELETE_LOAD_BALANCER_RULE);
        this.provider.waitForJob(doc, "Remove Load Balancer Rule");
    }

    private void toRule(@Nullable Node node, @Nonnull Map<String, LoadBalancer> current) throws InternalException, CloudException {
        NodeList attributes = node.getChildNodes();
        int publicPort = -1;
        int privatePort = -1;
        LbAlgorithm algorithm = null;
        String publicIp = null;
        String ruleId = null;
        String lbName = null;
        String lbDesc = "";
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node n = attributes.item(i);
            String name = n.getNodeName().toLowerCase();
            String value = n.getChildNodes().getLength() > 0 ? n.getFirstChild().getNodeValue() : null;
            if (name.equals("publicip")) {
                publicIp = value;
                continue;
            }
            if (name.equals("id")) {
                ruleId = value;
                continue;
            }
            if (name.equals("publicport") && value != null) {
                publicPort = Integer.parseInt(value);
                continue;
            }
            if (name.equals("privateport") && value != null) {
                privatePort = Integer.parseInt(value);
                continue;
            }
            if (name.equals("algorithm")) {
                if (value == null || value.equals("roundrobin")) {
                    algorithm = LbAlgorithm.ROUND_ROBIN;
                    continue;
                }
                if (value.equals("leastconn")) {
                    algorithm = LbAlgorithm.LEAST_CONN;
                    continue;
                }
                if (value.equals("")) {
                    algorithm = LbAlgorithm.SOURCE;
                    continue;
                }
                algorithm = LbAlgorithm.ROUND_ROBIN;
                continue;
            }
            if (name.equals("name")) {
                lbName = value;
                continue;
            }
            if (!name.equals("description")) continue;
            lbDesc = value;
        }
        LbListener listener = LbListener.getInstance(algorithm, (LbPersistence)LbPersistence.NONE, (LbProtocol)LbProtocol.RAW_TCP, (int)publicPort, (int)privatePort);
        Collection<String> serverIds = this.getServersAt(ruleId);
        if (current.containsKey(publicIp)) {
            LoadBalancer lb = current.get(publicIp);
            String[] currentIds = lb.getProviderServerIds();
            LbListener[] listeners = lb.getListeners();
            TreeSet<Integer> ports = new TreeSet<Integer>();
            for (int port : lb.getPublicPorts()) {
                ports.add(port);
            }
            ports.add(publicPort);
            int[] portList = new int[ports.size()];
            int i = 0;
            for (Integer p : ports) {
                portList[i++] = p;
            }
            lb.setPublicPorts(portList);
            boolean there = false;
            for (LbListener l : listeners) {
                if (!l.getAlgorithm().equals((Object)listener.getAlgorithm()) || !l.getNetworkProtocol().equals((Object)listener.getNetworkProtocol()) || l.getPublicPort() != listener.getPublicPort() || l.getPrivatePort() != listener.getPrivatePort()) continue;
                there = true;
                break;
            }
            if (!there) {
                lb.withListeners(new LbListener[]{listener});
            }
            TreeSet<String> newIds = new TreeSet<String>();
            Collections.addAll(newIds, currentIds);
            for (String id : serverIds) {
                newIds.add(id);
            }
            lb.setProviderServerIds(newIds.toArray(new String[newIds.size()]));
            lb.setName(lbName);
            lb.setDescription(lbDesc);
        } else {
            Collection<DataCenter> dcs = this.provider.getDataCenterServices().listDataCenters(this.provider.getContext().getRegionId());
            String[] ids = new String[dcs.size()];
            int i = 0;
            for (DataCenter dc : dcs) {
                ids[i++] = dc.getProviderDataCenterId();
            }
            LoadBalancer lb = LoadBalancer.getInstance((String)this.getContext().getAccountNumber(), (String)this.getContext().getRegionId(), (String)publicIp, (LoadBalancerState)LoadBalancerState.ACTIVE, (String)lbName, (String)lbDesc, (LoadBalancerAddressType)LoadBalancerAddressType.IP, (String)publicIp, (int[])new int[]{publicPort}).withListeners(new LbListener[]{listener}).operatingIn(ids);
            lb.setProviderServerIds(serverIds.toArray(new String[serverIds.size()]));
            current.put(publicIp, lb);
        }
    }

    @Nullable
    private String getRuleId(@Nonnull String loadBalancerId) throws CloudException, InternalException {
        try {
            HashMap matches = new HashMap();
            boolean isId = this.isId(loadBalancerId);
            String key = isId ? "publicIpId" : "publicIp";
            CSMethod method = new CSMethod(this.provider);
            Document doc = method.get(method.buildUrl(LIST_LOAD_BALANCER_RULES, new Param(key, loadBalancerId)), LIST_LOAD_BALANCER_RULES);
            NodeList rules = doc.getElementsByTagName("loadbalancerrule");
            for (int i = 0; i < rules.getLength(); ++i) {
                NodeList attributes = rules.item(i).getChildNodes();
                String ruleId = null;
                String publicIp = null;
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Node n = attributes.item(j);
                    String name = n.getNodeName().toLowerCase();
                    String value = n.getChildNodes().getLength() > 0 ? n.getFirstChild().getNodeValue() : null;
                    if (name.equals("publicip")) {
                        publicIp = value;
                        continue;
                    }
                    if (!name.equals("id")) continue;
                    ruleId = value;
                }
                if (!loadBalancerId.equals(publicIp)) continue;
                return ruleId;
            }
        }
        catch (CSException e) {
            if (e.getHttpCode() == 431) {
                return null;
            }
            throw e;
        }
        return null;
    }
}

