/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.network;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSException;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.cloudstack.network.CSNetworkServices;
import org.dasein.cloud.cloudstack.network.CSVlanCapabilities;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.network.AbstractVLANSupport;
import org.dasein.cloud.network.Firewall;
import org.dasein.cloud.network.FirewallSupport;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.InternetGateway;
import org.dasein.cloud.network.IpAddress;
import org.dasein.cloud.network.IpAddressSupport;
import org.dasein.cloud.network.Networkable;
import org.dasein.cloud.network.RoutingTable;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.network.VLANCapabilities;
import org.dasein.cloud.network.VLANState;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Network
extends AbstractVLANSupport {
    public static final Logger logger = Logger.getLogger(Network.class);
    public static final String CREATE_NETWORK = "createNetwork";
    public static final String DELETE_NETWORK = "deleteNetwork";
    public static final String LIST_NETWORK_OFFERINGS = "listNetworkOfferings";
    public static final String LIST_NETWORKS = "listNetworks";
    public static final String CREATE_EGRESS_RULE = "createEgressFirewallRule";
    private CSCloud cloudstack;
    private volatile transient CSVlanCapabilities capabilities;

    Network(CSCloud cloudstack) {
        super((CloudProvider)cloudstack);
        this.cloudstack = cloudstack;
    }

    public List<String> findFreeNetworks() throws CloudException, InternalException {
        ArrayList<String> vlans = new ArrayList<String>();
        for (VLAN n : this.listDefaultNetworks(true, true)) {
            if (n == null) continue;
            vlans.add(n.getProviderVlanId());
        }
        for (VLAN n : this.listDefaultNetworks(false, true)) {
            if (n == null || vlans.contains(n.getProviderVlanId())) continue;
            vlans.add(n.getProviderVlanId());
        }
        return vlans;
    }

    @Nonnull
    public VLANCapabilities getCapabilities() throws InternalException, CloudException {
        if (this.capabilities == null) {
            this.capabilities = new CSVlanCapabilities(this.cloudstack);
        }
        return this.capabilities;
    }

    @Nonnull
    public Collection<NetworkOffering> getNetworkOfferings(@Nonnull String regionId) throws InternalException, CloudException {
        Collection offerings;
        Cache cache = null;
        if (regionId.equals(this.getContext().getRegionId()) && (offerings = (Collection)(cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"networkOfferings", NetworkOffering.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.HOUR))).get(this.getContext())) != null) {
            return offerings;
        }
        CSMethod method = new CSMethod(this.cloudstack);
        Document doc = method.get(method.buildUrl(LIST_NETWORK_OFFERINGS, new Param("zoneId", regionId)), LIST_NETWORK_OFFERINGS);
        NodeList matches = doc.getElementsByTagName("networkoffering");
        ArrayList<NetworkOffering> offerings2 = new ArrayList<NetworkOffering>();
        for (int i = 0; i < matches.getLength(); ++i) {
            Node node = matches.item(i);
            NodeList attributes = node.getChildNodes();
            NetworkOffering offering = new NetworkOffering();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node n = attributes.item(j);
                String value = n.getChildNodes().getLength() > 0 ? n.getFirstChild().getNodeValue() : null;
                if (n.getNodeName().equals("id") && value != null) {
                    offering.offeringId = value.trim();
                    continue;
                }
                if (n.getNodeName().equalsIgnoreCase("availability")) {
                    offering.availability = value == null ? "unavailable" : value.trim();
                    continue;
                }
                if (!n.getNodeName().equalsIgnoreCase("guestiptype")) continue;
                offering.networkType = value == null ? "direct" : value.trim();
            }
            offerings2.add(offering);
        }
        if (cache != null) {
            cache.put(this.getContext(), offerings2);
        }
        return offerings2;
    }

    @Nullable
    private String getNetworkOffering(@Nonnull String regionId) throws InternalException, CloudException {
        for (NetworkOffering offering : this.getNetworkOfferings(regionId)) {
            if (offering.availability.equalsIgnoreCase("unavailable") || !offering.networkType.equals("Isolated")) continue;
            return offering.offeringId;
        }
        return null;
    }

    @Nullable
    public VLAN getVlan(@Nonnull String vlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.getVlan");
        try {
            ProviderContext ctx = this.cloudstack.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            try {
                CSMethod method = new CSMethod(this.cloudstack);
                Document doc = method.get(method.buildUrl(LIST_NETWORKS, new Param("zoneId", ctx.getRegionId()), new Param("id", vlanId)), LIST_NETWORKS);
                NodeList matches = doc.getElementsByTagName("network");
                for (int i = 0; i < matches.getLength(); ++i) {
                    VLAN vlan;
                    Node node = matches.item(i);
                    if (node == null || (vlan = this.toNetwork(node, ctx)) == null) continue;
                    VLAN vLAN = vlan;
                    return vLAN;
                }
                VLAN vLAN = null;
                return vLAN;
            }
            catch (CSException e) {
                if (e.getHttpCode() == 431) {
                    VLAN vLAN = null;
                    return vLAN;
                }
                throw e;
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    public String getAttachedInternetGatewayId(@Nonnull String vlanId) throws CloudException, InternalException {
        return null;
    }

    @Nullable
    public InternetGateway getInternetGatewayById(@Nonnull String gatewayId) throws CloudException, InternalException {
        return null;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.isSubscribed");
        try {
            ProviderContext ctx = this.cloudstack.getContext();
            if (ctx == null) {
                throw new InternalException("No context was established");
            }
            CSMethod method = new CSMethod(this.cloudstack);
            try {
                method.get(method.buildUrl(LIST_NETWORKS, new Param("zoneId", ctx.getRegionId())), LIST_NETWORKS);
                boolean bl = true;
                return bl;
            }
            catch (CSException e) {
                block8: {
                    int code = e.getHttpCode();
                    if (code != 403 && code != 401 && code != 531) break block8;
                    boolean bl = false;
                    APITrace.end();
                    return bl;
                }
                throw e;
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<VLAN> listVlans() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.listVlans");
        try {
            ProviderContext ctx = this.cloudstack.getContext();
            if (ctx == null) {
                throw new InternalException("No context was established");
            }
            CSMethod method = new CSMethod(this.cloudstack);
            Document doc = method.get(method.buildUrl(LIST_NETWORKS, new Param("zoneId", ctx.getRegionId()), new Param("canusefordeploy", "true")), LIST_NETWORKS);
            ArrayList<VLAN> networks = new ArrayList<VLAN>();
            int numPages = 1;
            NodeList nodes = doc.getElementsByTagName("count");
            Node n = nodes.item(0);
            if (n != null) {
                String value = n.getFirstChild().getNodeValue().trim();
                int count = Integer.parseInt(value);
                numPages = count / 500;
                int remainder = count % 500;
                if (remainder > 0) {
                    ++numPages;
                }
            }
            for (int page = 1; page <= numPages; ++page) {
                if (page > 1) {
                    String nextPage = String.valueOf(page);
                    doc = method.get(method.buildUrl(LIST_NETWORKS, new Param("zoneId", ctx.getRegionId()), new Param("pagesize", "500"), new Param("page", nextPage), new Param("canusefordeploy", "true")), LIST_NETWORKS);
                }
                NodeList matches = doc.getElementsByTagName("network");
                for (int i = 0; i < matches.getLength(); ++i) {
                    VLAN vlan;
                    Node node = matches.item(i);
                    if (node == null || (vlan = this.toNetwork(node, ctx)) == null) continue;
                    networks.add(vlan);
                }
            }
            ArrayList<VLAN> arrayList = networks;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public void removeInternetGatewayById(@Nonnull String id) throws CloudException, InternalException {
    }

    @Nonnull
    public Iterable<VLAN> listDefaultNetworks(boolean shared, boolean forDeploy) throws CloudException, InternalException {
        ProviderContext ctx = this.cloudstack.getContext();
        if (ctx == null) {
            throw new InternalException("No context was set for this request");
        }
        CSMethod method = new CSMethod(this.cloudstack);
        Param[] params = !shared && forDeploy ? new Param[3] : (!shared || forDeploy ? new Param[2] : new Param[]{new Param("zoneId", ctx.getRegionId())});
        int idx = 1;
        if (forDeploy) {
            params[idx++] = new Param("canUseForDeploy", "true");
        }
        if (!shared) {
            params[idx] = new Param("account", ctx.getAccountNumber());
        }
        Document doc = method.get(method.buildUrl(LIST_NETWORKS, params), LIST_NETWORKS);
        ArrayList<VLAN> networks = new ArrayList<VLAN>();
        NodeList matches = doc.getElementsByTagName("network");
        for (int i = 0; i < matches.getLength(); ++i) {
            VLAN vlan;
            Node node = matches.item(i);
            if (node == null || (vlan = this.toNetwork(node, ctx)) == null || vlan.getTag("displaynetwork") != null && !vlan.getTag("displaynetwork").equals("true") || vlan.getTag("isdefault") != null && !vlan.getTag("isdefault").equals("true")) continue;
            networks.add(vlan);
        }
        return networks;
    }

    @Nonnull
    public VLAN createVlan(@Nonnull String cidr, @Nonnull String name, @Nonnull String description, @Nullable String domainName, @Nullable String[] dnsServers, @Nullable String[] ntpServers) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.createVlan");
        try {
            if (!this.getCapabilities().allowsNewVlanCreation()) {
                throw new OperationNotSupportedException();
            }
            ProviderContext ctx = this.cloudstack.getContext();
            if (ctx == null) {
                throw new InternalException("No context was set for this request");
            }
            String regionId = ctx.getRegionId();
            if (regionId == null) {
                throw new CloudException("No region was set for this request");
            }
            String offering = this.getNetworkOffering(regionId);
            if (offering == null) {
                throw new CloudException("No offerings exist for " + ctx.getRegionId());
            }
            String[] parts = cidr.split("/");
            String gateway = "";
            String netmask = "";
            if (parts.length == 1) {
                gateway = parts[0];
                netmask = "255.255.255.255";
            }
            if (parts.length == 2) {
                int mask;
                gateway = parts[0];
                netmask = parts[1];
                int prefix = Integer.parseInt(netmask);
                int value = mask = -1 << 32 - prefix;
                byte[] bytes = new byte[]{(byte)(value >>> 24), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
                try {
                    InetAddress netAddr = InetAddress.getByAddress(bytes);
                    netmask = netAddr.getHostAddress();
                }
                catch (UnknownHostException e) {
                    throw new InternalException("Unable to parse netmask from " + cidr);
                }
            }
            CSMethod method = new CSMethod(this.cloudstack);
            Document doc = parts.length > 0 ? method.get(method.buildUrl(CREATE_NETWORK, new Param("zoneId", ctx.getRegionId()), new Param("networkOfferingId", offering), new Param("name", name), new Param("displayText", name), new Param("gateway", gateway), new Param("netmask", netmask)), CREATE_NETWORK) : method.get(method.buildUrl(CREATE_NETWORK, new Param("zoneId", ctx.getRegionId()), new Param("networkOfferingId", offering), new Param("name", name), new Param("displayText", name)), CREATE_NETWORK);
            NodeList matches = doc.getElementsByTagName("network");
            for (int i = 0; i < matches.getLength(); ++i) {
                VLAN network;
                Node node = matches.item(i);
                if (node == null || (network = this.toNetwork(node, ctx)) == null) continue;
                try {
                    method.get(method.buildUrl(CREATE_EGRESS_RULE, new Param("protocol", "All"), new Param("cidrlist", "0.0.0.0/0"), new Param("networkid", network.getProviderVlanId())), CREATE_EGRESS_RULE);
                }
                catch (Throwable ignore) {
                    logger.warn((Object)"Unable to create default egress rule");
                }
                VLAN vLAN = network;
                return vLAN;
            }
            throw new CloudException("Creation requested failed to create a network without an error");
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    public VLAN toNetwork(@Nullable Node node, @Nonnull ProviderContext ctx) {
        if (node == null) {
            return null;
        }
        String netmask = null;
        VLAN network = new VLAN();
        String gateway = null;
        NodeList attributes = node.getChildNodes();
        network.setProviderOwnerId(ctx.getAccountNumber());
        network.setProviderRegionId(ctx.getRegionId());
        network.setCurrentState(VLANState.AVAILABLE);
        network.setSupportedTraffic(new IPVersion[]{IPVersion.IPV4});
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (name.equalsIgnoreCase("id")) {
                network.setProviderVlanId(value);
                continue;
            }
            if (name.equalsIgnoreCase("name")) {
                if (network.getName() != null) continue;
                network.setName(value);
                continue;
            }
            if (name.equalsIgnoreCase("displaytext")) {
                network.setName(value);
                continue;
            }
            if (name.equalsIgnoreCase("displaynetwork")) {
                network.setTag("displaynetwork", value);
                continue;
            }
            if (name.equalsIgnoreCase("isdefault")) {
                network.setTag("isdefault", value);
                continue;
            }
            if (name.equalsIgnoreCase("networkdomain")) {
                network.setDomainName(value);
                continue;
            }
            if (name.equalsIgnoreCase("zoneid") && value != null) {
                network.setProviderRegionId(value);
                continue;
            }
            if (name.startsWith("dns") && value != null && !value.trim().equals("")) {
                String[] dns;
                if (network.getDnsServers() != null) {
                    dns = new String[network.getDnsServers().length + 1];
                    for (int idx = 0; idx < network.getDnsServers().length; ++idx) {
                        dns[idx] = network.getDnsServers()[idx];
                    }
                    dns[dns.length - 1] = value;
                } else {
                    dns = new String[]{value};
                }
                network.setDnsServers(dns);
                continue;
            }
            if (name.equalsIgnoreCase("netmask")) {
                netmask = value;
                continue;
            }
            if (name.equals("gateway")) {
                gateway = value;
                continue;
            }
            if (name.equalsIgnoreCase("networkofferingdisplaytext")) {
                network.setNetworkType(value);
                continue;
            }
            if (!name.equalsIgnoreCase("account")) continue;
            network.setProviderOwnerId(value);
        }
        if (network.getProviderVlanId() == null) {
            return null;
        }
        network.setProviderDataCenterId(network.getProviderRegionId());
        if (network.getName() == null) {
            network.setName(network.getProviderVlanId());
        }
        if (network.getDescription() == null) {
            network.setDescription(network.getName());
        }
        if (gateway != null) {
            if (netmask == null) {
                netmask = "255.255.255.0";
            }
            network.setCidr(netmask, gateway);
        }
        return network;
    }

    @Nonnull
    public String getProviderTermForNetworkInterface(@Nonnull Locale locale) {
        return "NIC";
    }

    @Nonnull
    public String getProviderTermForSubnet(@Nonnull Locale locale) {
        return "network";
    }

    @Nonnull
    public String getProviderTermForVlan(@Nonnull Locale locale) {
        return "network";
    }

    @Nonnull
    public Collection<InternetGateway> listInternetGateways(@Nullable String vlanId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<Networkable> listResources(@Nonnull String inVlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.listResources");
        try {
            IpAddressSupport ipSupport;
            ArrayList<Networkable> resources = new ArrayList<Networkable>();
            CSNetworkServices network = this.cloudstack.getNetworkServices();
            FirewallSupport fwSupport = network.getFirewallSupport();
            if (fwSupport != null) {
                for (Firewall fw : fwSupport.list()) {
                    if (!inVlanId.equals(fw.getProviderVlanId())) continue;
                    resources.add((Networkable)fw);
                }
            }
            if ((ipSupport = network.getIpAddressSupport()) != null) {
                for (IPVersion version : ipSupport.getCapabilities().listSupportedIPVersions()) {
                    for (IpAddress addr : ipSupport.listIpPool(version, false)) {
                        if (!inVlanId.equals(addr.getProviderVlanId())) continue;
                        resources.add((Networkable)addr);
                    }
                }
            }
            for (RoutingTable table : this.listRoutingTables(inVlanId)) {
                resources.add((Networkable)table);
            }
            Iterable<VirtualMachine> vms = this.cloudstack.getComputeServices().getVirtualMachineSupport().listVirtualMachines();
            for (VirtualMachine vm : vms) {
                if (!inVlanId.equals(vm.getProviderVlanId())) continue;
                resources.add((Networkable)vm);
            }
            ArrayList<Networkable> arrayList = resources;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listVlanStatus() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.listVlanStatus");
        try {
            ProviderContext ctx = this.cloudstack.getContext();
            if (ctx == null) {
                throw new InternalException("No context was established");
            }
            CSMethod method = new CSMethod(this.cloudstack);
            Document doc = method.get(method.buildUrl(LIST_NETWORKS, new Param("zoneId", ctx.getRegionId()), new Param("canusefordeploy", "true")), LIST_NETWORKS);
            ArrayList<ResourceStatus> networks = new ArrayList<ResourceStatus>();
            int numPages = 1;
            NodeList nodes = doc.getElementsByTagName("count");
            Node n = nodes.item(0);
            if (n != null) {
                String value = n.getFirstChild().getNodeValue().trim();
                int count = Integer.parseInt(value);
                numPages = count / 500;
                int remainder = count % 500;
                if (remainder > 0) {
                    ++numPages;
                }
            }
            for (int page = 1; page <= numPages; ++page) {
                if (page > 1) {
                    String nextPage = String.valueOf(page);
                    doc = method.get(method.buildUrl(LIST_NETWORKS, new Param("zoneId", ctx.getRegionId()), new Param("pagesize", "500"), new Param("page", nextPage), new Param("canusefordeploy", "true")), LIST_NETWORKS);
                }
                NodeList matches = doc.getElementsByTagName("network");
                for (int i = 0; i < matches.getLength(); ++i) {
                    ResourceStatus vlan;
                    Node node = matches.item(i);
                    if (node == null || (vlan = this.toVLANStatus(node)) == null) continue;
                    networks.add(vlan);
                }
            }
            ArrayList<ResourceStatus> arrayList = networks;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVlan(String vlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.removeVlan");
        try {
            CSMethod method = new CSMethod(this.cloudstack);
            Document doc = method.get(method.buildUrl(DELETE_NETWORK, new Param("id", vlanId)), DELETE_NETWORK);
            this.cloudstack.waitForJob(doc, "Delete VLAN");
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    public ResourceStatus toVLANStatus(@Nullable Node node) {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        String networkId = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (!name.equalsIgnoreCase("id")) continue;
            networkId = value;
            break;
        }
        if (networkId == null) {
            return null;
        }
        return new ResourceStatus(networkId, (Object)VLANState.AVAILABLE);
    }

    public static class NetworkOffering {
        public String availability;
        public String networkType;
        public String offeringId;
    }
}

