/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSException;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.cloudstack.network.SecurityGroupCapabilities;
import org.dasein.cloud.network.AbstractFirewallSupport;
import org.dasein.cloud.network.Direction;
import org.dasein.cloud.network.Firewall;
import org.dasein.cloud.network.FirewallCapabilities;
import org.dasein.cloud.network.FirewallCreateOptions;
import org.dasein.cloud.network.FirewallRule;
import org.dasein.cloud.network.Permission;
import org.dasein.cloud.network.Protocol;
import org.dasein.cloud.network.RuleTarget;
import org.dasein.cloud.network.RuleTargetType;
import org.dasein.cloud.util.APITrace;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityGroup
extends AbstractFirewallSupport {
    private static final Logger logger = Logger.getLogger(SecurityGroup.class);
    public static final String AUTHORIZE_SECURITY_GROUP_EGRESS = "authorizeSecurityGroupEgress";
    public static final String AUTHORIZE_SECURITY_GROUP_INGRESS = "authorizeSecurityGroupIngress";
    public static final String CREATE_SECURITY_GROUP = "createSecurityGroup";
    public static final String DELETE_SECURITY_GROUP = "deleteSecurityGroup";
    public static final String LIST_SECURITY_GROUPS = "listSecurityGroups";
    public static final String REVOKE_SECURITY_GROUP_EGRESS = "revokeSecurityGroupEgress";
    public static final String REVOKE_SECURITY_GROUP_INGRESS = "revokeSecurityGroupIngress";
    private CSCloud cloudstack;
    private volatile transient SecurityGroupCapabilities capabilities;

    SecurityGroup(CSCloud cloudstack) {
        super((CloudProvider)cloudstack);
        this.cloudstack = cloudstack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String authorize(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull RuleTarget sourceEndpoint, @Nonnull Protocol protocol, @Nonnull RuleTarget destinationEndpoint, int beginPort, int endPort, @Nonnegative int precedence) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Firewall.authorize");
        try {
            boolean group;
            if (!permission.equals((Object)Permission.ALLOW)) {
                throw new OperationNotSupportedException("Only ALLOW rules are supported");
            }
            String sourceCidr = null;
            if (direction.equals((Object)Direction.INGRESS)) {
                group = sourceEndpoint.getRuleTargetType().equals((Object)RuleTargetType.GLOBAL);
                if (!group) {
                    sourceCidr = sourceEndpoint.getCidr();
                }
            } else {
                group = destinationEndpoint.getRuleTargetType().equals((Object)RuleTargetType.GLOBAL);
                if (!group) {
                    sourceCidr = destinationEndpoint.getCidr();
                }
            }
            if (sourceCidr != null && sourceCidr.indexOf(47) == -1) {
                sourceCidr = sourceCidr + "/32";
            }
            CSMethod method = new CSMethod(this.cloudstack);
            if (group) {
                throw new OperationNotSupportedException("Security group sources are not supported");
            }
            Param[] params = new Param[]{new Param("securitygroupid", firewallId), new Param("cidrlist", sourceCidr), new Param("startport", String.valueOf(beginPort)), new Param("endport", String.valueOf(endPort)), new Param("protocol", protocol.name())};
            Document doc = null;
            doc = direction.equals((Object)Direction.INGRESS) ? method.get(method.buildUrl(AUTHORIZE_SECURITY_GROUP_INGRESS, params), AUTHORIZE_SECURITY_GROUP_INGRESS) : method.get(method.buildUrl(AUTHORIZE_SECURITY_GROUP_EGRESS, params), AUTHORIZE_SECURITY_GROUP_EGRESS);
            this.cloudstack.waitForJob(doc, "Authorize rule");
            String id = this.getRuleId(firewallId, direction, permission, protocol, sourceEndpoint, destinationEndpoint, beginPort, endPort);
            if (id == null) {
                throw new CloudException("Unable to identify newly created firewall rule ID");
            }
            String string = id;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    private String getRuleId(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull Protocol protocol, @Nonnull RuleTarget sourceEndpoint, @Nonnull RuleTarget destinationEndpoint, int beginPort, int endPort) throws CloudException, InternalException {
        for (FirewallRule rule : this.getRules(firewallId)) {
            if (!rule.getDirection().equals((Object)direction) || !rule.getPermission().equals((Object)permission) || !rule.getProtocol().equals((Object)protocol) || !rule.getSourceEndpoint().getRuleTargetType().equals((Object)sourceEndpoint.getRuleTargetType()) || !rule.getDestinationEndpoint().getRuleTargetType().equals((Object)destinationEndpoint.getRuleTargetType()) || rule.getStartPort() != beginPort || rule.getEndPort() != endPort || !(rule.getSourceEndpoint().getRuleTargetType().equals((Object)RuleTargetType.CIDR) ? rule.getSourceEndpoint().getCidr().equals(sourceEndpoint.getCidr()) && (rule.getDestinationEndpoint().getRuleTargetType().equals((Object)RuleTargetType.CIDR) ? rule.getDestinationEndpoint().getCidr().equals(destinationEndpoint.getCidr()) : rule.getDestinationEndpoint().getRuleTargetType().equals((Object)RuleTargetType.GLOBAL) && rule.getDestinationEndpoint().getProviderFirewallId().equals(destinationEndpoint.getProviderFirewallId())) : rule.getSourceEndpoint().getRuleTargetType().equals((Object)RuleTargetType.GLOBAL) && rule.getSourceEndpoint().getProviderFirewallId().equals(sourceEndpoint.getProviderFirewallId()))) continue;
            return rule.getProviderRuleId();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String create(@Nonnull FirewallCreateOptions options) throws InternalException, CloudException {
        if (options.getProviderVlanId() != null) {
            throw new OperationNotSupportedException("No VLAN security groups are supported");
        }
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Firewall.create");
        try {
            Param[] params = new Param[]{new Param("name", options.getName()), new Param("description", options.getDescription())};
            CSMethod method = new CSMethod(this.cloudstack);
            Document doc = method.get(method.buildUrl(CREATE_SECURITY_GROUP, params), CREATE_SECURITY_GROUP);
            NodeList matches = doc.getElementsByTagName("id");
            String groupId = null;
            if (matches.getLength() > 0) {
                groupId = matches.item(0).getFirstChild().getNodeValue();
            }
            if (groupId == null) {
                throw new CloudException("Failed to create firewall");
            }
            String string = groupId;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(@Nonnull String firewallId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Firewall.delete");
        try {
            try {
                for (FirewallRule rule : this.getRules(firewallId)) {
                    try {
                        this.revoke(rule.getProviderRuleId());
                    }
                    catch (Throwable ignore) {}
                }
            }
            catch (Throwable ignore) {
                // empty catch block
            }
            CSMethod method = new CSMethod(this.cloudstack);
            method.get(method.buildUrl(DELETE_SECURITY_GROUP, new Param("id", firewallId)), DELETE_SECURITY_GROUP);
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public FirewallCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new SecurityGroupCapabilities(this.cloudstack);
        }
        return this.capabilities;
    }

    @Nullable
    public Firewall getFirewall(@Nonnull String firewallId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Firewall.getFirewall");
        try {
            ProviderContext ctx = this.cloudstack.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            CSMethod method = new CSMethod(this.cloudstack);
            try {
                Document doc = method.get(method.buildUrl(LIST_SECURITY_GROUPS, new Param("id", firewallId)), LIST_SECURITY_GROUPS);
                NodeList matches = doc.getElementsByTagName("securitygroup");
                for (int i = 0; i < matches.getLength(); ++i) {
                    Firewall fw;
                    Node node = matches.item(i);
                    if (node == null || (fw = this.toFirewall(node, ctx)) == null) continue;
                    Firewall firewall = fw;
                    return firewall;
                }
                Firewall firewall = null;
                return firewall;
            }
            catch (CSException e) {
                if (e.getHttpCode() == 431) {
                    Firewall firewall = null;
                    return firewall;
                }
                throw e;
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String getProviderTermForFirewall(@Nonnull Locale locale) {
        return "security group";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<FirewallRule> getRules(@Nonnull String firewallId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Firewall.getRules");
        try {
            CSMethod method = new CSMethod(this.cloudstack);
            Document doc = method.get(method.buildUrl(LIST_SECURITY_GROUPS, new Param("id", firewallId)), LIST_SECURITY_GROUPS);
            ArrayList<FirewallRule> rules = new ArrayList<FirewallRule>();
            int numPages = 1;
            NodeList nodes = doc.getElementsByTagName("count");
            Node n = nodes.item(0);
            if (n != null) {
                String value = n.getFirstChild().getNodeValue().trim();
                int count = Integer.parseInt(value);
                numPages = count / 500;
                int remainder = count % 500;
                if (remainder > 0) {
                    ++numPages;
                }
            }
            for (int page = 1; page <= numPages; ++page) {
                FirewallRule rule;
                Node node;
                int i;
                if (page > 1) {
                    String nextPage = String.valueOf(page);
                    doc = method.get(method.buildUrl(LIST_SECURITY_GROUPS, new Param("id", firewallId), new Param("pagesize", "500"), new Param("page", nextPage)), LIST_SECURITY_GROUPS);
                }
                NodeList matches = doc.getElementsByTagName("ingressrule");
                for (i = 0; i < matches.getLength(); ++i) {
                    node = matches.item(i);
                    if (node == null || (rule = this.toRule(firewallId, node, Direction.INGRESS)) == null) continue;
                    rules.add(rule);
                }
                matches = doc.getElementsByTagName("egressrule");
                for (i = 0; i < matches.getLength(); ++i) {
                    node = matches.item(i);
                    if (node == null || (rule = this.toRule(firewallId, node, Direction.EGRESS)) == null) continue;
                    rules.add(rule);
                }
            }
            ArrayList<FirewallRule> arrayList = rules;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Firewall.isSubscribed");
        try {
            ProviderContext ctx = this.cloudstack.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            String regionId = ctx.getRegionId();
            if (regionId == null) {
                throw new CloudException("No region was set for this request");
            }
            boolean bl = this.cloudstack.getDataCenterServices().supportsSecurityGroups(regionId, false);
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Collection<Firewall> list() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Firewall.list");
        try {
            ProviderContext ctx = this.cloudstack.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            CSMethod method = new CSMethod(this.cloudstack);
            Document doc = method.get(method.buildUrl(LIST_SECURITY_GROUPS, new Param[0]), LIST_SECURITY_GROUPS);
            ArrayList<Firewall> firewalls = new ArrayList<Firewall>();
            int numPages = 1;
            NodeList nodes = doc.getElementsByTagName("count");
            Node n = nodes.item(0);
            if (n != null) {
                String value = n.getFirstChild().getNodeValue().trim();
                int count = Integer.parseInt(value);
                numPages = count / 500;
                int remainder = count % 500;
                if (remainder > 0) {
                    ++numPages;
                }
            }
            for (int page = 1; page <= numPages; ++page) {
                if (page > 1) {
                    String nextPage = String.valueOf(page);
                    doc = method.get(method.buildUrl(LIST_SECURITY_GROUPS, new Param("pagesize", "500"), new Param("page", nextPage)), LIST_SECURITY_GROUPS);
                }
                NodeList matches = doc.getElementsByTagName("securitygroup");
                for (int i = 0; i < matches.getLength(); ++i) {
                    Firewall fw;
                    Node node = matches.item(i);
                    if (node == null || (fw = this.toFirewall(node, ctx)) == null) continue;
                    firewalls.add(fw);
                }
            }
            ArrayList<Firewall> arrayList = firewalls;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listFirewallStatus() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Firewall.listFirewallStatus");
        try {
            ProviderContext ctx = this.cloudstack.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            CSMethod method = new CSMethod(this.cloudstack);
            Document doc = method.get(method.buildUrl(LIST_SECURITY_GROUPS, new Param[0]), LIST_SECURITY_GROUPS);
            ArrayList<ResourceStatus> firewalls = new ArrayList<ResourceStatus>();
            int numPages = 1;
            NodeList nodes = doc.getElementsByTagName("count");
            Node n = nodes.item(0);
            if (n != null) {
                String value = n.getFirstChild().getNodeValue().trim();
                int count = Integer.parseInt(value);
                numPages = count / 500;
                int remainder = count % 500;
                if (remainder > 0) {
                    ++numPages;
                }
            }
            for (int page = 1; page <= numPages; ++page) {
                if (page > 1) {
                    String nextPage = String.valueOf(page);
                    doc = method.get(method.buildUrl(LIST_SECURITY_GROUPS, new Param("pagesize", "500"), new Param("page", nextPage)), LIST_SECURITY_GROUPS);
                }
                NodeList matches = doc.getElementsByTagName("securitygroup");
                for (int i = 0; i < matches.getLength(); ++i) {
                    ResourceStatus fw;
                    Node node = matches.item(i);
                    if (node == null || (fw = this.toStatus(node)) == null) continue;
                    firewalls.add(fw);
                }
            }
            ArrayList<ResourceStatus> arrayList = firewalls;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<RuleTargetType> listSupportedDestinationTypes(boolean inVlan) throws InternalException, CloudException {
        if (inVlan) {
            return Collections.emptyList();
        }
        return Collections.singletonList(RuleTargetType.GLOBAL);
    }

    @Nonnull
    public Iterable<Direction> listSupportedDirections(boolean inVlan) throws InternalException, CloudException {
        if (inVlan) {
            return Collections.emptyList();
        }
        ArrayList<Direction> directions = new ArrayList<Direction>();
        directions.add(Direction.INGRESS);
        directions.add(Direction.EGRESS);
        return directions;
    }

    @Nonnull
    public Iterable<Permission> listSupportedPermissions(boolean inVlan) throws InternalException, CloudException {
        if (inVlan) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Permission.ALLOW);
    }

    @Nonnull
    public Iterable<RuleTargetType> listSupportedSourceTypes(boolean inVlan) throws InternalException, CloudException {
        if (inVlan) {
            return Collections.emptyList();
        }
        return Collections.singletonList(RuleTargetType.CIDR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revoke(@Nonnull String providerFirewallRuleId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Firewall.revoke");
        try {
            FirewallRule target = null;
            for (Firewall fw : this.list()) {
                for (FirewallRule rule : this.getRules(fw.getProviderFirewallId())) {
                    if (!rule.getProviderRuleId().equals(providerFirewallRuleId)) continue;
                    target = rule;
                    break;
                }
                if (target == null) continue;
                break;
            }
            if (target == null) {
                return;
            }
            Param[] params = new Param[]{new Param("id", providerFirewallRuleId)};
            CSMethod method = new CSMethod(this.cloudstack);
            if (Direction.EGRESS.equals((Object)target.getDirection())) {
                method.get(method.buildUrl(REVOKE_SECURITY_GROUP_EGRESS, params), REVOKE_SECURITY_GROUP_EGRESS);
            } else {
                method.get(method.buildUrl(REVOKE_SECURITY_GROUP_INGRESS, params), REVOKE_SECURITY_GROUP_INGRESS);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<String> listFirewallsForVM(@Nonnull String vmId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Firewall.listFirewallsForVM");
        try {
            ProviderContext ctx = this.cloudstack.getContext();
            if (ctx == null) {
                throw new CloudException("No context was set for this request");
            }
            CSMethod method = new CSMethod(this.cloudstack);
            Document doc = method.get(method.buildUrl(LIST_SECURITY_GROUPS, new Param("virtualmachineId", vmId)), LIST_SECURITY_GROUPS);
            ArrayList<String> firewalls = new ArrayList<String>();
            int numPages = 1;
            NodeList nodes = doc.getElementsByTagName("count");
            Node n = nodes.item(0);
            if (n != null) {
                String value = n.getFirstChild().getNodeValue().trim();
                int count = Integer.parseInt(value);
                numPages = count / 500;
                int remainder = count % 500;
                if (remainder > 0) {
                    ++numPages;
                }
            }
            for (int page = 1; page <= numPages; ++page) {
                if (page > 1) {
                    String nextPage = String.valueOf(page);
                    doc = method.get(method.buildUrl(LIST_SECURITY_GROUPS, new Param("virtualmachineId", vmId), new Param("pagesize", "500"), new Param("page", nextPage)), LIST_SECURITY_GROUPS);
                }
                NodeList matches = doc.getElementsByTagName("securitygroup");
                for (int i = 0; i < matches.getLength(); ++i) {
                    Firewall fw;
                    Node node = matches.item(i);
                    if (node == null || (fw = this.toFirewall(node, ctx)) == null) continue;
                    firewalls.add(fw.getProviderFirewallId());
                }
            }
            ArrayList<String> arrayList = firewalls;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public void revoke(@Nonnull String firewallId, @Nonnull String cidr, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        this.revoke(firewallId, Direction.INGRESS, Permission.ALLOW, cidr, protocol, RuleTarget.getGlobal((String)firewallId), beginPort, endPort);
    }

    public void revoke(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull String cidr, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        this.revoke(firewallId, direction, Permission.ALLOW, cidr, protocol, RuleTarget.getGlobal((String)firewallId), beginPort, endPort);
    }

    public void revoke(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull String source, @Nonnull Protocol protocol, int beginPort, int endPort) throws CloudException, InternalException {
        this.revoke(firewallId, direction, permission, source, protocol, RuleTarget.getGlobal((String)firewallId), beginPort, endPort);
    }

    public void revoke(@Nonnull String firewallId, @Nonnull Direction direction, @Nonnull Permission permission, @Nonnull String source, @Nonnull Protocol protocol, @Nonnull RuleTarget target, int beginPort, int endPort) throws CloudException, InternalException {
        RuleTarget destinationEndpoint;
        RuleTarget sourceEndpoint;
        if (!Permission.ALLOW.equals((Object)permission)) {
            throw new OperationNotSupportedException("Only ALLOW rules are supported");
        }
        if (direction.equals((Object)Direction.INGRESS)) {
            sourceEndpoint = RuleTarget.getCIDR((String)source);
            destinationEndpoint = target;
        } else {
            sourceEndpoint = target;
            destinationEndpoint = RuleTarget.getCIDR((String)source);
        }
        String ruleId = this.getRuleId(firewallId, direction, permission, protocol, sourceEndpoint, destinationEndpoint, beginPort, endPort);
        if (ruleId == null) {
            logger.warn((Object)("No such rule for " + firewallId + ": " + direction + "/" + permission + "/" + source + "/" + protocol + "/" + beginPort + "/" + endPort));
            return;
        }
        this.revoke(ruleId);
    }

    public boolean supportsFirewallSources() throws CloudException, InternalException {
        return false;
    }

    @Nullable
    private Firewall toFirewall(@Nullable Node node, @Nonnull ProviderContext ctx) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        String regionId = ctx.getRegionId();
        if (regionId == null) {
            throw new CloudException("No region was specified for this request");
        }
        NodeList attributes = node.getChildNodes();
        Firewall firewall = new Firewall();
        firewall.setActive(true);
        firewall.setAvailable(true);
        firewall.setRegionId(regionId);
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (name.equalsIgnoreCase("id") && value != null) {
                firewall.setProviderFirewallId(value);
                continue;
            }
            if (name.equalsIgnoreCase("description") && value != null) {
                firewall.setDescription(value);
                continue;
            }
            if (!name.equalsIgnoreCase("name") || value == null) continue;
            firewall.setName(value);
        }
        if (firewall.getProviderFirewallId() == null) {
            logger.warn((Object)("Discovered firewall " + firewall.getProviderFirewallId() + " with an empty firewall ID"));
            return null;
        }
        String id = firewall.getProviderFirewallId();
        if (id == null) {
            return null;
        }
        String name = firewall.getName();
        if (name == null) {
            name = id;
            firewall.setName(name);
        }
        if (firewall.getDescription() == null) {
            firewall.setDescription(name);
        }
        return firewall;
    }

    private FirewallRule toRule(String firewallId, Node node, Direction direction) {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        int startPort = -1;
        int endPort = -1;
        Protocol protocol = Protocol.TCP;
        String source = "0.0.0.0/0";
        String ruleId = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (name.equalsIgnoreCase("cidr") && value != null) {
                source = value;
                continue;
            }
            if (name.equalsIgnoreCase("endport") && value != null) {
                endPort = Integer.parseInt(value);
                continue;
            }
            if (name.equalsIgnoreCase("startport") && value != null) {
                startPort = Integer.parseInt(value);
                continue;
            }
            if (name.equalsIgnoreCase("protocol") && value != null) {
                protocol = Protocol.valueOf((String)value.toUpperCase());
                continue;
            }
            if (!name.equalsIgnoreCase("ruleId") || value == null) continue;
            ruleId = value;
        }
        if (!(startPort != -1 && endPort != -1 || startPort == -1 && endPort == -1)) {
            if (startPort == -1) {
                startPort = endPort;
            } else {
                endPort = startPort;
            }
        }
        if (direction.equals((Object)Direction.INGRESS)) {
            return FirewallRule.getInstance(ruleId, (String)firewallId, (RuleTarget)RuleTarget.getCIDR((String)source), (Direction)direction, (Protocol)protocol, (Permission)Permission.ALLOW, (RuleTarget)RuleTarget.getGlobal((String)firewallId), (int)startPort, (int)endPort);
        }
        return FirewallRule.getInstance(ruleId, (String)firewallId, (RuleTarget)RuleTarget.getGlobal((String)firewallId), (Direction)direction, (Protocol)protocol, (Permission)Permission.ALLOW, (RuleTarget)RuleTarget.getCIDR((String)source), (int)startPort, (int)endPort);
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (!name.equalsIgnoreCase("id") || value == null) continue;
            return new ResourceStatus(value, (Object)true);
        }
        return null;
    }
}

