/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack;

import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.AbstractCloud;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.ContextRequirements;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Tag;
import org.dasein.cloud.cloudstack.CSException;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.CSServiceProvider;
import org.dasein.cloud.cloudstack.CSTopology;
import org.dasein.cloud.cloudstack.CSVersion;
import org.dasein.cloud.cloudstack.Iterables;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.cloudstack.compute.CSComputeServices;
import org.dasein.cloud.cloudstack.identity.CSIdentityServices;
import org.dasein.cloud.cloudstack.network.CSNetworkServices;
import org.dasein.cloud.storage.BlobStoreSupport;
import org.dasein.cloud.storage.StorageServices;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CSCloud
extends AbstractCloud {
    private static final Logger logger = CSCloud.getLogger(CSCloud.class, "std");
    public static final String LIST_ACCOUNTS = "listAccounts";
    private static final String LIST_HYPERVISORS = "listHypervisors";
    private static final String LIST_TAGS = "listTags";
    private static final String CREATE_TAGS = "createTags";
    private static final String DELETE_TAGS = "deleteTags";
    private transient CSServiceProvider serviceProvider;
    private transient String versionString;
    private transient CSVersion version;

    @Nonnull
    private static String getLastItem(@Nonnull String name) {
        int idx = name.lastIndexOf(46);
        if (idx < 0) {
            return name;
        }
        if (idx == name.length() - 1) {
            return "";
        }
        return name.substring(idx + 1);
    }

    @Nonnull
    public static Logger getLogger(@Nonnull Class<?> cls, @Nonnull String type) {
        String pkg = CSCloud.getLastItem(cls.getPackage().getName());
        pkg = pkg.equals("cloudstack") ? "" : pkg + ".";
        return Logger.getLogger((String)("dasein.cloud.cloudstack." + type + "." + pkg + CSCloud.getLastItem(cls.getName())));
    }

    @Nonnull
    public String getCloudName() {
        ProviderContext ctx = this.getContext();
        if (ctx == null) {
            return "CloudStack";
        }
        String name = ctx.getCloudName();
        if (name == null) {
            return "CloudStack";
        }
        return name;
    }

    @Nonnull
    public ContextRequirements getContextRequirements() {
        return new ContextRequirements(new ContextRequirements.Field[]{new ContextRequirements.Field("apiKey", "The API Keypair", ContextRequirements.FieldType.KEYPAIR, "accessKeys", true)});
    }

    @Nonnull
    public CSComputeServices getComputeServices() {
        return new CSComputeServices(this);
    }

    @Nonnull
    public CSTopology getDataCenterServices() {
        return new CSTopology(this);
    }

    @Nullable
    public CSIdentityServices getIdentityServices() {
        if (this.getVersion().greaterThan(CSVersion.CS21)) {
            return new CSIdentityServices(this);
        }
        return null;
    }

    @Nonnull
    public CSNetworkServices getNetworkServices() {
        return new CSNetworkServices(this);
    }

    @Nonnull
    public String getProviderName() {
        ProviderContext ctx = this.getContext();
        if (ctx == null) {
            return "Citrix";
        }
        String name = ctx.getProviderName();
        if (name == null) {
            return "Citrix";
        }
        return name;
    }

    public CSServiceProvider getServiceProvider() {
        if (this.serviceProvider == null) {
            String pn = this.getProviderName();
            this.serviceProvider = "kt".equalsIgnoreCase(pn) ? CSServiceProvider.KT : ("datapipe".equalsIgnoreCase(pn) ? CSServiceProvider.DATAPIPE : ("tata".equalsIgnoreCase(pn) ? CSServiceProvider.TATA : ("democloud".equalsIgnoreCase(pn) ? CSServiceProvider.DEMOCLOUD : CSServiceProvider.INTERNAL)));
        }
        return this.serviceProvider;
    }

    @Nonnull
    public String getVersionString() throws CloudException {
        APITrace.begin((CloudProvider)this, (String)"CSCloud.getVersionString");
        if (this.versionString == null) {
            try {
                CSMethod method = new CSMethod(this);
                Document doc = method.get("listZones", new Param("available", "true"));
                NodeList meta = doc.getElementsByTagName("listzonesresponse");
                for (int item = 0; item < meta.getLength(); ++item) {
                    Node node = meta.item(item);
                    this.versionString = node.getAttributes().getNamedItem("cloud-stack-version").getNodeValue();
                }
            }
            catch (Throwable e) {
                throw new CloudException("Unable to get CloudStack version for " + this.getCloudName(), e);
            }
            finally {
                APITrace.end();
            }
        }
        return this.versionString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public CSVersion getVersion() {
        APITrace.begin((CloudProvider)this, (String)"CSCloud.getVersion");
        if (this.version == null) {
            Properties properties;
            ProviderContext ctx = this.getContext();
            Properties properties2 = properties = ctx == null ? null : ctx.getCustomProperties();
            if (properties == null || properties.getProperty("apiVersion") == null || properties.getProperty("apiVersion").equals("")) {
                try {
                    CSMethod method = new CSMethod(this);
                    Document doc = method.get("listZones", new Param("available", "true"));
                    NodeList meta = doc.getElementsByTagName("listzonesresponse");
                    for (int item = 0; item < meta.getLength(); ++item) {
                        Node node = meta.item(item);
                        String v = node.getAttributes().getNamedItem("cloud-stack-version").getNodeValue();
                        if (!v.startsWith("4")) continue;
                        if (properties == null) {
                            properties = new Properties();
                        }
                        properties.setProperty("apiVersion", "CS4");
                        logger.info((Object)("Version property not found so setting based on result of query: " + v));
                        CSVersion cSVersion = this.version = CSVersion.CS4;
                        return cSVersion;
                    }
                }
                catch (Throwable method) {
                }
                finally {
                    APITrace.end();
                }
            }
            String versionString = properties == null ? "CS3" : properties.getProperty("apiVersion", "CS3");
            try {
                this.version = CSVersion.valueOf(versionString);
            }
            catch (Throwable t) {
                this.version = CSVersion.CS3;
            }
        }
        return this.version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this, (String)"CSCloud.isSubscribed");
        try {
            String ctxKey;
            NodeList matches;
            CSMethod method = new CSMethod(this);
            try {
                Document doc = method.get(LIST_ACCOUNTS, new Param[0]);
                matches = doc.getElementsByTagName("user");
                if (matches.getLength() < 1) {
                    boolean bl = false;
                    return bl;
                }
                ctxKey = null;
            }
            catch (CSException e) {
                int code = e.getHttpCode();
                if (code != 403 && code != 401) {
                    if (code != 531) throw e;
                }
                boolean bl2 = false;
                return bl2;
            }
            catch (CloudException e) {
                int code = e.getHttpCode();
                if (code != 403) {
                    if (code != 401) throw e;
                }
                boolean bl3 = false;
                return bl3;
            }
            try {
                List fields = this.getContextRequirements().getConfigurableValues();
                for (ContextRequirements.Field f : fields) {
                    if (!f.type.equals((Object)ContextRequirements.FieldType.KEYPAIR)) continue;
                    byte[][] keyPair = (byte[][])this.getContext().getConfigurationValue(f);
                    ctxKey = new String(keyPair[0], "utf-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                throw new RuntimeException("This cannot happen: " + e.getMessage(), e);
            }
            int i = 0;
            while (true) {
                if (i >= matches.getLength()) {
                    logger.debug((Object)"No match to api key found");
                    boolean bl = false;
                    return bl;
                }
                boolean found = false;
                String account = null;
                Node node = matches.item(i);
                NodeList attributes = node.getChildNodes();
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Node attribute = attributes.item(j);
                    String name = attribute.getNodeName().toLowerCase();
                    String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
                    if (name.equals("apikey")) {
                        if (!value.equals(ctxKey)) continue;
                        found = true;
                        continue;
                    }
                    if (!name.equals("account")) continue;
                    account = value;
                }
                if (found) {
                    if (!this.getContext().getAccountNumber().equals(account)) {
                        this.getContext().setAccountNumber(account);
                    }
                    boolean bl = true;
                    return bl;
                }
                ++i;
            }
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnegative
    public long parseTime(@Nonnull String timestamp) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        try {
            return df.parse(timestamp).getTime();
        }
        catch (ParseException e) {
            df = new SimpleDateFormat("EEE MMM dd HH:mm:ss z yyyy");
            try {
                return df.parse(timestamp).getTime();
            }
            catch (ParseException another) {
                return 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String testContext() {
        String string;
        APITrace.begin((CloudProvider)this, (String)"testContext");
        try {
            ProviderContext ctx = this.getContext();
            if (ctx == null) {
                String string2 = null;
                return string2;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"testContext(): Checking CSCloud compute credentials");
            }
            if (!this.isSubscribed()) {
                logger.warn((Object)"testContext(): CSCloud compute credentials are not subscribed for VM services");
                String string3 = null;
                return string3;
            }
            if (this.hasStorageServices()) {
                BlobStoreSupport support;
                StorageServices services;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("testContext(): Checking " + ctx.getStorage() + " storage credentials"));
                }
                if ((services = this.getStorageServices()) != null && services.hasOnlineStorageSupport() && (support = services.getOnlineStorageSupport()) != null) {
                    try {
                        support.list(null).iterator().hasNext();
                    }
                    catch (Throwable t) {
                        logger.warn((Object)("testContext(): Storage credentials failed: " + t.getMessage()));
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"textContext(): Storage credentials failed: ", t);
                        }
                        String string4 = null;
                        APITrace.end();
                        return string4;
                    }
                }
            }
            if (logger.isInfoEnabled()) {
                logger.info((Object)"testContext(): Credentials validated");
            }
            string = ctx.getAccountNumber();
            return string;
        }
        catch (Throwable t) {
            logger.warn((Object)("testContext(): Failed to test cloudstack context: " + t.getMessage()));
            t.printStackTrace();
            string = null;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    public Document waitForJob(Document doc, String jobName) throws CloudException, InternalException {
        NodeList matches = doc.getElementsByTagName("jobid");
        if (matches.getLength() > 0) {
            return this.waitForJob(matches.item(0).getFirstChild().getNodeValue(), jobName);
        }
        return null;
    }

    public Document waitForJob(String jobId, String jobName) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this, (String)"waitForJob");
        try {
            int code;
            NodeList matches;
            Document doc;
            CSMethod method = new CSMethod(this);
            while (true) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                doc = method.get("queryAsyncJobResult", new Param("jobId", jobId));
                matches = doc.getElementsByTagName("jobstatus");
                int status = 0;
                if (matches.getLength() > 0) {
                    status = Integer.parseInt(matches.item(0).getFirstChild().getNodeValue());
                }
                if (status <= 0) continue;
                code = status;
                if (status == 1) {
                    Document document = doc;
                    return document;
                }
                if (status == 2) break;
            }
            matches = doc.getElementsByTagName("jobresult");
            if (matches.getLength() > 0) {
                String str = matches.item(0).getFirstChild().getNodeValue();
                if (str == null || str.trim().length() < 1) {
                    NodeList nodes = matches.item(0).getChildNodes();
                    String message = null;
                    for (int i = 0; i < nodes.getLength(); ++i) {
                        Node n = nodes.item(i);
                        if (n.getNodeName().equalsIgnoreCase("errorcode")) {
                            try {
                                code = Integer.parseInt(n.getFirstChild().getNodeValue().trim());
                            }
                            catch (NumberFormatException numberFormatException) {}
                            continue;
                        }
                        if (!n.getNodeName().equalsIgnoreCase("errortext")) continue;
                        message = n.getFirstChild().getNodeValue().trim();
                    }
                    CSMethod.ParsedError error = new CSMethod.ParsedError();
                    error.code = code;
                    error.message = message;
                    throw new CSException(error);
                }
                throw new CloudException(str);
            }
            throw new CloudException(jobName + " failed with an unexplained error.");
        }
        finally {
            APITrace.end();
        }
    }

    public String getParentAccount() throws CloudException, InternalException {
        return this.getUserAccountData().getParentAccount();
    }

    public String getDomainId() throws CloudException, InternalException {
        return this.getUserAccountData().getDomainId();
    }

    public String getAccountId() throws CloudException, InternalException {
        return this.getUserAccountData().getAccountId();
    }

    public boolean isAdminAccount() throws CloudException, InternalException {
        return this.getUserAccountData().isAdmin();
    }

    public boolean hasApi(@Nullable String callName) throws CloudException, InternalException {
        Cache cache = Cache.getInstance((CloudProvider)this, (String)("api." + callName), Boolean.class, (CacheLevel)CacheLevel.CLOUD_ACCOUNT, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.DAY));
        Iterable cachedValues = cache.get(this.getContext());
        if (cachedValues != null && cachedValues.iterator().hasNext()) {
            return (Boolean)cachedValues.iterator().next();
        }
        APITrace.begin((CloudProvider)this, (String)"getApis");
        try {
            new CSMethod(this).get("listApis", new Param("name", callName));
            cache.put(this.getContext(), Collections.singleton(Boolean.TRUE));
            boolean bl = true;
            return bl;
        }
        catch (CSException e) {
            if (e.getHttpCode() == 530) {
                cache.put(this.getContext(), Collections.singleton(Boolean.FALSE));
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    private AccountData getUserAccountData() throws CloudException, InternalException {
        AccountData data = null;
        Cache cache = Cache.getInstance((CloudProvider)this, (String)"account", AccountData.class, (CacheLevel)CacheLevel.CLOUD_ACCOUNT, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.DAY));
        Iterable cachedValues = cache.get(this.getContext());
        if (cachedValues != null && cachedValues.iterator().hasNext()) {
            data = (AccountData)cachedValues.iterator().next();
        }
        if (data != null) {
            return data;
        }
        APITrace.begin((CloudProvider)this, (String)"getUserAccountData");
        try {
            Document doc = new CSMethod(this).get(LIST_ACCOUNTS, new Param[0]);
            String ctxKey = null;
            List fields = this.getContextRequirements().getConfigurableValues();
            for (ContextRequirements.Field f : fields) {
                if (!f.type.equals((Object)ContextRequirements.FieldType.KEYPAIR)) continue;
                byte[][] keyPair = (byte[][])this.getContext().getConfigurationValue(f);
                ctxKey = new String(keyPair[0], "utf-8");
            }
            NodeList matches = doc.getElementsByTagName("user");
            for (int i = 0; i < matches.getLength(); ++i) {
                boolean userAccountFound = false;
                String accountName = null;
                String domainId = null;
                String accountId = null;
                String username = null;
                int accountType = 0;
                NodeList attributes = matches.item(i).getChildNodes();
                for (int j = 0; j < attributes.getLength(); ++j) {
                    Node attribute = attributes.item(j);
                    String name = attribute.getNodeName().toLowerCase();
                    String value = attribute.hasChildNodes() && attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
                    if (name.equalsIgnoreCase("username")) {
                        username = value;
                        continue;
                    }
                    if (name.equalsIgnoreCase("apikey") && ctxKey.equals(value)) {
                        userAccountFound = true;
                        continue;
                    }
                    if (name.equalsIgnoreCase("account")) {
                        accountName = value;
                        continue;
                    }
                    if (name.equalsIgnoreCase("domainid")) {
                        domainId = value;
                        continue;
                    }
                    if ("accountid".equalsIgnoreCase(name)) {
                        accountId = value;
                        continue;
                    }
                    if (!"accounttype".equalsIgnoreCase(name)) continue;
                    accountType = Integer.parseInt(value);
                }
                if (!userAccountFound) continue;
                data = new AccountData(username, accountId, accountName, domainId, accountType > 0);
                break;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("This cannot happen: " + e.getMessage(), e);
        }
        finally {
            APITrace.end();
        }
        if (data == null) {
            throw new InternalException("Unable to find user account for name " + this.getContext().getAccountNumber());
        }
        cache.put(this.getContext(), Arrays.asList(data));
        return data;
    }

    public static String getTextValue(Node node) {
        if (node.getChildNodes().getLength() == 0) {
            return null;
        }
        return node.getFirstChild().getNodeValue();
    }

    public static boolean getBooleanValue(Node node) {
        return Boolean.valueOf(CSCloud.getTextValue(node));
    }

    @Nonnull
    public List<String> getZoneHypervisors(String regionId) throws CloudException, InternalException {
        ProviderContext ctx = this.getContext();
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        String cacheName = "hypervisorCache";
        Cache hypervisorCache = Cache.getInstance((CloudProvider)this, (String)cacheName, String.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.DAY));
        List<String> zoneHypervisors = Iterables.toList(hypervisorCache.get(ctx));
        if (zoneHypervisors != null) {
            return zoneHypervisors;
        }
        Document doc = new CSMethod(this).get(LIST_HYPERVISORS, new Param("zoneid", ctx.getRegionId()));
        NodeList nodes = doc.getElementsByTagName("name");
        zoneHypervisors = new ArrayList<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item = nodes.item(i);
            zoneHypervisors.add(item.getFirstChild().getNodeValue().trim());
        }
        hypervisorCache.put(ctx, zoneHypervisors);
        return zoneHypervisors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public void createTags(@Nonnull String[] resIds, @Nonnull String resourceType, Tag ... keyValuePairs) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this, (String)"Cloud.createTags");
        try {
            try {
                String resourceIds = "";
                for (String resId : resIds) {
                    resourceIds = resourceIds + resId + ",";
                }
                if (resourceIds.endsWith(",")) {
                    resourceIds = resourceIds.substring(0, resourceIds.length() - 1);
                }
                ArrayList<Param> params = new ArrayList<Param>();
                params.add(new Param("resourceids", resourceIds));
                params.add(new Param("resourcetype", resourceType));
                for (int i = 0; i < keyValuePairs.length; ++i) {
                    if (keyValuePairs[i].getValue() == null || keyValuePairs[i].getValue().equals("")) continue;
                    params.add(new Param("tags[" + i + "].key", keyValuePairs[i].getKey()));
                    params.add(new Param("tags[" + i + "].value", keyValuePairs[i].getValue()));
                }
                Document doc = new CSMethod(this).get(CREATE_TAGS, params);
                this.waitForJob(doc, "Create Tags");
            }
            catch (CloudException e) {
                logger.error((Object)("Error while creating tags for " + resourceType + " - "), (Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public void updateTags(@Nonnull String[] resIds, String resourceType, Tag ... keyValuePairs) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this, (String)"Cloud.updateTags");
        try {
            try {
                for (String resId : resIds) {
                    Tag[] tagList = this.getTags(resId);
                    if (tagList.length <= 0) continue;
                    ArrayList<Tag> tags = new ArrayList<Tag>();
                    for (int i = 0; i < keyValuePairs.length; ++i) {
                        for (int k = 0; k < tagList.length; ++k) {
                            if (!keyValuePairs[i].getKey().equals(tagList[k].getKey()) || tagList[k].getValue() == null) continue;
                            tags.add(new Tag(tagList[k].getKey(), tagList[k].getValue()));
                        }
                    }
                    if (tags.size() <= 0) continue;
                    this.removeTags(new String[]{resId}, resourceType, tags.toArray(new Tag[tags.size()]));
                }
                this.createTags(resIds, resourceType, keyValuePairs);
            }
            catch (CloudException e) {
                logger.error((Object)("Error while updating tags for " + resourceType + " - "), (Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public void removeTags(@Nonnull String[] vmIds, String resourceType, Tag ... keyValuePairs) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this, (String)"Cloud.removeTags");
        try {
            String resourceIds = "";
            try {
                for (String vmId : vmIds) {
                    resourceIds = resourceIds + vmId + ",";
                }
                if (resourceIds.endsWith(",")) {
                    resourceIds = resourceIds.substring(0, resourceIds.length() - 1);
                }
                ArrayList<Param> params = new ArrayList<Param>();
                params.add(new Param("resourceids", resourceIds));
                params.add(new Param("resourcetype", resourceType));
                for (int i = 0; i < keyValuePairs.length; ++i) {
                    if (keyValuePairs[i].getValue() == null || keyValuePairs[i].getValue().equals("")) continue;
                    params.add(new Param("tags[" + i + "].key", keyValuePairs[i].getKey()));
                    params.add(new Param("tags[" + i + "].value", keyValuePairs[i].getValue()));
                }
                Document doc = new CSMethod(this).get(DELETE_TAGS, params);
                this.waitForJob(doc, "Delete Tags");
            }
            catch (CloudException e) {
                logger.error((Object)("Error while removing tags for " + resourceType + " - "), (Throwable)e);
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Tag[] getTags(@Nonnull String resourceId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this, (String)"Cloud.listTags");
        try {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            try {
                Document doc = new CSMethod(this).get(LIST_TAGS, new Param("resourceid", resourceId));
                NodeList matches = doc.getElementsByTagName("tag");
                if (matches.getLength() > 0) {
                    for (int i = 0; i < matches.getLength(); ++i) {
                        tags.add(new Tag(matches.item(i).getChildNodes().item(0).getTextContent(), matches.item(i).getChildNodes().item(1).getTextContent()));
                    }
                }
            }
            catch (CloudException e) {
                logger.error((Object)("Error while listing the tags for - " + resourceId + "."), (Throwable)e);
            }
            Tag[] tagArray = tags.toArray(new Tag[tags.size()]);
            return tagArray;
        }
        finally {
            APITrace.end();
        }
    }

    public class AccountData {
        private String accountId;
        private String parentAccount;
        private String username;
        private String domainId;
        private boolean admin;

        public AccountData(String username, String accountId, String parentAccount, String domainId, boolean admin) {
            this.username = username;
            this.accountId = accountId;
            this.parentAccount = parentAccount;
            this.domainId = domainId;
            this.admin = admin;
        }

        public String getAccountId() {
            return this.accountId;
        }

        public String getParentAccount() {
            return this.parentAccount;
        }

        public String getDomainId() {
            return this.domainId;
        }

        public boolean isAdmin() {
            return this.admin;
        }

        public String getUsername() {
            return this.username;
        }
    }
}

