/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.SignatureException;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudErrorType;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.ContextRequirements;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSException;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.util.APITrace;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class CSMethod {
    public static final String CREATE_KEYPAIR = "createSSHKeyPair";
    public static final String DELETE_KEYPAIR = "deleteSSHKeyPair";
    public static final String LIST_KEYPAIRS = "listSSHKeyPairs";
    private CSCloud provider;

    public CSMethod(@Nonnull CSCloud provider) {
        this.provider = provider;
    }

    private String buildUrl(String command, Param ... params) throws CloudException, InternalException {
        ProviderContext ctx = this.provider.getContext();
        String apiShared = "";
        String apiSecret = "";
        try {
            List fields = this.provider.getContextRequirements().getConfigurableValues();
            for (ContextRequirements.Field f : fields) {
                if (!f.type.equals((Object)ContextRequirements.FieldType.KEYPAIR)) continue;
                byte[][] keyPair = (byte[][])ctx.getConfigurationValue(f);
                apiShared = new String(keyPair[0], "utf-8");
                apiSecret = new String(keyPair[1], "utf-8");
            }
        }
        catch (UnsupportedEncodingException fields) {
            // empty catch block
        }
        if (ctx == null) {
            throw new CloudException("No context was set for this request");
        }
        try {
            char c;
            int i;
            StringBuilder str = new StringBuilder();
            String apiKey = apiShared;
            String accessKey = apiSecret;
            StringBuilder newKey = new StringBuilder();
            for (i = 0; i < apiKey.length(); ++i) {
                c = apiKey.charAt(i);
                if (c == '\r') continue;
                newKey.append(c);
            }
            apiKey = newKey.toString();
            newKey = new StringBuilder();
            for (i = 0; i < accessKey.length(); ++i) {
                c = accessKey.charAt(i);
                if (c == '\r') continue;
                newKey.append(c);
            }
            accessKey = newKey.toString();
            str.append(ctx.getCloud().getEndpoint());
            while (str.lastIndexOf("/") == str.length() - 1) {
                str.deleteCharAt(str.length() - 1);
            }
            if (!str.toString().endsWith("/api")) {
                str.append("/api");
            }
            str.append("?command=");
            str.append(command);
            for (Param param : params) {
                str.append("&");
                str.append((String)param.getKey());
                if (param.getValue() == null) continue;
                str.append("=");
                str.append(URLEncoder.encode((String)param.getValue(), "UTF-8").replaceAll("\\+", "%20"));
            }
            str.append("&apiKey=");
            str.append(URLEncoder.encode(apiKey, "UTF-8").replaceAll("\\+", "%20"));
            str.append("&signature=");
            try {
                str.append(URLEncoder.encode(this.getSignature(command, apiKey, accessKey, params), "UTF-8").replaceAll("\\+", "%20"));
            }
            catch (SignatureException e) {
                throw new InternalException((Throwable)e);
            }
            return str.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new RuntimeException("This cannot happen: " + e.getMessage());
        }
    }

    private byte[] calculateHmac(String data, String key) throws SignatureException {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key.getBytes(), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            return mac.doFinal(data.getBytes());
        }
        catch (Exception e) {
            throw new SignatureException("Failed to generate HMAC : " + e.getMessage());
        }
    }

    @Nonnull
    protected HttpClient getClient(String url) throws InternalException {
        ProviderContext ctx = this.provider.getContext();
        if (ctx == null) {
            throw new InternalException("No context was specified for this request");
        }
        boolean ssl = url.startsWith("https");
        BasicHttpParams params = new BasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)"UTF-8");
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)"Dasein Cloud");
        Properties p = ctx.getCustomProperties();
        if (p != null) {
            String proxyHost = p.getProperty("proxyHost");
            String proxyPort = p.getProperty("proxyPort");
            if (proxyHost != null) {
                int port = 0;
                if (proxyPort != null && proxyPort.length() > 0) {
                    port = Integer.parseInt(proxyPort);
                }
                params.setParameter("http.route.default-proxy", (Object)new HttpHost(proxyHost, port, ssl ? "https" : "http"));
            }
        }
        return new DefaultHttpClient((HttpParams)params);
    }

    @Nonnull
    public Document get(@Nonnull String command, @Nonnull List<Param> params) throws CloudException, InternalException {
        return this.get(command, params.toArray(new Param[params.size()]));
    }

    @Nonnull
    public Document get(@Nonnull String command, Param ... params) throws CloudException, InternalException {
        Logger wire = CSCloud.getLogger(CSMethod.class, "wire");
        Logger logger = CSCloud.getLogger(CSMethod.class, "std");
        String url = this.buildUrl(command, params);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enter - " + CSMethod.class.getName() + ".get(" + url + ")"));
        }
        if (wire.isDebugEnabled()) {
            wire.debug((Object)("[" + new Date() + "] -------------------------------------------------------------------"));
            wire.debug((Object)"");
        }
        HttpClient client = null;
        try {
            int status;
            HttpResponse response;
            block25: {
                HttpGet get = new HttpGet(url);
                client = this.getClient(url);
                get.addHeader("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
                if (wire.isDebugEnabled()) {
                    wire.debug((Object)get.getRequestLine().toString());
                    for (Header header : get.getAllHeaders()) {
                        wire.debug((Object)(header.getName() + ": " + header.getValue()));
                    }
                    wire.debug((Object)"");
                }
                try {
                    APITrace.trace((CloudProvider)this.provider, (String)command);
                    response = client.execute((HttpUriRequest)get);
                }
                catch (IOException e) {
                    logger.error((Object)("I/O error from server communications: " + e.getMessage()));
                    e.printStackTrace();
                    throw new InternalException((Throwable)e);
                }
                status = response.getStatusLine().getStatusCode();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("get(): HTTP Status " + status));
                }
                if (wire.isDebugEnabled()) {
                    Header[] headers = response.getAllHeaders();
                    wire.debug((Object)response.getStatusLine().toString());
                    for (Header h : headers) {
                        if (h.getValue() != null) {
                            wire.debug((Object)(h.getName() + ": " + h.getValue().trim()));
                            continue;
                        }
                        wire.debug((Object)(h.getName() + ":"));
                    }
                    wire.debug((Object)"");
                }
                try {
                    String body;
                    if (status == 200) break block25;
                    HttpEntity entity = response.getEntity();
                    String string = body = entity == null ? null : EntityUtils.toString((HttpEntity)entity);
                    if (body == null) {
                        ParsedError p = new ParsedError();
                        p.code = status;
                        p.message = "No error information was provided";
                        throw new CSException(CloudErrorType.GENERAL, p);
                    }
                    if (body.contains("<html>")) {
                        if (status == 403 || status == 401) {
                            ParsedError p = new ParsedError();
                            p.code = status;
                            p.message = body;
                            throw new CSException(CloudErrorType.AUTHENTICATION, p);
                        }
                        if (status == 430 || status == 431 || status == 432 || status == 436) {
                            Document p = null;
                            return p;
                        }
                        ParsedError p = new ParsedError();
                        p.code = status;
                        p.message = body;
                        throw new CSException(p);
                    }
                    throw new CSException(this.parseError(status, body));
                }
                catch (NoHttpResponseException e) {
                    throw new CloudException("No answer from endpoint: " + e.getMessage());
                }
                catch (IOException e) {
                    throw new CloudException("IOException getting stream: " + e.getMessage());
                }
            }
            HttpEntity entity = response.getEntity();
            Document document = this.parseResponse(status, EntityUtils.toString((HttpEntity)entity));
            return document;
        }
        finally {
            if (wire.isDebugEnabled()) {
                wire.debug((Object)"");
                wire.debug((Object)("[" + new Date() + "] -------------------------------------------------------------------"));
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + CSMethod.class.getName() + ".get()"));
            }
            if (client != null) {
                client.getConnectionManager().shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getSignature(String command, String apiKey, String accessKey, Param ... params) throws UnsupportedEncodingException, SignatureException {
        Logger logger = CSCloud.getLogger(CSMethod.class, "std");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enter - " + CSMethod.class.getName() + ".getSignature(" + command + "," + apiKey + "," + accessKey + ",[params])"));
        }
        try {
            TreeSet<Param> sorted = new TreeSet<Param>();
            StringBuilder str = new StringBuilder();
            sorted.add(new Param("command", URLEncoder.encode(command, "UTF-8").replaceAll("\\+", "%20").toLowerCase()));
            sorted.add(new Param("apikey", URLEncoder.encode(apiKey, "UTF-8").replaceAll("\\+", "%20").toLowerCase()));
            for (Param param : params) {
                sorted.add(new Param(((String)param.getKey()).toLowerCase(), URLEncoder.encode((String)param.getValue(), "UTF-8").replaceAll("\\+", "%20").toLowerCase()));
            }
            boolean first = true;
            for (Param param : sorted) {
                if (!first) {
                    str.append("&");
                }
                first = false;
                str.append((String)param.getKey());
                str.append("=");
                str.append((String)param.getValue());
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getSignature(): String to sign=" + str.toString()));
            }
            String string = new String(Base64.encodeBase64((byte[])this.calculateHmac(str.toString(), accessKey)));
            return string;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + CSMethod.class.getName() + ".getSignature()"));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ParsedError parseError(int httpStatus, String assumedXml) throws InternalException {
        Logger logger = CSCloud.getLogger(CSMethod.class, "std");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enter - " + CSMethod.class.getName() + ".parseError(" + httpStatus + "," + assumedXml + ")"));
        }
        try {
            ParsedError error;
            block10: {
                error = new ParsedError();
                error.code = httpStatus;
                error.message = null;
                try {
                    Document doc = this.parseResponse(httpStatus, assumedXml);
                    NodeList codes = doc.getElementsByTagName("errorcode");
                    for (int i = 0; i < codes.getLength(); ++i) {
                        Node n = codes.item(i);
                        if (n == null || !n.hasChildNodes()) continue;
                        error.code = Integer.parseInt(n.getFirstChild().getNodeValue().trim());
                    }
                    NodeList text = doc.getElementsByTagName("errortext");
                    for (int i = 0; i < text.getLength(); ++i) {
                        Node n = text.item(i);
                        if (n == null || !n.hasChildNodes()) continue;
                        error.message = n.getFirstChild().getNodeValue();
                    }
                }
                catch (Throwable ignore) {
                    logger.warn((Object)("parseError(): Error was unparsable: " + ignore.getMessage()));
                    if (error.message != null) break block10;
                    error.message = assumedXml;
                }
            }
            if (error.message == null) {
                error.message = httpStatus == 401 ? "Unauthorized user" : (httpStatus == 430 ? "Malformed parameters" : (httpStatus == 547 || httpStatus == 530 ? "Server error in cloud (" + httpStatus + ")" : (httpStatus == 531 ? "Unable to find account" : "Received error code from server: " + httpStatus)));
            }
            ParsedError parsedError = error;
            return parsedError;
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + CSMethod.class.getName() + ".parseError()"));
            }
        }
    }

    @Nonnull
    private Document parseResponse(int code, String xml) throws CloudException, InternalException {
        Logger wire = CSCloud.getLogger(CSMethod.class, "wire");
        Logger logger = CSCloud.getLogger(CSMethod.class, "std");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enter - " + CSMethod.class.getName() + ".parseResponse(" + xml + ")"));
        }
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(xml.getBytes("utf-8"));
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(input);
            if (wire.isDebugEnabled()) {
                wire.debug((Object)this.prettifyXml(doc));
            }
            Document document = doc;
            return document;
        }
        catch (IOException e) {
            if (wire.isDebugEnabled()) {
                wire.debug((Object)xml);
            }
            throw new CloudException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            if (wire.isDebugEnabled()) {
                wire.debug((Object)xml);
            }
            throw new CloudException((Throwable)e);
        }
        catch (SAXException e) {
            if (wire.isDebugEnabled()) {
                wire.debug((Object)xml);
            }
            throw new CloudException("Received error code from server [" + code + "]: " + xml);
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + CSMethod.class.getName() + ".parseResponse()"));
            }
        }
    }

    private String prettifyXml(Document doc) {
        try {
            DOMImplementationLS impl = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS"));
            LSSerializer writer = impl.createLSSerializer();
            writer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            return writer.writeToString(doc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class ParsedError {
        public int code;
        public String message;
    }
}

