/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.CSTopologyCapabilities;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.dc.AbstractDataCenterServices;
import org.dasein.cloud.dc.DataCenter;
import org.dasein.cloud.dc.DataCenterCapabilities;
import org.dasein.cloud.dc.Region;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CSTopology
extends AbstractDataCenterServices<CSCloud> {
    public static final String LIST_ZONES = "listZones";
    private volatile transient CSTopologyCapabilities capabilities;

    CSTopology(CSCloud provider) {
        super((CloudProvider)provider);
    }

    @Nonnull
    public DataCenterCapabilities getCapabilities() throws InternalException, CloudException {
        if (this.capabilities == null) {
            this.capabilities = new CSTopologyCapabilities((CSCloud)this.getProvider());
        }
        return this.capabilities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DataCenter getDataCenter(@Nonnull String zoneId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"DC.getDataCenter");
        try {
            for (Region region : this.listRegions()) {
                for (DataCenter dc : this.listDataCenters(region.getProviderRegionId())) {
                    if (!dc.getProviderDataCenterId().equals(zoneId)) continue;
                    DataCenter dataCenter = dc;
                    return dataCenter;
                }
            }
            Iterator<Region> iterator = null;
            return iterator;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Region getRegion(@Nonnull String regionId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"DC.getRegion");
        try {
            for (Region region : this.listRegions()) {
                if (!region.getProviderRegionId().equals(regionId)) continue;
                Region region2 = region;
                return region2;
            }
            Iterator<Region> iterator = null;
            return iterator;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zoneSupportsVlans(@Nonnull String zoneId) throws InternalException, CloudException {
        Cache cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)("advanced.vlan." + zoneId), Boolean.class, (CacheLevel)CacheLevel.CLOUD_ACCOUNT, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.DAY));
        Iterable cachedValues = cache.get(this.getContext());
        if (cachedValues != null && cachedValues.iterator().hasNext()) {
            return (Boolean)cachedValues.iterator().next();
        }
        APITrace.begin((CloudProvider)this.getProvider(), (String)"DC.zoneSupportsVlans");
        try {
            Document doc = new CSMethod((CSCloud)this.getProvider()).get(LIST_ZONES, new Param("available", "true"));
            NodeList matches = doc.getElementsByTagName("zone");
            for (int i = 0; i < matches.getLength(); ++i) {
                Node zone = matches.item(i);
                if (!zone.hasChildNodes()) continue;
                NodeList attrs = zone.getChildNodes();
                String networkType = null;
                String id = null;
                for (int j = 0; j < attrs.getLength(); ++j) {
                    Node attr = attrs.item(j);
                    if (attr.getNodeName().equalsIgnoreCase("id")) {
                        id = attr.getFirstChild().getNodeValue().trim();
                        continue;
                    }
                    if (!attr.getNodeName().equalsIgnoreCase("networkType")) continue;
                    networkType = attr.getFirstChild().getNodeValue().trim();
                }
                if (!zoneId.equals(id)) continue;
                boolean advancedZone = !"basic".equalsIgnoreCase(networkType);
                cache.put(this.getContext(), Collections.singleton(advancedZone));
                boolean bl = advancedZone;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean supportsSecurityGroups(@Nonnull String zoneId, boolean basicOnly) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"DC.supportsSecurityGroups");
        try {
            Document doc = new CSMethod((CSCloud)this.getProvider()).get(LIST_ZONES, new Param("available", "true"));
            boolean sg = false;
            boolean basic = false;
            NodeList matches = doc.getElementsByTagName("zone");
            for (int i = 0; i < matches.getLength(); ++i) {
                Node zone = matches.item(i);
                if (!zone.hasChildNodes()) continue;
                NodeList attrs = zone.getChildNodes();
                boolean groups = false;
                String networkType = null;
                String id = null;
                for (int j = 0; j < attrs.getLength(); ++j) {
                    Node attr = attrs.item(j);
                    if (attr.getNodeName().equalsIgnoreCase("id")) {
                        id = attr.getFirstChild().getNodeValue().trim();
                        continue;
                    }
                    if (attr.getNodeName().equalsIgnoreCase("networkType")) {
                        networkType = attr.getFirstChild().getNodeValue().trim();
                        continue;
                    }
                    if (!attr.getNodeName().equalsIgnoreCase("securitygroupsenabled")) continue;
                    groups = attr.getFirstChild().getNodeValue().trim().equalsIgnoreCase("true");
                }
                if (!zoneId.equals(id)) continue;
                basic = "basic".equalsIgnoreCase(networkType);
                sg = groups;
                break;
            }
            boolean bl = (!basicOnly || basic) && sg;
            return bl;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<DataCenter> listDataCenters(@Nonnull String regionId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"DC.listDataCenters");
        try {
            Cache cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"dataCenters", DataCenter.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)15, (TimePeriodUnit)TimePeriod.MINUTE));
            List<DataCenter> dcs = cache.get(this.getContext());
            if (dcs == null) {
                Region region = this.getRegion(regionId);
                if (region == null) {
                    throw new CloudException("No such region: " + regionId);
                }
                DataCenter zone = new DataCenter();
                zone.setActive(true);
                zone.setAvailable(true);
                zone.setName(region.getName() + " (DC)");
                zone.setProviderDataCenterId(regionId);
                zone.setRegionId(regionId);
                dcs = Collections.singletonList(zone);
                cache.put(this.getContext(), dcs);
            }
            List<DataCenter> list = dcs;
            return list;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<Region> listRegions() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"DC.listRegions");
        try {
            Cache cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"regions", Region.class, (CacheLevel)CacheLevel.CLOUD_ACCOUNT, (TimePeriod)new TimePeriod((Number)15, (TimePeriodUnit)TimePeriod.MINUTE));
            ArrayList regions = cache.get(this.getContext());
            if (regions == null) {
                Document doc = new CSMethod((CSCloud)this.getProvider()).get(LIST_ZONES, new Param("available", "true"));
                regions = new ArrayList();
                NodeList matches = doc.getElementsByTagName("zone");
                for (int i = 0; i < matches.getLength(); ++i) {
                    Region r = this.toRegion(matches.item(i));
                    if (r == null || ((CSCloud)this.getProvider()).getProviderName().contains("Datapipe") && r.getName().contains("Shanghai")) continue;
                    ((List)regions).add(r);
                }
                cache.put(this.getContext(), regions);
            }
            ArrayList arrayList = regions;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    private Region toRegion(@Nullable Node node) {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        Region region = new Region();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node n = attributes.item(i);
            String name = n.getNodeName().toLowerCase();
            String value = n.getChildNodes().getLength() > 0 ? n.getFirstChild().getNodeValue() : null;
            if (name.equals("id")) {
                region.setProviderRegionId(value);
                continue;
            }
            if (!name.equals("name")) continue;
            region.setName(value);
        }
        if (region.getProviderRegionId() == null) {
            return null;
        }
        if (region.getName() == null) {
            region.setName(region.getProviderRegionId());
        }
        region.setActive(true);
        region.setAvailable(true);
        region.setJurisdiction(this.getJurisdiction(region.getName()));
        return region;
    }

    private String getJurisdiction(String name) {
        if (name.contains("New York")) {
            return "US";
        }
        if (name.contains("Hong Kong")) {
            return "HK";
        }
        if (name.contains("India")) {
            return "IN";
        }
        if (name.contains("London")) {
            return "EU";
        }
        ProviderContext ctx = ((CSCloud)this.getProvider()).getContext();
        Properties p = ctx == null ? null : ctx.getCustomProperties();
        return p == null ? "US" : p.getProperty("locale." + name, "US");
    }
}

