/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.compute;

import java.util.Arrays;
import java.util.Collections;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.VisibleScope;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.compute.ImageCapabilities;
import org.dasein.cloud.compute.ImageClass;
import org.dasein.cloud.compute.MachineImageFormat;
import org.dasein.cloud.compute.MachineImageType;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.util.NamingConstraints;

public class CSTemplateCapabilities
extends AbstractCapabilities<CSCloud>
implements ImageCapabilities {
    public CSTemplateCapabilities(@Nonnull CSCloud provider) {
        super((CloudProvider)provider);
    }

    public boolean canBundle(@Nonnull VmState fromState) throws CloudException, InternalException {
        return false;
    }

    public boolean canImage(@Nonnull VmState fromState) throws CloudException, InternalException {
        return fromState.equals((Object)VmState.STOPPED);
    }

    @Nonnull
    public String getProviderTermForImage(@Nonnull Locale locale, @Nonnull ImageClass cls) {
        switch (cls) {
            case KERNEL: {
                return "kernel template";
            }
            case RAMDISK: {
                return "ramdisk template";
            }
        }
        return "template";
    }

    @Nonnull
    public String getProviderTermForCustomImage(@Nonnull Locale locale, @Nonnull ImageClass cls) {
        return this.getProviderTermForImage(locale, cls);
    }

    @Nullable
    public VisibleScope getImageVisibleScope() {
        return null;
    }

    @Nonnull
    public Requirement identifyLocalBundlingRequirement() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormats() throws CloudException, InternalException {
        return Arrays.asList(MachineImageFormat.QCOW2, MachineImageFormat.VHD, MachineImageFormat.RAW);
    }

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormatsForBundling() throws CloudException, InternalException {
        return Collections.emptyList();
    }

    @Nonnull
    public Iterable<ImageClass> listSupportedImageClasses() throws CloudException, InternalException {
        return Collections.singletonList(ImageClass.MACHINE);
    }

    @Nonnull
    public Iterable<MachineImageType> listSupportedImageTypes() throws CloudException, InternalException {
        return Collections.singletonList(MachineImageType.VOLUME);
    }

    public boolean imageCaptureDestroysVM() throws InternalException, CloudException {
        return false;
    }

    @Nonnull
    public NamingConstraints getImageNamingConstraints() throws CloudException, InternalException {
        return NamingConstraints.getAlphaNumeric((int)1, (int)255);
    }

    public boolean supportsDirectImageUpload() throws CloudException, InternalException {
        return ((CSCloud)this.getProvider()).hasApi("registerTemplate");
    }

    public boolean supportsImageCapture(@Nonnull MachineImageType type) throws CloudException, InternalException {
        return ((CSCloud)this.getProvider()).hasApi("createTemplate");
    }

    public boolean supportsImageCopy() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsImageRemoval() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsImageSharing() throws CloudException, InternalException {
        return ((CSCloud)this.getProvider()).hasApi("updateTemplatePermissions");
    }

    public boolean supportsImageSharingWithPublic() throws CloudException, InternalException {
        return ((CSCloud)this.getProvider()).hasApi("updateTemplatePermissions");
    }

    public boolean supportsListingAllRegions() throws CloudException, InternalException {
        return false;
    }

    public boolean supportsPublicLibrary(@Nonnull ImageClass cls) throws CloudException, InternalException {
        return true;
    }
}

