/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.compute;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSException;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.CSVersion;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.cloudstack.compute.VMCapabilities;
import org.dasein.cloud.cloudstack.network.Network;
import org.dasein.cloud.cloudstack.network.SecurityGroup;
import org.dasein.cloud.compute.AbstractVMSupport;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VMLaunchOptions;
import org.dasein.cloud.compute.VMScalingCapabilities;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineCapabilities;
import org.dasein.cloud.compute.VirtualMachineProduct;
import org.dasein.cloud.compute.VirtualMachineProductFilterOptions;
import org.dasein.cloud.compute.VmState;
import org.dasein.cloud.network.RawAddress;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.uom.storage.Storage;
import org.dasein.util.uom.storage.StorageUnit;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VirtualMachines
extends AbstractVMSupport<CSCloud> {
    public static final Logger logger = Logger.getLogger(VirtualMachines.class);
    private static final String DEPLOY_VIRTUAL_MACHINE = "deployVirtualMachine";
    private static final String DESTROY_VIRTUAL_MACHINE = "destroyVirtualMachine";
    private static final String GET_VIRTUAL_MACHINE_PASSWORD = "getVMPassword";
    private static final String LIST_VIRTUAL_MACHINES = "listVirtualMachines";
    private static final String LIST_SERVICE_OFFERINGS = "listServiceOfferings";
    private static final String REBOOT_VIRTUAL_MACHINE = "rebootVirtualMachine";
    private static final String RESET_VIRTUAL_MACHINE_PASSWORD = "resetPasswordForVirtualMachine";
    private static final String RESIZE_VIRTUAL_MACHINE = "scaleVirtualMachine";
    private static final String START_VIRTUAL_MACHINE = "startVirtualMachine";
    private static final String STOP_VIRTUAL_MACHINE = "stopVirtualMachine";
    private static Properties cloudMappings;
    private static Map<String, Map<String, String>> customNetworkMappings;
    private static Map<String, Map<String, Set<String>>> customServiceMappings;
    private volatile transient VMCapabilities capabilities;

    public VirtualMachines(CSCloud provider) {
        super((CloudProvider)provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualMachine alterVirtualMachineSize(@Nonnull String vmId, @Nullable String cpuCount, @Nullable String ramInMB) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.alterVirtualMachineSize");
        try {
            Node virtualMachine;
            NodeList nodeList;
            VirtualMachine vm = this.getVirtualMachine(vmId);
            boolean restart = false;
            if (!vm.getCurrentState().equals((Object)VmState.STOPPED)) {
                restart = true;
                this.stop(vmId, true);
            }
            long timeout = System.currentTimeMillis() + 1200000L;
            while (System.currentTimeMillis() < timeout && !vm.getCurrentState().equals((Object)VmState.STOPPED)) {
                try {
                    Thread.sleep(15000L);
                    vm = this.getVirtualMachine(vmId);
                }
                catch (InterruptedException interruptedException) {}
            }
            vm = this.getVirtualMachine(vmId);
            if (!vm.getCurrentState().equals((Object)VmState.STOPPED)) {
                throw new CloudException("Unable to stop vm for scaling");
            }
            ArrayList<Param> params = new ArrayList<Param>();
            params.add(new Param("id", vmId));
            params.add(new Param("serviceOfferingId", vm.getProductId()));
            int index = 0;
            if (cpuCount != null) {
                params.add(new Param("details[" + index + "].cpunumber", cpuCount));
                ++index;
            }
            if (ramInMB != null) {
                params.add(new Param("details[" + index + "].memory", ramInMB));
            }
            Document doc = new CSMethod((CSCloud)this.getProvider()).get(RESIZE_VIRTUAL_MACHINE, params);
            NodeList matches = doc.getElementsByTagName("scalevirtualmachineresponse");
            String jobId = null;
            for (int i = 0; i < matches.getLength(); ++i) {
                NodeList attrs = matches.item(i).getChildNodes();
                for (int j = 0; j < attrs.getLength(); ++j) {
                    Node node = attrs.item(j);
                    if (node == null || !node.getNodeName().equalsIgnoreCase("jobid")) continue;
                    jobId = node.getFirstChild().getNodeValue();
                }
            }
            if (jobId == null) {
                throw new CloudException("Could not scale server");
            }
            Document responseDoc = ((CSCloud)this.getProvider()).waitForJob(doc, "Scale Server");
            if (responseDoc != null && (nodeList = responseDoc.getElementsByTagName("virtualmachine")).getLength() > 0 && (vm = this.toVirtualMachine(virtualMachine = nodeList.item(0))) != null) {
                if (restart) {
                    this.start(vmId);
                }
                VirtualMachine virtualMachine2 = vm;
                return virtualMachine2;
            }
            if (restart) {
                this.start(vmId);
            }
            VirtualMachine virtualMachine3 = this.getVirtualMachine(vmId);
            return virtualMachine3;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualMachine alterVirtualMachineProduct(@Nonnull String vmId, @Nonnull String productId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.alterVirtualMachineProduct");
        try {
            Node virtualMachine;
            NodeList nodeList;
            VirtualMachine vm = this.getVirtualMachine(vmId);
            if (vm.getProductId().equals(productId)) {
                VirtualMachine virtualMachine2 = vm;
                return virtualMachine2;
            }
            boolean restart = false;
            if (!vm.getCurrentState().equals((Object)VmState.STOPPED)) {
                restart = true;
                this.stop(vmId, true);
            }
            long timeout = System.currentTimeMillis() + 1200000L;
            while (System.currentTimeMillis() < timeout && !vm.getCurrentState().equals((Object)VmState.STOPPED)) {
                try {
                    Thread.sleep(15000L);
                    vm = this.getVirtualMachine(vmId);
                }
                catch (InterruptedException interruptedException) {}
            }
            vm = this.getVirtualMachine(vmId);
            if (!vm.getCurrentState().equals((Object)VmState.STOPPED)) {
                throw new CloudException("Unable to stop vm for scaling");
            }
            Document doc = new CSMethod((CSCloud)this.getProvider()).get(RESIZE_VIRTUAL_MACHINE, new Param("id", vmId), new Param("serviceOfferingId", productId));
            NodeList matches = doc.getElementsByTagName("scalevirtualmachineresponse");
            String jobId = null;
            for (int i = 0; i < matches.getLength(); ++i) {
                NodeList attrs = matches.item(i).getChildNodes();
                for (int j = 0; j < attrs.getLength(); ++j) {
                    Node node = attrs.item(j);
                    if (node == null || !node.getNodeName().equalsIgnoreCase("jobid")) continue;
                    jobId = node.getFirstChild().getNodeValue();
                }
            }
            if (jobId == null) {
                throw new CloudException("Could not scale server");
            }
            Document responseDoc = ((CSCloud)this.getProvider()).waitForJob(doc, "Scale Server");
            if (responseDoc != null && (nodeList = responseDoc.getElementsByTagName("virtualmachine")).getLength() > 0 && (vm = this.toVirtualMachine(virtualMachine = nodeList.item(0))) != null) {
                if (restart) {
                    this.start(vmId);
                }
                VirtualMachine virtualMachine3 = vm;
                return virtualMachine3;
            }
            if (restart) {
                this.start(vmId);
            }
            VirtualMachine virtualMachine4 = this.getVirtualMachine(vmId);
            return virtualMachine4;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public VirtualMachineCapabilities getCapabilities() throws InternalException, CloudException {
        if (this.capabilities == null) {
            this.capabilities = new VMCapabilities((CSCloud)this.getProvider());
        }
        return this.capabilities;
    }

    @Nullable
    public VMScalingCapabilities describeVerticalScalingCapabilities() throws CloudException, InternalException {
        return VMScalingCapabilities.getInstance((boolean)false, (boolean)true, (Requirement)Requirement.NONE, (Requirement)Requirement.NONE);
    }

    @Nullable
    public String getPassword(@Nonnull String vmId) throws InternalException, CloudException {
        return this.getRootPassword(vmId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRootPassword(@Nonnull String serverId) throws CloudException, InternalException {
        String string;
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.getPassword");
        try {
            Document doc = new CSMethod((CSCloud)this.getProvider()).get(GET_VIRTUAL_MACHINE_PASSWORD, new Param("id", serverId));
            if (doc != null) {
                NodeList matches = doc.getElementsByTagName("getvmpasswordresponse");
                for (int i = 0; i < matches.getLength(); ++i) {
                    Node node = matches.item(i);
                    if (node == null) continue;
                    NodeList attributes = node.getChildNodes();
                    for (int j = 0; j < attributes.getLength(); ++j) {
                        Node attribute = attributes.item(j);
                        String name = attribute.getNodeName().toLowerCase();
                        String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
                        if (!name.equals("password")) continue;
                        NodeList nodes = attribute.getChildNodes();
                        for (int k = 0; k < nodes.getLength(); ++k) {
                            Node password = nodes.item(k);
                            name = password.getNodeName().toLowerCase();
                            value = password.getChildNodes().getLength() > 0 ? password.getFirstChild().getNodeValue() : null;
                            if (!name.equals("encryptedpassword")) continue;
                            String string2 = value;
                            return string2;
                        }
                    }
                }
            }
            logger.warn((Object)("Unable to find password for vm with id " + serverId));
            string = null;
            return string;
        }
        catch (CSException e) {
            if (e.getHttpCode() == 431) {
                logger.warn((Object)("No password found for vm " + serverId));
            }
            string = null;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    public VirtualMachine getVirtualMachine(@Nonnull String serverId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.getVirtualMachine");
        try {
            Document doc = new CSMethod((CSCloud)this.getProvider()).get(LIST_VIRTUAL_MACHINES, new Param("id", serverId));
            NodeList matches = doc.getElementsByTagName("virtualmachine");
            if (matches.getLength() < 1) {
                VirtualMachine virtualMachine = null;
                return virtualMachine;
            }
            for (int i = 0; i < matches.getLength(); ++i) {
                VirtualMachine s = this.toVirtualMachine(matches.item(i));
                if (s == null || !s.getProviderVirtualMachineId().equals(serverId)) continue;
                VirtualMachine virtualMachine = s;
                return virtualMachine;
            }
            VirtualMachine virtualMachine = null;
            return virtualMachine;
        }
        catch (CloudException e) {
            if (e.getMessage().contains("does not exist")) {
                VirtualMachine virtualMachine = null;
                return virtualMachine;
            }
            throw e;
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.isSubscribed");
        try {
            new CSMethod((CSCloud)this.getProvider()).get("listZones", new Param("available", "true"));
            boolean bl = true;
            return bl;
        }
        catch (CSException e) {
            int code = e.getHttpCode();
            if (code == 403 || code == 401 || code == 531) {
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        catch (CloudException e) {
            int code = e.getHttpCode();
            if (code == 403 || code == 401) {
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public VirtualMachine launch(@Nonnull VMLaunchOptions withLaunchOptions) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.launch");
        try {
            String id = withLaunchOptions.getStandardProductId();
            VirtualMachineProduct product = this.getProduct(id);
            if (product == null) {
                throw new CloudException("Invalid product ID: " + id);
            }
            VirtualMachine vm = ((CSCloud)this.getProvider()).getVersion().greaterThan(CSVersion.CS21) ? this.launch22(withLaunchOptions.getMachineImageId(), product, withLaunchOptions.getDataCenterId(), withLaunchOptions.getFriendlyName(), withLaunchOptions.getBootstrapKey(), withLaunchOptions.getVlanId(), withLaunchOptions.getFirewallIds(), withLaunchOptions.getUserData()) : this.launch21(withLaunchOptions.getMachineImageId(), product, withLaunchOptions.getDataCenterId(), withLaunchOptions.getFriendlyName());
            ArrayList<Tag> tags = new ArrayList<Tag>();
            Map meta = withLaunchOptions.getMetaData();
            for (Map.Entry entry : meta.entrySet()) {
                if (((String)entry.getKey()).equalsIgnoreCase("name") || ((String)entry.getKey()).equalsIgnoreCase("description") || entry.getValue() == null || entry.getValue().equals("")) continue;
                tags.add(new Tag((String)entry.getKey(), entry.getValue().toString()));
            }
            tags.add(new Tag("Name", withLaunchOptions.getFriendlyName()));
            tags.add(new Tag("Description", withLaunchOptions.getDescription()));
            if (withLaunchOptions.getVirtualMachineGroup() != null) {
                tags.add(new Tag("dsnVMGroup", withLaunchOptions.getVirtualMachineGroup()));
            }
            ((CSCloud)this.getProvider()).createTags(new String[]{vm.getProviderVirtualMachineId()}, "UserVm", tags.toArray(new Tag[tags.size()]));
            VirtualMachine virtualMachine = vm;
            return virtualMachine;
        }
        finally {
            APITrace.end();
        }
    }

    @Deprecated
    @Nonnull
    public VirtualMachine launch(@Nonnull String imageId, @Nonnull VirtualMachineProduct product, @Nonnull String inZoneId, @Nonnull String name, @Nonnull String description, @Nullable String usingKey, @Nullable String withVlanId, boolean withMonitoring, boolean asSandbox, @Nullable String[] protectedByFirewalls, Tag ... tags) throws InternalException, CloudException {
        if (((CSCloud)this.getProvider()).getVersion().greaterThan(CSVersion.CS21)) {
            StringBuilder userData = new StringBuilder();
            if (tags != null && tags.length > 0) {
                for (Tag tag : tags) {
                    userData.append(tag.getKey());
                    userData.append("=");
                    userData.append(tag.getValue());
                    userData.append("\n");
                }
            } else {
                userData.append("created=Dasein Cloud\n");
            }
            return this.launch22(imageId, product, inZoneId, name, usingKey, withVlanId, protectedByFirewalls, userData.toString());
        }
        return this.launch21(imageId, product, inZoneId, name);
    }

    private VirtualMachine launch21(String imageId, VirtualMachineProduct product, String inZoneId, String name) throws InternalException, CloudException {
        return this.launch(new CSMethod((CSCloud)this.getProvider()).get(DEPLOY_VIRTUAL_MACHINE, new Param("zoneId", this.getContext().getRegionId()), new Param("serviceOfferingId", product.getProviderProductId()), new Param("templateId", imageId), new Param("displayName", name)));
    }

    private void load() {
        HashMap<String, Map<String, String>> mapping;
        Properties properties;
        InputStream input2;
        try {
            String line;
            input2 = VirtualMachines.class.getResourceAsStream("/cloudMappings.cfg");
            BufferedReader reader = new BufferedReader(new InputStreamReader(input2));
            properties = new Properties();
            while ((line = reader.readLine()) != null) {
                int idx;
                if (line.startsWith("#") || (idx = line.indexOf(61)) < 0 || line.endsWith("=")) continue;
                String cloudUrl = line.substring(0, idx);
                String cloudId = line.substring(idx + 1);
                properties.put(cloudUrl, cloudId);
            }
            cloudMappings = properties;
        }
        catch (Throwable input2) {
            // empty catch block
        }
        try {
            input2 = VirtualMachines.class.getResourceAsStream("/customNetworkMappings.cfg");
            mapping = new HashMap<String, Map<String, String>>();
            properties = new Properties();
            properties.load(input2);
            for (Object key : properties.keySet()) {
                String[] trueKey = ((String)key).split(",");
                HashMap<String, String> current = (HashMap<String, String>)mapping.get(trueKey[0]);
                if (current == null) {
                    current = new HashMap<String, String>();
                    mapping.put(trueKey[0], current);
                }
                current.put(trueKey[1], (String)properties.get(key));
            }
            customNetworkMappings = mapping;
        }
        catch (Throwable input3) {
            // empty catch block
        }
        try {
            input2 = VirtualMachines.class.getResourceAsStream("/customServiceMappings.cfg");
            mapping = new HashMap();
            properties = new Properties();
            properties.load(input2);
            for (Object key : properties.keySet()) {
                String value = (String)properties.get(key);
                if (value == null) continue;
                String[] trueKey = ((String)key).split(",");
                HashMap tmp = (HashMap)mapping.get(trueKey[0]);
                if (tmp == null) {
                    tmp = new HashMap();
                    mapping.put(trueKey[0], tmp);
                }
                TreeSet<String> m = new TreeSet<String>();
                String[] offerings = value.split(",");
                if (offerings == null || offerings.length < 1) {
                    m.add(value);
                } else {
                    Collections.addAll(m, offerings);
                }
                tmp.put(trueKey[1], m);
            }
            customServiceMappings = mapping;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Nonnull
    private VirtualMachine launch22(@Nonnull String imageId, @Nonnull VirtualMachineProduct product, @Nullable String inZoneId, @Nonnull String name, @Nullable String withKeypair, @Nullable String targetVlanId, @Nullable String[] protectedByFirewalls, @Nullable String userData) throws InternalException, CloudException {
        String id22;
        Map<String, String> map;
        String cloudId;
        ProviderContext ctx = this.getContext();
        List<Object> vlans = null;
        if (ctx == null) {
            throw new InternalException("No context was provided for this request");
        }
        String regionId = ctx.getRegionId();
        if (inZoneId == null || inZoneId.isEmpty()) {
            inZoneId = regionId;
        }
        if (inZoneId == null || inZoneId.isEmpty()) {
            throw new InternalException("No region is established for this request");
        }
        String prdId = product.getProviderProductId();
        if (customNetworkMappings == null) {
            this.load();
        }
        if (customNetworkMappings != null && (cloudId = cloudMappings.getProperty(ctx.getCloud().getEndpoint())) != null && (map = customNetworkMappings.get(cloudId)) != null && (id22 = map.get(prdId)) != null) {
            targetVlanId = id22;
        }
        if (targetVlanId != null && targetVlanId.length() < 1) {
            targetVlanId = null;
        }
        if (userData == null) {
            userData = "";
        }
        String securityGroupIds = StringUtils.join((Object[])protectedByFirewalls, (String)",");
        if (targetVlanId == null) {
            Network vlan = ((CSCloud)this.getProvider()).getNetworkServices().getVlanSupport();
            if (vlan != null && vlan.isSubscribed() && this.getCapabilities().identifyVlanRequirement().equals((Object)Requirement.REQUIRED)) {
                vlans = vlan.findFreeNetworks();
            }
        } else {
            vlans = new ArrayList<String>();
            vlans.add(targetVlanId);
        }
        if (securityGroupIds != null && !securityGroupIds.isEmpty()) {
            if (!((CSCloud)this.getProvider()).getDataCenterServices().supportsSecurityGroups(regionId, vlans == null || vlans.isEmpty())) {
                securityGroupIds = null;
            }
        } else if (((CSCloud)this.getProvider()).getDataCenterServices().supportsSecurityGroups(regionId, vlans == null || vlans.isEmpty())) {
            // empty if block
        }
        ArrayList<Param> params = new ArrayList<Param>();
        params.add(new Param("zoneId", inZoneId));
        params.add(new Param("serviceOfferingId", prdId));
        params.add(new Param("templateId", imageId));
        params.add(new Param("displayName", name));
        if (userData != null && userData.length() > 0) {
            try {
                params.add(new Param("userdata", new String(Base64.encodeBase64((byte[])userData.getBytes("utf-8")), "utf-8")));
            }
            catch (UnsupportedEncodingException id22) {
                // empty catch block
            }
        }
        if (withKeypair != null) {
            params.add(new Param("keypair", withKeypair));
        }
        if (securityGroupIds != null && securityGroupIds.length() > 0) {
            params.add(new Param("securitygroupids", securityGroupIds));
        }
        if (vlans != null && vlans.size() > 0) {
            CloudException lastError = null;
            for (String string : vlans) {
                params.add(new Param("networkIds", string));
                try {
                    return this.launch(new CSMethod((CSCloud)this.getProvider()).get(DEPLOY_VIRTUAL_MACHINE, params.toArray(new Param[params.size()])));
                }
                catch (CloudException e) {
                    if (e.getMessage().contains("sufficient address capacity")) {
                        lastError = e;
                        continue;
                    }
                    throw e;
                }
            }
            if (lastError == null) {
                throw lastError;
            }
            throw new CloudException("Unable to identify a network into which a VM can be launched");
        }
        return this.launch(new CSMethod((CSCloud)this.getProvider()).get(DEPLOY_VIRTUAL_MACHINE, params.toArray(new Param[params.size()])));
    }

    @Nonnull
    private VirtualMachine launch(@Nonnull Document doc) throws InternalException, CloudException {
        Node virtualMachine;
        NodeList nodeList;
        NodeList matches = doc.getElementsByTagName("deployvirtualmachineresponse");
        String serverId = null;
        String jobId = null;
        for (int i = 0; i < matches.getLength(); ++i) {
            NodeList attrs = matches.item(i).getChildNodes();
            for (int j = 0; j < attrs.getLength(); ++j) {
                Node node = attrs.item(j);
                if (node != null && (node.getNodeName().equalsIgnoreCase("virtualmachineid") || node.getNodeName().equalsIgnoreCase("id"))) {
                    serverId = node.getFirstChild().getNodeValue();
                    break;
                }
                if (node == null || !node.getNodeName().equalsIgnoreCase("jobid")) continue;
                jobId = node.getFirstChild().getNodeValue();
            }
            if (serverId != null) break;
        }
        if (serverId == null && jobId == null) {
            throw new CloudException("Could not launch server");
        }
        VirtualMachine vm = null;
        Document responseDoc = ((CSCloud)this.getProvider()).waitForJob(doc, "Launch Server");
        if (responseDoc != null && (nodeList = responseDoc.getElementsByTagName("virtualmachine")).getLength() > 0 && (vm = this.toVirtualMachine(virtualMachine = nodeList.item(0))) != null) {
            return vm;
        }
        if (vm == null) {
            vm = this.getVirtualMachine(serverId);
        }
        if (vm == null) {
            throw new CloudException("No virtual machine provided: " + serverId);
        }
        return vm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<String> listFirewalls(@Nonnull String vmId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.listFirewalls");
        try {
            SecurityGroup support = ((CSCloud)this.getProvider()).getNetworkServices().getFirewallSupport();
            if (support == null) {
                List<String> list = Collections.emptyList();
                return list;
            }
            Iterable<String> iterable = support.listFirewallsForVM(vmId);
            return iterable;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFirewalls(@Nonnull VirtualMachine vm) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.setFirewalls");
        try {
            SecurityGroup support = ((CSCloud)this.getProvider()).getNetworkServices().getFirewallSupport();
            if (support == null) {
                return;
            }
            ArrayList<String> ids = new ArrayList<String>();
            for (String id : support.listFirewallsForVM(vm.getProviderVirtualMachineId())) {
                ids.add(id);
            }
            vm.setProviderFirewallIds(ids.toArray(new String[ids.size()]));
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<VirtualMachineProduct> listAllProducts() throws InternalException, CloudException {
        return this.listProducts(VirtualMachineProductFilterOptions.getInstance(), Architecture.I64);
    }

    @Nonnull
    public Iterable<VirtualMachineProduct> listProducts(@Nonnull String machineImageId, @Nonnull VirtualMachineProductFilterOptions options) throws InternalException, CloudException {
        return this.listProducts(options, Architecture.I64);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<VirtualMachineProduct> listProducts(VirtualMachineProductFilterOptions options, Architecture architecture) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.listProducts");
        try {
            Cache cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"ServerProducts", VirtualMachineProduct.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)4, (TimePeriodUnit)TimePeriod.HOUR));
            ArrayList<VirtualMachineProduct> products = (ArrayList<VirtualMachineProduct>)cache.get(this.getContext());
            if (products == null) {
                Map<String, Set<String>> map;
                String cloudId;
                Set<String> mapping = null;
                if (customServiceMappings == null) {
                    this.load();
                }
                if (customServiceMappings != null && (cloudId = cloudMappings.getProperty(this.getContext().getCloud().getEndpoint())) != null && (map = customServiceMappings.get(cloudId)) != null) {
                    mapping = map.get(this.getContext().getRegionId());
                }
                products = new ArrayList<VirtualMachineProduct>();
                Document doc = new CSMethod((CSCloud)this.getProvider()).get(LIST_SERVICE_OFFERINGS, new Param("zoneId", this.getContext().getRegionId()));
                NodeList matches = doc.getElementsByTagName("serviceoffering");
                for (int i = 0; i < matches.getLength(); ++i) {
                    String id = null;
                    String name = null;
                    Node node = matches.item(i);
                    int memory = 0;
                    int cpu = 0;
                    Boolean customized = null;
                    NodeList attributes = node.getChildNodes();
                    for (int j = 0; j < attributes.getLength(); ++j) {
                        Node n = attributes.item(j);
                        String value = n.getChildNodes().getLength() > 0 ? n.getFirstChild().getNodeValue() : null;
                        if (n.getNodeName().equals("id")) {
                            id = value;
                        } else if (n.getNodeName().equals("name")) {
                            name = value;
                        } else if (n.getNodeName().equals("cpunumber")) {
                            cpu = Integer.parseInt(value);
                        } else if (n.getNodeName().equals("memory")) {
                            memory = Integer.parseInt(value);
                        } else if (n.getNodeName().equals("iscustomized")) {
                            customized = Boolean.valueOf(value);
                        }
                        if (id != null && name != null && cpu > 0 && memory > 0 && customized != null) break;
                    }
                    if (id == null || name == null || cpu <= 0 || memory <= 0 || customized.booleanValue() || mapping != null && !mapping.contains(id)) continue;
                    VirtualMachineProduct product = new VirtualMachineProduct();
                    product.setProviderProductId(id);
                    product.setName(name + " (" + cpu + " CPU/" + memory + "MB RAM)");
                    product.setDescription(name + " (" + cpu + " CPU/" + memory + "MB RAM)");
                    product.setRamSize(new Storage((Number)memory, (StorageUnit)Storage.MEGABYTE));
                    product.setCpuCount(cpu);
                    product.setRootVolumeSize(new Storage((Number)1, (StorageUnit)Storage.GIGABYTE));
                    product.setArchitectures(new Architecture[]{Architecture.I32, Architecture.I64});
                    if (options != null) {
                        if (!options.matches(product)) continue;
                        products.add(product);
                        continue;
                    }
                    products.add(product);
                }
                cache.put(this.getContext(), products);
            }
            ArrayList<VirtualMachineProduct> arrayList = products;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listVirtualMachineStatus() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.listVirtualMachineStatus");
        try {
            CSMethod method = new CSMethod((CSCloud)this.getProvider());
            Document doc = method.get(LIST_VIRTUAL_MACHINES, new Param("zoneId", this.getContext().getRegionId()));
            ArrayList<ResourceStatus> servers = new ArrayList<ResourceStatus>();
            int numPages = 1;
            NodeList nodes = doc.getElementsByTagName("count");
            Node n = nodes.item(0);
            if (n != null) {
                String value = n.getFirstChild().getNodeValue().trim();
                int count = Integer.parseInt(value);
                numPages = count / 500;
                int remainder = count % 500;
                if (remainder > 0) {
                    ++numPages;
                }
            }
            for (int page = 1; page <= numPages; ++page) {
                if (page > 1) {
                    String nextPage = String.valueOf(page);
                    doc = method.get(LIST_VIRTUAL_MACHINES, new Param("zoneId", this.getContext().getRegionId()), new Param("pagesize", "500"), new Param("page", nextPage));
                }
                NodeList matches = doc.getElementsByTagName("virtualmachine");
                for (int i = 0; i < matches.getLength(); ++i) {
                    ResourceStatus vm;
                    Node node = matches.item(i);
                    if (node == null || (vm = this.toStatus(node)) == null) continue;
                    servers.add(vm);
                }
            }
            ArrayList<ResourceStatus> arrayList = servers;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<VirtualMachine> listVirtualMachines() throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.listVirtualMachines");
        try {
            CSMethod method = new CSMethod((CSCloud)this.getProvider());
            Document doc = method.get(LIST_VIRTUAL_MACHINES, new Param("zoneId", this.getContext().getRegionId()));
            ArrayList<VirtualMachine> servers = new ArrayList<VirtualMachine>();
            int numPages = 1;
            NodeList nodes = doc.getElementsByTagName("count");
            Node n = nodes.item(0);
            if (n != null) {
                String value = n.getFirstChild().getNodeValue().trim();
                int count = Integer.parseInt(value);
                numPages = count / 500;
                int remainder = count % 500;
                if (remainder > 0) {
                    ++numPages;
                }
            }
            for (int page = 1; page <= numPages; ++page) {
                if (page > 1) {
                    String nextPage = String.valueOf(page);
                    doc = method.get(LIST_VIRTUAL_MACHINES, new Param("zoneId", this.getContext().getRegionId()), new Param("pagesize", "500"), new Param("page", nextPage));
                }
                NodeList matches = doc.getElementsByTagName("virtualmachine");
                for (int i = 0; i < matches.getLength(); ++i) {
                    VirtualMachine vm;
                    Node node = matches.item(i);
                    if (node == null || (vm = this.toVirtualMachine(node)) == null) continue;
                    servers.add(vm);
                }
            }
            ArrayList<VirtualMachine> arrayList = servers;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String resetPassword(@Nonnull String serverId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.resetPassword");
        try {
            Document doc = new CSMethod((CSCloud)this.getProvider()).get(RESET_VIRTUAL_MACHINE_PASSWORD, new Param("id", serverId));
            Document responseDoc = ((CSCloud)this.getProvider()).waitForJob(doc, "reset vm password");
            if (responseDoc != null) {
                NodeList matches = responseDoc.getElementsByTagName("virtualmachine");
                for (int i = 0; i < matches.getLength(); ++i) {
                    Node node = matches.item(i);
                    if (node == null) continue;
                    NodeList attributes = node.getChildNodes();
                    for (int j = 0; j < attributes.getLength(); ++j) {
                        Node attribute = attributes.item(j);
                        String name = attribute.getNodeName().toLowerCase();
                        String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
                        if (!name.equals("password")) continue;
                        String string = value;
                        return string;
                    }
                }
            }
            logger.warn((Object)("Unable to find password for vm with id " + serverId));
            String string = null;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    public void reboot(@Nonnull String serverId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.reboot");
        try {
            new CSMethod((CSCloud)this.getProvider()).get(REBOOT_VIRTUAL_MACHINE, new Param("id", serverId));
        }
        finally {
            APITrace.end();
        }
    }

    public void start(@Nonnull String serverId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.start");
        try {
            new CSMethod((CSCloud)this.getProvider()).get(START_VIRTUAL_MACHINE, new Param("id", serverId));
        }
        finally {
            APITrace.end();
        }
    }

    public void stop(@Nonnull String vmId, boolean force) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.stop");
        try {
            new CSMethod((CSCloud)this.getProvider()).get(STOP_VIRTUAL_MACHINE, new Param("id", vmId), new Param("forced", String.valueOf(force)));
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate(@Nonnull String serverId, @Nullable String explanation) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VM.terminate");
        try {
            ArrayList<Param> params = new ArrayList<Param>();
            params.add(new Param("id", serverId));
            if (((CSCloud)this.getProvider()).isAdminAccount()) {
                params.add(new Param("expunge", "true"));
            }
            new CSMethod((CSCloud)this.getProvider()).get(DESTROY_VIRTUAL_MACHINE, params);
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        VmState state = null;
        String serverId = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (name.equals("virtualmachineid") || name.equals("id")) {
                serverId = value;
            } else if (name.equals("state")) {
                if (value == null || value.equalsIgnoreCase("starting") || value.equalsIgnoreCase("creating")) {
                    state = VmState.PENDING;
                } else if (value.equalsIgnoreCase("stopped")) {
                    state = VmState.STOPPED;
                } else if (value.equalsIgnoreCase("running")) {
                    state = VmState.RUNNING;
                } else if (value.equalsIgnoreCase("stopping")) {
                    state = VmState.STOPPING;
                } else if (value.equalsIgnoreCase("migrating") || value.equalsIgnoreCase("ha")) {
                    state = VmState.REBOOTING;
                } else if (value.equalsIgnoreCase("destroyed") || value.equalsIgnoreCase("expunging")) {
                    state = VmState.TERMINATED;
                } else if (value.equalsIgnoreCase("error")) {
                    state = VmState.ERROR;
                } else {
                    throw new CloudException("Unexpected server state: " + value);
                }
            }
            if (serverId != null && state != null) break;
        }
        if (serverId == null) {
            return null;
        }
        if (state == null) {
            state = VmState.PENDING;
        }
        return new ResourceStatus(serverId, (Object)state);
    }

    @Nullable
    private VirtualMachine toVirtualMachine(@Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        VirtualMachine server = new VirtualMachine();
        NodeList attributes = node.getChildNodes();
        String productId = null;
        server.setProviderOwnerId(this.getContext().getAccountNumber());
        server.setClonable(false);
        server.setImagable(false);
        server.setPausable(true);
        server.setPersistent(true);
        server.setArchitecture(Architecture.I64);
        block4: for (int i = 0; i < attributes.getLength(); ++i) {
            NodeList parts;
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (name.equals("virtualmachineid") || name.equals("id")) {
                server.setProviderVirtualMachineId(value);
                continue;
            }
            if (name.equals("name")) {
                server.setDescription(value);
                continue;
            }
            if (name.equals("displayname")) {
                server.setName(value);
                continue;
            }
            if (name.equals("ipaddress")) {
                if (value != null) {
                    server.setPrivateAddresses(new RawAddress[]{new RawAddress(value)});
                }
                server.setPrivateDnsAddress(value);
                continue;
            }
            if (name.equals("password")) {
                server.setRootPassword(value);
                continue;
            }
            if (name.equals("securitygroup")) {
                if (!attribute.hasChildNodes()) continue;
                parts = attribute.getChildNodes();
                Object sgId = null;
                Object sgName = null;
                Object sgDescription = null;
                for (int j = 0; j < parts.getLength(); ++j) {
                    Node part = parts.item(j);
                    if (!"id".equalsIgnoreCase(part.getNodeName())) continue;
                    server.setProviderFirewallIds(new String[]{part.getFirstChild().getNodeValue()});
                    continue block4;
                }
                continue;
            }
            if (name.equals("nic")) {
                if (!attribute.hasChildNodes()) continue;
                parts = attribute.getChildNodes();
                String addr = null;
                for (int j = 0; j < parts.getLength(); ++j) {
                    Node part = parts.item(j);
                    if (part.getNodeName().equalsIgnoreCase("ipaddress")) {
                        if (!part.hasChildNodes() || (addr = part.getFirstChild().getNodeValue()) == null) continue;
                        addr = addr.trim();
                        continue;
                    }
                    if (!part.getNodeName().equalsIgnoreCase("networkid")) continue;
                    server.setProviderVlanId(part.getFirstChild().getNodeValue().trim());
                }
                if (addr == null) continue;
                boolean pub = false;
                if (!addr.startsWith("10.") && !addr.startsWith("192.168.")) {
                    if (addr.startsWith("172.")) {
                        String[] nums = addr.split("\\.");
                        if (nums.length != 4) {
                            pub = true;
                        } else {
                            try {
                                int x = Integer.parseInt(nums[1]);
                                if (x < 16 || x > 31) {
                                    pub = true;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    } else {
                        pub = true;
                    }
                }
                if (pub) {
                    server.setPublicAddresses(new RawAddress[]{new RawAddress(addr)});
                    if (server.getPublicDnsAddress() != null) continue;
                    server.setPublicDnsAddress(addr);
                    continue;
                }
                server.setPrivateAddresses(new RawAddress[]{new RawAddress(addr)});
                if (server.getPrivateDnsAddress() != null) continue;
                server.setPrivateDnsAddress(addr);
                continue;
            }
            if (name.equals("osarchitecture")) {
                if (value != null && value.equals("32")) {
                    server.setArchitecture(Architecture.I32);
                    continue;
                }
                server.setArchitecture(Architecture.I64);
                continue;
            }
            if (name.equals("created")) {
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
                try {
                    server.setCreationTimestamp(df.parse(value).getTime());
                }
                catch (ParseException e) {
                    logger.warn((Object)("Invalid date: " + value));
                    server.setLastBootTimestamp(0L);
                }
                continue;
            }
            if (name.equals("state")) {
                VmState state;
                if (value.equalsIgnoreCase("stopped")) {
                    state = VmState.STOPPED;
                    server.setImagable(true);
                } else if (value.equalsIgnoreCase("running")) {
                    state = VmState.RUNNING;
                } else if (value.equalsIgnoreCase("stopping")) {
                    state = VmState.STOPPING;
                } else if (value.equalsIgnoreCase("starting")) {
                    state = VmState.PENDING;
                } else if (value.equalsIgnoreCase("creating")) {
                    state = VmState.PENDING;
                } else if (value.equalsIgnoreCase("migrating")) {
                    state = VmState.REBOOTING;
                } else if (value.equalsIgnoreCase("destroyed")) {
                    state = VmState.TERMINATED;
                } else if (value.equalsIgnoreCase("error")) {
                    state = VmState.ERROR;
                } else if (value.equalsIgnoreCase("expunging")) {
                    state = VmState.TERMINATED;
                } else if (value.equalsIgnoreCase("ha")) {
                    state = VmState.REBOOTING;
                } else {
                    throw new CloudException("Unexpected server state: " + value);
                }
                server.setCurrentState(state);
                continue;
            }
            if (name.equals("zoneid")) {
                server.setProviderRegionId(value);
                server.setProviderDataCenterId(value);
                continue;
            }
            if (name.equals("templateid")) {
                server.setProviderMachineImageId(value);
                continue;
            }
            if (name.equals("templatename")) {
                server.setPlatform(Platform.guess((String)value));
                continue;
            }
            if (name.equals("serviceofferingid")) {
                productId = value;
                continue;
            }
            if (name.equals("keypair")) {
                server.setProviderKeypairId(value);
                continue;
            }
            if (value == null) continue;
            properties.put(name, value);
        }
        if (server.getName() == null) {
            server.setName(server.getProviderVirtualMachineId());
        }
        if (server.getDescription() == null) {
            server.setDescription(server.getName());
        }
        server.setProviderAssignedIpAddressId(null);
        if (server.getProviderRegionId() == null) {
            server.setProviderRegionId(this.getContext().getRegionId());
        }
        if (server.getProviderDataCenterId() == null) {
            server.setProviderDataCenterId(this.getContext().getRegionId());
        }
        if (productId != null) {
            server.setProductId(productId);
        }
        server.setTags(properties);
        return server;
    }

    public void setTags(@Nonnull String vmId, Tag ... tags) throws CloudException, InternalException {
        this.setTags(new String[]{vmId}, tags);
    }

    public void setTags(@Nonnull String[] vmIds, Tag ... tags) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Server.setTags");
        try {
            this.removeTags(vmIds, new Tag[0]);
            ((CSCloud)this.getProvider()).createTags(vmIds, "UserVm", tags);
        }
        finally {
            APITrace.end();
        }
    }

    public void updateTags(@Nonnull String vmId, Tag ... tags) throws CloudException, InternalException {
        this.updateTags(new String[]{vmId}, tags);
    }

    public void updateTags(@Nonnull String[] vmIds, Tag ... tags) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Server.updateTags");
        try {
            ((CSCloud)this.getProvider()).updateTags(vmIds, "UserVm", tags);
        }
        finally {
            APITrace.end();
        }
    }

    public void removeTags(@Nonnull String vmId, Tag ... tags) throws CloudException, InternalException {
        this.removeTags(new String[]{vmId}, tags);
    }

    public void removeTags(@Nonnull String[] vmIds, Tag ... tags) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"Server.removeTags");
        try {
            ((CSCloud)this.getProvider()).removeTags(vmIds, "UserVm", tags);
        }
        finally {
            APITrace.end();
        }
    }
}

