/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.network;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSException;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.CSVersion;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.cloudstack.network.CSIPAddressCapabilities;
import org.dasein.cloud.cloudstack.network.LoadBalancers;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.AbstractIpAddressSupport;
import org.dasein.cloud.network.AddressType;
import org.dasein.cloud.network.IPAddressCapabilities;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.IpForwardingRule;
import org.dasein.cloud.network.LoadBalancer;
import org.dasein.cloud.network.Protocol;
import org.dasein.cloud.network.RawAddress;
import org.dasein.cloud.util.APITrace;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class IpAddress
extends AbstractIpAddressSupport<CSCloud> {
    private static final Logger logger = CSCloud.getLogger(IpAddress.class, "std");
    static final String ASSOCIATE_IP_ADDRESS = "associateIpAddress";
    private static final String CREATE_PORT_FORWARDING_RULE = "createPortForwardingRule";
    private static final String DISASSOCIATE_IP_ADDRESS = "disassociateIpAddress";
    private static final String LIST_PORT_FORWARDING_RULES = "listPortForwardingRules";
    private static final String LIST_PUBLIC_IP_ADDRESSES = "listPublicIpAddresses";
    private static final String STOP_FORWARD = "deletePortForwardingRule";
    private volatile transient CSIPAddressCapabilities capabilities;

    public IpAddress(CSCloud provider) {
        super((CloudProvider)provider);
    }

    public void assign(@Nonnull String addressId, @Nonnull String toServerId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Address assignment is not supported");
    }

    public void assignToNetworkInterface(@Nonnull String addressId, @Nonnull String nicId) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Network interfaces are not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String forward(@Nonnull String addressId, int publicPort, @Nonnull Protocol protocol, int privatePort, @Nonnull String onServerId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"IpAddress.forward");
        try {
            VirtualMachine server = ((CSCloud)this.getProvider()).getComputeServices().getVirtualMachineSupport().getVirtualMachine(onServerId);
            RawAddress privateIpAddress = null;
            if (server == null) {
                throw new CloudException("No such server: " + onServerId);
            }
            RawAddress[] addresses = server.getPrivateAddresses();
            if (addresses != null && addresses.length > 0) {
                privateIpAddress = addresses[0];
            }
            if (privateIpAddress == null) {
                throw new CloudException("Could not determine a private IP address for " + onServerId);
            }
            ArrayList<Param> params = new ArrayList<Param>();
            params.add(new Param("publicPort", String.valueOf(publicPort)));
            params.add(new Param("privatePort", String.valueOf(privatePort)));
            params.add(new Param("protocol", protocol.name()));
            params.add(new Param("virtualMachineId", onServerId));
            params.add(new Param("ipAddressId", addressId));
            Document doc = new CSMethod((CSCloud)this.getProvider()).get(CREATE_PORT_FORWARDING_RULE, params);
            ((CSCloud)this.getProvider()).waitForJob(doc, "Assigning forwarding rule");
            for (IpForwardingRule rule : this.listRules(addressId)) {
                if (rule.getPublicPort() != publicPort || rule.getPrivatePort() != privatePort || !onServerId.equals(rule.getServerId()) || !protocol.equals((Object)rule.getProtocol()) || !addressId.equals(rule.getAddressId())) continue;
                String string = rule.getProviderRuleId();
                return string;
            }
            Iterator iterator = null;
            return iterator;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public IPAddressCapabilities getCapabilities() throws CloudException, InternalException {
        if (this.capabilities == null) {
            this.capabilities = new CSIPAddressCapabilities((CSCloud)this.getProvider());
        }
        return this.capabilities;
    }

    private boolean isId() {
        return ((CSCloud)this.getProvider()).getVersion().greaterThan(CSVersion.CS21);
    }

    @Nullable
    public org.dasein.cloud.network.IpAddress getIpAddress(@Nonnull String addressId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"IpAddress.getIpAddress");
        try {
            LoadBalancer lb;
            CSMethod method = new CSMethod((CSCloud)this.getProvider());
            Document doc = method.get(LIST_PUBLIC_IP_ADDRESSES, new Param(this.isId() ? "id" : "ipAddress", addressId));
            HashMap<String, LoadBalancer> loadBalancers = new HashMap<String, LoadBalancer>();
            LoadBalancers support = ((CSCloud)this.getProvider()).getNetworkServices().getLoadBalancerSupport();
            LoadBalancer loadBalancer = lb = support == null ? null : support.getLoadBalancer(addressId);
            if (lb != null) {
                loadBalancers.put(addressId, lb);
            }
            NodeList matches = doc.getElementsByTagName("publicipaddress");
            for (int i = 0; i < matches.getLength(); ++i) {
                org.dasein.cloud.network.IpAddress addr = this.toAddress(matches.item(i), loadBalancers);
                if (addr == null || !addr.getProviderIpAddressId().equals(addressId)) continue;
                org.dasein.cloud.network.IpAddress ipAddress = addr;
                return ipAddress;
            }
            org.dasein.cloud.network.IpAddress ipAddress = null;
            return ipAddress;
        }
        catch (CSException e) {
            if (e.getHttpCode() == 431) {
                org.dasein.cloud.network.IpAddress ipAddress = null;
                return ipAddress;
            }
            throw e;
        }
        finally {
            APITrace.end();
        }
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"IpAddress.isSubscribed");
        try {
            new CSMethod((CSCloud)this.getProvider()).get(LIST_PUBLIC_IP_ADDRESSES, new Param("zoneId", this.getContext().getRegionId()));
            boolean bl = true;
            return bl;
        }
        catch (CSException e) {
            int code = e.getHttpCode();
            if (code == 403 || code == 401 || code == 531) {
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<org.dasein.cloud.network.IpAddress> listIpPool(@Nonnull IPVersion version, boolean unassignedOnly) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"IpAddress.listIpPool");
        try {
            if (version.equals((Object)IPVersion.IPV4)) {
                HashMap<String, LoadBalancer> loadBalancers = new HashMap<String, LoadBalancer>();
                LoadBalancers support = ((CSCloud)this.getProvider()).getNetworkServices().getLoadBalancerSupport();
                if (support != null) {
                    for (LoadBalancer lb : support.listLoadBalancers()) {
                        loadBalancers.put(lb.getProviderLoadBalancerId(), lb);
                    }
                }
                CSMethod method = new CSMethod((CSCloud)this.getProvider());
                Document doc = method.get(LIST_PUBLIC_IP_ADDRESSES, new Param("zoneId", this.getContext().getRegionId()));
                ArrayList<org.dasein.cloud.network.IpAddress> addresses = new ArrayList<org.dasein.cloud.network.IpAddress>();
                int numPages = 1;
                NodeList nodes = doc.getElementsByTagName("count");
                Node n = nodes.item(0);
                if (n != null) {
                    String value = n.getFirstChild().getNodeValue().trim();
                    int count = Integer.parseInt(value);
                    numPages = count / 500;
                    int remainder = count % 500;
                    if (remainder > 0) {
                        ++numPages;
                    }
                }
                for (int page = 1; page <= numPages; ++page) {
                    if (page > 1) {
                        String nextPage = String.valueOf(page);
                        doc = method.get(LIST_PUBLIC_IP_ADDRESSES, new Param("zoneId", this.getContext().getRegionId()), new Param("pagesize", "500"), new Param("page", nextPage));
                    }
                    NodeList matches = doc.getElementsByTagName("publicipaddress");
                    for (int i = 0; i < matches.getLength(); ++i) {
                        org.dasein.cloud.network.IpAddress addr = this.toAddress(matches.item(i), loadBalancers);
                        if (addr == null || unassignedOnly && addr.isAssigned()) continue;
                        addresses.add(addr);
                    }
                }
                ArrayList<org.dasein.cloud.network.IpAddress> arrayList = addresses;
                return arrayList;
            }
            List<org.dasein.cloud.network.IpAddress> list = Collections.emptyList();
            return list;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Future<Iterable<org.dasein.cloud.network.IpAddress>> listIpPoolConcurrently(@Nonnull IPVersion version, boolean unassignedOnly) throws InternalException, CloudException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listIpPoolStatus(@Nonnull IPVersion version) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"IpAddress.listIpPoolStatus");
        try {
            if (!IPVersion.IPV4.equals((Object)version)) {
                List<ResourceStatus> list = Collections.emptyList();
                return list;
            }
            HashMap<String, LoadBalancer> loadBalancers = new HashMap<String, LoadBalancer>();
            LoadBalancers support = ((CSCloud)this.getProvider()).getNetworkServices().getLoadBalancerSupport();
            if (support != null) {
                for (LoadBalancer lb : support.listLoadBalancers()) {
                    loadBalancers.put(lb.getProviderLoadBalancerId(), lb);
                }
            }
            CSMethod method = new CSMethod((CSCloud)this.getProvider());
            Document doc = method.get(LIST_PUBLIC_IP_ADDRESSES, new Param("zoneId", this.getContext().getRegionId()));
            ArrayList<ResourceStatus> addresses = new ArrayList<ResourceStatus>();
            int numPages = 1;
            NodeList nodes = doc.getElementsByTagName("count");
            Node n = nodes.item(0);
            if (n != null) {
                String value = n.getFirstChild().getNodeValue().trim();
                int count = Integer.parseInt(value);
                numPages = count / 500;
                int remainder = count % 500;
                if (remainder > 0) {
                    ++numPages;
                }
            }
            for (int page = 1; page <= numPages; ++page) {
                if (page > 1) {
                    String nextPage = String.valueOf(page);
                    doc = method.get(LIST_PUBLIC_IP_ADDRESSES, new Param("zoneId", this.getContext().getRegionId()), new Param("pagesize", "500"), new Param("page", nextPage));
                }
                NodeList matches = doc.getElementsByTagName("publicipaddress");
                for (int i = 0; i < matches.getLength(); ++i) {
                    ResourceStatus addr = this.toStatus(matches.item(i), loadBalancers);
                    if (addr == null) continue;
                    addresses.add(addr);
                }
            }
            ArrayList<ResourceStatus> arrayList = addresses;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Collection<IpForwardingRule> listRules(@Nonnull String addressId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"IpAddress.listRules");
        try {
            ArrayList<IpForwardingRule> rules = new ArrayList<IpForwardingRule>();
            Param[] params = ((CSCloud)this.getProvider()).getVersion().greaterThan(CSVersion.CS21) ? new Param[]{new Param("ipaddressid", addressId)} : new Param[]{new Param("ipAddress", addressId)};
            Document doc = new CSMethod((CSCloud)this.getProvider()).get(LIST_PORT_FORWARDING_RULES, params);
            if (doc == null) {
                throw new CloudException("No such IP address: " + addressId);
            }
            NodeList matches = doc.getElementsByTagName("portforwardingrule");
            for (int i = 0; i < matches.getLength(); ++i) {
                Node node = matches.item(i);
                if (node == null) continue;
                IpForwardingRule rule = new IpForwardingRule();
                NodeList list = node.getChildNodes();
                rule.setAddressId(addressId);
                for (int j = 0; j < list.getLength(); ++j) {
                    Node attr = list.item(j);
                    if (attr.getNodeName().equals("publicport")) {
                        rule.setPublicPort(Integer.parseInt(attr.getFirstChild().getNodeValue()));
                        continue;
                    }
                    if (attr.getNodeName().equals("privateport")) {
                        rule.setPrivatePort(Integer.parseInt(attr.getFirstChild().getNodeValue()));
                        continue;
                    }
                    if (attr.getNodeName().equals("protocol")) {
                        rule.setProtocol(Protocol.valueOf((String)attr.getFirstChild().getNodeValue().toUpperCase()));
                        continue;
                    }
                    if (attr.getNodeName().equals("id")) {
                        rule.setProviderRuleId(attr.getFirstChild().getNodeValue());
                        continue;
                    }
                    if (!attr.getNodeName().equals("virtualmachineid")) continue;
                    rule.setServerId(attr.getFirstChild().getNodeValue());
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("listRules(): * " + rule));
                }
                rules.add(rule);
            }
            ArrayList<IpForwardingRule> arrayList = rules;
            return arrayList;
        }
        catch (RuntimeException e) {
            logger.error((Object)("listRules(): Runtime exception listing rules for " + addressId + ": " + e.getMessage()));
            e.printStackTrace();
            throw new InternalException((Throwable)e);
        }
        catch (Error e) {
            logger.error((Object)("listRules(): Error listing rules for " + addressId + ": " + e.getMessage()));
            e.printStackTrace();
            throw new InternalException((Throwable)e);
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException {
        return Collections.singletonList(IPVersion.IPV4);
    }

    @Nonnull
    public String[] mapServiceAction(@Nonnull ServiceAction action) {
        return new String[0];
    }

    public void releaseFromPool(@Nonnull String addressId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"IpAddress.releaseFromPool");
        try {
            CSMethod method = new CSMethod((CSCloud)this.getProvider());
            method.get(DISASSOCIATE_IP_ADDRESS, new Param(this.isId() ? "id" : "ipaddress", addressId));
        }
        finally {
            APITrace.end();
        }
    }

    public void releaseFromServer(@Nonnull String addressId) throws InternalException, CloudException {
        throw new OperationNotSupportedException();
    }

    @Nonnull
    public String request(@Nonnull AddressType typeOfAddress) throws InternalException, CloudException {
        if (typeOfAddress.equals((Object)AddressType.PUBLIC)) {
            return this.request(IPVersion.IPV4);
        }
        throw new OperationNotSupportedException("Private IP requests are not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String request(@Nonnull IPVersion version) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"IpAddress.request");
        try {
            NodeList nodeList;
            NodeList matches;
            if (!version.equals((Object)IPVersion.IPV4)) {
                throw new OperationNotSupportedException("Only IPv4 is currently supported");
            }
            Document doc = new CSMethod((CSCloud)this.getProvider()).get(ASSOCIATE_IP_ADDRESS, new Param("zoneId", this.getContext().getRegionId()));
            if (((CSCloud)this.getProvider()).getVersion().greaterThan(CSVersion.CS21)) {
                matches = doc.getElementsByTagName("id");
                if (matches.getLength() == 0) {
                    matches = doc.getElementsByTagName("jobid");
                }
            } else {
                matches = doc.getElementsByTagName("ipaddress");
            }
            String id = null;
            if (matches.getLength() > 0) {
                id = matches.item(0).getFirstChild().getNodeValue();
            }
            if (id == null) {
                throw new CloudException("Failed to request an IP address without error");
            }
            Document responseDoc = ((CSCloud)this.getProvider()).waitForJob(doc, ASSOCIATE_IP_ADDRESS);
            if (responseDoc != null && (nodeList = responseDoc.getElementsByTagName("ipaddress")).getLength() > 0) {
                Node ipAddress = nodeList.item(0);
                NodeList attributes = ipAddress.getChildNodes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attribute = attributes.item(i);
                    String tmpname = attribute.getNodeName().toLowerCase();
                    String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
                    if (!tmpname.equalsIgnoreCase("id")) continue;
                    id = value;
                    break;
                }
            }
            String string = id;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    @Nonnull
    public String requestForVLAN(@Nonnull IPVersion version) throws InternalException, CloudException {
        throw new OperationNotSupportedException("Not yet supported since CloudStack requires you to name the network");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public String requestForVLAN(@Nonnull IPVersion version, @Nonnull String vlanId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"IpAddress.requestForVLAN");
        try {
            NodeList nodeList;
            NodeList matches;
            if (!version.equals((Object)IPVersion.IPV4)) {
                throw new OperationNotSupportedException("Only IPv4 is currently supported");
            }
            CSMethod method = new CSMethod((CSCloud)this.getProvider());
            Document doc = method.get(ASSOCIATE_IP_ADDRESS, new Param("zoneId", this.getContext().getRegionId()), new Param("networkId", vlanId));
            if (((CSCloud)this.getProvider()).getVersion().greaterThan(CSVersion.CS21)) {
                matches = doc.getElementsByTagName("id");
                if (matches.getLength() == 0) {
                    matches = doc.getElementsByTagName("jobid");
                }
            } else {
                matches = doc.getElementsByTagName("ipaddress");
            }
            String id = null;
            if (matches.getLength() > 0) {
                id = matches.item(0).getFirstChild().getNodeValue();
            }
            if (id == null) {
                throw new CloudException("Failed to request an IP address without error");
            }
            Document responseDoc = ((CSCloud)this.getProvider()).waitForJob(doc, ASSOCIATE_IP_ADDRESS);
            if (responseDoc != null && (nodeList = responseDoc.getElementsByTagName("ipaddress")).getLength() > 0) {
                Node ipAddress = nodeList.item(0);
                NodeList attributes = ipAddress.getChildNodes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Node attribute = attributes.item(i);
                    String tmpname = attribute.getNodeName().toLowerCase();
                    String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
                    if (!tmpname.equalsIgnoreCase("id")) continue;
                    id = value;
                    break;
                }
            }
            String string = id;
            return string;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopForward(@Nonnull String ruleId) throws InternalException, CloudException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"IpAddress.stopForward");
        Logger logger = CSCloud.getLogger(IpAddress.class, "std");
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("enter - " + IpAddress.class.getName() + ".stopForward(" + ruleId + ")"));
        }
        try {
            Document doc = new CSMethod((CSCloud)this.getProvider()).get(STOP_FORWARD, new Param("id", ruleId));
            ((CSCloud)this.getProvider()).waitForJob(doc, STOP_FORWARD);
        }
        finally {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("exit - " + IpAddress.class.getName() + ".stopForward()"));
            }
            APITrace.end();
        }
    }

    public boolean supportsVLANAddresses(@Nonnull IPVersion ofVersion) throws InternalException, CloudException {
        return IPVersion.IPV4.equals((Object)ofVersion);
    }

    @Nullable
    private org.dasein.cloud.network.IpAddress toAddress(@Nullable Node node, @Nonnull Map<String, LoadBalancer> loadBalancers) throws InternalException, CloudException {
        if (node == null) {
            return null;
        }
        String regionId = this.getContext().getRegionId();
        if (regionId == null) {
            throw new CloudException("No region was set for this request");
        }
        org.dasein.cloud.network.IpAddress address = new org.dasein.cloud.network.IpAddress();
        NodeList attributes = node.getChildNodes();
        address.setRegionId(regionId);
        address.setServerId(null);
        address.setProviderLoadBalancerId(null);
        address.setAddressType(AddressType.PUBLIC);
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node n = attributes.item(i);
            String name = n.getNodeName().toLowerCase();
            String value = n.getChildNodes().getLength() > 0 ? n.getFirstChild().getNodeValue() : null;
            if (name.equalsIgnoreCase("id") && value != null) {
                address.setIpAddressId(value);
                continue;
            }
            if (name.equalsIgnoreCase("ipaddress") && value != null) {
                if (address.getProviderIpAddressId() == null) {
                    address.setIpAddressId(value);
                }
                address.setAddress(value);
                continue;
            }
            if (name.equalsIgnoreCase("zoneid") && value != null) {
                address.setRegionId(value);
                continue;
            }
            if (name.equalsIgnoreCase("virtualmachineid")) {
                address.setServerId(value);
                continue;
            }
            if (name.equalsIgnoreCase("state")) {
                if (value == null || value.equalsIgnoreCase("allocated")) continue;
                return null;
            }
            if (!name.equalsIgnoreCase("associatednetworkid") || value == null) continue;
            address.setForVlan(true);
            address.setProviderVlanId(value);
        }
        LoadBalancer lb = loadBalancers.get(address.getRawAddress().getIpAddress());
        if (lb != null) {
            address.setProviderLoadBalancerId(lb.getProviderLoadBalancerId());
        }
        if (address.getServerId() == null) {
            for (VirtualMachine vm : ((CSCloud)this.getProvider()).getComputeServices().getVirtualMachineSupport().listVirtualMachines()) {
                RawAddress[] addrs;
                for (RawAddress addr : addrs = vm.getPublicAddresses()) {
                    if (!addr.getIpAddress().equals(address.getRawAddress().getIpAddress())) continue;
                    address.setServerId(vm.getProviderVirtualMachineId());
                }
            }
        }
        return address;
    }

    @Nullable
    private ResourceStatus toStatus(@Nullable Node node, @Nonnull Map<String, LoadBalancer> loadBalancers) throws InternalException, CloudException {
        LoadBalancer lb;
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        String addressId = null;
        String address = null;
        Boolean available = null;
        boolean hasState = false;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node n = attributes.item(i);
            String name = n.getNodeName().toLowerCase();
            String value = n.getChildNodes().getLength() > 0 ? n.getFirstChild().getNodeValue() : null;
            if (name.equalsIgnoreCase("id") && value != null) {
                addressId = value;
            } else if (name.equalsIgnoreCase("ipaddress") && value != null) {
                address = value;
            } else if (name.equalsIgnoreCase("virtualmachineid")) {
                available = value != null && !value.equals("");
            } else if (name.equalsIgnoreCase("state")) {
                if (value != null && !value.equalsIgnoreCase("allocated")) {
                    return null;
                }
                hasState = true;
            }
            if (addressId != null && address != null && available != null && hasState) break;
        }
        if (addressId == null) {
            return null;
        }
        if (address != null && (lb = loadBalancers.get(address)) != null) {
            available = false;
        }
        if (available == null) {
            available = true;
        }
        return new ResourceStatus(addressId, (Object)available);
    }

    public void setTags(@Nonnull String addressId, Tag ... tags) throws CloudException, InternalException {
        this.setTags(new String[]{addressId}, tags);
    }

    public void setTags(@Nonnull String[] addressIds, Tag ... tags) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"IpAddress.setTags");
        try {
            this.removeTags(addressIds, new Tag[0]);
            ((CSCloud)this.getProvider()).createTags(addressIds, "PublicIpAddress", tags);
        }
        finally {
            APITrace.end();
        }
    }

    public void updateTags(@Nonnull String addressId, Tag ... tags) throws CloudException, InternalException {
        this.updateTags(new String[]{addressId}, tags);
    }

    public void updateTags(@Nonnull String[] addressIds, Tag ... tags) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"IpAddress.updateTags");
        try {
            ((CSCloud)this.getProvider()).updateTags(addressIds, "PublicIpAddress", tags);
        }
        finally {
            APITrace.end();
        }
    }

    public void removeTags(@Nonnull String addressId, Tag ... tags) throws CloudException, InternalException {
        this.removeTags(new String[]{addressId}, tags);
    }

    public void removeTags(@Nonnull String[] addressIds, Tag ... tags) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"IpAddress.removeTags");
        try {
            ((CSCloud)this.getProvider()).removeTags(addressIds, "PublicIpAddress", tags);
        }
        finally {
            APITrace.end();
        }
    }
}

