/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.network;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.log4j.Logger;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.OperationNotSupportedException;
import org.dasein.cloud.ResourceStatus;
import org.dasein.cloud.Tag;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.cloudstack.CSException;
import org.dasein.cloud.cloudstack.CSMethod;
import org.dasein.cloud.cloudstack.Param;
import org.dasein.cloud.cloudstack.network.CSNetworkServices;
import org.dasein.cloud.cloudstack.network.CSVlanCapabilities;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.network.AbstractVLANSupport;
import org.dasein.cloud.network.Firewall;
import org.dasein.cloud.network.FirewallSupport;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.InternetGateway;
import org.dasein.cloud.network.IpAddress;
import org.dasein.cloud.network.IpAddressSupport;
import org.dasein.cloud.network.Networkable;
import org.dasein.cloud.network.RoutingTable;
import org.dasein.cloud.network.VLAN;
import org.dasein.cloud.network.VLANCapabilities;
import org.dasein.cloud.network.VLANState;
import org.dasein.cloud.util.APITrace;
import org.dasein.cloud.util.Cache;
import org.dasein.cloud.util.CacheLevel;
import org.dasein.util.uom.time.TimePeriod;
import org.dasein.util.uom.time.TimePeriodUnit;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Network
extends AbstractVLANSupport<CSCloud> {
    public static final Logger logger = Logger.getLogger(Network.class);
    public static final String CREATE_NETWORK = "createNetwork";
    public static final String DELETE_NETWORK = "deleteNetwork";
    public static final String LIST_NETWORK_OFFERINGS = "listNetworkOfferings";
    public static final String LIST_NETWORKS = "listNetworks";
    public static final String CREATE_EGRESS_RULE = "createEgressFirewallRule";
    private volatile transient CSVlanCapabilities capabilities;

    Network(CSCloud provider) {
        super((CloudProvider)provider);
    }

    public List<String> findFreeNetworks() throws CloudException, InternalException {
        ArrayList<String> vlans = new ArrayList<String>();
        for (VLAN n : this.listDefaultNetworks(false, true)) {
            if (n == null || vlans.contains(n.getProviderVlanId())) continue;
            vlans.add(n.getProviderVlanId());
        }
        return vlans;
    }

    @Nonnull
    public VLANCapabilities getCapabilities() throws InternalException, CloudException {
        if (this.capabilities == null) {
            this.capabilities = new CSVlanCapabilities((CSCloud)this.getProvider());
        }
        return this.capabilities;
    }

    @Nonnull
    public Collection<NetworkOffering> getNetworkOfferings(@Nonnull String regionId) throws InternalException, CloudException {
        Collection offerings;
        Cache cache = null;
        if (regionId.equals(this.getContext().getRegionId()) && (offerings = (Collection)(cache = Cache.getInstance((CloudProvider)this.getProvider(), (String)"networkOfferings", NetworkOffering.class, (CacheLevel)CacheLevel.REGION_ACCOUNT, (TimePeriod)new TimePeriod((Number)1, (TimePeriodUnit)TimePeriod.HOUR))).get(this.getContext())) != null) {
            return offerings;
        }
        Document doc = new CSMethod((CSCloud)this.getProvider()).get(LIST_NETWORK_OFFERINGS, new Param("zoneId", regionId));
        NodeList matches = doc.getElementsByTagName("networkoffering");
        ArrayList<NetworkOffering> offerings2 = new ArrayList<NetworkOffering>();
        for (int i = 0; i < matches.getLength(); ++i) {
            Node node = matches.item(i);
            NodeList attributes = node.getChildNodes();
            NetworkOffering offering = new NetworkOffering();
            for (int j = 0; j < attributes.getLength(); ++j) {
                Node n = attributes.item(j);
                String value = n.getChildNodes().getLength() > 0 ? n.getFirstChild().getNodeValue() : null;
                if (n.getNodeName().equals("id") && value != null) {
                    offering.offeringId = value.trim();
                    continue;
                }
                if (n.getNodeName().equalsIgnoreCase("availability")) {
                    offering.availability = value == null ? "unavailable" : value.trim();
                    continue;
                }
                if (!n.getNodeName().equalsIgnoreCase("guestiptype")) continue;
                offering.networkType = value == null ? "direct" : value.trim();
            }
            offerings2.add(offering);
        }
        if (cache != null) {
            cache.put(this.getContext(), offerings2);
        }
        return offerings2;
    }

    @Nullable
    private String getNetworkOffering(@Nonnull String regionId) throws InternalException, CloudException {
        for (NetworkOffering offering : this.getNetworkOfferings(regionId)) {
            if (offering.availability.equalsIgnoreCase("unavailable") || !offering.networkType.equals("Isolated")) continue;
            return offering.offeringId;
        }
        return null;
    }

    @Nullable
    public VLAN getVlan(@Nonnull String vlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.getVlan");
        try {
            Document doc = new CSMethod((CSCloud)this.getProvider()).get(LIST_NETWORKS, new Param("zoneId", this.getContext().getRegionId()), new Param("id", vlanId));
            NodeList matches = doc.getElementsByTagName("network");
            for (int i = 0; i < matches.getLength(); ++i) {
                VLAN vlan;
                Node node = matches.item(i);
                if (node == null || (vlan = this.toNetwork(node)) == null) continue;
                VLAN vLAN = vlan;
                return vLAN;
            }
            VLAN vLAN = null;
            return vLAN;
        }
        catch (CSException e) {
            if (e.getHttpCode() == 431) {
                VLAN vLAN = null;
                return vLAN;
            }
            throw e;
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    public String getAttachedInternetGatewayId(@Nonnull String vlanId) throws CloudException, InternalException {
        return null;
    }

    @Nullable
    public InternetGateway getInternetGatewayById(@Nonnull String gatewayId) throws CloudException, InternalException {
        return null;
    }

    public boolean isSubscribed() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.isSubscribed");
        try {
            CSMethod method = new CSMethod((CSCloud)this.getProvider());
            try {
                method.get(LIST_NETWORKS, new Param("zoneId", this.getContext().getRegionId()));
                boolean bl = true;
                return bl;
            }
            catch (CSException e) {
                block7: {
                    int code = e.getHttpCode();
                    if (code != 403 && code != 401 && code != 531) break block7;
                    boolean bl = false;
                    APITrace.end();
                    return bl;
                }
                throw e;
            }
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<VLAN> listVlans() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.listVlans");
        try {
            CSMethod method = new CSMethod((CSCloud)this.getProvider());
            Document doc = method.get(LIST_NETWORKS, new Param("zoneId", this.getContext().getRegionId()), new Param("canusefordeploy", "true"));
            ArrayList<VLAN> networks = new ArrayList<VLAN>();
            int numPages = 1;
            NodeList nodes = doc.getElementsByTagName("count");
            Node n = nodes.item(0);
            if (n != null) {
                String value = n.getFirstChild().getNodeValue().trim();
                int count = Integer.parseInt(value);
                numPages = count / 500;
                int remainder = count % 500;
                if (remainder > 0) {
                    ++numPages;
                }
            }
            for (int page = 1; page <= numPages; ++page) {
                if (page > 1) {
                    String nextPage = String.valueOf(page);
                    doc = method.get(LIST_NETWORKS, new Param("zoneId", this.getContext().getRegionId()), new Param("pagesize", "500"), new Param("page", nextPage), new Param("canusefordeploy", "true"));
                }
                NodeList matches = doc.getElementsByTagName("network");
                for (int i = 0; i < matches.getLength(); ++i) {
                    VLAN vlan;
                    Node node = matches.item(i);
                    if (node == null || (vlan = this.toNetwork(node)) == null) continue;
                    networks.add(vlan);
                }
            }
            ArrayList<VLAN> arrayList = networks;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public void removeInternetGatewayById(@Nonnull String id) throws CloudException, InternalException {
    }

    @Nonnull
    public Iterable<VLAN> listDefaultNetworks(boolean shared, boolean forDeploy) throws CloudException, InternalException {
        CSMethod method = new CSMethod((CSCloud)this.getProvider());
        ArrayList<Param> params = new ArrayList<Param>();
        params.add(new Param("zoneId", this.getContext().getRegionId()));
        if (forDeploy) {
            params.add(new Param("canUseForDeploy", "true"));
        }
        if (!shared) {
            params.add(new Param("account", this.getContext().getAccountNumber()));
            params.add(new Param("domainid", ((CSCloud)this.getProvider()).getDomainId()));
        }
        Document doc = method.get(LIST_NETWORKS, params);
        ArrayList<VLAN> networks = new ArrayList<VLAN>();
        NodeList matches = doc.getElementsByTagName("network");
        for (int i = 0; i < matches.getLength(); ++i) {
            VLAN vlan;
            Node node = matches.item(i);
            if (node == null || (vlan = this.toNetwork(node)) == null || vlan.getTag("displaynetwork") != null && !vlan.getTag("displaynetwork").equals("true") || vlan.getTag("isdefault") != null && !vlan.getTag("isdefault").equals("true")) continue;
            networks.add(vlan);
        }
        return networks;
    }

    @Nonnull
    public VLAN createVlan(@Nonnull String cidr, @Nonnull String name, @Nonnull String description, @Nullable String domainName, @Nullable String[] dnsServers, @Nullable String[] ntpServers) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.createVlan");
        try {
            if (!this.getCapabilities().allowsNewVlanCreation()) {
                throw new OperationNotSupportedException();
            }
            String regionId = this.getContext().getRegionId();
            if (regionId == null) {
                throw new CloudException("No region was set for this request");
            }
            String offering = this.getNetworkOffering(regionId);
            if (offering == null) {
                throw new CloudException("No offerings exist for " + this.getContext().getRegionId());
            }
            ArrayList<Param> params = new ArrayList<Param>();
            params.add(new Param("zoneId", this.getContext().getRegionId()));
            params.add(new Param("networkOfferingId", offering));
            params.add(new Param("name", name));
            params.add(new Param("displayText", name));
            String[] parts = cidr.split("/");
            String netmask = "255.255.255.255";
            if (parts.length > 0) {
                params.add(new Param("gateway", parts[0]));
            }
            if (parts.length >= 1) {
                int mask;
                netmask = parts[1];
                int prefix = Integer.parseInt(netmask);
                int value = mask = -1 << 32 - prefix;
                byte[] bytes = new byte[]{(byte)(value >>> 24), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
                try {
                    InetAddress netAddr = InetAddress.getByAddress(bytes);
                    netmask = netAddr.getHostAddress();
                }
                catch (UnknownHostException e) {
                    throw new InternalException("Unable to parse netmask from " + cidr);
                }
            }
            params.add(new Param("netmask", netmask));
            CSMethod method = new CSMethod((CSCloud)this.getProvider());
            Document doc = method.get(CREATE_NETWORK, params);
            NodeList matches = doc.getElementsByTagName("network");
            for (int i = 0; i < matches.getLength(); ++i) {
                VLAN network;
                Node node = matches.item(i);
                if (node == null || (network = this.toNetwork(node)) == null) continue;
                try {
                    method.get(CREATE_EGRESS_RULE, new Param("protocol", "All"), new Param("cidrlist", "0.0.0.0/0"), new Param("networkid", network.getProviderVlanId()));
                }
                catch (Throwable ignore) {
                    logger.warn((Object)"Unable to create default egress rule");
                }
                ArrayList<Tag> tags = new ArrayList<Tag>();
                tags.add(new Tag("Name", name));
                tags.add(new Tag("Description", description));
                ((CSCloud)this.getProvider()).createTags(new String[]{network.getProviderVlanId()}, "Network", tags.toArray(new Tag[tags.size()]));
                VLAN vLAN = network;
                return vLAN;
            }
            throw new CloudException("Creation requested failed to create a network without an error");
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    private VLAN toNetwork(@Nullable Node node) throws CloudException, InternalException {
        if (node == null) {
            return null;
        }
        VLAN network = new VLAN();
        String netmask = null;
        String gateway = null;
        NodeList attributes = node.getChildNodes();
        network.setProviderOwnerId(this.getContext().getAccountNumber());
        network.setProviderRegionId(this.getContext().getRegionId());
        network.setCurrentState(VLANState.AVAILABLE);
        network.setSupportedTraffic(new IPVersion[]{IPVersion.IPV4});
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (name.equalsIgnoreCase("id")) {
                network.setProviderVlanId(value);
                continue;
            }
            if (name.equalsIgnoreCase("name")) {
                if (network.getName() != null) continue;
                network.setName(value);
                continue;
            }
            if (name.equalsIgnoreCase("displaytext")) {
                network.setName(value);
                continue;
            }
            if (name.equalsIgnoreCase("displaynetwork")) {
                network.setTag("displaynetwork", value);
                continue;
            }
            if (name.equalsIgnoreCase("isdefault")) {
                network.setTag("isdefault", value);
                continue;
            }
            if (name.equalsIgnoreCase("networkdomain")) {
                network.setDomainName(value);
                continue;
            }
            if (name.equalsIgnoreCase("zoneid") && value != null) {
                network.setProviderRegionId(value);
                continue;
            }
            if (name.startsWith("dns") && value != null && !value.trim().equals("")) {
                String[] dns;
                if (network.getDnsServers() != null) {
                    dns = new String[network.getDnsServers().length + 1];
                    for (int idx = 0; idx < network.getDnsServers().length; ++idx) {
                        dns[idx] = network.getDnsServers()[idx];
                    }
                    dns[dns.length - 1] = value;
                } else {
                    dns = new String[]{value};
                }
                network.setDnsServers(dns);
                continue;
            }
            if (name.equalsIgnoreCase("netmask")) {
                netmask = value;
                continue;
            }
            if (name.equals("gateway")) {
                gateway = value;
                continue;
            }
            if (name.equalsIgnoreCase("networkofferingdisplaytext")) {
                network.setNetworkType(value);
                continue;
            }
            if (!name.equalsIgnoreCase("account")) continue;
            network.setProviderOwnerId(value);
        }
        if (network.getProviderVlanId() == null) {
            return null;
        }
        network.setProviderDataCenterId(network.getProviderRegionId());
        if (network.getName() == null) {
            network.setName(network.getProviderVlanId());
        }
        if (network.getDescription() == null) {
            network.setDescription(network.getName());
        }
        if (gateway != null) {
            if (netmask == null) {
                netmask = "255.255.255.0";
            }
            network.setCidr(netmask, gateway);
        }
        return network;
    }

    @Nonnull
    public String getProviderTermForNetworkInterface(@Nonnull Locale locale) {
        return "NIC";
    }

    @Nonnull
    public String getProviderTermForSubnet(@Nonnull Locale locale) {
        return "network";
    }

    @Nonnull
    public String getProviderTermForVlan(@Nonnull Locale locale) {
        return "network";
    }

    @Nonnull
    public Collection<InternetGateway> listInternetGateways(@Nullable String vlanId) throws CloudException, InternalException {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<Networkable> listResources(@Nonnull String inVlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.listResources");
        try {
            IpAddressSupport ipSupport;
            ArrayList<Object> resources = new ArrayList<Object>();
            CSNetworkServices network = ((CSCloud)this.getProvider()).getNetworkServices();
            FirewallSupport fwSupport = network.getFirewallSupport();
            if (fwSupport != null) {
                for (Firewall fw : fwSupport.list()) {
                    if (!inVlanId.equals(fw.getProviderVlanId())) continue;
                    resources.add(fw);
                }
            }
            if ((ipSupport = network.getIpAddressSupport()) != null) {
                for (IPVersion version : ipSupport.getCapabilities().listSupportedIPVersions()) {
                    for (IpAddress addr : ipSupport.listIpPool(version, false)) {
                        if (!inVlanId.equals(addr.getProviderVlanId())) continue;
                        resources.add(addr);
                    }
                }
            }
            for (RoutingTable table : this.listRoutingTables(inVlanId)) {
                resources.add(table);
            }
            Iterable<VirtualMachine> vms = ((CSCloud)this.getProvider()).getComputeServices().getVirtualMachineSupport().listVirtualMachines();
            for (VirtualMachine vm : vms) {
                if (!inVlanId.equals(vm.getProviderVlanId())) continue;
                resources.add(vm);
            }
            ArrayList<Object> arrayList = resources;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public Iterable<ResourceStatus> listVlanStatus() throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.listVlanStatus");
        try {
            CSMethod method = new CSMethod((CSCloud)this.getProvider());
            Document doc = method.get(LIST_NETWORKS, new Param("zoneId", this.getContext().getRegionId()), new Param("canusefordeploy", "true"));
            ArrayList<ResourceStatus> networks = new ArrayList<ResourceStatus>();
            int numPages = 1;
            NodeList nodes = doc.getElementsByTagName("count");
            Node n = nodes.item(0);
            if (n != null) {
                String value = n.getFirstChild().getNodeValue().trim();
                int count = Integer.parseInt(value);
                numPages = count / 500;
                int remainder = count % 500;
                if (remainder > 0) {
                    ++numPages;
                }
            }
            for (int page = 1; page <= numPages; ++page) {
                if (page > 1) {
                    String nextPage = String.valueOf(page);
                    doc = method.get(LIST_NETWORKS, new Param("zoneId", this.getContext().getRegionId()), new Param("pagesize", "500"), new Param("page", nextPage), new Param("canusefordeploy", "true"));
                }
                NodeList matches = doc.getElementsByTagName("network");
                for (int i = 0; i < matches.getLength(); ++i) {
                    ResourceStatus vlan;
                    Node node = matches.item(i);
                    if (node == null || (vlan = this.toVLANStatus(node)) == null) continue;
                    networks.add(vlan);
                }
            }
            ArrayList<ResourceStatus> arrayList = networks;
            return arrayList;
        }
        finally {
            APITrace.end();
        }
    }

    public void removeVlan(String vlanId) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.removeVlan");
        try {
            Document doc = new CSMethod((CSCloud)this.getProvider()).get(DELETE_NETWORK, new Param("id", vlanId));
            ((CSCloud)this.getProvider()).waitForJob(doc, "Delete VLAN");
        }
        finally {
            APITrace.end();
        }
    }

    @Nullable
    public ResourceStatus toVLANStatus(@Nullable Node node) {
        if (node == null) {
            return null;
        }
        NodeList attributes = node.getChildNodes();
        String networkId = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node attribute = attributes.item(i);
            String name = attribute.getNodeName().toLowerCase();
            String value = attribute.getChildNodes().getLength() > 0 ? attribute.getFirstChild().getNodeValue() : null;
            if (!name.equalsIgnoreCase("id")) continue;
            networkId = value;
            break;
        }
        if (networkId == null) {
            return null;
        }
        return new ResourceStatus(networkId, (Object)VLANState.AVAILABLE);
    }

    public void updateVLANTags(@Nonnull String vlanId, Tag ... tags) throws CloudException, InternalException {
        this.updateVLANTags(new String[]{vlanId}, tags);
    }

    public void updateVLANTags(@Nonnull String[] vlanIds, Tag ... tags) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.updateTags");
        try {
            ((CSCloud)this.getProvider()).updateTags(vlanIds, "Network", tags);
        }
        finally {
            APITrace.end();
        }
    }

    public void removeVLANTags(@Nonnull String vlanId, Tag ... tags) throws CloudException, InternalException {
        this.removeVLANTags(new String[]{vlanId}, tags);
    }

    public void removeVLANTags(@Nonnull String[] vlanIds, Tag ... tags) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.removeTags");
        try {
            ((CSCloud)this.getProvider()).removeTags(vlanIds, "Network", tags);
        }
        finally {
            APITrace.end();
        }
    }

    public void setVLANTags(@Nonnull String vlanId, Tag ... tags) throws CloudException, InternalException {
        this.setVLANTags(new String[]{vlanId}, tags);
    }

    public void setVLANTags(@Nonnull String[] vlanIds, Tag ... tags) throws CloudException, InternalException {
        APITrace.begin((CloudProvider)this.getProvider(), (String)"VLAN.setTags");
        try {
            this.removeVLANTags(vlanIds, new Tag[0]);
            ((CSCloud)this.getProvider()).createTags(vlanIds, "Network", tags);
        }
        finally {
            APITrace.end();
        }
    }

    public static class NetworkOffering {
        public String availability;
        public String networkType;
        public String offeringId;
    }
}

