/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.cloudstack.network;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AbstractCapabilities;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.VisibleScope;
import org.dasein.cloud.cloudstack.CSCloud;
import org.dasein.cloud.network.Direction;
import org.dasein.cloud.network.FirewallCapabilities;
import org.dasein.cloud.network.FirewallConstraints;
import org.dasein.cloud.network.Permission;
import org.dasein.cloud.network.Protocol;
import org.dasein.cloud.network.RuleTargetType;
import org.dasein.cloud.util.NamingConstraints;

public class SecurityGroupCapabilities
extends AbstractCapabilities<CSCloud>
implements FirewallCapabilities {
    public SecurityGroupCapabilities(CSCloud cloud) {
        super((CloudProvider)cloud);
    }

    @Nonnull
    public FirewallConstraints getFirewallConstraintsForCloud() throws InternalException, CloudException {
        return FirewallConstraints.getInstance();
    }

    @Nonnull
    public String getProviderTermForFirewall(@Nonnull Locale locale) {
        return "security group";
    }

    @Nullable
    public VisibleScope getFirewallVisibleScope() {
        return null;
    }

    @Nonnull
    public Requirement identifyPrecedenceRequirement(boolean inVlan) throws InternalException, CloudException {
        return Requirement.NONE;
    }

    public boolean isZeroPrecedenceHighest() throws InternalException, CloudException {
        return true;
    }

    @Deprecated
    @Nonnull
    public Iterable<RuleTargetType> listSupportedDestinationTypes(boolean inVlan) throws InternalException, CloudException {
        return this.listSupportedDestinationTypes(inVlan, Direction.INGRESS);
    }

    @Deprecated
    @Nonnull
    public Iterable<Direction> listSupportedDirections(boolean inVlan) throws InternalException, CloudException {
        if (inVlan) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(Direction.INGRESS, Direction.EGRESS));
    }

    @Nonnull
    public Iterable<Permission> listSupportedPermissions(boolean inVlan) throws InternalException, CloudException {
        if (inVlan) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Permission.ALLOW);
    }

    @Nonnull
    public Iterable<Protocol> listSupportedProtocols(boolean inVlan) throws InternalException, CloudException {
        return Collections.unmodifiableList(Arrays.asList(Protocol.TCP, Protocol.UDP));
    }

    @Deprecated
    @Nonnull
    public Iterable<RuleTargetType> listSupportedSourceTypes(boolean inVlan) throws InternalException, CloudException {
        return this.listSupportedSourceTypes(inVlan, Direction.INGRESS);
    }

    public boolean requiresRulesOnCreation() throws CloudException, InternalException {
        return false;
    }

    @Nonnull
    public Requirement requiresVLAN() throws CloudException, InternalException {
        return Requirement.NONE;
    }

    public boolean supportsRules(@Nonnull Direction direction, @Nonnull Permission permission, boolean inVlan) throws CloudException, InternalException {
        return !inVlan && permission.equals((Object)Permission.ALLOW);
    }

    public boolean supportsFirewallCreation(boolean inVlan) throws CloudException, InternalException {
        return !inVlan;
    }

    public boolean supportsFirewallDeletion() throws CloudException, InternalException {
        return true;
    }

    @Nonnull
    public NamingConstraints getFirewallNamingConstraints() throws CloudException, InternalException {
        return NamingConstraints.getAlphaNumeric((int)1, (int)255);
    }

    @Nonnull
    public Iterable<RuleTargetType> listSupportedDestinationTypes(boolean inVlan, Direction direction) throws InternalException, CloudException {
        if (inVlan) {
            return Collections.emptyList();
        }
        List<Object> supportedDestinationTypes = new ArrayList();
        if (direction.equals((Object)Direction.INGRESS)) {
            supportedDestinationTypes = Collections.singletonList(RuleTargetType.GLOBAL);
        } else if (direction.equals((Object)Direction.EGRESS)) {
            supportedDestinationTypes = Collections.singletonList(RuleTargetType.CIDR);
        }
        return supportedDestinationTypes;
    }

    @Nonnull
    public Iterable<RuleTargetType> listSupportedSourceTypes(boolean inVlan, Direction direction) throws InternalException, CloudException {
        if (inVlan) {
            return Collections.emptyList();
        }
        List<Object> supportedSourceTypes = new ArrayList();
        if (direction.equals((Object)Direction.INGRESS)) {
            supportedSourceTypes = Collections.singletonList(RuleTargetType.CIDR);
        } else if (direction.equals((Object)Direction.EGRESS)) {
            supportedSourceTypes = Collections.singletonList(RuleTargetType.GLOBAL);
        }
        return supportedSourceTypes;
    }
}

