/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud;

import javax.annotation.Nonnegative;
import javax.annotation.Nullable;

public class AsynchronousTask<T> {
    private double percentComplete;
    private long endTime = -1L;
    private T result;
    private long startTime = System.currentTimeMillis();
    private Throwable taskError;

    public synchronized void complete(@Nullable Throwable withError) {
        this.taskError = withError;
        this.endTime = System.currentTimeMillis();
        this.notifyAll();
    }

    public synchronized void completeWithResult(@Nullable T result) {
        this.result = result;
        this.endTime = System.currentTimeMillis();
        this.notifyAll();
    }

    public synchronized boolean isComplete() {
        return this.endTime > -1L;
    }

    public synchronized long getDuration() {
        if (this.endTime == -1L) {
            return System.currentTimeMillis() - this.startTime;
        }
        return this.endTime - this.startTime;
    }

    @Nonnegative
    public synchronized double getPercentComplete() {
        return this.percentComplete;
    }

    public synchronized void setPercentComplete(@Nonnegative double percentComplete) {
        this.percentComplete = percentComplete;
        this.notifyAll();
    }

    @Nonnegative
    public synchronized long getEndTime() {
        return this.endTime;
    }

    @Nullable
    public T getResult() {
        return this.result;
    }

    @Nonnegative
    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(@Nonnegative long startTime) {
        this.startTime = startTime;
    }

    @Nullable
    public Throwable getTaskError() {
        return this.taskError;
    }
}

