/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.CloudErrorType;

public class CloudException
extends Exception {
    private static final long serialVersionUID = -1975104091752615199L;
    private CloudErrorType errorType;
    private int httpCode;
    private String providerCode;

    public CloudException() {
    }

    public CloudException(@Nonnull String msg) {
        super(msg);
    }

    public CloudException(@Nonnull Throwable cause) {
        super(cause);
    }

    public CloudException(@Nonnull CloudErrorType type, @Nonnegative int httpCode, @Nullable String providerCode, @Nonnull String msg) {
        super(msg);
        this.errorType = type;
        this.httpCode = httpCode;
        this.providerCode = providerCode;
    }

    @Nonnegative
    public int getHttpCode() {
        return this.httpCode;
    }

    @Nonnull
    public CloudErrorType getErrorType() {
        return this.errorType == null ? CloudErrorType.GENERAL : this.errorType;
    }

    @Nonnull
    public String getProviderCode() {
        return this.providerCode == null ? "" : this.providerCode;
    }
}

