/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud;

import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.ProviderContext;
import org.dasein.cloud.admin.AdminServices;
import org.dasein.cloud.compute.ComputeServices;
import org.dasein.cloud.dc.DataCenterServices;
import org.dasein.cloud.identity.IdentityServices;
import org.dasein.cloud.network.NetworkServices;
import org.dasein.cloud.platform.PlatformServices;
import org.dasein.cloud.storage.StorageServices;

public abstract class CloudProvider {
    private CloudProvider computeCloud = null;
    private ProviderContext context = null;
    private int holdCount = 0;
    private CloudProvider storageCloudProvider = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        int h;
        CloudProvider cloudProvider = this;
        synchronized (cloudProvider) {
            h = this.holdCount;
        }
        if (h > 0) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    CloudProvider.this.waitForHold();
                }
            };
            t.setName("Close Hold for " + this);
            t.setDaemon(true);
            t.start();
        } else {
            this.waitForHold();
        }
    }

    public final void connect(@Nonnull ProviderContext context) {
        this.connect(context, null);
    }

    public final void connect(@Nonnull ProviderContext context, @Nullable CloudProvider computeProvider) {
        this.close();
        this.context = context;
        this.computeCloud = computeProvider;
    }

    @Nullable
    public abstract AdminServices getAdminServices();

    public final CloudProvider getComputeCloud() {
        return this.computeCloud;
    }

    @Nullable
    public final ProviderContext getContext() {
        return this.context;
    }

    @Nonnull
    public abstract String getCloudName();

    @Nonnull
    public abstract DataCenterServices getDataCenterServices();

    @Nullable
    public abstract ComputeServices getComputeServices();

    @Nullable
    public abstract IdentityServices getIdentityServices();

    @Nullable
    public abstract NetworkServices getNetworkServices();

    @Nullable
    public abstract PlatformServices getPlatformServices();

    @Nonnull
    public abstract String getProviderName();

    @Nullable
    public synchronized StorageServices getStorageServices() {
        if (this.storageCloudProvider != null) {
            return this.storageCloudProvider.getStorageServices();
        }
        ProviderContext computeContext = this.getContext();
        String storage = computeContext.getStorage();
        if (storage == null) {
            return null;
        }
        try {
            CloudProvider p = (CloudProvider)Class.forName(storage).newInstance();
            ProviderContext ctx = new ProviderContext();
            Properties props = computeContext.getStorageCustomProperties();
            ctx.setRegionId(computeContext.getRegionId());
            ctx.setCloudName(computeContext.getCloudName());
            ctx.setProviderName(computeContext.getProviderName());
            ctx.setEffectiveAccountNumber(computeContext.getEffectiveAccountNumber());
            ctx.setEndpoint(computeContext.getStorageEndpoint());
            ctx.setAccountNumber(computeContext.getStorageAccountNumber());
            ctx.setAccessKeys(computeContext.getStoragePublic(), computeContext.getStoragePrivate());
            ctx.setX509Cert(computeContext.getStorageX509Cert());
            ctx.setX509Key(computeContext.getStorageX509Key());
            ctx.setCustomProperties(props == null ? new Properties() : props);
            p.connect(ctx, this);
            this.storageCloudProvider = p;
            return p.getStorageServices();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public boolean hasComputeServices() {
        return this.getComputeServices() != null;
    }

    public boolean hasIdentityServices() {
        return this.getIdentityServices() != null;
    }

    public boolean hasNetworkServices() {
        return this.getNetworkServices() != null;
    }

    public boolean hasPlatformServices() {
        return this.getPlatformServices() != null;
    }

    public boolean hasStorageServices() {
        return this.getStorageServices() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hold() {
        if (this.computeCloud != null) {
            this.computeCloud.hold();
        } else {
            CloudProvider cloudProvider = this;
            synchronized (cloudProvider) {
                ++this.holdCount;
            }
        }
    }

    public synchronized boolean isConnected() {
        return this.context != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (this.computeCloud != null) {
            this.computeCloud.release();
        } else {
            CloudProvider cloudProvider = this;
            synchronized (cloudProvider) {
                --this.holdCount;
                this.notifyAll();
            }
        }
    }

    public String testContext() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForHold() {
        long timeout = System.currentTimeMillis() + 1200000L;
        while (timeout > System.currentTimeMillis()) {
            CloudProvider cloudProvider = this;
            synchronized (cloudProvider) {
                if (this.holdCount < 1) {
                    break;
                }
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.context != null) {
            this.context.clear();
            this.context = null;
        }
        if (this.storageCloudProvider != null) {
            this.storageCloudProvider.close();
            this.storageCloudProvider = null;
        }
    }
}

