/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud;

import java.util.Arrays;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NameRules {
    private boolean allowNumbers;
    private boolean mixedCase;
    private int maximumCharacters;
    private int minimumCharacters;
    private boolean onlyLatin1;
    private char[] specialCharacters;

    public static NameRules getInstance(@Nonnegative int minChars, @Nonnegative int maxChars, boolean mixedCase, boolean allowNumbers, boolean latin1Only, @Nullable char[] specialChars) {
        NameRules rules = new NameRules();
        rules.allowNumbers = allowNumbers;
        rules.mixedCase = mixedCase;
        rules.maximumCharacters = maxChars;
        rules.minimumCharacters = minChars;
        rules.onlyLatin1 = latin1Only;
        rules.specialCharacters = specialChars;
        return rules;
    }

    private NameRules() {
    }

    public boolean isAllowNumbers() {
        return this.allowNumbers;
    }

    public boolean isMixedCase() {
        return this.mixedCase;
    }

    public int getMaximumCharacters() {
        return this.maximumCharacters;
    }

    public int getMinimumCharacters() {
        return this.minimumCharacters;
    }

    public boolean isOnlyLatin1() {
        return this.onlyLatin1;
    }

    public char[] getSpecialCharacters() {
        return this.specialCharacters;
    }

    public boolean isValidName(@Nonnull String name) {
        if (this.maximumCharacters < name.length()) {
            return false;
        }
        if (this.minimumCharacters > name.length()) {
            return false;
        }
        for (char c : name.toCharArray()) {
            if (c >= 'a' && c <= 'z') continue;
            if (c >= 'A' && c <= 'Z') {
                if (this.mixedCase) continue;
                return false;
            }
            if (c >= '0' && c <= '9') {
                if (this.allowNumbers) continue;
                return false;
            }
            if (Character.isLetterOrDigit(c)) {
                if (!this.onlyLatin1) continue;
                return false;
            }
            if (this.specialCharacters == null) continue;
            boolean ok = false;
            for (char s : this.specialCharacters) {
                if (s != c) continue;
                ok = true;
            }
            if (ok) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public String validName(@Nonnull String originalName) {
        StringBuilder newName = new StringBuilder();
        String special = null;
        if (!this.mixedCase) {
            originalName = originalName.toLowerCase();
        }
        if (this.specialCharacters != null) {
            for (char c : this.specialCharacters) {
                if (c != '_' && special != null) continue;
                special = String.valueOf(c);
            }
        }
        for (char c : originalName.toCharArray()) {
            if (c >= 'a' && c <= 'z') {
                newName.append(c);
                continue;
            }
            if (c >= '0' && c <= '9') {
                if (this.allowNumbers) {
                    newName.append(c);
                    continue;
                }
                if (special == null) continue;
                newName.append(special);
                continue;
            }
            if (Character.isLetterOrDigit(c)) {
                if (!this.onlyLatin1) {
                    newName.append(c);
                    continue;
                }
                if (special == null) continue;
                newName.append(special);
                continue;
            }
            if (special == null) continue;
            for (char s : special.toCharArray()) {
                if (s != c) continue;
                newName.append(c);
            }
        }
        if (newName.length() > this.maximumCharacters) {
            return newName.toString().substring(0, this.maximumCharacters);
        }
        while (newName.length() < this.minimumCharacters) {
            newName.append('x');
        }
        return newName.toString();
    }

    @Nonnull
    public String toString() {
        return "min=" + this.minimumCharacters + ",max=" + this.maximumCharacters + ",mixed=" + this.mixedCase + ",numbers=" + this.allowNumbers + ",onlyLatin=" + this.onlyLatin1 + ",special=" + Arrays.toString(this.specialCharacters);
    }
}

