/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud;

import java.io.Serializable;
import java.util.Properties;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ProviderContext
implements Serializable {
    private static final long serialVersionUID = 3503959903660616914L;
    private static final Random random = new Random();
    private byte[] accessPrivate;
    private byte[] accessPublic;
    private String accountNumber;
    private String cloudName;
    private Properties customProperties;
    private String effectiveAccountNumber;
    private String endpoint;
    private String providerName;
    private String regionId;
    private String storage;
    private String storageAccountNumber;
    private Properties storageCustomProperties;
    private String storageEndpoint;
    private byte[] storagePrivate;
    private byte[] storagePublic;
    private byte[] storageX509Cert;
    private byte[] storageX509Key;
    private byte[] x509Cert;
    private byte[] x509Key;

    public static void clear(byte[] ... keys) {
        if (keys != null) {
            for (byte[] key : keys) {
                if (key == null) continue;
                random.nextBytes(key);
            }
        }
    }

    public ProviderContext() {
    }

    public ProviderContext(@Nonnull String accountNumber, @Nonnull String inRegionId) {
        this.accountNumber = accountNumber;
        this.regionId = inRegionId;
    }

    public void clear() {
        ProviderContext.clear(this.accessPublic, this.accessPrivate, this.storagePublic, this.storagePrivate, this.x509Cert, this.x509Key, this.storageX509Cert, this.storageX509Key);
    }

    @Nullable
    public byte[] getAccessPrivate() {
        return this.accessPrivate;
    }

    @Nullable
    public byte[] getAccessPublic() {
        return this.accessPublic;
    }

    @Nonnull
    public String getAccountNumber() {
        return this.accountNumber;
    }

    @Nullable
    public String getCloudName() {
        return this.cloudName;
    }

    @Nullable
    public Properties getCustomProperties() {
        if (this.customProperties == null) {
            return new Properties();
        }
        return this.customProperties;
    }

    @Nullable
    public String getEndpoint() {
        return this.endpoint;
    }

    @Nullable
    public String getProviderName() {
        return this.providerName;
    }

    @Nullable
    public String getRegionId() {
        return this.regionId;
    }

    @Nullable
    public byte[] getStoragePrivate() {
        return this.storagePrivate;
    }

    @Nullable
    public byte[] getStoragePublic() {
        return this.storagePublic;
    }

    public void setAccessKeys(@Nullable byte[] publicKey, @Nullable byte[] privateKey) {
        this.accessPublic = publicKey;
        this.accessPrivate = privateKey;
    }

    public void setAccessPrivate(@Nullable byte[] accessPrivate) {
        this.accessPrivate = accessPrivate;
    }

    public void setAccessPublic(@Nullable byte[] accessPublic) {
        this.accessPublic = accessPublic;
    }

    public void setAccountNumber(@Nonnull String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public void setCloudName(@Nullable String name) {
        this.cloudName = name;
    }

    public void setCustomProperties(@Nonnull Properties properties) {
        this.customProperties = properties;
    }

    public void setEndpoint(@Nullable String endpoint) {
        this.endpoint = endpoint;
    }

    public void setProviderName(@Nullable String name) {
        this.providerName = name;
    }

    public void setRegionId(@Nullable String regionId) {
        this.regionId = regionId;
    }

    public void setStorageKeys(@Nullable byte[] publicKey, @Nullable byte[] privateKey) {
        this.storagePublic = publicKey;
        this.storagePrivate = privateKey;
    }

    public void setStoragePrivate(@Nullable byte[] storagePrivate) {
        this.storagePrivate = storagePrivate;
    }

    public void setStoragePublic(@Nullable byte[] storagePublic) {
        this.storagePublic = storagePublic;
    }

    public String getStorage() {
        return this.storage;
    }

    public void setStorage(String storage) {
        this.storage = storage;
    }

    public String getStorageAccountNumber() {
        return this.storageAccountNumber;
    }

    public void setStorageAccountNumber(String storageAccountNumber) {
        this.storageAccountNumber = storageAccountNumber;
    }

    public byte[] getX509Cert() {
        return this.x509Cert;
    }

    public void setX509Cert(byte[] x509Cert) {
        this.x509Cert = x509Cert;
    }

    public byte[] getX509Key() {
        return this.x509Key;
    }

    public void setX509Key(byte[] x509Key) {
        this.x509Key = x509Key;
    }

    public static Random getRandom() {
        return random;
    }

    public byte[] getStorageX509Cert() {
        return this.storageX509Cert;
    }

    public void setStorageX509Cert(byte[] storageX509Cert) {
        this.storageX509Cert = storageX509Cert;
    }

    public byte[] getStorageX509Key() {
        return this.storageX509Key;
    }

    public void setStorageX509Key(byte[] storageX509Key) {
        this.storageX509Key = storageX509Key;
    }

    public void setStorageEndpoint(String storageEndpoint) {
        this.storageEndpoint = storageEndpoint;
    }

    public String getStorageEndpoint() {
        return this.storageEndpoint;
    }

    public void setEffectiveAccountNumber(String effectiveAccountNumber) {
        this.effectiveAccountNumber = effectiveAccountNumber;
    }

    public String getEffectiveAccountNumber() {
        if (this.effectiveAccountNumber == null) {
            return this.getAccountNumber();
        }
        return this.effectiveAccountNumber;
    }

    public void setStorageCustomProperties(Properties storageCustomProperties) {
        this.storageCustomProperties = storageCustomProperties;
    }

    public Properties getStorageCustomProperties() {
        return this.storageCustomProperties;
    }
}

