/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.compute;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import org.dasein.cloud.Tag;
import org.dasein.cloud.Taggable;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.MachineImageState;
import org.dasein.cloud.compute.MachineImageType;
import org.dasein.cloud.compute.Platform;

public class MachineImage
implements Taggable {
    private static final long serialVersionUID = 3254097599257280038L;
    private Architecture architecture;
    private MachineImageState currentState;
    private Map<String, String> tags;
    private String description;
    private String name;
    private Platform platform;
    private String providerMachineImageId;
    private String providerOwnerId;
    private String providerRegionId;
    private String software;
    private MachineImageType type;

    public boolean equals(Object ob) {
        if (ob == null) {
            return false;
        }
        if (ob == this) {
            return true;
        }
        if (ob instanceof MachineImage) {
            MachineImage image = (MachineImage)ob;
            if (!this.providerRegionId.equals(image.providerRegionId)) {
                return false;
            }
            return this.providerMachineImageId.equals(image.providerMachineImageId);
        }
        return false;
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(Architecture architecture) {
        this.architecture = architecture;
    }

    public MachineImageState getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(MachineImageState currentState) {
        this.currentState = currentState;
    }

    public void addTag(Tag t) {
        this.addTag(t.getKey(), t.getValue());
    }

    public void addTag(String key, String value) {
        this.getTags().put(key, value);
    }

    public Object getTag(String tag) {
        return this.getTags().get(tag);
    }

    @Override
    @Nonnull
    public synchronized Map<String, String> getTags() {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        return this.tags;
    }

    @Override
    public void setTag(@Nonnull String key, @Nonnull String value) {
        this.getTags().put(key, value);
    }

    public synchronized void setTags(Map<String, String> properties) {
        this.getTags().clear();
        this.getTags().putAll(properties);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public String getProviderMachineImageId() {
        return this.providerMachineImageId;
    }

    public void setProviderMachineImageId(String providerMachineImageId) {
        this.providerMachineImageId = providerMachineImageId;
    }

    public String getProviderOwnerId() {
        return this.providerOwnerId;
    }

    public void setProviderOwnerId(String providerOwnerId) {
        this.providerOwnerId = providerOwnerId;
    }

    public String getProviderRegionId() {
        return this.providerRegionId;
    }

    public void setProviderRegionId(String providerRegionId) {
        this.providerRegionId = providerRegionId;
    }

    public String getSoftware() {
        return this.software;
    }

    public void setSoftware(String software) {
        this.software = software;
    }

    public MachineImageType getType() {
        return this.type;
    }

    public void setType(MachineImageType type) {
        this.type = type;
    }

    public int hashCode() {
        return (this.providerRegionId + this.providerMachineImageId).hashCode();
    }

    public String toString() {
        return this.name + " [" + this.providerMachineImageId + "]";
    }
}

