/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.compute;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AccessControlledService;
import org.dasein.cloud.AsynchronousTask;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.MachineImage;
import org.dasein.cloud.compute.MachineImageFormat;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.identity.ServiceAction;

public interface MachineImageSupport
extends AccessControlledService {
    public static final ServiceAction ANY = new ServiceAction("IMAGE:ANY");
    public static final ServiceAction DOWNLOAD_IMAGE = new ServiceAction("IMAGE:DOWNLOAD_IMAGE");
    public static final ServiceAction GET_IMAGE = new ServiceAction("IMAGE:GET_IMAGE");
    public static final ServiceAction IMAGE_VM = new ServiceAction("IMAGE:IMAGE_VM");
    public static final ServiceAction LIST_IMAGE = new ServiceAction("IMAGE:LIST_IMAGE");
    public static final ServiceAction MAKE_PUBLIC = new ServiceAction("IMAGE:MAKE_PUBLIC");
    public static final ServiceAction REGISTER_IMAGE = new ServiceAction("IMAGE:REGISTER_IMAGE");
    public static final ServiceAction REMOVE_IMAGE = new ServiceAction("IMAGE:REMOVE_IMAGE");
    public static final ServiceAction SHARE_IMAGE = new ServiceAction("IMAGE:SHARE_IMAGE");
    public static final ServiceAction UPLOAD_IMAGE = new ServiceAction("IMAGE:UPLOAD_IMAGE");

    public void downloadImage(@Nonnull String var1, @Nonnull OutputStream var2) throws CloudException, InternalException;

    @Nullable
    public MachineImage getMachineImage(@Nonnull String var1) throws CloudException, InternalException;

    @Nonnull
    public String getProviderTermForImage(@Nonnull Locale var1);

    public boolean hasPublicLibrary();

    @Nonnull
    public AsynchronousTask<String> imageVirtualMachine(String var1, String var2, String var3) throws CloudException, InternalException;

    @Nonnull
    public AsynchronousTask<String> imageVirtualMachineToStorage(String var1, String var2, String var3, String var4) throws CloudException, InternalException;

    @Nonnull
    public String installImageFromUpload(@Nonnull MachineImageFormat var1, @Nonnull InputStream var2) throws CloudException, InternalException;

    public boolean isImageSharedWithPublic(@Nonnull String var1) throws CloudException, InternalException;

    public boolean isSubscribed() throws CloudException, InternalException;

    @Nonnull
    public Iterable<MachineImage> listMachineImages() throws CloudException, InternalException;

    @Nonnull
    public Iterable<MachineImage> listMachineImagesOwnedBy(String var1) throws CloudException, InternalException;

    @Nonnull
    public Iterable<MachineImageFormat> listSupportedFormats() throws CloudException, InternalException;

    @Nonnull
    public Iterable<String> listShares(@Nonnull String var1) throws CloudException, InternalException;

    @Nonnull
    public String registerMachineImage(String var1) throws CloudException, InternalException;

    public void remove(@Nonnull String var1) throws CloudException, InternalException;

    @Nonnull
    public Iterable<MachineImage> searchMachineImages(@Nullable String var1, @Nullable Platform var2, @Nullable Architecture var3) throws CloudException, InternalException;

    public void shareMachineImage(@Nonnull String var1, @Nonnull String var2, boolean var3) throws CloudException, InternalException;

    public boolean supportsCustomImages();

    public boolean supportsImageSharing();

    public boolean supportsImageSharingWithPublic();

    @Nonnull
    public String transfer(@Nonnull CloudProvider var1, @Nonnull String var2) throws CloudException, InternalException;
}

