/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.compute;

public enum Platform {
    UNIX,
    UBUNTU,
    DEBIAN,
    SOLARIS,
    FEDORA_CORE,
    RHEL,
    FREE_BSD,
    OPEN_BSD,
    CENT_OS,
    WINDOWS,
    UNKNOWN;


    public static Platform guess(String name) {
        if (name == null) {
            return UNKNOWN;
        }
        if ((name = name.toLowerCase()).indexOf("centos") > -1) {
            return CENT_OS;
        }
        if (name.indexOf("ubuntu") > -1) {
            return UBUNTU;
        }
        if (name.indexOf("fedora") > -1) {
            return FEDORA_CORE;
        }
        if (name.indexOf("windows") > -1) {
            return WINDOWS;
        }
        if (name.indexOf("linux") > -1) {
            return UNIX;
        }
        if (name.indexOf("red hat") > -1 || name.indexOf("redhat") > -1 || name.indexOf("red-hat") > -1 || name.indexOf("rhel") > -1) {
            return RHEL;
        }
        if (name.indexOf("debian") > -1) {
            return DEBIAN;
        }
        if (name.indexOf("bsd") > -1) {
            if (name.indexOf("free") > -1) {
                return FREE_BSD;
            }
            if (name.indexOf("open") > -1) {
                return OPEN_BSD;
            }
            return UNIX;
        }
        if (name.indexOf("solaris") > -1) {
            return SOLARIS;
        }
        return UNKNOWN;
    }

    public String getDeviceId(String letter) {
        switch (this) {
            case WINDOWS: {
                return "xvd" + letter;
            }
        }
        return "sd" + letter;
    }

    public String getDeviceMapping(String letter) {
        switch (this) {
            case WINDOWS: {
                return "xvd" + letter;
            }
        }
        return "/dev/sd" + letter;
    }

    public boolean isBsd() {
        return this.equals((Object)FREE_BSD) || this.equals((Object)OPEN_BSD);
    }

    public boolean isLinux() {
        switch (this) {
            case WINDOWS: 
            case SOLARIS: 
            case FREE_BSD: 
            case OPEN_BSD: 
            case UNKNOWN: {
                return false;
            }
        }
        return true;
    }

    public boolean isOpen() {
        return this.isLinux() || this.isBsd() || this.equals((Object)SOLARIS);
    }

    public boolean isUnix() {
        return !this.isWindows() && !this.equals((Object)UNKNOWN);
    }

    public boolean isWindows() {
        return this.equals((Object)WINDOWS);
    }

    public String toString() {
        switch (this) {
            case UNIX: {
                return "Generic Unix";
            }
            case UBUNTU: {
                return "Ubuntu";
            }
            case DEBIAN: {
                return "Debian";
            }
            case SOLARIS: {
                return "Solaris";
            }
            case FEDORA_CORE: {
                return "Fedora";
            }
            case RHEL: {
                return "Red Hat";
            }
            case FREE_BSD: {
                return "FreeBSD";
            }
            case OPEN_BSD: {
                return "OpenBSD";
            }
            case CENT_OS: {
                return "CentOS";
            }
            case WINDOWS: {
                return "Windows";
            }
        }
        return "Unknown";
    }
}

