/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.compute;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.compute.VolumeCreateOptions;
import org.dasein.cloud.network.NICCreateOptions;

public class VMLaunchOptions {
    private String bootstrapKey;
    private String bootstrapPassword;
    private String bootstrapUser;
    private String dataCenterId;
    private String description;
    private boolean extendedAnalytics;
    private String[] firewallIds;
    private String friendlyName;
    private String hostName;
    private String machineImageId;
    private Map<String, Object> metaData;
    private String networkProductId;
    private NICConfig[] networkInterfaces;
    private boolean preventApiTermination;
    private String rootVolumeProductId;
    private String standardProductId;
    private String[] staticIpIds;
    private String userData;
    private String vlanId;
    private VolumeAttachment[] volumes;

    @Nonnull
    public static VMLaunchOptions getInstance(@Nonnull String withStandardProductId, @Nonnull String usingMachineImageId, @Nonnull String havingFriendlyName, @Nonnull String withDescription) {
        return new VMLaunchOptions(withStandardProductId, usingMachineImageId, havingFriendlyName, havingFriendlyName, withDescription);
    }

    @Nonnull
    public static VMLaunchOptions getInstance(@Nonnull String withStandardProductId, @Nonnull String usingMachineImageId, @Nonnull String withHostName, @Nonnull String havingFriendlyName, @Nonnull String withDescription) {
        return new VMLaunchOptions(withStandardProductId, usingMachineImageId, withHostName, havingFriendlyName, withDescription);
    }

    private VMLaunchOptions() {
    }

    private VMLaunchOptions(@Nonnull String standardProductId, @Nonnull String machineImageId, @Nonnull String hostName, @Nonnull String friendlyName, @Nonnull String description) {
        this.standardProductId = standardProductId;
        this.machineImageId = machineImageId;
        this.description = description;
        this.hostName = hostName;
        this.friendlyName = friendlyName;
        this.extendedAnalytics = false;
    }

    @Nullable
    public String getBootstrapKey() {
        return this.bootstrapKey;
    }

    @Nullable
    public String getBootstrapPassword() {
        return this.bootstrapPassword;
    }

    @Nullable
    public String getBootstrapUser() {
        return this.bootstrapUser;
    }

    @Nullable
    public String getDataCenterId() {
        return this.dataCenterId;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    public boolean isExtendedAnalytics() {
        return this.extendedAnalytics;
    }

    @Nonnull
    public String[] getFirewallIds() {
        return this.firewallIds == null ? new String[]{} : this.firewallIds;
    }

    @Nonnull
    public String getFriendlyName() {
        return this.friendlyName;
    }

    @Nonnull
    public String getHostName() {
        return this.hostName;
    }

    @Nonnull
    public String getMachineImageId() {
        return this.machineImageId;
    }

    @Nonnull
    public Map<String, Object> getMetaData() {
        return this.metaData == null ? new HashMap() : this.metaData;
    }

    @Nullable
    public String getNetworkProductId() {
        return this.networkProductId;
    }

    public boolean isPreventApiTermination() {
        return this.preventApiTermination;
    }

    public NICConfig[] getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    @Nullable
    public String getRootVolumeProductId() {
        return this.rootVolumeProductId;
    }

    @Nonnull
    public String getStandardProductId() {
        return this.standardProductId;
    }

    @Nullable
    public String getUserData() {
        return this.userData;
    }

    @Nullable
    public String getVlanId() {
        return this.vlanId;
    }

    @Nonnull
    public VolumeAttachment[] getVolumes() {
        return this.volumes == null ? new VolumeAttachment[]{} : this.volumes;
    }

    @Nonnull
    public VMLaunchOptions behindFirewalls(String ... firewallIds) {
        if (this.firewallIds == null || this.firewallIds.length < 1) {
            this.firewallIds = firewallIds;
        } else if (firewallIds.length > 0) {
            String[] tmp = new String[this.firewallIds.length + firewallIds.length];
            int i = 0;
            for (String id : this.firewallIds) {
                tmp[i++] = id;
            }
            for (String id : firewallIds) {
                tmp[i++] = id;
            }
            this.firewallIds = tmp;
        }
        return this;
    }

    @Nonnull
    public VMLaunchOptions inDataCenter(@Nonnull String dataCenterId) {
        this.dataCenterId = dataCenterId;
        return this;
    }

    @Nonnull
    public VMLaunchOptions preventAPITermination() {
        this.preventApiTermination = true;
        return this;
    }

    @Nonnull
    public VMLaunchOptions inVlan(@Nullable String networkProductId, @Nonnull String dataCenterId, @Nonnull String vlanId) {
        this.networkProductId = networkProductId;
        this.dataCenterId = dataCenterId;
        this.vlanId = vlanId;
        return this;
    }

    @Nonnull
    public VMLaunchOptions withAttachments(VolumeAttachment ... attachments) {
        if (this.volumes == null || this.volumes.length < 1) {
            this.volumes = attachments;
        } else if (attachments.length > 0) {
            VolumeAttachment[] tmp = new VolumeAttachment[this.volumes.length + attachments.length];
            int i = 0;
            for (VolumeAttachment a : this.volumes) {
                tmp[i++] = a;
            }
            for (VolumeAttachment a : attachments) {
                tmp[i++] = a;
            }
            this.volumes = tmp;
        }
        return this;
    }

    @Nonnull
    public VMLaunchOptions withAttachments(VolumeCreateOptions ... toBeCreated) {
        int i = 0;
        if (this.volumes != null && this.volumes.length > 0) {
            VolumeAttachment[] tmp = new VolumeAttachment[this.volumes.length + toBeCreated.length];
            for (VolumeAttachment a : this.volumes) {
                tmp[i++] = a;
            }
            this.volumes = tmp;
        } else {
            this.volumes = new VolumeAttachment[toBeCreated.length];
        }
        for (VolumeCreateOptions options : toBeCreated) {
            VolumeAttachment a;
            a = new VolumeAttachment();
            a.deviceId = options.getDeviceId();
            a.volumeToCreate = options;
            this.volumes[i++] = a;
        }
        return this;
    }

    @Nonnull
    public VMLaunchOptions withAttachment(@Nonnull String existingVolumeId, @Nonnull String withDeviceId) {
        VolumeAttachment a = new VolumeAttachment();
        a.deviceId = withDeviceId;
        a.existingVolumeId = existingVolumeId;
        if (this.volumes == null || this.volumes.length < 1) {
            this.volumes = new VolumeAttachment[]{a};
        } else {
            VolumeAttachment[] tmp = new VolumeAttachment[this.volumes.length + 1];
            int i = 0;
            for (VolumeAttachment current : this.volumes) {
                tmp[i++] = current;
            }
            tmp[i] = a;
            this.volumes = tmp;
        }
        return this;
    }

    @Nonnull
    public VMLaunchOptions withBoostrapKey(@Nonnull String key) {
        this.bootstrapKey = key;
        return this;
    }

    @Nonnull
    public VMLaunchOptions withBootstrapUser(@Nonnull String user, @Nonnull String password) {
        this.bootstrapUser = user;
        this.bootstrapPassword = password;
        return this;
    }

    @Nonnull
    public VMLaunchOptions withExtendedAnalytics() {
        this.extendedAnalytics = true;
        return this;
    }

    @Nonnull
    public VMLaunchOptions withMetaData(@Nonnull String key, @Nonnull Object value) {
        if (this.metaData == null) {
            this.metaData = new HashMap<String, Object>();
        }
        this.metaData.put(key, value);
        return this;
    }

    @Nonnull
    public VMLaunchOptions withMetaData(@Nonnull Map<String, Object> metaData) {
        if (this.metaData == null) {
            this.metaData = new HashMap<String, Object>();
        }
        this.metaData.putAll(metaData);
        return this;
    }

    @Nonnull
    public VMLaunchOptions withNetworkInterfaces(String ... nicIds) {
        if (this.networkInterfaces == null || this.networkInterfaces.length < 1) {
            int i = 0;
            this.networkInterfaces = new NICConfig[nicIds.length];
            for (String id : nicIds) {
                NICConfig cfg = new NICConfig();
                cfg.nicId = id;
                this.networkInterfaces[i++] = cfg;
            }
        } else if (nicIds.length > 0) {
            NICConfig[] tmp = new NICConfig[this.networkInterfaces.length + nicIds.length];
            int i = 0;
            for (NICConfig cfg : this.networkInterfaces) {
                tmp[i++] = cfg;
            }
            for (String id : nicIds) {
                NICConfig cfg = new NICConfig();
                cfg.nicId = id;
                tmp[i++] = cfg;
            }
            this.networkInterfaces = tmp;
        }
        return this;
    }

    @Nonnull
    public VMLaunchOptions withNetworkInterfaces(NICCreateOptions ... options) {
        if (this.networkInterfaces == null || this.networkInterfaces.length < 1) {
            int i = 0;
            this.networkInterfaces = new NICConfig[options.length];
            for (NICCreateOptions opt : options) {
                NICConfig cfg = new NICConfig();
                cfg.nicToCreate = opt;
                this.networkInterfaces[i++] = cfg;
            }
        } else if (options.length > 0) {
            NICConfig[] tmp = new NICConfig[this.networkInterfaces.length + options.length];
            int i = 0;
            for (NICConfig cfg : this.networkInterfaces) {
                tmp[i++] = cfg;
            }
            for (NICCreateOptions opt : options) {
                NICConfig cfg = new NICConfig();
                cfg.nicToCreate = opt;
                tmp[i++] = cfg;
            }
            this.networkInterfaces = tmp;
        }
        return this;
    }

    @Nonnull
    public VMLaunchOptions withRootVolumeProduct(@Nonnull String volumeProductId) {
        this.rootVolumeProductId = volumeProductId;
        return this;
    }

    @Nonnull
    public VMLaunchOptions withUserData(@Nonnull String userData) {
        this.userData = userData;
        return this;
    }

    @Nonnull
    public VMLaunchOptions withStaticIps(String ... ipIds) {
        this.staticIpIds = ipIds;
        return this;
    }

    public static class VolumeAttachment {
        public String deviceId;
        public String existingVolumeId;
        public VolumeCreateOptions volumeToCreate;
    }

    public static class NICConfig {
        public String nicId;
        public NICCreateOptions nicToCreate;
    }
}

