/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.compute;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import org.dasein.cloud.Tag;
import org.dasein.cloud.Taggable;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VmState;

public class VirtualMachine
implements Taggable {
    private Architecture architecture;
    private boolean clonable;
    private long creationTimestamp;
    private VmState currentState;
    private Map<String, String> tags;
    private String description;
    private boolean imagable;
    private long lastBootTimestamp;
    private long lastPauseTimestamp;
    private String name;
    private boolean pausable;
    private boolean persistent;
    private Platform platform;
    private String privateDnsAddress;
    private String[] privateIpAddresses;
    private String productId;
    private String providerAssignedIpAddressId;
    private String providerDataCenterId;
    private String providerMachineImageId;
    private String providerOwnerId;
    private String providerRegionId;
    private String providerSubnetId;
    private String providerVirtualMachineId;
    private String providerVlanId;
    private String publicDnsAddress;
    public String[] publicIpAddresses;
    private boolean rebootable;
    private String rootPassword;
    private String rootUser;
    private long terminationTimestamp;
    private volatile transient Callable<String> passwordCallback = null;

    public boolean equals(Object ob) {
        if (ob == null) {
            return false;
        }
        if (ob == this) {
            return true;
        }
        if (!this.getClass().getName().equals(ob.getClass().getName())) {
            return false;
        }
        VirtualMachine other = (VirtualMachine)ob;
        if (!this.getProviderRegionId().equals(other.getProviderRegionId())) {
            return false;
        }
        return this.getProviderVirtualMachineId().equals(other.getProviderVirtualMachineId());
    }

    public void addTag(Tag t) {
        this.addTag(t.getKey(), t.getValue());
    }

    public void addTag(String key, String value) {
        this.getTags().put(key, value);
    }

    public void setPasswordCallback(Callable<String> callback) {
        this.passwordCallback = callback;
    }

    public void setRootPassword(String rootPassword) {
        this.rootPassword = rootPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRootPassword() {
        String pw;
        VirtualMachine virtualMachine = this;
        synchronized (virtualMachine) {
            pw = this.rootPassword;
        }
        if (pw != null) {
            return pw;
        }
        if (this.passwordCallback != null) {
            pw = this.fetchPassword();
        }
        return pw;
    }

    public String getRootPassword(long timeoutInMilliseconds) throws InterruptedException {
        long timeout = System.currentTimeMillis() + timeoutInMilliseconds;
        String pw = this.getRootPassword();
        if (this.passwordCallback != null) {
            while (pw == null) {
                if (timeout <= System.currentTimeMillis()) {
                    throw new InterruptedException("System timed out waiting for a password to become available.");
                }
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                pw = this.getRootPassword();
            }
        }
        return pw;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String fetchPassword() {
        String pw;
        VirtualMachine virtualMachine = this;
        synchronized (virtualMachine) {
            pw = this.rootPassword;
        }
        if (pw != null) {
            return pw;
        }
        if (this.passwordCallback == null) {
            return null;
        }
        try {
            pw = this.passwordCallback.call();
            if (pw != null) {
                virtualMachine = this;
                synchronized (virtualMachine) {
                    this.rootPassword = pw;
                }
            }
            return this.rootPassword;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String toString() {
        return this.name + " [" + this.providerVirtualMachineId + "]";
    }

    public Architecture getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(Architecture architecture) {
        this.architecture = architecture;
    }

    public boolean isClonable() {
        return this.clonable;
    }

    public void setClonable(boolean clonable) {
        this.clonable = clonable;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setCreationTimestamp(long creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public VmState getCurrentState() {
        return this.currentState;
    }

    public void setCurrentState(VmState currentState) {
        this.currentState = currentState;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isImagable() {
        return this.imagable;
    }

    public void setImagable(boolean imagable) {
        this.imagable = imagable;
    }

    public long getLastBootTimestamp() {
        return this.lastBootTimestamp;
    }

    public void setLastBootTimestamp(long lastBootTimestamp) {
        this.lastBootTimestamp = lastBootTimestamp;
    }

    public long getLastPauseTimestamp() {
        return this.lastPauseTimestamp;
    }

    public void setLastPauseTimestamp(long lastPauseTimestamp) {
        this.lastPauseTimestamp = lastPauseTimestamp;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isPausable() {
        return this.pausable;
    }

    public void setPausable(boolean pausable) {
        this.pausable = pausable;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public String getPrivateDnsAddress() {
        return this.privateDnsAddress;
    }

    public void setPrivateDnsAddress(String privateDnsAddress) {
        this.privateDnsAddress = privateDnsAddress;
    }

    public String[] getPrivateIpAddresses() {
        return this.privateIpAddresses;
    }

    public void setPrivateIpAddresses(String[] privateIpAddresses) {
        this.privateIpAddresses = privateIpAddresses;
    }

    public String getProviderAssignedIpAddressId() {
        return this.providerAssignedIpAddressId;
    }

    public void setProviderAssignedIpAddressId(String providerAssignedIpAddressId) {
        this.providerAssignedIpAddressId = providerAssignedIpAddressId;
    }

    public String getProviderDataCenterId() {
        return this.providerDataCenterId;
    }

    public void setProviderDataCenterId(String providerDataCenterId) {
        this.providerDataCenterId = providerDataCenterId;
    }

    public String getProviderMachineImageId() {
        return this.providerMachineImageId;
    }

    public void setProviderMachineImageId(String providerMachineImageId) {
        this.providerMachineImageId = providerMachineImageId;
    }

    public String getProviderOwnerId() {
        return this.providerOwnerId;
    }

    public void setProviderOwnerId(String providerOwnerId) {
        this.providerOwnerId = providerOwnerId;
    }

    public String getProviderRegionId() {
        return this.providerRegionId;
    }

    public void setProviderRegionId(String providerRegionId) {
        this.providerRegionId = providerRegionId;
    }

    public String getProviderVirtualMachineId() {
        return this.providerVirtualMachineId;
    }

    public void setProviderVirtualMachineId(String providerVirtualMachineId) {
        this.providerVirtualMachineId = providerVirtualMachineId;
    }

    public String getPublicDnsAddress() {
        return this.publicDnsAddress;
    }

    public void setPublicDnsAddress(String publicDnsAddress) {
        this.publicDnsAddress = publicDnsAddress;
    }

    public String[] getPublicIpAddresses() {
        return this.publicIpAddresses;
    }

    public void setPublicIpAddresses(String[] publicIpAddresses) {
        this.publicIpAddresses = publicIpAddresses;
    }

    public boolean isRebootable() {
        return this.rebootable;
    }

    public void setRebootable(boolean rebootable) {
        this.rebootable = rebootable;
    }

    public String getRootUser() {
        return this.rootUser;
    }

    public void setRootUser(String rootUser) {
        this.rootUser = rootUser;
    }

    public long getTerminationTimestamp() {
        return this.terminationTimestamp;
    }

    public void setTerminationTimestamp(long terminationTimestamp) {
        this.terminationTimestamp = terminationTimestamp;
    }

    public Callable<String> getPasswordCallback() {
        return this.passwordCallback;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public String getProductId() {
        return this.productId;
    }

    public Object getTag(String tag) {
        return this.getTags().get(tag);
    }

    @Override
    public synchronized Map<String, String> getTags() {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        return this.tags;
    }

    @Override
    public void setTag(@Nonnull String key, @Nonnull String value) {
        if (this.tags == null) {
            this.tags = new HashMap<String, String>();
        }
        this.tags.put(key, value);
    }

    public synchronized void setTags(Map<String, String> properties) {
        this.getTags().clear();
        this.getTags().putAll(properties);
    }

    public void setProviderSubnetId(String providerSubnetId) {
        this.providerSubnetId = providerSubnetId;
    }

    public String getProviderSubnetId() {
        return this.providerSubnetId;
    }

    public void setProviderVlanId(String providerVlanId) {
        this.providerVlanId = providerVlanId;
    }

    public String getProviderVlanId() {
        return this.providerVlanId;
    }
}

