/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.compute;

import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AccessControlledService;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.Tag;
import org.dasein.cloud.compute.Architecture;
import org.dasein.cloud.compute.VMLaunchOptions;
import org.dasein.cloud.compute.VirtualMachine;
import org.dasein.cloud.compute.VirtualMachineProduct;
import org.dasein.cloud.compute.VmStatistics;
import org.dasein.cloud.identity.ServiceAction;

public interface VirtualMachineSupport
extends AccessControlledService {
    public static final ServiceAction ANY = new ServiceAction("VM:ANY");
    public static final ServiceAction BOOT = new ServiceAction("VM:BOOT");
    public static final ServiceAction CLONE = new ServiceAction("VM:CLONE");
    public static final ServiceAction CREATE_VM = new ServiceAction("VM:CREATE_VM");
    public static final ServiceAction GET_VM = new ServiceAction("VM:GET_VM");
    public static final ServiceAction LIST_VM = new ServiceAction("VM:LIST_VM");
    public static final ServiceAction PAUSE = new ServiceAction("VM:PAUSE");
    public static final ServiceAction REBOOT = new ServiceAction("VM:REBOOT");
    public static final ServiceAction REMOVE_VM = new ServiceAction("VM:REMOVE_VM");
    public static final ServiceAction TOGGLE_ANALYTICS = new ServiceAction("VM:TOGGLE_ANALYTICS");
    public static final ServiceAction VIEW_ANALYTICS = new ServiceAction("VM:VIEW_ANALYTICS");
    public static final ServiceAction VIEW_CONSOLE = new ServiceAction("VM:VIEW_CONSOLE");

    public void boot(@Nonnull String var1) throws InternalException, CloudException;

    @Nonnull
    public VirtualMachine clone(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3, @Nonnull String var4, boolean var5, String ... var6) throws InternalException, CloudException;

    public void disableAnalytics(String var1) throws InternalException, CloudException;

    public void enableAnalytics(String var1) throws InternalException, CloudException;

    @Nonnull
    public String getConsoleOutput(@Nonnull String var1) throws InternalException, CloudException;

    public int getMaximumVirtualMachineCount() throws CloudException, InternalException;

    @Nullable
    public VirtualMachineProduct getProduct(@Nonnull String var1) throws InternalException, CloudException;

    @Nonnull
    public String getProviderTermForServer(@Nonnull Locale var1);

    @Nullable
    public VirtualMachine getVirtualMachine(@Nonnull String var1) throws InternalException, CloudException;

    public VmStatistics getVMStatistics(String var1, long var2, long var4) throws InternalException, CloudException;

    @Nonnull
    public Iterable<VmStatistics> getVMStatisticsForPeriod(@Nonnull String var1, @Nonnegative long var2, @Nonnegative long var4) throws InternalException, CloudException;

    @Nonnull
    public Requirement identifyPasswordRequirement() throws CloudException, InternalException;

    @Nonnull
    public Requirement identifyRootVolumeRequirement() throws CloudException, InternalException;

    @Nonnull
    public Requirement identifyShellKeyRequirement() throws CloudException, InternalException;

    @Nonnull
    public Requirement identifyVlanRequirement() throws CloudException, InternalException;

    public boolean isAPITerminationPreventable() throws CloudException, InternalException;

    public boolean isBasicAnalyticsSupported() throws CloudException, InternalException;

    public boolean isExtendedAnalyticsSupported() throws CloudException, InternalException;

    public boolean isSubscribed() throws CloudException, InternalException;

    public boolean isUserDataSupported() throws CloudException, InternalException;

    @Nonnull
    public VirtualMachine launch(VMLaunchOptions var1) throws CloudException, InternalException;

    @Nonnull
    public VirtualMachine launch(@Nonnull String var1, @Nonnull VirtualMachineProduct var2, @Nonnull String var3, @Nonnull String var4, @Nonnull String var5, @Nullable String var6, @Nullable String var7, boolean var8, boolean var9, String ... var10) throws InternalException, CloudException;

    @Nonnull
    public VirtualMachine launch(@Nonnull String var1, @Nonnull VirtualMachineProduct var2, @Nonnull String var3, @Nonnull String var4, @Nonnull String var5, @Nullable String var6, @Nullable String var7, boolean var8, boolean var9, @Nullable String[] var10, Tag ... var11) throws InternalException, CloudException;

    @Nonnull
    public Iterable<String> listFirewalls(@Nonnull String var1) throws InternalException, CloudException;

    public Iterable<VirtualMachineProduct> listProducts(Architecture var1) throws InternalException, CloudException;

    public Iterable<Architecture> listSupportedArchitectures() throws InternalException, CloudException;

    @Nonnull
    public Iterable<VirtualMachine> listVirtualMachines() throws InternalException, CloudException;

    public void pause(@Nonnull String var1) throws InternalException, CloudException;

    public void reboot(@Nonnull String var1) throws CloudException, InternalException;

    public boolean supportsAnalytics() throws CloudException, InternalException;

    public void terminate(@Nonnull String var1) throws InternalException, CloudException;
}

