/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.compute;

import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.VolumeState;
import org.dasein.cloud.compute.VolumeType;
import org.dasein.util.uom.UnitOfMeasure;
import org.dasein.util.uom.storage.Gigabyte;
import org.dasein.util.uom.storage.Storage;

public class Volume {
    private long creationTimestamp;
    private VolumeState currentState;
    private String providerDataCenterId;
    private String description;
    private String deviceId;
    private Platform guestOperatingSystem;
    private String mediaLink;
    private String name;
    private String providerProductId;
    private String providerVolumeId;
    private String providerRegionId;
    private String providerVirtualMachineId;
    private boolean rootVolume;
    private Storage<Gigabyte> size;
    private String providerSnapshotId;
    private VolumeType type;

    public boolean equals(Object ob) {
        if (ob == null) {
            return false;
        }
        if (ob == this) {
            return true;
        }
        if (!this.getClass().getName().equals(ob.getClass().getName())) {
            return false;
        }
        Volume other = (Volume)ob;
        if (!this.providerRegionId.equals(other.providerRegionId)) {
            return false;
        }
        return this.providerVolumeId.equals(other.providerVolumeId);
    }

    public String getSnapshotId() {
        return this.getProviderSnapshotId();
    }

    public String getProviderSnapshotId() {
        return this.providerSnapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.providerSnapshotId = snapshotId;
    }

    public void setProviderSnapshotId(String snapshotId) {
        this.providerSnapshotId = snapshotId;
    }

    public VolumeState getCurrentState() {
        return this.currentState;
    }

    public String getDataCenterId() {
        return this.getProviderDataCenterId();
    }

    public String getProviderDataCenterId() {
        return this.providerDataCenterId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getName() {
        return this.name;
    }

    public String getProviderVolumeId() {
        return this.providerVolumeId;
    }

    public String getRegionId() {
        return this.getProviderRegionId();
    }

    public String getProviderRegionId() {
        return this.providerRegionId;
    }

    public String getServerId() {
        return this.getProviderVirtualMachineId();
    }

    public String getProviderVirtualMachineId() {
        return this.providerVirtualMachineId;
    }

    public Storage<Gigabyte> getSize() {
        return this.size;
    }

    public void setSize(Storage<?> size) {
        this.size = (Storage)size.convertTo((UnitOfMeasure)Storage.GIGABYTE);
    }

    public int getSizeInGigabytes() {
        return this.size == null ? 0 : this.size.getQuantity().intValue();
    }

    public void setCurrentState(VolumeState currentState) {
        this.currentState = currentState;
    }

    public void setDataCenterId(String dataCenterId) {
        this.setProviderDataCenterId(dataCenterId);
    }

    public void setProviderDataCenterId(String dataCenterId) {
        this.providerDataCenterId = dataCenterId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setProviderVolumeId(String providerVolumeId) {
        this.providerVolumeId = providerVolumeId;
    }

    public void setRegionId(String regionId) {
        this.setProviderRegionId(regionId);
    }

    public void setProviderRegionId(String regionId) {
        this.providerRegionId = regionId;
    }

    public void setServerId(String serverId) {
        this.setProviderVirtualMachineId(serverId);
    }

    public void setProviderVirtualMachineId(String serverId) {
        this.providerVirtualMachineId = serverId;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public void setCreationTimestamp(long creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public VolumeType getType() {
        return this.type;
    }

    public void setType(VolumeType t) {
        this.type = t;
    }

    public String toString() {
        return this.name + " [" + this.providerVolumeId + "]";
    }

    public String getProviderProductId() {
        return this.providerProductId;
    }

    public void setProviderProductId(String providerProductId) {
        this.providerProductId = providerProductId;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isRootVolume() {
        return this.rootVolume;
    }

    public void setRootVolume(boolean rootVolume) {
        this.rootVolume = rootVolume;
    }

    public String getMediaLink() {
        return this.mediaLink;
    }

    public void setMediaLink(String mediaLink) {
        this.mediaLink = mediaLink;
    }

    public Platform getGuestOperatingSystem() {
        return this.guestOperatingSystem;
    }

    public void setGuestOperatingSystem(Platform guestOperatingSystem) {
        this.guestOperatingSystem = guestOperatingSystem;
    }
}

