/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.compute;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.util.uom.UnitOfMeasure;
import org.dasein.util.uom.storage.Gigabyte;
import org.dasein.util.uom.storage.Storage;

public class VolumeCreateOptions {
    private String dataCenterId;
    private String description;
    private String deviceId;
    private int iops;
    private String name;
    private String snapshotId;
    private String virtualMachineId;
    private String volumeProductId;
    private Storage<Gigabyte> volumeSize;

    public static VolumeCreateOptions getInstance(@Nonnull Storage<?> size, @Nonnull String name, @Nonnull String description) {
        return new VolumeCreateOptions(null, null, size, name, description, 0);
    }

    public static VolumeCreateOptions getInstance(@Nonnull String volumeProductId, @Nonnull Storage<?> size, @Nonnull String name, @Nonnull String description, @Nonnegative int iops) {
        return new VolumeCreateOptions(volumeProductId, null, size, name, description, iops);
    }

    public static VolumeCreateOptions getInstanceForSnapshot(@Nonnull String snapshotId, @Nonnull Storage<?> size, @Nonnull String name, @Nonnull String description) {
        return new VolumeCreateOptions(null, snapshotId, size, name, description, 0);
    }

    public static VolumeCreateOptions getInstanceForSnapshot(@Nonnull String volumeProductId, @Nonnull String snapshotId, @Nonnull Storage<?> size, @Nonnull String name, @Nonnull String description, @Nonnegative int iops) {
        return new VolumeCreateOptions(volumeProductId, snapshotId, size, name, description, iops);
    }

    private VolumeCreateOptions() {
    }

    private VolumeCreateOptions(@Nullable String volumeProductId, @Nullable String snapshotId, @Nonnull Storage<?> size, @Nonnull String name, @Nonnull String description, @Nonnegative int iops) {
        this.volumeProductId = volumeProductId;
        this.snapshotId = snapshotId;
        this.volumeSize = (Storage)size.convertTo((UnitOfMeasure)Storage.GIGABYTE);
        this.name = name;
        this.description = description;
        this.iops = iops;
    }

    @Nullable
    public String getDataCenterId() {
        return this.dataCenterId;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nullable
    public String getDeviceId() {
        return this.deviceId;
    }

    @Nonnegative
    public int getIops() {
        return this.iops;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getSnapshotId() {
        return this.snapshotId;
    }

    @Nullable
    public String getVirtualMachineId() {
        return this.virtualMachineId;
    }

    @Nullable
    public String getVolumeProductId() {
        return this.volumeProductId;
    }

    @Nonnull
    public Storage<Gigabyte> getVolumeSize() {
        return this.volumeSize;
    }

    @Nonnull
    public VolumeCreateOptions inDataCenter(@Nonnull String dataCenterId) {
        this.dataCenterId = dataCenterId;
        return this;
    }

    @Nonnull
    public VolumeCreateOptions withAttachment(@Nonnull String vmId, @Nonnull String asDeviceId) {
        this.virtualMachineId = vmId;
        this.deviceId = asDeviceId;
        return this;
    }
}

