/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.compute;

import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.compute.VolumeType;
import org.dasein.util.uom.UnitOfMeasure;
import org.dasein.util.uom.storage.Gigabyte;
import org.dasein.util.uom.storage.Storage;

public class VolumeProduct {
    private String currency;
    private String description;
    private Float iopsCost;
    private int maxIops;
    private int minIops;
    private Float monthlyGigabyteCost;
    private String name;
    private String providerProductId;
    private Storage<Gigabyte> volumeSize;
    private VolumeType type;

    @Nonnull
    public static VolumeProduct getInstance(@Nonnull String id, @Nonnull String name, @Nonnull String description, @Nonnull VolumeType type) {
        return new VolumeProduct(id, name, description, type);
    }

    @Nonnull
    public static VolumeProduct getInstance(@Nonnull String id, @Nonnull String name, @Nonnull String description, @Nonnull VolumeType type, @Nonnegative int minIops, @Nonnegative int maxIops, @Nullable Float monthlyCost, @Nullable Float iopsCost) {
        return new VolumeProduct(id, name, description, type, minIops, maxIops, monthlyCost, iopsCost);
    }

    @Nonnull
    public static VolumeProduct getInstance(@Nonnull String id, @Nonnull String name, @Nonnull String description, @Nonnull VolumeType type, @Nonnull Storage<?> volumeSize) {
        return new VolumeProduct(id, name, description, type, (Storage<Gigabyte>)((Storage)volumeSize.convertTo((UnitOfMeasure)Storage.GIGABYTE)));
    }

    @Nonnull
    public static VolumeProduct getInstance(@Nonnull String id, @Nonnull String name, @Nonnull String description, @Nonnull VolumeType type, @Nonnull Storage<?> volumeSize, @Nonnull String currency, @Nonnegative int minIops, @Nonnegative int maxIops, @Nullable Float monthlyCost, @Nullable Float iopsCost) {
        return new VolumeProduct(id, name, description, type, (Storage<Gigabyte>)((Storage)volumeSize.convertTo((UnitOfMeasure)Storage.GIGABYTE)), currency, minIops, maxIops, monthlyCost, iopsCost);
    }

    private VolumeProduct() {
    }

    private VolumeProduct(@Nonnull String id, @Nonnull String name, @Nonnull String description, @Nonnull VolumeType type) {
        this.providerProductId = id;
        this.name = name;
        this.description = description;
        this.type = type;
        this.minIops = 0;
        this.maxIops = 0;
    }

    private VolumeProduct(@Nonnull String id, @Nonnull String name, @Nonnull String description, @Nonnull VolumeType type, @Nonnegative int minIops, @Nonnegative int maxIops, @Nullable Float monthlyCost, @Nullable Float iopsCost) {
        this.providerProductId = id;
        this.name = name;
        this.description = description;
        this.type = type;
        this.minIops = minIops;
        this.maxIops = maxIops;
        this.monthlyGigabyteCost = monthlyCost;
        this.iopsCost = iopsCost;
    }

    private VolumeProduct(@Nonnull String id, @Nonnull String name, @Nonnull String description, @Nonnull VolumeType type, @Nonnull Storage<Gigabyte> volumeSize) {
        this.providerProductId = id;
        this.name = name;
        this.description = description;
        this.volumeSize = volumeSize;
        this.type = type;
        this.minIops = 0;
        this.maxIops = 0;
    }

    private VolumeProduct(@Nonnull String id, @Nonnull String name, @Nonnull String description, @Nonnull VolumeType type, @Nonnull Storage<Gigabyte> volumeSize, @Nonnull String currency, @Nonnegative float monthlyCost) {
        this.providerProductId = id;
        this.name = name;
        this.description = description;
        this.type = type;
        this.volumeSize = volumeSize;
        this.currency = currency;
        this.monthlyGigabyteCost = Float.valueOf(monthlyCost);
        this.minIops = 0;
        this.maxIops = 0;
    }

    private VolumeProduct(@Nonnull String id, @Nonnull String name, @Nonnull String description, @Nonnull VolumeType type, @Nonnull Storage<Gigabyte> volumeSize, @Nonnull String currency, @Nonnegative int minIops, @Nonnegative int maxIops, @Nullable Float monthlyCost, @Nullable Float iopsCost) {
        this.providerProductId = id;
        this.name = name;
        this.description = description;
        this.type = type;
        this.volumeSize = volumeSize;
        this.currency = currency;
        this.monthlyGigabyteCost = monthlyCost;
        this.minIops = minIops;
        this.maxIops = maxIops;
        this.iopsCost = iopsCost;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.getClass().getName().equals(other.getClass().getName())) {
            return false;
        }
        VolumeProduct prd = (VolumeProduct)other;
        return this.getProviderProductId().equals(prd.getProviderProductId());
    }

    @Nullable
    public String getCurrency() {
        return this.currency;
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnegative
    public int getMaxIops() {
        return this.maxIops;
    }

    @Nonnegative
    public int getMinIops() {
        return this.minIops;
    }

    @Nullable
    public Float getIopsCost() {
        return this.iopsCost;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public Float getMonthlyGigabyteCost() {
        return this.monthlyGigabyteCost;
    }

    @Nonnull
    public String getProviderProductId() {
        return this.providerProductId;
    }

    @Nonnull
    public VolumeType getType() {
        return this.type;
    }

    @Nullable
    public Storage<Gigabyte> getVolumeSize() {
        return this.volumeSize;
    }

    public String toString() {
        return this.name + " [#" + this.providerProductId + "]";
    }
}

