/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.compute;

import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AccessControlledService;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.compute.Platform;
import org.dasein.cloud.compute.Volume;
import org.dasein.cloud.compute.VolumeCreateOptions;
import org.dasein.cloud.compute.VolumeProduct;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.util.uom.storage.Gigabyte;
import org.dasein.util.uom.storage.Storage;

public interface VolumeSupport
extends AccessControlledService {
    public static final ServiceAction ANY = new ServiceAction("VOLUME:ANY");
    public static final ServiceAction ATTACH = new ServiceAction("VOLUME:ATTACH");
    public static final ServiceAction CREATE_VOLUME = new ServiceAction("VOLUME:CREATE_VOLUME");
    public static final ServiceAction DETACH = new ServiceAction("VOLUME:DETACH");
    public static final ServiceAction GET_VOLUME = new ServiceAction("VOLUME:GET_VOLUME");
    public static final ServiceAction LIST_VOLUME = new ServiceAction("VOLUME:LIST_VOLUME");
    public static final ServiceAction REMOVE_VOLUME = new ServiceAction("VOLUME:REMOVE_VOLUME");

    public void attach(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3) throws InternalException, CloudException;

    @Nonnull
    public String create(@Nonnull String var1, @Nonnegative int var2, @Nonnull String var3) throws InternalException, CloudException;

    @Nonnull
    public String createVolume(@Nonnull VolumeCreateOptions var1) throws InternalException, CloudException;

    public void detach(@Nonnull String var1) throws InternalException, CloudException;

    public int getMaximumVolumeCount() throws InternalException, CloudException;

    @Nullable
    public Storage<Gigabyte> getMaximumVolumeSize() throws InternalException, CloudException;

    @Nonnull
    public Storage<Gigabyte> getMinimumVolumeSize() throws InternalException, CloudException;

    @Nonnull
    public String getProviderTermForVolume(@Nonnull Locale var1);

    @Nullable
    public Volume getVolume(@Nonnull String var1) throws InternalException, CloudException;

    @Nonnull
    public Requirement getVolumeProductRequirement() throws InternalException, CloudException;

    public boolean isVolumeSizeDeterminedByProduct() throws InternalException, CloudException;

    @Nonnull
    public Iterable<String> listPossibleDeviceIds(@Nonnull Platform var1) throws InternalException, CloudException;

    @Nonnull
    public Iterable<VolumeProduct> listVolumeProducts() throws InternalException, CloudException;

    @Nonnull
    public Iterable<Volume> listVolumes() throws InternalException, CloudException;

    public boolean isSubscribed() throws CloudException, InternalException;

    public void remove(@Nonnull String var1) throws InternalException, CloudException;
}

