/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.identity;

import javax.annotation.Nonnull;
import org.dasein.cloud.AccessControlledService;
import org.dasein.cloud.CloudProvider;
import org.dasein.cloud.identity.IdentityServices;
import org.dasein.cloud.network.NetworkServices;

public class ServiceAction {
    private String actionId;
    private String serviceId;

    public ServiceAction(String actionId) {
        int idx = actionId.indexOf(":");
        this.actionId = actionId;
        this.serviceId = idx < 0 ? "" : this.actionId.substring(0, idx);
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.getClass().getName().equals(other.getClass().getName()) && this.getActionId().equals(((ServiceAction)other).getActionId());
    }

    public String getActionId() {
        return this.actionId;
    }

    @Nonnull
    public String[] map(@Nonnull CloudProvider provider) {
        AccessControlledService svc = null;
        if (this.serviceId.equals("DNS")) {
            NetworkServices services = provider.getNetworkServices();
            if (services == null) {
                return null;
            }
            svc = services.getDnsSupport();
        } else if (this.serviceId.equals("IAM")) {
            IdentityServices services = provider.getIdentityServices();
            if (services == null) {
                return null;
            }
            svc = services.getIdentityAndAccessSupport();
        } else if (this.serviceId.equals("FW")) {
            NetworkServices services = provider.getNetworkServices();
            if (services == null) {
                return null;
            }
            svc = services.getFirewallSupport();
        } else if (this.serviceId.equals("LB")) {
            NetworkServices services = provider.getNetworkServices();
            if (services == null) {
                return null;
            }
            svc = services.getLoadBalancerSupport();
        }
        if (svc == null) {
            return new String[0];
        }
        return svc.mapServiceAction(this);
    }

    public int hashCode() {
        return this.actionId.hashCode();
    }

    public String toString() {
        return this.actionId;
    }
}

