/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.network;

import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AccessControlledService;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.DNSRecord;
import org.dasein.cloud.network.DNSRecordType;
import org.dasein.cloud.network.DNSZone;

public interface DNSSupport
extends AccessControlledService {
    public static final ServiceAction ANY = new ServiceAction("DNS:ANY");
    public static final ServiceAction ADD_RECORD = new ServiceAction("DNS:AddRecord");
    public static final ServiceAction CREATE_ZONE = new ServiceAction("DNS:CreateZone");
    public static final ServiceAction GET_ZONE = new ServiceAction("DNS:GetZone");
    public static final ServiceAction LIST_RECORD = new ServiceAction("DNS:ListRecord");
    public static final ServiceAction LIST_ZONE = new ServiceAction("DNS:ListZone");
    public static final ServiceAction REMOVE_RECORD = new ServiceAction("DNS:RemoveRecord");
    public static final ServiceAction REMOVE_ZONE = new ServiceAction("DNS:RemoveZone");

    @Nonnull
    public DNSRecord addDnsRecord(@Nonnull String var1, @Nonnull DNSRecordType var2, @Nonnull String var3, @Nonnegative int var4, String ... var5) throws CloudException, InternalException;

    @Nonnull
    public String createDnsZone(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3) throws CloudException, InternalException;

    public void deleteDnsRecords(DNSRecord ... var1) throws CloudException, InternalException;

    public void deleteDnsZone(@Nonnull String var1) throws CloudException, InternalException;

    @Nullable
    public DNSZone getDnsZone(@Nonnull String var1) throws CloudException, InternalException;

    @Nonnull
    public String getProviderTermForRecord(@Nonnull Locale var1);

    @Nonnull
    public String getProviderTermForZone(@Nonnull Locale var1);

    @Nonnull
    public Iterable<DNSRecord> listDnsRecords(@Nonnull String var1, @Nullable DNSRecordType var2, @Nullable String var3) throws CloudException, InternalException;

    @Nonnull
    public Iterable<DNSZone> listDnsZones() throws CloudException, InternalException;

    public boolean isSubscribed() throws CloudException, InternalException;
}

