/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.network;

import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.network.Direction;
import org.dasein.cloud.network.Permission;
import org.dasein.cloud.network.Protocol;

public class FirewallRule
implements Serializable {
    private static final long serialVersionUID = -3830971132733183138L;
    private String cidr;
    private Direction direction;
    private int endPort;
    private String firewallId;
    private Permission permission;
    private Protocol protocol;
    private String providerRuleId;
    private int startPort;

    public static String getRuleId(String providerFirewallId, String cidr, Direction direction, Protocol protocol, int startPort, int endPort) {
        return providerFirewallId + ":" + cidr + ":" + (Object)((Object)direction) + ":" + (Object)((Object)protocol) + ":" + startPort + ":" + endPort;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (!this.getClass().getName().equals(other.getClass().getName())) {
            return false;
        }
        return this.getProviderRuleId().equals(((FirewallRule)other).getProviderRuleId());
    }

    @Nullable
    public String getCidr() {
        return this.cidr;
    }

    public int getEndPort() {
        return this.endPort;
    }

    @Nullable
    public String getFirewallId() {
        return this.firewallId;
    }

    @Nullable
    public Protocol getProtocol() {
        return this.protocol;
    }

    public int getStartPort() {
        return this.startPort;
    }

    public void setCidr(@Nonnull String cidr) {
        this.cidr = cidr;
    }

    public void setEndPort(int endPort) {
        this.endPort = endPort;
    }

    public void setFirewallId(@Nonnull String firewallId) {
        this.firewallId = firewallId;
    }

    public void setProtocol(@Nonnull Protocol protocol) {
        this.protocol = protocol;
    }

    public void setStartPort(int startPort) {
        this.startPort = startPort;
    }

    public void setDirection(@Nonnull Direction direction) {
        this.direction = direction;
    }

    @Nullable
    public Direction getDirection() {
        return this.direction == null ? Direction.INGRESS : this.direction;
    }

    public void setPermission(Permission permission) {
        this.permission = permission;
    }

    public Permission getPermission() {
        return this.permission == null ? Permission.ALLOW : this.permission;
    }

    public void setProviderRuleId(String providerRuleId) {
        this.providerRuleId = providerRuleId;
    }

    @Nonnull
    public String getProviderRuleId() {
        if (this.providerRuleId == null) {
            return FirewallRule.getRuleId(this.getFirewallId(), this.getCidr(), this.getDirection(), this.getProtocol(), this.getStartPort(), this.getEndPort());
        }
        return this.providerRuleId;
    }

    public String toString() {
        return (Object)((Object)this.direction) + "/" + (Object)((Object)this.permission) + ": " + this.cidr + "->" + (Object)((Object)this.protocol) + ":" + this.startPort + "-" + this.endPort;
    }
}

