/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.network;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.network.AddressType;
import org.dasein.cloud.network.IPVersion;

public class IpAddress
implements Comparable<IpAddress> {
    private String address;
    private AddressType addressType;
    private boolean forVlan;
    private String providerNetworkInterfaceId;
    private String providerIpAddressId;
    private String providerLoadBalancerId;
    private String regionId;
    private String serverId;
    private IPVersion version;

    @Override
    public int compareTo(@Nonnull IpAddress other) {
        if (other == this) {
            return 0;
        }
        int x = this.address.compareTo(other.address);
        if (x != 0) {
            return x;
        }
        return this.providerIpAddressId.compareTo(other.providerIpAddressId);
    }

    public boolean equals(@CheckForNull Object ob) {
        if (ob == null) {
            return false;
        }
        if (ob == this) {
            return true;
        }
        if (!this.getClass().getName().equals(ob.getClass().getName())) {
            return false;
        }
        IpAddress other = (IpAddress)ob;
        return this.address.equals(other.address) && this.providerIpAddressId.equals(other.providerIpAddressId);
    }

    @Nonnull
    public String getAddress() {
        return this.address;
    }

    @Nonnull
    public String getProviderIpAddressId() {
        return this.providerIpAddressId;
    }

    @Nonnull
    public String getRegionId() {
        return this.regionId;
    }

    @Nullable
    public String getServerId() {
        return this.serverId;
    }

    @Nullable
    public String getProviderLoadBalancerId() {
        return this.providerLoadBalancerId;
    }

    @Nonnull
    public AddressType getAddressType() {
        return this.addressType;
    }

    public boolean isAssigned() {
        return this.serverId != null || this.providerLoadBalancerId != null;
    }

    public void setAddress(@Nonnull String address) {
        this.address = address;
    }

    public void setIpAddressId(@Nonnull String ipAddressId) {
        this.providerIpAddressId = ipAddressId;
    }

    public void setRegionId(@Nonnull String regionId) {
        this.regionId = regionId;
    }

    public void setServerId(@Nullable String serverId) {
        this.serverId = serverId;
    }

    @Nonnull
    public String toString() {
        return this.address + " (" + this.providerIpAddressId + ")";
    }

    public void setProviderLoadBalancerId(@Nullable String providerLoadBalancerId) {
        this.providerLoadBalancerId = providerLoadBalancerId;
    }

    public void setAddressType(@Nonnull AddressType addressType) {
        this.addressType = addressType;
    }

    public void setForVlan(boolean f) {
        this.forVlan = f;
    }

    public boolean isForVlan() {
        return this.forVlan;
    }

    public String getProviderNetworkInterfaceId() {
        return this.providerNetworkInterfaceId;
    }

    public void setProviderNetworkInterfaceId(String providerNetworkInterfaceId) {
        this.providerNetworkInterfaceId = providerNetworkInterfaceId;
    }

    @Nonnull
    public IPVersion getVersion() {
        return this.version == null ? IPVersion.IPV4 : this.version;
    }

    public void setVersion(IPVersion version) {
        this.version = version;
    }
}

