/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.network;

import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AccessControlledService;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.AddressType;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.IpAddress;
import org.dasein.cloud.network.IpForwardingRule;
import org.dasein.cloud.network.Protocol;

public interface IpAddressSupport
extends AccessControlledService {
    public static final ServiceAction ANY = new ServiceAction("IPADDR:ANY");
    public static final ServiceAction ASSIGN = new ServiceAction("IPADDR:ASSIGN");
    public static final ServiceAction CREATE_IP_ADDRESS = new ServiceAction("IPADDR:CREATE_IP_ADDRESS");
    public static final ServiceAction FORWARD = new ServiceAction("IPADDR:FORWARD");
    public static final ServiceAction GET_IP_ADDRESS = new ServiceAction("IPADDR:GET_IP_ADDRESS");
    public static final ServiceAction LIST_IP_ADDRESS = new ServiceAction("IPADDR:LIST_IP_ADDRESS");
    public static final ServiceAction RELEASE = new ServiceAction("IPADDR:RELEASE");
    public static final ServiceAction REMOVE_IP_ADDRESS = new ServiceAction("IPADDR:REMOVE_IP_ADDRESS");
    public static final ServiceAction STOP_FORWARD = new ServiceAction("IPADDR:STOP_FORWARD");

    public void assign(@Nonnull String var1, @Nonnull String var2) throws InternalException, CloudException;

    public void assignToNetworkInterface(@Nonnull String var1, @Nonnull String var2) throws InternalException, CloudException;

    @Nonnull
    public String forward(@Nonnull String var1, int var2, @Nonnull Protocol var3, int var4, @Nonnull String var5) throws InternalException, CloudException;

    @Nullable
    public IpAddress getIpAddress(@Nonnull String var1) throws InternalException, CloudException;

    @Nonnull
    public String getProviderTermForIpAddress(@Nonnull Locale var1);

    public boolean isAssigned(@Nonnull AddressType var1);

    public boolean isAssigned(@Nonnull IPVersion var1) throws CloudException, InternalException;

    public boolean isForwarding();

    public boolean isForwarding(IPVersion var1) throws CloudException, InternalException;

    public boolean isRequestable(@Nonnull AddressType var1);

    public boolean isRequestable(@Nonnull IPVersion var1) throws CloudException, InternalException;

    public boolean isSubscribed() throws CloudException, InternalException;

    @Nonnull
    public Iterable<IpAddress> listPrivateIpPool(boolean var1) throws InternalException, CloudException;

    @Nonnull
    public Iterable<IpAddress> listPublicIpPool(boolean var1) throws InternalException, CloudException;

    @Nonnull
    public Iterable<IpAddress> listIpPool(@Nonnull IPVersion var1, boolean var2) throws InternalException, CloudException;

    @Nonnull
    public Iterable<IpForwardingRule> listRules(@Nonnull String var1) throws InternalException, CloudException;

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException;

    public void releaseFromPool(@Nonnull String var1) throws InternalException, CloudException;

    public void releaseFromServer(@Nonnull String var1) throws InternalException, CloudException;

    @Nonnull
    public String request(@Nonnull AddressType var1) throws InternalException, CloudException;

    @Nonnull
    public String request(@Nonnull IPVersion var1) throws InternalException, CloudException;

    @Nonnull
    public String requestForVLAN(IPVersion var1) throws InternalException, CloudException;

    public void stopForward(@Nonnull String var1) throws InternalException, CloudException;

    public boolean supportsVLANAddresses(@Nonnull IPVersion var1) throws InternalException, CloudException;
}

