/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.network;

import java.io.Serializable;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.dasein.cloud.network.Protocol;

public class IpForwardingRule
implements Comparable<IpForwardingRule>,
Serializable {
    private static final long serialVersionUID = -4772439155723800830L;
    private String addressId;
    private int privatePort;
    private Protocol protocol;
    private String providerRuleId;
    private int publicPort;
    private String serverId;

    @Override
    public int compareTo(@Nonnull IpForwardingRule other) {
        if (other == this) {
            return 0;
        }
        if (this.providerRuleId.equals(other.providerRuleId)) {
            return 0;
        }
        int x = this.addressId.compareTo(other.addressId);
        if (x != 0) {
            return x;
        }
        x = new Integer(this.publicPort).compareTo(other.publicPort);
        if (x != 0) {
            return x;
        }
        x = this.serverId.compareTo(other.serverId);
        if (x != 0) {
            return x;
        }
        x = new Integer(this.privatePort).compareTo(other.privatePort);
        if (x != 0) {
            return x;
        }
        x = this.protocol.compareTo(other.protocol);
        if (x != 0) {
            return x;
        }
        return this.providerRuleId.compareTo(other.providerRuleId);
    }

    public boolean equals(@CheckForNull Object ob) {
        if (ob == null) {
            return false;
        }
        if (ob == this) {
            return true;
        }
        if (!this.getClass().getName().equals(ob.getClass().getName())) {
            return false;
        }
        IpForwardingRule other = (IpForwardingRule)ob;
        return this.providerRuleId.equals(other.providerRuleId);
    }

    @Nonnull
    public String getAddressId() {
        return this.addressId;
    }

    public int getPrivatePort() {
        return this.privatePort;
    }

    @Nonnull
    public Protocol getProtocol() {
        return this.protocol;
    }

    @Nonnull
    public String getProviderRuleId() {
        return this.providerRuleId;
    }

    public int getPublicPort() {
        return this.publicPort;
    }

    @Nonnull
    public String getServerId() {
        return this.serverId;
    }

    public int hashCode() {
        return this.providerRuleId.hashCode();
    }

    public void setAddressId(@Nonnull String addressId) {
        this.addressId = addressId;
    }

    public void setPrivatePort(int privatePort) {
        this.privatePort = privatePort;
    }

    public void setProtocol(@Nonnull Protocol protocol) {
        this.protocol = protocol;
    }

    public void setProviderRuleId(@Nonnull String providerRuleId) {
        this.providerRuleId = providerRuleId;
    }

    public void setPublicPort(int publicPort) {
        this.publicPort = publicPort;
    }

    public void setServerId(@Nonnull String serverId) {
        this.serverId = serverId;
    }

    @Nonnull
    public String toString() {
        return this.addressId + ":" + this.publicPort + " -> " + this.serverId + ":" + this.privatePort + " (" + (Object)((Object)this.protocol) + ")";
    }
}

