/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.network;

import java.io.Serializable;
import javax.annotation.Nonnull;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.LbListener;
import org.dasein.cloud.network.LoadBalancerAddressType;
import org.dasein.cloud.network.LoadBalancerState;

public class LoadBalancer
implements Serializable {
    private static final long serialVersionUID = -2396639777723684882L;
    private String address;
    private LoadBalancerAddressType addressType;
    private long creationTimestamp;
    private LoadBalancerState currentState;
    private String description;
    private LbListener[] listeners;
    private String name;
    private String[] providerDataCenterIds;
    private String providerLoadBalancerId;
    private String providerOwnerId;
    private String providerRegionId;
    private String[] providerServerIds;
    private int[] publicPorts;
    private IPVersion[] supportedTraffic;

    public boolean equals(Object ob) {
        if (ob == null) {
            return false;
        }
        if (ob == this) {
            return true;
        }
        if (!this.getClass().getName().equals(ob.getClass().getName())) {
            return false;
        }
        LoadBalancer other = (LoadBalancer)ob;
        if (!this.providerOwnerId.equals(other.providerOwnerId)) {
            return false;
        }
        if (!this.providerRegionId.equals(other.providerRegionId)) {
            return false;
        }
        return this.providerLoadBalancerId.equals(other.providerLoadBalancerId);
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public LoadBalancerAddressType getAddressType() {
        return this.addressType;
    }

    public void setAddressType(LoadBalancerAddressType addressType) {
        this.addressType = addressType;
    }

    public String[] getProviderDataCenterIds() {
        return this.providerDataCenterIds;
    }

    public void setProviderDataCenterIds(String[] providerDataCenterIds) {
        this.providerDataCenterIds = providerDataCenterIds;
    }

    public String getProviderLoadBalancerId() {
        return this.providerLoadBalancerId;
    }

    public void setProviderLoadBalancerId(String providerLoadBalancerId) {
        this.providerLoadBalancerId = providerLoadBalancerId;
    }

    public String getProviderOwnerId() {
        return this.providerOwnerId;
    }

    public void setProviderOwnerId(String providerOwnerId) {
        this.providerOwnerId = providerOwnerId;
    }

    public String getProviderRegionId() {
        return this.providerRegionId;
    }

    public void setProviderRegionId(String providerRegionId) {
        this.providerRegionId = providerRegionId;
    }

    public String[] getProviderServerIds() {
        return this.providerServerIds;
    }

    public void setProviderServerIds(String[] providerServerIds) {
        this.providerServerIds = providerServerIds;
    }

    public int[] getPublicPorts() {
        return this.publicPorts;
    }

    public void setPublicPorts(int[] publicPorts) {
        this.publicPorts = publicPorts;
    }

    public void setListeners(LbListener[] listeners) {
        this.listeners = listeners;
    }

    public LbListener[] getListeners() {
        return this.listeners;
    }

    public void setCurrentState(LoadBalancerState currentState) {
        this.currentState = currentState;
    }

    public LoadBalancerState getCurrentState() {
        return this.currentState;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name + " [" + this.address + "]";
    }

    public void setCreationTimestamp(long creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    @Nonnull
    public IPVersion[] getSupportedTraffic() {
        IPVersion[] iPVersionArray;
        if (this.supportedTraffic == null) {
            IPVersion[] iPVersionArray2 = new IPVersion[1];
            iPVersionArray = iPVersionArray2;
            iPVersionArray2[0] = IPVersion.IPV4;
        } else {
            iPVersionArray = this.supportedTraffic;
        }
        return iPVersionArray;
    }

    public void setSupportedTraffic(IPVersion[] supportedTraffic) {
        this.supportedTraffic = supportedTraffic;
    }
}

