/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.network;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NICCreateOptions {
    private String description;
    private String[] firewallIds;
    private String ipAddress;
    private String name;
    private String subnetId;
    private String vlanId;

    public static NICCreateOptions getInstanceForSubnet(@Nonnull String subnetId, @Nonnull String name, @Nonnull String description) {
        NICCreateOptions options = new NICCreateOptions();
        options.subnetId = subnetId;
        options.name = name;
        options.description = description;
        return options;
    }

    public static NICCreateOptions getInstanceForVlan(@Nonnull String vlanId, @Nonnull String name, @Nonnull String description) {
        NICCreateOptions options = new NICCreateOptions();
        options.vlanId = vlanId;
        options.name = name;
        options.description = description;
        return options;
    }

    private NICCreateOptions() {
    }

    @Nonnull
    public String getDescription() {
        return this.description;
    }

    @Nonnull
    public String[] getFirewallIds() {
        return this.firewallIds == null ? new String[]{} : this.firewallIds;
    }

    @Nullable
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public String getSubnetId() {
        return this.subnetId;
    }

    @Nullable
    public String getVlanId() {
        return this.vlanId;
    }

    @Nonnull
    public NICCreateOptions behindFirewalls(String ... firewallIds) {
        if (this.firewallIds == null || this.firewallIds.length < 1) {
            this.firewallIds = firewallIds;
        } else if (firewallIds.length > 0) {
            String[] tmp = new String[this.firewallIds.length + firewallIds.length];
            int i = 0;
            for (String id : this.firewallIds) {
                tmp[i++] = id;
            }
            for (String id : firewallIds) {
                tmp[i++] = id;
            }
            this.firewallIds = tmp;
        }
        return this;
    }

    @Nonnull
    public NICCreateOptions withIpAddress(@Nonnull String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }
}

