/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.network;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.network.IPVersion;

public class Route {
    private String destinationCidr;
    private String gatewayAddress;
    private String gatewayId;
    private String gatewayOwnerId;
    private String gatewayNetworkInterfaceId;
    private String gatewayVirtualMachineId;
    private IPVersion version;

    public static Route getRouteToAddress(@Nonnull IPVersion version, @Nonnull String destination, @Nonnull String gatewayAddress) {
        Route r = new Route();
        r.version = version;
        r.destinationCidr = destination;
        r.gatewayAddress = gatewayAddress;
        return r;
    }

    public static Route getRouteToGateway(@Nonnull IPVersion version, @Nonnull String destination, @Nonnull String gatewayId) {
        Route r = new Route();
        r.version = version;
        r.destinationCidr = destination;
        r.gatewayId = gatewayId;
        return r;
    }

    public static Route getRouteToNetworkInterface(@Nonnull IPVersion version, @Nonnull String destination, @Nonnull String nicId) {
        Route r = new Route();
        r.version = version;
        r.destinationCidr = destination;
        r.gatewayNetworkInterfaceId = nicId;
        return r;
    }

    public static Route getRouteToVirtualMachine(@Nonnull IPVersion version, @Nonnull String destination, @Nonnull String ownerId, @Nonnull String vmId) {
        Route r = new Route();
        r.version = version;
        r.destinationCidr = destination;
        r.gatewayOwnerId = ownerId;
        r.gatewayVirtualMachineId = vmId;
        return r;
    }

    private Route() {
    }

    @Nonnull
    public String getDestinationCidr() {
        return this.destinationCidr;
    }

    @Nullable
    public String getGatewayAddress() {
        return this.gatewayAddress;
    }

    @Nullable
    public String getGatewayId() {
        return this.gatewayId;
    }

    @Nullable
    public String getGatewayNetworkInterfaceId() {
        return this.gatewayNetworkInterfaceId;
    }

    @Nullable
    public String getGatewayOwnerId() {
        return this.gatewayOwnerId;
    }

    @Nullable
    public String getGatewayVirtualMachineId() {
        return this.gatewayVirtualMachineId;
    }

    @Nonnull
    public IPVersion getVersion() {
        return this.version;
    }

    public String toString() {
        return this.destinationCidr + " [" + (Object)((Object)this.version) + "] -> " + (this.gatewayId == null ? this.gatewayAddress : this.gatewayId);
    }
}

