/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.network;

import java.util.Collection;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AccessControlledService;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.IPVersion;
import org.dasein.cloud.network.NICCreateOptions;
import org.dasein.cloud.network.NetworkInterface;
import org.dasein.cloud.network.RoutingTable;
import org.dasein.cloud.network.Subnet;
import org.dasein.cloud.network.VLAN;

public interface VLANSupport
extends AccessControlledService {
    public static final ServiceAction ANY = new ServiceAction("NET:ANY");
    public static final ServiceAction ADD_ROUTE = new ServiceAction("NET:ADD_ROUTE");
    public static final ServiceAction ASSIGN_ROUTE_TO_SUBNET = new ServiceAction("NET:ASSIGN_ROUTE_TO_SUBNET");
    public static final ServiceAction ASSIGN_ROUTE_TO_VLAN = new ServiceAction("NET:ASSIGN_ROUTE_TO_VLAN");
    public static final ServiceAction ATTACH_INTERNET_GATEWAY = new ServiceAction("NET:ATTACH_INTERNET_GATEWAY");
    public static final ServiceAction CREATE_ROUTING_TABLE = new ServiceAction("NET:CREATE_ROUTING_TABLE");
    public static final ServiceAction CREATE_INTERNET_GATEWAY = new ServiceAction("NET:CREATE_INTERNET_GATEWAY");
    public static final ServiceAction GET_ROUTING_TABLE = new ServiceAction("NET:GET_ROUTING_TABLE");
    public static final ServiceAction LIST_ROUTING_TABLE = new ServiceAction("NET:LIST_ROUTING_TABLE");
    public static final ServiceAction REMOVE_INTERNET_GATEWAY = new ServiceAction("NET:REMOVE_INTERNET_GATEWAY");
    public static final ServiceAction REMOVE_ROUTE = new ServiceAction("NET:REMOVE_ROUTE");
    public static final ServiceAction REMOVE_ROUTING_TABLE = new ServiceAction("NET:REMOVE_ROUTING_TABLE");
    public static final ServiceAction ATTACH_NIC = new ServiceAction("NET:ATTACH_NIC");
    public static final ServiceAction CREATE_NIC = new ServiceAction("NET:CREATE_NIC");
    public static final ServiceAction DETACH_NIC = new ServiceAction("NET:DETACH_NIC");
    public static final ServiceAction GET_NIC = new ServiceAction("NET:GET_NIC");
    public static final ServiceAction LIST_NIC = new ServiceAction("NET:LIST_NIC");
    public static final ServiceAction REMOVE_NIC = new ServiceAction("NET:REMOVE_NIC");
    public static final ServiceAction CREATE_SUBNET = new ServiceAction("NET:CREATE_SUBNET");
    public static final ServiceAction CREATE_VLAN = new ServiceAction("NET:CREATE_VLAN");
    public static final ServiceAction GET_SUBNET = new ServiceAction("NET:GET_SUBNET");
    public static final ServiceAction GET_VLAN = new ServiceAction("NET:GET_VLAN");
    public static final ServiceAction LIST_SUBNET = new ServiceAction("NET:LIST_SUBNET");
    public static final ServiceAction LIST_VLAN = new ServiceAction("NET:LIST_VLAN");
    public static final ServiceAction REMOVE_SUBNET = new ServiceAction("NET:REMOVE_SUBNET");
    public static final ServiceAction REMOVE_VLAN = new ServiceAction("NET:REMOVE_VLAN");

    public void addRouteToAddress(@Nonnull String var1, @Nonnull IPVersion var2, @Nullable String var3, @Nonnull String var4) throws CloudException, InternalException;

    public void addRouteToGateway(@Nonnull String var1, @Nonnull IPVersion var2, @Nullable String var3, @Nonnull String var4) throws CloudException, InternalException;

    public void addRouteToNetworkInterface(@Nonnull String var1, @Nonnull IPVersion var2, @Nullable String var3, @Nonnull String var4) throws CloudException, InternalException;

    public void addRouteToVirtualMachine(@Nonnull String var1, @Nonnull IPVersion var2, @Nullable String var3, @Nonnull String var4) throws CloudException, InternalException;

    public boolean allowsNewNetworkInterfaceCreation() throws CloudException, InternalException;

    public boolean allowsNewVlanCreation() throws CloudException, InternalException;

    public boolean allowsNewSubnetCreation() throws CloudException, InternalException;

    public void assignRoutingTableToSubnet(@Nonnull String var1, @Nonnull String var2) throws CloudException, InternalException;

    public void assignRoutingTableToVlan(@Nonnull String var1, @Nonnull String var2) throws CloudException, InternalException;

    public void attachNetworkInterface(@Nonnull String var1, @Nonnull String var2, int var3) throws CloudException, InternalException;

    @Nullable
    public String createInternetGateway(@Nonnull String var1) throws CloudException, InternalException;

    @Nonnull
    public String createRoutingTable(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3) throws CloudException, InternalException;

    @Nonnull
    public NetworkInterface createNetworkInterface(@Nonnull NICCreateOptions var1) throws CloudException, InternalException;

    @Nonnull
    public Subnet createSubnet(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3, @Nonnull String var4) throws CloudException, InternalException;

    @Nonnull
    public VLAN createVlan(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3, @Nonnull String var4, @Nonnull String[] var5, @Nonnull String[] var6) throws CloudException, InternalException;

    public void detachNetworkInterface(@Nonnull String var1) throws CloudException, InternalException;

    public int getMaxNetworkInterfaceCount() throws CloudException, InternalException;

    public int getMaxVlanCount() throws CloudException, InternalException;

    @Nonnull
    public String getProviderTermForNetworkInterface(@Nonnull Locale var1);

    @Nonnull
    public String getProviderTermForSubnet(@Nonnull Locale var1);

    @Nonnull
    public String getProviderTermForVlan(@Nonnull Locale var1);

    @Nullable
    public NetworkInterface getNetworkInterface(@Nonnull String var1) throws CloudException, InternalException;

    @Nullable
    public RoutingTable getRoutingTableForSubnet(@Nonnull String var1) throws CloudException, InternalException;

    @Nonnull
    public Requirement getRoutingTableSupport() throws CloudException, InternalException;

    @Nullable
    public RoutingTable getRoutingTableForVlan(@Nonnull String var1) throws CloudException, InternalException;

    @Nullable
    public Subnet getSubnet(@Nonnull String var1) throws CloudException, InternalException;

    @Nonnull
    public Requirement getSubnetSupport() throws CloudException, InternalException;

    @Nullable
    public VLAN getVlan(@Nonnull String var1) throws CloudException, InternalException;

    public boolean isNetworkInterfaceSupportEnabled() throws CloudException, InternalException;

    public boolean isSubscribed() throws CloudException, InternalException;

    public boolean isSubnetDataCenterConstrained() throws CloudException, InternalException;

    public boolean isVlanDataCenterConstrained() throws CloudException, InternalException;

    public Collection<String> listFirewallIdsForNIC(@Nonnull String var1) throws CloudException, InternalException;

    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfaces() throws CloudException, InternalException;

    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfacesForVM(@Nonnull String var1) throws CloudException, InternalException;

    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfacesInSubnet(@Nonnull String var1) throws CloudException, InternalException;

    @Nonnull
    public Iterable<NetworkInterface> listNetworkInterfacesInVLAN(@Nonnull String var1) throws CloudException, InternalException;

    @Nonnull
    public Iterable<RoutingTable> listRoutingTables(@Nonnull String var1) throws CloudException, InternalException;

    @Nonnull
    public Iterable<Subnet> listSubnets(@Nonnull String var1) throws CloudException, InternalException;

    @Nonnull
    public Iterable<IPVersion> listSupportedIPVersions() throws CloudException, InternalException;

    @Nonnull
    public Iterable<VLAN> listVlans() throws CloudException, InternalException;

    public void removeInternetGateway(@Nonnull String var1) throws CloudException, InternalException;

    public void removeNetworkInterface(@Nonnull String var1) throws CloudException, InternalException;

    public void removeRoute(@Nonnull String var1, @Nonnull String var2) throws CloudException, InternalException;

    public void removeRoutingTable(@Nonnull String var1) throws CloudException, InternalException;

    public void removeSubnet(String var1) throws CloudException, InternalException;

    public void removeVlan(String var1) throws CloudException, InternalException;

    public boolean supportsInternetGatewayCreation() throws CloudException, InternalException;

    public boolean supportsRawAddressRouting() throws CloudException, InternalException;
}

