/*
 * Decompiled with CFR 0.152.
 */
package org.dasein.cloud.network;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.dasein.cloud.AccessControlledService;
import org.dasein.cloud.CloudException;
import org.dasein.cloud.InternalException;
import org.dasein.cloud.Requirement;
import org.dasein.cloud.identity.ServiceAction;
import org.dasein.cloud.network.VPN;
import org.dasein.cloud.network.VPNConnection;
import org.dasein.cloud.network.VPNGateway;
import org.dasein.cloud.network.VPNProtocol;

public interface VPNSupport
extends AccessControlledService {
    public static final ServiceAction ANY = new ServiceAction("VPN:ANY");
    public static final ServiceAction ATTACH = new ServiceAction("VPN:ATTACH");
    public static final ServiceAction CONNECT_GATEWAY = new ServiceAction("VPN:CONNECT_GATEWAY");
    public static final ServiceAction CREATE_GATEWAY = new ServiceAction("VPN:CREATE_GATEWAY");
    public static final ServiceAction CREATE_VPN = new ServiceAction("VPN:CREATE_VPN");
    public static final ServiceAction DETACH = new ServiceAction("VPN:DETACH");
    public static final ServiceAction DISCONNECT_GATEWAY = new ServiceAction("VPN:DISCONNECT_GATEWAY");
    public static final ServiceAction GET_GATEWAY = new ServiceAction("VPN:GET_GATEWAY");
    public static final ServiceAction GET_VPN = new ServiceAction("VPN:GET_VPN");
    public static final ServiceAction LIST_GATEWAY = new ServiceAction("VPN:LIST_GATEWAY");
    public static final ServiceAction LIST_VPN = new ServiceAction("VPN:LIST_VPN");
    public static final ServiceAction REMOVE_GATEWAY = new ServiceAction("VPN:REMOVE_GATEWAY");
    public static final ServiceAction REMOVE_VPN = new ServiceAction("VPN:REMOVE_VPN");

    public void attachToVLAN(@Nonnull String var1, @Nonnull String var2) throws CloudException, InternalException;

    public void connectToGateway(@Nonnull String var1, @Nonnull String var2) throws CloudException, InternalException;

    @Nonnull
    public VPN createVPN(@Nullable String var1, @Nonnull String var2, @Nonnull String var3, @Nonnull VPNProtocol var4) throws CloudException, InternalException;

    @Nonnull
    public VPNGateway createVPNGateway(@Nonnull String var1, @Nonnull String var2, @Nonnull String var3, @Nonnull VPNProtocol var4, @Nonnull String var5) throws CloudException, InternalException;

    public void deleteVPN(@Nonnull String var1) throws CloudException, InternalException;

    public void deleteVPNGateway(@Nonnull String var1) throws CloudException, InternalException;

    public void detachFromVLAN(@Nonnull String var1, @Nonnull String var2) throws CloudException, InternalException;

    public void disconnectFromGateway(@Nonnull String var1, @Nonnull String var2) throws CloudException, InternalException;

    @Nullable
    public VPNGateway getGateway(@Nonnull String var1) throws CloudException, InternalException;

    @Nullable
    public VPN getVPN(@Nonnull String var1) throws CloudException, InternalException;

    public Requirement getVPNDataCenterConstraint() throws CloudException, InternalException;

    @Nonnull
    public Iterable<VPNConnection> listGatewayConnections(@Nonnull String var1) throws CloudException, InternalException;

    @Nonnull
    public Iterable<VPNGateway> listGateways() throws CloudException, InternalException;

    @Nonnull
    public Iterable<VPNGateway> listGatewaysWithBgpAsn(@Nonnull String var1) throws CloudException, InternalException;

    @Nonnull
    public Iterable<VPNConnection> listVPNConnections(@Nonnull String var1) throws CloudException, InternalException;

    @Nonnull
    public Iterable<VPN> listVPNs() throws CloudException, InternalException;

    @Nonnull
    public Iterable<VPNProtocol> listSupportedVPNProtocols() throws CloudException, InternalException;

    public boolean isSubscribed() throws CloudException, InternalException;
}

